/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorSorter;
import blusunrize.immersiveengineering.common.gui.ContainerSorter;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GuiSorter
extends GuiContainer {
    TileEntityConveyorSorter tile;

    public GuiSorter(InventoryPlayer inventoryPlayer, TileEntityConveyorSorter tile) {
        super((Container)new ContainerSorter(inventoryPlayer, tile));
        this.tile = tile;
        this.ySize = 244;
    }

    public void drawScreen(int mx, int my, float partial) {
        super.drawScreen(mx, my, partial);
        for (GuiButton button : this.buttonList) {
            if (!(button instanceof ButtonSorter) || mx <= button.xPosition || mx >= button.xPosition + 18 || my <= button.yPosition || my >= button.yPosition + 18) continue;
            ArrayList<String> tooltip = new ArrayList<String>();
            int type = ((ButtonSorter)button).type;
            String[] split = StatCollector.translateToLocal((String)("desc.ImmersiveEngineering.info.filter." + (type == 0 ? "oreDict" : (type == 1 ? "nbt" : "fuzzy")))).split("<br>");
            for (int i = 0; i < split.length; ++i) {
                tooltip.add((i == 0 ? EnumChatFormatting.WHITE : EnumChatFormatting.GRAY) + split[i]);
            }
            ClientUtils.drawHoveringText(tooltip, mx, my, this.fontRendererObj, this.guiLeft + this.xSize, -1);
            RenderHelper.enableGUIStandardItemLighting();
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtils.bindTexture("immersiveengineering:textures/gui/sorter.png");
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        for (int side = 0; side < 6; ++side) {
            int x = this.guiLeft + 30 + side / 2 * 58;
            int y = this.guiTop + 44 + side % 2 * 76;
            String s = StatCollector.translateToLocal((String)("desc.ImmersiveEngineering.info.blockSide." + ForgeDirection.getOrientation((int)side).toString())).substring(0, 1);
            GL11.glEnable((int)3042);
            ClientUtils.font().drawString(s, x - ClientUtils.font().getStringWidth(s) / 2, y, -1429418804, true);
        }
        ClientUtils.bindTexture("immersiveengineering:textures/gui/sorter.png");
    }

    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        for (int side = 0; side < 6; ++side) {
            for (int i = 0; i < 3; ++i) {
                int x = this.guiLeft + 3 + side / 2 * 58 + i * 18;
                int y = this.guiTop + 3 + side % 2 * 76;
                ButtonSorter b = new ButtonSorter(side * 3 + i, x, y, i);
                b.active = i == 0 ? this.tile.doOredict(side) : (i == 1 ? this.tile.doNBT(side) : this.tile.doFuzzy(side));
                this.buttonList.add(b);
            }
        }
    }

    protected void actionPerformed(GuiButton button) {
        if (button instanceof ButtonSorter && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            int side = button.id / 3;
            int bit = button.id % 3;
            int mask = 1 << bit;
            this.tile.sideFilter[side] = this.tile.sideFilter[side] ^ mask;
            NBTTagCompound tag = new NBTTagCompound();
            tag.setIntArray("sideConfig", this.tile.sideFilter);
            ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageTileSync(this.tile, tag));
            this.initGui();
        }
    }

    public static class ButtonSorter
    extends GuiButton {
        int type;
        boolean active = false;

        public ButtonSorter(int id, int x, int y, int type) {
            super(id, x, y, 18, 18, "");
            this.type = type;
        }

        public void drawButton(Minecraft mc, int mx, int my) {
            if (this.visible) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = mx >= this.xPosition && my >= this.yPosition && mx < this.xPosition + this.width && my < this.yPosition + this.height;
                GL11.glEnable((int)3042);
                OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
                GL11.glBlendFunc((int)770, (int)771);
                this.drawTexturedModalRect(this.xPosition, this.yPosition, 176 + this.type * 18, this.active ? 3 : 21, this.width, this.height);
                this.mouseDragged(mc, mx, my);
            }
        }
    }
}

