/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.fx;

import blusunrize.immersiveengineering.client.fx.EntityFXIEBase;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityFXItemParts
extends EntityFXIEBase {
    ItemStack item;
    int part = 0;

    public EntityFXItemParts(World world, ItemStack item, int part, double x, double y, double z, double mx, double my, double mz) {
        super(world, x, y, z, mx, my, mz);
        this.item = item;
        this.part = part;
        this.particleMaxAge = 16;
        if (item != null && item.getItem() != null) {
            this.particleIcon = item.getItem() instanceof ItemBlock ? Block.getBlockFromItem((Item)item.getItem()).getIcon(0, item.getItemDamage()) : item.getItem().getIcon(item, 0);
        }
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.motionX = mx;
        this.motionY = my;
        this.motionZ = mz;
    }

    @Override
    public ResourceLocation getParticleTexture() {
        return TextureMap.locationItemsTexture;
    }

    @Override
    public String getParticleName() {
        return "itemParts";
    }

    @Override
    public void tessellateFromQueue(Tessellator tessellator) {
        if (this.item != null && this.item.getItem() != null && this.particleIcon != null) {
            float f10 = 0.025f * this.particleScale;
            float uMin = this.particleIcon.getInterpolatedU((double)(this.part % 4 * 4));
            float uMax = this.particleIcon.getInterpolatedU((double)((this.part % 4 + 1) * 4));
            float vMin = this.particleIcon.getInterpolatedV((double)(this.part / 4 * 4));
            float vMax = this.particleIcon.getInterpolatedV((double)((this.part / 4 + 1) * 4));
            float f11 = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)this.f2 - interpPosX);
            float f12 = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)this.f2 - interpPosY);
            float f13 = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)this.f2 - interpPosZ);
            tessellator.setBrightness(this.getBrightnessForRender(this.f7));
            tessellator.setColorRGBA_F(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha);
            tessellator.addVertexWithUV((double)(f11 - this.f3 * f10 - this.f6 * f10), (double)(f12 - this.f4 * f10), (double)(f13 - this.f5 * f10 - this.f7 * f10), (double)uMax, (double)vMax);
            tessellator.addVertexWithUV((double)(f11 - this.f3 * f10 + this.f6 * f10), (double)(f12 + this.f4 * f10), (double)(f13 - this.f5 * f10 + this.f7 * f10), (double)uMax, (double)vMin);
            tessellator.addVertexWithUV((double)(f11 + this.f3 * f10 + this.f6 * f10), (double)(f12 + this.f4 * f10), (double)(f13 + this.f5 * f10 + this.f7 * f10), (double)uMin, (double)vMin);
            tessellator.addVertexWithUV((double)(f11 + this.f3 * f10 - this.f6 * f10), (double)(f12 - this.f4 * f10), (double)(f13 + this.f5 * f10 - this.f7 * f10), (double)uMin, (double)vMax);
        }
    }
}

