/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;

public class ExternalHeaterHandler {
    public static int defaultFurnaceEnergyCost;
    public static int defaultFurnaceSpeedupCost;
    public static HashMap<Class<? extends TileEntity>, HeatableAdapter> adapterMap;

    public static void registerHeatableAdapter(Class<? extends TileEntity> c, HeatableAdapter adapter) {
        adapterMap.put(c, adapter);
    }

    public static HeatableAdapter getHeatableAdapter(Class<? extends TileEntity> c) {
        HeatableAdapter adapter = adapterMap.get(c);
        if (adapter == null && c != TileEntity.class && c.getSuperclass() != TileEntity.class) {
            adapter = ExternalHeaterHandler.getHeatableAdapter(c.getSuperclass());
            adapterMap.put(c, adapter);
        }
        return adapter;
    }

    static {
        adapterMap = new HashMap();
    }

    public static class DefaultFurnaceAdapter
    extends HeatableAdapter<TileEntityFurnace> {
        boolean canCook(TileEntityFurnace tileEntity) {
            ItemStack input = tileEntity.getStackInSlot(0);
            if (input == null) {
                return false;
            }
            ItemStack output = FurnaceRecipes.smelting().getSmeltingResult(input);
            if (output == null) {
                return false;
            }
            ItemStack existingOutput = tileEntity.getStackInSlot(2);
            if (existingOutput == null) {
                return true;
            }
            if (!existingOutput.isItemEqual(output)) {
                return false;
            }
            int stackSize = existingOutput.stackSize + output.stackSize;
            return stackSize <= tileEntity.getInventoryStackLimit() && stackSize <= output.getMaxStackSize();
        }

        @Override
        public int doHeatTick(TileEntityFurnace tileEntity, int energyAvailable, boolean redstone) {
            int energyConsumed = 0;
            boolean canCook = this.canCook(tileEntity);
            if (canCook || redstone) {
                int energyToUse;
                int heatEnergyRatio;
                int heatAttempt;
                int energyToUse2;
                int heat;
                boolean burning = tileEntity.isBurning();
                if (tileEntity.furnaceBurnTime < 200 && (heat = (energyToUse2 = Math.min(energyAvailable, (heatAttempt = 4) * (heatEnergyRatio = Math.max(1, defaultFurnaceEnergyCost)))) / heatEnergyRatio) > 0) {
                    tileEntity.furnaceBurnTime += heat;
                    energyConsumed += heat * heatEnergyRatio;
                    if (!burning) {
                        this.updateFurnace((TileEntity)tileEntity, tileEntity.furnaceBurnTime > 0);
                    }
                }
                if (canCook && tileEntity.furnaceBurnTime >= 200 && tileEntity.furnaceCookTime < 199 && energyAvailable - energyConsumed > (energyToUse = defaultFurnaceSpeedupCost)) {
                    energyConsumed += energyToUse;
                    ++tileEntity.furnaceCookTime;
                }
            }
            return energyConsumed;
        }

        public void updateFurnace(TileEntity tileEntity, boolean active) {
            Block containing = tileEntity.getBlockType();
            if (containing == Blocks.furnace || containing == Blocks.lit_furnace) {
                BlockFurnace.updateFurnaceBlockState((boolean)active, (World)tileEntity.getWorldObj(), (int)tileEntity.xCoord, (int)tileEntity.yCoord, (int)tileEntity.zCoord);
            } else {
                NBTTagCompound nbt = new NBTTagCompound();
                tileEntity.writeToNBT(nbt);
                nbt.setBoolean("active", active);
                nbt.setBoolean("Active", active);
                tileEntity.readFromNBT(nbt);
                tileEntity.getWorldObj().markBlockForUpdate(tileEntity.xCoord, tileEntity.yCoord, tileEntity.zCoord);
            }
        }
    }

    public static abstract class HeatableAdapter<E extends TileEntity> {
        public abstract int doHeatTick(E var1, int var2, boolean var3);
    }

    public static interface IExternalHeatable {
        public int doHeatTick(int var1, boolean var2);
    }
}

