/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderCaseBalloon;
import blusunrize.immersiveengineering.api.shader.ShaderCaseChemthrower;
import blusunrize.immersiveengineering.api.shader.ShaderCaseDrill;
import blusunrize.immersiveengineering.api.shader.ShaderCaseMinecart;
import blusunrize.immersiveengineering.api.shader.ShaderCaseRailgun;
import blusunrize.immersiveengineering.api.shader.ShaderCaseRevolver;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ShaderRegistry {
    public static ArrayList<String> shaderList = new ArrayList();
    public static HashMap<String, ShaderRegistryEntry> shaderRegistry = new HashMap();
    public static ArrayList<String> chestLootShaders = new ArrayList();
    public static HashMap<EnumRarity, Integer> rarityWeightMap = new HashMap();
    public static ArrayList<EnumRarity> sortedRarityMap;
    public static ArrayListMultimap<String, String> receivedShaders;
    public static HashMap<EnumRarity, Integer> totalWeight;
    public static HashMap<String, HashMap<EnumRarity, Integer>> playerTotalWeight;
    public static ManualInstance.ManualEntry manualEntry;
    public static Item itemShader;
    public static Item itemShaderBag;

    public static ShaderCase getShader(String name, String shaderType) {
        if (shaderRegistry.containsKey(name)) {
            return shaderRegistry.get(name).getCase(shaderType);
        }
        return null;
    }

    public static ShaderRegistryEntry registerShader(String name, String overlayType, EnumRarity rarity, int[] colourPrimary, int[] colourSecondary, int[] colourBackground, int[] colourBlade, String additionalTexture, boolean loot, boolean bags) {
        ShaderRegistry.registerShader_Revolver(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, colourBlade, additionalTexture);
        ShaderRegistry.registerShader_Chemthrower(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, true, false, additionalTexture);
        ShaderRegistry.registerShader_Drill(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, additionalTexture);
        ShaderRegistry.registerShader_Railgun(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, additionalTexture);
        ShaderRegistry.registerShader_Minecart(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, additionalTexture);
        ShaderRegistry.registerShader_Balloon(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, additionalTexture);
        return shaderRegistry.get(name).setCrateLoot(loot).setBagLoot(bags);
    }

    public static ShaderCaseRevolver registerShader_Revolver(String name, String overlayType, EnumRarity rarity, int[] colourGrip, int[] colourPrimary, int[] colourSecondary, int[] colourBlade, String additionalTexture) {
        if (!shaderList.contains(name)) {
            shaderList.add(name);
        }
        ShaderCaseRevolver shader = new ShaderCaseRevolver(overlayType, colourGrip, colourPrimary, colourSecondary, colourBlade, additionalTexture);
        if (!shaderRegistry.containsKey(name)) {
            shaderRegistry.put(name, new ShaderRegistryEntry(name, rarity, shader));
        } else {
            shaderRegistry.get(name).addCase(shader);
        }
        return shader;
    }

    public static ShaderCaseChemthrower registerShader_Chemthrower(String name, String overlayType, EnumRarity rarity, int[] colourGrip, int[] colourPrimary, int[] colourSecondary, boolean cageOnBase, boolean tanksUncoloured, String additionalTexture) {
        if (!shaderList.contains(name)) {
            shaderList.add(name);
        }
        ShaderCaseChemthrower shader = new ShaderCaseChemthrower(overlayType, colourGrip, colourPrimary, colourSecondary, cageOnBase, tanksUncoloured, additionalTexture);
        if (!shaderRegistry.containsKey(name)) {
            shaderRegistry.put(name, new ShaderRegistryEntry(name, rarity, shader));
        } else {
            shaderRegistry.get(name).addCase(shader);
        }
        return shader;
    }

    public static ShaderCaseDrill registerShader_Drill(String name, String overlayType, EnumRarity rarity, int[] colourGrip, int[] colourPrimary, int[] colourSecondary, String additionalTexture) {
        if (!shaderList.contains(name)) {
            shaderList.add(name);
        }
        ShaderCaseDrill shader = new ShaderCaseDrill(overlayType, colourGrip, colourPrimary, colourSecondary, additionalTexture);
        if (!shaderRegistry.containsKey(name)) {
            shaderRegistry.put(name, new ShaderRegistryEntry(name, rarity, shader));
        } else {
            shaderRegistry.get(name).addCase(shader);
        }
        return shader;
    }

    public static ShaderCaseRailgun registerShader_Railgun(String name, String overlayType, EnumRarity rarity, int[] colourGrip, int[] colourPrimary, int[] colourSecondary, String additionalTexture) {
        if (!shaderList.contains(name)) {
            shaderList.add(name);
        }
        ShaderCaseRailgun shader = new ShaderCaseRailgun(overlayType, colourGrip, colourPrimary, colourSecondary, additionalTexture);
        if (!shaderRegistry.containsKey(name)) {
            shaderRegistry.put(name, new ShaderRegistryEntry(name, rarity, shader));
        } else {
            shaderRegistry.get(name).addCase(shader);
        }
        return shader;
    }

    public static ShaderCaseMinecart registerShader_Minecart(String name, String overlayType, EnumRarity rarity, int[] colourUnderlying, int[] colourPrimary, int[] colourSecondary, String additionalTexture) {
        if (!shaderList.contains(name)) {
            shaderList.add(name);
        }
        ShaderCaseMinecart shader = new ShaderCaseMinecart(overlayType, colourUnderlying, colourPrimary, colourSecondary, additionalTexture);
        if (!shaderRegistry.containsKey(name)) {
            shaderRegistry.put(name, new ShaderRegistryEntry(name, rarity, shader));
        } else {
            shaderRegistry.get(name).addCase(shader);
        }
        return shader;
    }

    public static ShaderCaseBalloon registerShader_Balloon(String name, String overlayType, EnumRarity rarity, int[] colourUnderlying, int[] colourPrimary, int[] colourSecondary, String additionalTexture) {
        if (!shaderList.contains(name)) {
            shaderList.add(name);
        }
        ShaderCaseBalloon shader = new ShaderCaseBalloon(overlayType, colourUnderlying, colourPrimary, colourSecondary, additionalTexture);
        if (!shaderRegistry.containsKey(name)) {
            shaderRegistry.put(name, new ShaderRegistryEntry(name, rarity, shader));
        } else {
            shaderRegistry.get(name).addCase(shader);
        }
        return shader;
    }

    public static void compileWeight() {
        int i;
        totalWeight.clear();
        chestLootShaders.clear();
        for (ShaderRegistryEntry entry : shaderRegistry.values()) {
            if (entry.getIsBagLoot()) {
                int entryRarityWeight = rarityWeightMap.get(entry.getRarity());
                for (Map.Entry<EnumRarity, Integer> weightedRarity : rarityWeightMap.entrySet()) {
                    if (!(entry.getIsInLowerBags() ? weightedRarity.getValue() >= entryRarityWeight : weightedRarity.getValue() == entryRarityWeight)) continue;
                    int i2 = totalWeight.containsKey(weightedRarity.getKey()) ? totalWeight.get(weightedRarity.getKey()) : 0;
                    totalWeight.put(weightedRarity.getKey(), i2 + entry.getWeight());
                }
            }
            if (!entry.getIsCrateLoot()) continue;
            for (i = 0; i < entry.getWeight(); ++i) {
                chestLootShaders.add(entry.getName());
            }
        }
        sortedRarityMap.clear();
        sortedRarityMap.addAll(rarityWeightMap.keySet());
        Collections.sort(sortedRarityMap, new Comparator<EnumRarity>(){

            @Override
            public int compare(EnumRarity enum0, EnumRarity enum1) {
                return Integer.compare(rarityWeightMap.get(enum0), rarityWeightMap.get(enum1));
            }
        });
        if (manualEntry != null) {
            ArrayList<ManualPages.PositionedItemStack[]> recipes = new ArrayList<ManualPages.PositionedItemStack[]>();
            ItemStack[] shaderBags = new ItemStack[sortedRarityMap.size()];
            recipes = new ArrayList();
            for (i = 0; i < sortedRarityMap.size(); ++i) {
                EnumRarity outputRarity = sortedRarityMap.get(i);
                shaderBags[i] = new ItemStack(itemShaderBag);
                shaderBags[i].setTagCompound(new NBTTagCompound());
                shaderBags[i].getTagCompound().setString("rarity", outputRarity.toString());
                ArrayList<EnumRarity> upperRarities = ShaderRegistry.getHigherRarities(outputRarity);
                if (upperRarities.isEmpty()) continue;
                ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
                for (EnumRarity enumRarity : upperRarities) {
                    ItemStack bag = new ItemStack(itemShaderBag);
                    bag.setTagCompound(new NBTTagCompound());
                    bag.getTagCompound().setString("rarity", enumRarity.toString());
                    inputList.add(bag);
                }
                ItemStack s0 = new ItemStack(itemShaderBag, 2);
                s0.setTagCompound(new NBTTagCompound());
                s0.getTagCompound().setString("rarity", outputRarity.toString());
                if (!inputList.isEmpty()) {
                    recipes.add(new ManualPages.PositionedItemStack[]{new ManualPages.PositionedItemStack(inputList, 33, 0), new ManualPages.PositionedItemStack(s0, 69, 0)});
                }
                inputList = new ArrayList();
                for (ShaderRegistryEntry entry : shaderRegistry.values()) {
                    if (!upperRarities.contains(entry.getRarity())) continue;
                    ItemStack shader = new ItemStack(itemShader);
                    shader.setTagCompound(new NBTTagCompound());
                    shader.getTagCompound().setString("shader_name", entry.getName());
                    inputList.add(shader);
                }
                ItemStack itemStack = new ItemStack(itemShaderBag);
                itemStack.setTagCompound(new NBTTagCompound());
                itemStack.getTagCompound().setString("rarity", outputRarity.toString());
                if (inputList.isEmpty()) continue;
                recipes.add(new ManualPages.PositionedItemStack[]{new ManualPages.PositionedItemStack(inputList, 33, 0), new ManualPages.PositionedItemStack(itemStack, 69, 0)});
            }
            ShaderRegistry.manualEntry.getPages()[1] = new ManualPages.ItemDisplay(ManualHelper.getManual(), "shader1", shaderBags);
            ShaderRegistry.manualEntry.getPages()[2] = new ManualPages.CraftingMulti(ManualHelper.getManual(), "shader2", recipes.toArray((T[])new ManualPages.PositionedItemStack[recipes.size()][3]));
        }
    }

    public static void recalculatePlayerTotalWeight(String player) {
        if (!playerTotalWeight.containsKey(player)) {
            playerTotalWeight.put(player, new HashMap());
        } else {
            playerTotalWeight.get(player).clear();
        }
        List received = receivedShaders.get((Object)player);
        for (ShaderRegistryEntry entry : shaderRegistry.values()) {
            if (!entry.getIsBagLoot()) continue;
            int entryRarityWeight = rarityWeightMap.get(entry.getRarity());
            for (Map.Entry<EnumRarity, Integer> weightedRarity : rarityWeightMap.entrySet()) {
                if (!(entry.getIsInLowerBags() ? weightedRarity.getValue() >= entryRarityWeight : weightedRarity.getValue() == entryRarityWeight)) continue;
                int weight = playerTotalWeight.get(player).containsKey(weightedRarity.getKey()) ? playerTotalWeight.get(player).get(weightedRarity.getKey()) : 0;
                int value = entry.getWeight();
                if (received.contains(entry.getName())) {
                    value = 1;
                }
                playerTotalWeight.get(player).put(weightedRarity.getKey(), weight + value);
            }
        }
    }

    public static String getRandomShader(String player, Random rand, EnumRarity minRarity, boolean addToReceived) {
        int total = 0;
        if (!playerTotalWeight.containsKey(player)) {
            playerTotalWeight.put(player, totalWeight);
        }
        total = playerTotalWeight.get(player).get(minRarity);
        String shader = null;
        int minWeight = rarityWeightMap.get(minRarity);
        int weight = total < 1 ? total : rand.nextInt(total);
        for (ShaderRegistryEntry entry : shaderRegistry.values()) {
            if (!entry.getIsBagLoot()) continue;
            int entryRarityWeight = rarityWeightMap.get(entry.getRarity());
            if (!(entry.getIsInLowerBags() ? minWeight >= entryRarityWeight : minWeight == entryRarityWeight)) continue;
            int value = entry.getWeight();
            if (receivedShaders.get((Object)player).contains(entry.getName())) {
                value = 1;
            }
            if ((weight -= value) > 0) continue;
            shader = entry.getName();
            break;
        }
        if (addToReceived && shader != null && !shader.isEmpty() && player != null && !player.isEmpty()) {
            if (!receivedShaders.get((Object)player).contains(shader)) {
                receivedShaders.put((Object)player, (Object)shader);
            }
            ShaderRegistry.recalculatePlayerTotalWeight(player);
        }
        return shader;
    }

    public static EnumRarity getLowerRarity(EnumRarity rarity) {
        int idx = sortedRarityMap.indexOf(rarity);
        int weight = rarityWeightMap.get(rarity);
        for (int next = idx + 1; next < sortedRarityMap.size(); ++next) {
            if (rarityWeightMap.get(sortedRarityMap.get(next)) <= weight) continue;
            return sortedRarityMap.get(next);
        }
        return null;
    }

    public static ArrayList<EnumRarity> getAllLowerRarities(EnumRarity rarity) {
        ArrayList<EnumRarity> list = new ArrayList<EnumRarity>();
        int idx = sortedRarityMap.indexOf(rarity);
        int weight = rarityWeightMap.get(rarity);
        for (int next = idx + 1; next < sortedRarityMap.size(); ++next) {
            if (rarityWeightMap.get(sortedRarityMap.get(next)) <= weight) continue;
            list.add(sortedRarityMap.get(next));
        }
        return list;
    }

    public static ArrayList<EnumRarity> getHigherRarities(EnumRarity rarity) {
        ArrayList<EnumRarity> list = new ArrayList<EnumRarity>();
        int idx = sortedRarityMap.indexOf(rarity);
        if (idx <= 0) {
            return list;
        }
        int weight = rarityWeightMap.get(rarity);
        int lowerWeight = -1;
        for (int next = idx - 1; next >= 0; --next) {
            EnumRarity r = sortedRarityMap.get(next);
            int rWeight = rarityWeightMap.get(r);
            if (rWeight >= weight || lowerWeight != -1 && rWeight < lowerWeight) continue;
            list.add(r);
            lowerWeight = rWeight;
        }
        return list;
    }

    public static ArrayList<EnumRarity> getAllHigherRarities(EnumRarity rarity) {
        ArrayList<EnumRarity> list = new ArrayList<EnumRarity>();
        int idx = sortedRarityMap.indexOf(rarity);
        if (idx <= 0) {
            return list;
        }
        int weight = rarityWeightMap.get(rarity);
        for (int next = idx - 1; next >= 0; --next) {
            EnumRarity r = sortedRarityMap.get(next);
            int rWeight = rarityWeightMap.get(r);
            if (rWeight >= weight) continue;
            list.add(r);
        }
        return list;
    }

    static {
        rarityWeightMap.put(EnumRarity.common, 9);
        rarityWeightMap.put(EnumRarity.uncommon, 7);
        rarityWeightMap.put(EnumRarity.rare, 5);
        rarityWeightMap.put(EnumRarity.epic, 3);
        sortedRarityMap = new ArrayList();
        receivedShaders = ArrayListMultimap.create();
        totalWeight = new HashMap();
        playerTotalWeight = new HashMap();
    }

    public static class ShaderRegistryEntry {
        public String name;
        public HashMap<String, ShaderCase> cases = new HashMap();
        public EnumRarity rarity;
        public int weight;
        public boolean isCrateLoot;
        public boolean isBagLoot;
        public boolean isInLowerBags = true;

        public ShaderRegistryEntry(String name, EnumRarity rarity, List<ShaderCase> cases) {
            this.name = name;
            this.rarity = rarity;
            this.weight = rarityWeightMap.get(rarity);
            for (ShaderCase sCase : cases) {
                this.cases.put(sCase.getShaderType(), sCase);
            }
        }

        public ShaderRegistryEntry(String name, EnumRarity rarity, ShaderCase ... cases) {
            this(name, rarity, Arrays.asList(cases));
        }

        public ShaderRegistryEntry addCase(String type, ShaderCase sCase) {
            this.cases.put(type, sCase);
            return this;
        }

        public ShaderRegistryEntry addCase(ShaderCase sCase) {
            return this.addCase(sCase.getShaderType(), sCase);
        }

        public ShaderCase getCase(String type) {
            return this.cases.get(type);
        }

        public List<ShaderCase> getCases() {
            return new ArrayList<ShaderCase>(this.cases.values());
        }

        public String getName() {
            return this.name;
        }

        public EnumRarity getRarity() {
            return this.rarity;
        }

        public ShaderRegistryEntry setWeight(int weight) {
            this.weight = weight;
            return this;
        }

        public int getWeight() {
            return this.weight;
        }

        public ShaderRegistryEntry setCrateLoot(boolean b) {
            this.isCrateLoot = b;
            return this;
        }

        public boolean getIsCrateLoot() {
            return this.isCrateLoot;
        }

        public ShaderRegistryEntry setBagLoot(boolean b) {
            this.isBagLoot = b;
            return this;
        }

        public boolean getIsBagLoot() {
            return this.isBagLoot;
        }

        public ShaderRegistryEntry setInLowerBags(boolean b) {
            this.isInLowerBags = b;
            return this;
        }

        public boolean getIsInLowerBags() {
            return this.isInLowerBags;
        }
    }
}

