/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.GuiManual;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class ManualPageMultiblock
extends ManualPages {
    MultiblockHandler.IMultiblock multiblock;
    boolean canTick = true;
    boolean showCompleted = false;
    int tick = 0;
    int showLayer = -1;
    int blockCount = 0;
    int[] countPerLevel;
    int structureHeight = 0;
    int structureLength = 0;
    int structureWidth = 0;
    float rotX = 0.0f;
    float rotY = 0.0f;
    float rotZ = 0.0f;

    public ManualPageMultiblock(ManualInstance manual, String text, MultiblockHandler.IMultiblock multiblock) {
        super(manual, text);
        this.multiblock = multiblock;
    }

    @Override
    public void initPage(GuiManual gui, int x, int y, List<GuiButton> pageButtons) {
        int yOff = 0;
        if (this.multiblock.getStructureManual() != null) {
            ItemStack[][][] structure = this.multiblock.getStructureManual();
            this.structureHeight = structure.length;
            this.structureWidth = 0;
            this.structureLength = 0;
            this.rotX = 25.0f;
            this.rotY = 40.0f;
            this.countPerLevel = new int[this.structureHeight];
            this.blockCount = 0;
            for (int h = 0; h < structure.length; ++h) {
                if (structure[h].length - 1 > this.structureLength) {
                    this.structureLength = structure[h].length - 1;
                }
                int perLvl = 0;
                for (int l = 0; l < structure[h].length; ++l) {
                    if (structure[h][l].length - 1 > this.structureWidth) {
                        this.structureWidth = structure[h][l].length - 1;
                    }
                    for (ItemStack ss : structure[h][l]) {
                        if (ss == null) continue;
                        ++perLvl;
                    }
                }
                this.countPerLevel[h] = perLvl;
                this.blockCount += perLvl;
            }
            this.tick = (this.showLayer == -1 ? this.blockCount : this.countPerLevel[this.showLayer]) * 40;
            boolean canRenderFormed = this.multiblock.canRenderFormedStructure();
            yOff = (int)((double)this.multiblock.getManualScale() * Math.sqrt(this.structureHeight * this.structureHeight + this.structureWidth * this.structureWidth + this.structureLength * this.structureLength));
            yOff = Math.max(10 + (canRenderFormed ? 12 : 0) + (this.structureHeight > 1 ? 36 : 0), yOff);
            pageButtons.add(new GuiButtonManualNavigation(gui, 100, x + 4, y + yOff / 2 - (canRenderFormed ? 11 : 5), 10, 10, 4));
            if (canRenderFormed) {
                pageButtons.add(new GuiButtonManualNavigation(gui, 103, x + 4, y + yOff / 2 + 1, 10, 10, 6));
            }
            if (this.structureHeight > 1) {
                pageButtons.add(new GuiButtonManualNavigation(gui, 101, x + 4, y + yOff / 2 - (canRenderFormed ? 14 : 8) - 16, 10, 16, 3));
                pageButtons.add(new GuiButtonManualNavigation(gui, 102, x + 4, y + yOff / 2 + (canRenderFormed ? 14 : 8), 10, 16, 2));
            }
        }
        super.initPage(gui, x, y + yOff, pageButtons);
    }

    @Override
    public void renderPage(GuiManual gui, int x, int y, int mx, int my) {
        if (this.multiblock.getStructureManual() != null) {
            if (this.canTick) {
                ++this.tick;
            }
            ItemStack[][][] structure = this.multiblock.getStructureManual();
            int prevLayers = 0;
            if (this.showLayer != -1) {
                for (int ll = 0; ll < this.showLayer; ++ll) {
                    prevLayers += this.countPerLevel[ll];
                }
            }
            int limiter = prevLayers + this.tick / 40 % ((this.showLayer == -1 ? this.blockCount : this.countPerLevel[this.showLayer]) + 4);
            int xHalf = this.structureWidth * 5 - this.structureLength * 5;
            int yOffPartial = (this.structureHeight - 1) * 12 + this.structureWidth * 5 + this.structureLength * 5;
            int yOffTotal = Math.max(48, yOffPartial + 16);
            GL11.glEnable((int)32826);
            GL11.glPushMatrix();
            RenderHelper.disableStandardItemLighting();
            int i = 0;
            ItemStack highlighted = null;
            RenderBlocks blockRender = RenderBlocks.getInstance();
            float f = (float)Math.sqrt(this.structureHeight * this.structureHeight + this.structureWidth * this.structureWidth + this.structureLength * this.structureLength);
            float scale = this.multiblock.getManualScale();
            yOffTotal = Math.max(10 + (this.multiblock.canRenderFormedStructure() ? 12 : 0) + (this.structureHeight > 1 ? 36 : 0), (int)(f * scale));
            GL11.glTranslatef((float)(x + 60), (float)((float)y + f * scale / 2.0f), (float)Math.max(this.structureHeight, Math.max(this.structureWidth, this.structureLength)));
            GL11.glScalef((float)scale, (float)(-scale), (float)1.0f);
            GL11.glRotatef((float)this.rotX, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)this.rotY, (float)0.0f, (float)1.0f, (float)0.0f);
            if (this.showCompleted) {
                this.multiblock.renderFormedStructure();
            } else {
                if (this.structureWidth % 2 == 1) {
                    GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)0.0f);
                }
                int iterator = 0;
                for (int h = 0; h < structure.length; ++h) {
                    if (this.showLayer != -1 && h > this.showLayer) continue;
                    ItemStack[][] level = structure[h];
                    for (int l = 0; l < level.length; ++l) {
                        ItemStack[] row = level[l];
                        for (int w = row.length - 1; w >= 0; --w) {
                            int xx = 60 + xHalf - 10 * w + 10 * l - 7;
                            int yy = yOffPartial - 5 * w - 5 * l - 12 * h;
                            if (row[w] == null || i > limiter) continue;
                            ++i;
                            Block b = Block.getBlockFromItem((Item)row[w].getItem());
                            if (b != null) {
                                ClientUtils.bindAtlas(0);
                                GL11.glPushMatrix();
                                GL11.glTranslatef((float)(w - this.structureWidth / 2), (float)(h - this.structureHeight / 2), (float)(l - this.structureLength / 2));
                                if (!this.multiblock.overwriteBlockRender(row[w], iterator++)) {
                                    blockRender.renderBlockAsItem(b, row[w].getItemDamage(), 0.8f);
                                }
                                GL11.glPopMatrix();
                            }
                            if (mx < x + xx || mx >= x + xx + 16 || my < y + yy || my >= y + yy + 16) continue;
                            highlighted = row[w];
                        }
                    }
                }
            }
            GL11.glPopMatrix();
            RenderHelper.disableStandardItemLighting();
            GL11.glDisable((int)32826);
            this.manual.fontRenderer.setUnicodeFlag(false);
            if (this.multiblock.getTotalMaterials() != null) {
                this.manual.fontRenderer.drawString("?", x + 116, y + yOffTotal / 2 - 4, this.manual.getTextColour(), false);
            }
            if (this.multiblock.getTotalMaterials() != null && mx >= x + 116 && mx < x + 122 && my >= y + yOffTotal / 2 - 4 && my < y + yOffTotal / 2 + 4) {
                ArrayList<String> components = new ArrayList<String>();
                components.add(StatCollector.translateToLocal((String)"desc.ImmersiveEngineering.info.reqMaterial"));
                int maxOff = 1;
                for (ItemStack ss : this.multiblock.getTotalMaterials()) {
                    if (("" + ss.stackSize).length() <= maxOff) continue;
                    maxOff = ("" + ss.stackSize).length();
                }
                for (ItemStack ss : this.multiblock.getTotalMaterials()) {
                    if (ss == null) continue;
                    int indent = 0;
                    if (maxOff > ("" + ss.stackSize).length()) {
                        indent = maxOff - ("" + ss.stackSize).length();
                    }
                    String sIndent = "";
                    if (indent > 0) {
                        for (int ii = 0; ii < indent; ++ii) {
                            sIndent = sIndent + "0";
                        }
                    }
                    components.add("" + EnumChatFormatting.GRAY + sIndent + ss.stackSize + "x " + EnumChatFormatting.RESET + ss.getRarity().rarityColor + ss.getDisplayName());
                }
                gui.drawHoveringText(components, mx, my, this.manual.fontRenderer);
            }
            RenderHelper.disableStandardItemLighting();
            this.manual.fontRenderer.setUnicodeFlag(true);
            if (this.localizedText != null && !this.localizedText.isEmpty()) {
                this.manual.fontRenderer.drawSplitString(this.localizedText, x, y + yOffTotal, 120, this.manual.getTextColour());
            }
        }
    }

    @Override
    public void mouseDragged(int x, int y, int clickX, int clickY, int mx, int my, int lastX, int lastY, int button) {
        if (clickX >= 40 && clickX < 144 && mx >= 40 && mx < 144 && clickY >= 30 && clickY < 130 && my >= 30 && my < 130) {
            int dx = mx - lastX;
            int dy = my - lastY;
            this.rotY += (float)dx / 104.0f * 80.0f;
            this.rotX += (float)dy / 100.0f * 80.0f;
        }
    }

    @Override
    public void buttonPressed(GuiManual gui, GuiButton button) {
        if (button.id == 100) {
            this.canTick = !this.canTick;
            ((GuiButtonManualNavigation)button).type = ((GuiButtonManualNavigation)button).type == 4 ? 5 : 4;
        } else if (button.id == 101) {
            this.showLayer = Math.min(this.showLayer + 1, this.structureHeight - 1);
            this.tick = this.countPerLevel[this.showLayer] * 40;
        } else if (button.id == 102) {
            this.showLayer = Math.max(this.showLayer - 1, -1);
            this.tick = (this.showLayer == -1 ? this.blockCount : this.countPerLevel[this.showLayer]) * 40;
        } else if (button.id == 103) {
            this.showCompleted = !this.showCompleted;
        }
        super.buttonPressed(gui, button);
    }

    @Override
    public boolean listForSearch(String searchTag) {
        return false;
    }
}

