/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.tileentities;

import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.network.NetworkManager;
import java.util.List;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraftforge.common.util.ForgeDirection;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.ITextureHelper;
import shedar.mods.ic2.nuclearcontrol.items.ItemCard55Reactor;
import shedar.mods.ic2.nuclearcontrol.utils.NuclearHelper;

public class TileEntityThermo
extends TileEntity
implements INetworkDataProvider,
INetworkUpdateListener,
INetworkClientTileEntityEventListener,
IWrenchable,
ITextureHelper {
    protected boolean init = false;
    private int prevHeatLevel = 500;
    public int heatLevel = 500;
    private int mappedHeatLevel = 500;
    private int prevOnFire = 0;
    public int onFire = 0;
    private short prevFacing = 0;
    public short facing = 0;
    private boolean prevInvertRedstone = false;
    private boolean invertRedstone = false;
    private static int[] Coords = new int[3];
    protected int updateTicker = 0;
    protected int tickRate = -1;

    protected void initData() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
        this.init = true;
    }

    public boolean isInvertRedstone() {
        return this.invertRedstone;
    }

    public void setInvertRedstone(boolean value) {
        this.invertRedstone = value;
        if (this.prevInvertRedstone != value) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "invertRedstone");
        }
        this.prevInvertRedstone = value;
    }

    public short getFacing() {
        return (short)Facing.field_71588_a[this.facing];
    }

    public void setFacing(short f) {
        this.setSide((short)Facing.field_71588_a[f]);
    }

    private void setSide(short f) {
        this.facing = f;
        if (this.prevFacing != f) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "facing");
        }
        this.prevFacing = f;
    }

    public List<String> getNetworkedFields() {
        Vector<String> vector = new Vector<String>(3);
        vector.add("heatLevel");
        vector.add("onFire");
        vector.add("facing");
        vector.add("invertRedstone");
        return vector;
    }

    public void onNetworkUpdate(String field) {
        if (field.equals("heatLevel") && this.prevHeatLevel != this.heatLevel) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.prevHeatLevel = this.heatLevel;
        }
        if (field.equals("facing") && this.prevFacing != this.facing) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.prevFacing = this.facing;
        }
        if (field.equals("onFire") && this.prevOnFire != this.onFire) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.prevOnFire = this.onFire;
        }
        if (field.equals("invertRedstone") && this.prevInvertRedstone != this.invertRedstone) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.prevInvertRedstone = this.invertRedstone;
        }
    }

    public void onNetworkEvent(EntityPlayer entityplayer, int i) {
        if (i < 0) {
            switch (i) {
                case -1: {
                    this.setInvertRedstone(false);
                    break;
                }
                case -2: {
                    this.setInvertRedstone(true);
                    break;
                }
            }
        } else {
            this.setHeatLevel(i);
        }
    }

    public void setOnFire(int f) {
        this.onFire = f;
        if (this.prevOnFire != f) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "onFire");
        }
        this.prevOnFire = this.onFire;
    }

    public int getOnFire() {
        return this.onFire;
    }

    public void setHeatLevel(int h) {
        this.heatLevel = h;
        if (this.prevHeatLevel != h) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "heatLevel");
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
        this.prevHeatLevel = this.heatLevel;
        this.mappedHeatLevel = h;
    }

    public void setHeatLevelWithoutNotify(int h) {
        this.prevHeatLevel = this.heatLevel = h;
        this.mappedHeatLevel = h;
    }

    public Integer getHeatLevel() {
        return this.heatLevel;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("heatLevel")) {
            int heat = nbttagcompound.func_74762_e("heatLevel");
            this.setHeatLevelWithoutNotify(heat);
            this.prevFacing = this.facing = nbttagcompound.func_74765_d("facing");
            this.prevInvertRedstone = this.invertRedstone = nbttagcompound.func_74767_n("invert");
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("heatLevel", this.getHeatLevel().intValue());
        nbttagcompound.func_74777_a("facing", this.facing);
        nbttagcompound.func_74757_a("invert", this.isInvertRedstone());
    }

    protected void checkStatus() {
        int fire;
        IReactorChamber chamber = NuclearHelper.getReactorChamberAroundCoord(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        IReactor reactor = null;
        if (chamber != null) {
            reactor = chamber.getReactor();
        }
        if (reactor == null) {
            reactor = NuclearHelper.getReactorAroundCoord(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (reactor == null && chamber == null) {
            this.decodeSides(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            reactor = ItemCard55Reactor.getReactor(this.field_145850_b, Coords[0], Coords[1], Coords[2]);
        }
        if (reactor != null) {
            int reactorHeat;
            if (this.tickRate == -1) {
                this.tickRate = reactor.getTickRate() / 2;
                if (this.tickRate == 0) {
                    this.tickRate = 1;
                }
                this.updateTicker = this.tickRate;
            }
            fire = (reactorHeat = reactor.getHeat()) >= this.heatLevel ? 1 : 0;
        } else {
            fire = -1;
        }
        if (fire != this.getOnFire()) {
            this.setOnFire(fire);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    protected void decodeSides(int x, int y, int z) {
        ForgeDirection facing = this.getFacing() > 5 ? ForgeDirection.UNKNOWN : ForgeDirection.VALID_DIRECTIONS[this.getFacing()].getOpposite();
        TileEntityThermo.Coords[0] = x + facing.offsetX;
        TileEntityThermo.Coords[1] = y + facing.offsetY;
        TileEntityThermo.Coords[2] = z + facing.offsetZ;
    }

    public void func_145845_h() {
        if (!this.init) {
            this.initData();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.tickRate != -1 && this.updateTicker-- > 0) {
                return;
            }
            this.updateTicker = this.tickRate;
            this.checkStatus();
        }
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public int modifyTextureIndex(int texture) {
        if (texture != 3) {
            return texture;
        }
        int fireState = this.getOnFire();
        switch (fireState) {
            case 1: {
                texture = 4;
                break;
            }
            case 0: {
                texture = 3;
                break;
            }
            default: {
                texture = 5;
            }
        }
        return texture;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack((Block)IC2NuclearControl.blockNuclearControlMain, 1, 0);
    }
}

