/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.renderers;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import shedar.mods.ic2.nuclearcontrol.IScreenPart;
import shedar.mods.ic2.nuclearcontrol.api.CardState;
import shedar.mods.ic2.nuclearcontrol.api.IPanelDataSource;
import shedar.mods.ic2.nuclearcontrol.api.PanelString;
import shedar.mods.ic2.nuclearcontrol.panel.CardWrapperImpl;
import shedar.mods.ic2.nuclearcontrol.panel.Screen;
import shedar.mods.ic2.nuclearcontrol.renderers.model.ModelInfoPanel;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityAdvancedInfoPanel;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityInfoPanel;
import shedar.mods.ic2.nuclearcontrol.utils.StringUtils;

public class TileEntityInfoPanelRenderer
extends TileEntitySpecialRenderer {
    private static String implodeArray(String[] inputArray, String glueString) {
        String output = "";
        if (inputArray.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < inputArray.length; ++i) {
                if (inputArray[i] == null || inputArray[i].isEmpty()) continue;
                sb.append(glueString);
                sb.append(inputArray[i]);
            }
            output = sb.toString();
            if (output.length() > 1) {
                output = output.substring(1);
            }
        }
        return output;
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float f) {
        TileEntityInfoPanel core;
        Screen scr;
        boolean isPanel = tileEntity instanceof TileEntityInfoPanel;
        if (!isPanel && tileEntity instanceof IScreenPart && (scr = ((IScreenPart)tileEntity).getScreen()) != null && (core = scr.getCore((IBlockAccess)tileEntity.func_145831_w())) != null) {
            x += (double)(core.field_145851_c - tileEntity.field_145851_c);
            y += (double)(core.field_145848_d - tileEntity.field_145848_d);
            z += (double)(core.field_145849_e - tileEntity.field_145849_e);
            tileEntity = core;
            isPanel = tileEntity instanceof TileEntityInfoPanel;
        }
        if (isPanel) {
            int offsetY;
            int offsetX;
            TileEntityInfoPanel panel = (TileEntityInfoPanel)tileEntity;
            if (!panel.getPowered()) {
                return;
            }
            List<ItemStack> cards = panel.getCards();
            boolean anyCardFound = false;
            LinkedList<PanelString> joinedData = new LinkedList<PanelString>();
            for (ItemStack card : cards) {
                CardWrapperImpl helper;
                CardState state;
                List<PanelString> data;
                int displaySettings;
                if (card == null || !(card.func_77973_b() instanceof IPanelDataSource) || (displaySettings = panel.getDisplaySettingsByCard(card)) == 0 || (data = (state = (helper = new CardWrapperImpl(card, -1)).getState()) != CardState.OK && state != CardState.CUSTOM_ERROR ? StringUtils.getStateMessage(state) : panel.getCardData(displaySettings, card, helper)) == null) continue;
                joinedData.addAll(data);
                anyCardFound = true;
            }
            if (!anyCardFound) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glPolygonOffset((float)-10.0f, (float)-10.0f);
            GL11.glEnable((int)32823);
            short side = (short)Facing.field_71588_a[panel.getFacing()];
            Screen screen = panel.getScreen();
            float dx = 0.0625f;
            float dz = 0.0625f;
            float displayWidth = 0.875f;
            float displayHeight = 0.875f;
            if (screen != null) {
                y -= (double)(panel.field_145848_d - screen.maxY);
                z = side == 0 || side == 1 || side == 2 || side == 3 || side == 5 ? (z -= (double)(panel.field_145849_e - screen.minZ)) : (z -= (double)(panel.field_145849_e - screen.maxZ));
                x = side == 0 || side == 2 || side == 4 ? (x -= (double)(panel.field_145851_c - screen.minX)) : (x -= (double)(panel.field_145851_c - screen.maxX));
            }
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            switch (side) {
                case 0: {
                    if (screen == null) break;
                    displayWidth += (float)(screen.maxX - screen.minX);
                    displayHeight += (float)(screen.maxZ - screen.minZ);
                    break;
                }
                case 1: {
                    GL11.glTranslatef((float)1.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    if (screen == null) break;
                    displayWidth += (float)(screen.maxX - screen.minX);
                    displayHeight += (float)(screen.maxZ - screen.minZ);
                    break;
                }
                case 2: {
                    GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    if (screen == null) break;
                    displayWidth += (float)(screen.maxX - screen.minX);
                    displayHeight += (float)(screen.maxY - screen.minY);
                    break;
                }
                case 3: {
                    GL11.glTranslatef((float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    if (screen == null) break;
                    displayWidth += (float)(screen.maxX - screen.minX);
                    displayHeight += (float)(screen.maxY - screen.minY);
                    break;
                }
                case 4: {
                    GL11.glTranslatef((float)0.0f, (float)1.0f, (float)1.0f);
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    if (screen == null) break;
                    displayWidth += (float)(screen.maxZ - screen.minZ);
                    displayHeight += (float)(screen.maxY - screen.minY);
                    break;
                }
                case 5: {
                    GL11.glTranslatef((float)1.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    if (screen == null) break;
                    displayWidth += (float)(screen.maxZ - screen.minZ);
                    displayHeight += (float)(screen.maxY - screen.minY);
                }
            }
            float thickness = 1.0f;
            double angleHor = 0.0;
            double angleVert = 0.0;
            double[] deltas = null;
            if (panel instanceof TileEntityAdvancedInfoPanel && screen != null) {
                TileEntityAdvancedInfoPanel advPanel = (TileEntityAdvancedInfoPanel)panel;
                ModelInfoPanel model = new ModelInfoPanel();
                deltas = model.getDeltas(advPanel, screen);
                thickness = (float)((double)((float)advPanel.thickness / 16.0f) - (deltas[0] + deltas[1] + deltas[2] + deltas[3]) / 4.0);
            }
            GL11.glTranslatef((float)(dx + displayWidth / 2.0f), (float)thickness, (float)(dz + displayHeight / 2.0f));
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            switch (panel.rotation) {
                case 0: {
                    break;
                }
                case 1: {
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    float t = displayHeight;
                    displayHeight = displayWidth;
                    displayWidth = t;
                    break;
                }
                case 2: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    float tm = displayHeight;
                    displayHeight = displayWidth;
                    displayWidth = tm;
                    break;
                }
                case 3: {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
            }
            if (deltas != null) {
                if (deltas[0] == 0.0) {
                    angleHor = 57.29577951308232 * Math.atan(deltas[1] / (double)(displayWidth + 0.125f));
                    angleVert = -57.29577951308232 * Math.atan(deltas[2] / (double)(displayHeight + 0.125f));
                } else if (deltas[1] == 0.0) {
                    angleHor = -57.29577951308232 * Math.atan(deltas[0] / (double)(displayWidth + 0.125f));
                    angleVert = -57.29577951308232 * Math.atan(deltas[3] / (double)(displayHeight + 0.125f));
                } else if (deltas[2] == 0.0) {
                    angleHor = 57.29577951308232 * Math.atan(deltas[3] / (double)(displayWidth + 0.125f));
                    angleVert = 57.29577951308232 * Math.atan(deltas[0] / (double)(displayHeight + 0.125f));
                } else {
                    angleHor = -57.29577951308232 * Math.atan(deltas[2] / (double)(displayWidth + 0.125f));
                    angleVert = 57.29577951308232 * Math.atan(deltas[1] / (double)(displayHeight + 0.125f));
                }
            }
            GL11.glRotatef((float)((float)(-angleVert)), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)((float)angleHor), (float)0.0f, (float)1.0f, (float)0.0f);
            FontRenderer fontRenderer = this.func_147498_b();
            int maxWidth = 1;
            for (PanelString panelString : joinedData) {
                String currentString = TileEntityInfoPanelRenderer.implodeArray(new String[]{panelString.textLeft, panelString.textCenter, panelString.textRight}, " ");
                maxWidth = Math.max(fontRenderer.func_78256_a(currentString), maxWidth);
            }
            int lineHeight = fontRenderer.field_78288_b + 2;
            int requiredHeight = lineHeight * joinedData.size();
            float scaleX = displayWidth / (float)(maxWidth += 4);
            float scaleY = displayHeight / (float)requiredHeight;
            float scale = Math.min(scaleX, scaleY);
            GL11.glScalef((float)scale, (float)(-scale), (float)scale);
            GL11.glDepthMask((boolean)false);
            int realHeight = (int)Math.floor(displayHeight / scale);
            int realWidth = (int)Math.floor(displayWidth / scale);
            if (scaleX < scaleY) {
                offsetX = 2;
                offsetY = (realHeight - requiredHeight) / 2;
            } else {
                offsetX = (realWidth - maxWidth) / 2 + 2;
                offsetY = 0;
            }
            Block block = panel.func_145831_w().func_147439_a(panel.field_145851_c, panel.field_145848_d, panel.field_145849_e);
            if (block == null) {
                block = Blocks.field_150348_b;
            }
            GL11.glDisable((int)2896);
            int row = 0;
            for (PanelString panelString : joinedData) {
                if (panelString.textLeft != null) {
                    fontRenderer.func_78276_b(panelString.textLeft, offsetX - realWidth / 2, 1 + offsetY - realHeight / 2 + row * lineHeight, panelString.colorLeft != 0 ? panelString.colorLeft : panel.getColorTextHex());
                }
                if (panelString.textCenter != null) {
                    fontRenderer.func_78276_b(panelString.textCenter, -fontRenderer.func_78256_a(panelString.textCenter) / 2, offsetY - realHeight / 2 + row * lineHeight, panelString.colorCenter != 0 ? panelString.colorCenter : panel.getColorTextHex());
                }
                if (panelString.textRight != null) {
                    fontRenderer.func_78276_b(panelString.textRight, realWidth / 2 - fontRenderer.func_78256_a(panelString.textRight), offsetY - realHeight / 2 + row * lineHeight, panelString.colorRight != 0 ? panelString.colorRight : panel.getColorTextHex());
                }
                ++row;
            }
            GL11.glEnable((int)2896);
            GL11.glDepthMask((boolean)true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)32823);
            GL11.glPopMatrix();
        }
    }
}

