/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.crossmod.ic2;

import ic2.api.tile.IEnergyStorage;
import ic2.core.block.reactor.tileentity.TileEntityNuclearReactorElectric;
import ic2.core.block.reactor.tileentity.TileEntityReactorAccessHatch;
import ic2.core.block.reactor.tileentity.TileEntityReactorRedstonePort;
import ic2.core.item.reactor.ItemReactorLithiumCell;
import ic2.core.item.reactor.ItemReactorUranium;
import ic2.core.item.tool.ItemToolWrench;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import shedar.mods.ic2.nuclearcontrol.crossmod.EnergyStorageData;
import shedar.mods.ic2.nuclearcontrol.crossmod.ic2.IC2Cross;
import shedar.mods.ic2.nuclearcontrol.crossmod.ic2.IC2Type;

public class IC2ExpCross
extends IC2Cross {
    @Override
    public int getNuclearCellTimeLeft(ItemStack par1) {
        if (par1 == null) {
            return 0;
        }
        if (par1.func_77973_b() instanceof ItemReactorUranium) {
            return 20000 - par1.func_77960_j();
        }
        if (par1.func_77973_b() instanceof ItemReactorLithiumCell) {
            return 10000 - par1.func_77960_j();
        }
        return 0;
    }

    @Override
    public IC2Type getType() {
        return IC2Type.EXP;
    }

    @Override
    public boolean isWrench(ItemStack par1) {
        return par1 != null && par1.func_77973_b() instanceof ItemToolWrench;
    }

    @Override
    public boolean isSteamReactor(TileEntity par1) {
        return false;
    }

    @Override
    public EnergyStorageData getStorageData(TileEntity target) {
        if (target instanceof IEnergyStorage) {
            IEnergyStorage storage = (IEnergyStorage)target;
            EnergyStorageData result = new EnergyStorageData();
            result.capacity = storage.getCapacity();
            result.stored = storage.getStored();
            result.units = "EU";
            result.type = 0;
            return result;
        }
        return null;
    }

    @Override
    public IC2Cross.ReactorInfo getReactorInfo(TileEntity par1) {
        if (par1 == null || !(par1 instanceof TileEntityNuclearReactorElectric)) {
            return null;
        }
        TileEntityNuclearReactorElectric reactor = (TileEntityNuclearReactorElectric)par1;
        IC2Cross.ReactorInfo info = new IC2Cross.ReactorInfo();
        info.isOnline = reactor.getActive();
        info.outTank = reactor.getoutputtank().getFluidAmount();
        info.inTank = reactor.getinputtank().getFluidAmount();
        info.emitHeat = reactor.EmitHeat;
        info.coreTemp = (int)((double)reactor.getHeat() / (double)reactor.getMaxHeat() * 100.0);
        return info;
    }

    @Override
    public boolean isMultiReactorPart(TileEntity par1) {
        return par1 instanceof TileEntityReactorRedstonePort || par1 instanceof TileEntityReactorAccessHatch;
    }
}

