/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.island.laboratory;

import chylex.hee.system.logging.Log;
import chylex.hee.system.util.CycleProtection;
import chylex.hee.world.structure.island.biome.feature.island.laboratory.LaboratoryContent;
import chylex.hee.world.structure.island.biome.feature.island.laboratory.LaboratoryElement;
import chylex.hee.world.structure.island.biome.feature.island.laboratory.LaboratoryElementPlacer;
import chylex.hee.world.structure.island.biome.feature.island.laboratory.LaboratoryElementType;
import chylex.hee.world.structure.island.biome.feature.island.laboratory.LaboratoryPlan;
import chylex.hee.world.structure.util.pregen.LargeStructureWorld;
import chylex.hee.world.util.Direction;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class LaboratoryGenerator {
    private final TIntObjectHashMap<LaboratoryElement> elements;
    private final List<LaboratoryElement> roomElements;

    public LaboratoryGenerator(LaboratoryPlan plan) {
        this.elements = new TIntObjectHashMap(plan.elements.size());
        this.roomElements = plan.roomElements;
        for (LaboratoryElement element : plan.elements) {
            this.elements.put((element.x + 104) * 209 + element.z, (Object)element);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void generateInWorld(LargeStructureWorld world, Random rand) {
        ArrayList<int[]> stairs = new ArrayList<int[]>();
        for (LaboratoryElement room : this.roomElements) {
            if (room.type == LaboratoryElementType.SMALL_ROOM) {
                LaboratoryElementPlacer.generateSmallRoom(world, rand, room.x, room.y, room.z);
                continue;
            }
            LaboratoryElementPlacer.generateLargeRoom(world, rand, room.x, room.y, room.z);
        }
        for (LaboratoryElement room : this.roomElements) {
            block2: for (int dir = 0; dir < 4; ++dir) {
                int zz;
                int xx;
                if (!room.connected[dir]) continue;
                room.connected[dir] = false;
                int offX = Direction.offsetX[dir];
                int offZ = Direction.offsetZ[dir];
                int fromX = xx = room.x + offX * (room.type.halfSizeX + 1);
                int fromZ = zz = room.z + offZ * (room.type.halfSizeZ + 1);
                int yy = room.y;
                int dist = 1;
                LaboratoryElementPlacer.generateRoomEntrance(world, rand, fromX - offX, yy, fromZ - offZ, offX != 0);
                CycleProtection.setCounter(512);
                while (CycleProtection.proceed()) {
                    ++dist;
                    LaboratoryElement hall = this.getAt(xx += offX, zz += offZ);
                    if (hall == null) {
                        LaboratoryElement nextRoom = null;
                        int tx = xx;
                        int tz = zz;
                        for (int test = 0; test < 16; ++test) {
                            LaboratoryElement element = this.getAt(tx += offX, tz += offZ);
                            if (element == null) continue;
                            nextRoom = element;
                            break;
                        }
                        if (nextRoom == null) {
                            Log.error("Next room is null, this was never supposed to happen!", new Object[0]);
                            continue;
                        }
                        if (nextRoom.y != yy) {
                            stairs.add(new int[]{xx -= offX, yy, zz -= offZ, nextRoom.y - yy, dir});
                        }
                        LaboratoryElementPlacer.generateHall(world, rand, fromX, fromZ, xx - offX, zz - offZ, yy, offX != 0);
                        if (nextRoom.y != yy) {
                            xx += offX;
                            zz += offZ;
                            yy = nextRoom.y;
                        }
                        LaboratoryElementPlacer.generateRoomEntrance(world, rand, xx, yy, zz, offX != 0);
                        break;
                    }
                    if (hall.y == yy) continue;
                    LaboratoryElementPlacer.generateHall(world, rand, fromX, fromZ, xx - offX, zz - offZ, yy, offX != 0);
                    stairs.add(new int[]{xx, yy, zz, hall.y - yy, dir});
                    fromX = xx += offX;
                    fromZ = zz += offZ;
                    yy = hall.y;
                }
                CycleProtection.reset();
                dist += room.type.halfSizeX * offX + room.type.halfSizeZ * offZ - 1;
                while (--dist >= 0) {
                    void var7_10;
                    void var6_9;
                    LaboratoryElement ele = this.getAt(xx, zz);
                    if (ele != null && ele.type.isRoom()) {
                        ele.connected[Direction.rotateOpposite[dir]] = false;
                        continue block2;
                    }
                    var3_6 += var6_9;
                    var5_8 += var7_10;
                }
            }
        }
        for (LaboratoryElement room : this.roomElements) {
            if (room.type == LaboratoryElementType.SMALL_ROOM) {
                LaboratoryContent.populateSmallRoom(world, rand, room.x, room.y, room.z);
                continue;
            }
            LaboratoryContent.populateLargeRoom(world, rand, room.x, room.y, room.z);
        }
        for (int[] array : stairs) {
            LaboratoryElementPlacer.generateHallStairs(world, rand, array[0], array[1], array[2], Direction.offsetX[array[4]], array[3], Direction.offsetZ[array[4]]);
        }
    }

    private LaboratoryElement getAt(int x, int z) {
        return (LaboratoryElement)this.elements.get((x + 104) * 209 + z);
    }
}

