/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.game.save;

import chylex.hee.game.save.SaveData;
import java.io.File;
import net.minecraft.nbt.NBTTagCompound;

public abstract class SaveFile {
    protected final String filename;
    private boolean wasModified = false;

    public SaveFile(String filename) {
        this.filename = filename;
    }

    protected File getFile(File root) {
        return new File(root, this.filename);
    }

    protected void setModified() {
        this.wasModified = true;
    }

    public boolean wasModified() {
        return this.wasModified;
    }

    public final void saveToNBT(File root) {
        this.wasModified = false;
        NBTTagCompound nbt = new NBTTagCompound();
        this.onSave(nbt);
        SaveData.saveFile(this.getFile(root), nbt);
    }

    public final void loadFromNBT(File root) {
        this.wasModified = false;
        this.onLoad(SaveData.readFile(this.getFile(root)));
    }

    protected abstract void onSave(NBTTagCompound var1);

    protected abstract void onLoad(NBTTagCompound var1);
}

