/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMachineCallback;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicHull;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import ic2.core.block.BlockIC2Door;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

public class GT_MetaTileEntity_Cleanroom
extends GT_MetaTileEntity_MultiBlockBase {
    private int mHeight = -1;
    private static final HashMap<String, ConfigEntry> config = new HashMap();
    private static final String category = "cleanroom_allowed_blocks";
    private static final int wildcard_meta = Short.MAX_VALUE;

    public GT_MetaTileEntity_Cleanroom(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_Cleanroom(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Cleanroom(this.mName);
    }

    @Override
    public String[] getDescription() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Cleanroom").addInfo("Controller block for the Cleanroom").addInfo("Consumes 40 EU/t when first turned on").addInfo("and 4 EU/t once at 100% efficiency when not overclocked").addInfo("An energy hatch accepts up to 2A, so you can use 2A LV or 1A MV").addInfo("2 LV batteries + 1 LV generator or 1 MV generator").addInfo("Time required to reach full efficiency is proportional to").addInfo("the height of empty space within").addInfo("Make sure your Energy Hatch matches! ?").addSeparator().beginVariableStructureBlock(3, 15, 4, 15, 3, 15, true).addController("Top center").addCasingInfo("Plascrete", 20).addStructureInfo(GT_Values.cleanroomGlass + "% of the Plascrete can be replaced with Reinforced Glass").addStructureInfo("Other material can be used in place of Plascrete. See config for detail").addOtherStructurePart("Filter Machine Casing", "Top besides controller and edges").addEnergyHatch("Any casing. Exactly one.").addMaintenanceHatch("Any casing").addStructureInfo("1x Reinforced Door (keep closed or efficiency will reduce)").addStructureInfo("Up to 10 Machine Hulls for Item & Energy transfer through walls").addStructureInfo("You can also use Diodes for more power").addStructureInfo("Diodes also count towards 10 Machine Hulls count limit").toolTipFinisher("Gregtech");
        if (Keyboard.isKeyDown((int)42)) {
            return tt.getStructureInformation();
        }
        return tt.getInformation();
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        this.mEfficiencyIncrease = 100;
        this.calculateOverclockedNessMulti(40, 45 * Math.max(1, this.mHeight - 1), 1, this.getMaxInputVoltage());
        this.mEUt /= -10;
        return true;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        byte tMeta;
        Block tBlock;
        int i;
        int x = 1;
        int z = 1;
        int y = 1;
        int mDoorCount = 0;
        int mHullCount = 0;
        int mPlascreteCount = 0;
        HashMap<String, Integer> otherBlocks = new HashMap<String, Integer>();
        boolean doorState = false;
        this.mUpdate = 100;
        if (GT_Values.debugCleanroom) {
            GT_Log.out.println("Cleanroom: Checking machine");
        }
        for (i = 1; i < 8; ++i) {
            tBlock = aBaseMetaTileEntity.getBlockOffset(i, 0, 0);
            tMeta = aBaseMetaTileEntity.getMetaIDOffset(i, 0, 0);
            if (tBlock == GregTech_API.sBlockCasings3 && tMeta == 11) continue;
            if (tBlock == GregTech_API.sBlockReinforced || tMeta == 2) {
                x = i;
                break;
            }
            if (GT_Values.debugCleanroom) {
                GT_Log.out.println("Cleanroom: Unable to detect room X edge?");
            }
            return false;
        }
        for (i = 1; i < 8; ++i) {
            tBlock = aBaseMetaTileEntity.getBlockOffset(0, 0, i);
            tMeta = aBaseMetaTileEntity.getMetaIDOffset(0, 0, i);
            if (tBlock == GregTech_API.sBlockCasings3 && tMeta == 11) continue;
            if (tBlock == GregTech_API.sBlockReinforced || tMeta == 2) {
                z = i;
                break;
            }
            if (GT_Values.debugCleanroom) {
                GT_Log.out.println("Cleanroom: Unable to detect room Z edge?");
            }
            return false;
        }
        for (i = -x + 1; i < x; ++i) {
            for (int j = -z + 1; j < z; ++j) {
                if (i == 0 && j == 0) continue;
                Block tBlock2 = aBaseMetaTileEntity.getBlockOffset(j, 0, i);
                byte tMeta2 = aBaseMetaTileEntity.getMetaIDOffset(j, 0, i);
                if (tBlock2 == GregTech_API.sBlockCasings3 || tMeta2 == 11) continue;
                return false;
            }
        }
        for (i = -1; i > -16; --i) {
            tBlock = aBaseMetaTileEntity.getBlockOffset(x, i, z);
            tMeta = aBaseMetaTileEntity.getMetaIDOffset(x, i, z);
            if (tBlock == GregTech_API.sBlockReinforced && tMeta == 2) continue;
            y = i + 1;
            break;
        }
        if (y > -2) {
            if (GT_Values.debugCleanroom) {
                GT_Log.out.println("Cleanroom: Room not tall enough?");
            }
            return false;
        }
        for (int dX = -x; dX <= x; ++dX) {
            for (int dZ = -z; dZ <= z; ++dZ) {
                for (int dY = 0; dY >= y; --dY) {
                    if (dX != -x && dX != x && dY != 0 && dY != y && dZ != -z && dZ != z) continue;
                    Block tBlock3 = aBaseMetaTileEntity.getBlockOffset(dX, dY, dZ);
                    byte tMeta3 = aBaseMetaTileEntity.getMetaIDOffset(dX, dY, dZ);
                    if (dY == 0) {
                        if (dX == -x || dX == x || dZ == -z || dZ == z) {
                            if (tBlock3 == GregTech_API.sBlockReinforced && tMeta3 == 2) continue;
                            if (GT_Values.debugCleanroom) {
                                GT_Log.out.println("Cleanroom: Non reinforced block on top edge? tMeta != 2");
                            }
                            return false;
                        }
                        if (dX == 0 && dZ == 0 || tBlock3 == GregTech_API.sBlockCasings3 && tMeta3 == 11) continue;
                        if (GT_Values.debugCleanroom) {
                            GT_Log.out.println("Cleanroom: Non reinforced block on top face interior? tMeta != 11");
                        }
                        return false;
                    }
                    if (tBlock3 == GregTech_API.sBlockReinforced && tMeta3 == 2) {
                        ++mPlascreteCount;
                        continue;
                    }
                    IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(dX, dY, dZ);
                    if (this.addMaintenanceToMachineList(tTileEntity, 210) || this.addEnergyInputToMachineList(tTileEntity, 210)) continue;
                    if (tBlock3 instanceof BlockIC2Door) {
                        if ((tMeta3 & 8) == 0) {
                            if (Math.abs(dZ) < z) {
                                doorState = tMeta3 == 1 || tMeta3 == 3 || tMeta3 == 4 || tMeta3 == 6;
                            } else if (Math.abs(dX) < x) {
                                doorState = tMeta3 == 0 || tMeta3 == 2 || tMeta3 == 5 || tMeta3 == 7;
                            }
                        }
                        ++mDoorCount;
                        continue;
                    }
                    if (tTileEntity != null) {
                        IMetaTileEntity aMetaTileEntity = tTileEntity.getMetaTileEntity();
                        if (aMetaTileEntity == null) {
                            if (GT_Values.debugCleanroom) {
                                GT_Log.out.println("Cleanroom: Missing block? Not a aMetaTileEntity");
                            }
                            return false;
                        }
                        if (aMetaTileEntity instanceof GT_MetaTileEntity_BasicHull) {
                            ++mHullCount;
                            continue;
                        }
                        if (GT_Values.debugCleanroom) {
                            GT_Log.out.println("Cleanroom: Incorrect GT block? " + tBlock3.getUnlocalizedName());
                        }
                        return false;
                    }
                    String key = tBlock3.getUnlocalizedName() + ":" + tMeta3;
                    if (config.containsKey(key)) {
                        otherBlocks.compute(key, (k, v) -> v == null ? 1 : v + 1);
                        continue;
                    }
                    key = tBlock3.getUnlocalizedName();
                    if (config.containsKey(key)) {
                        otherBlocks.compute(key, (k, v) -> v == null ? 1 : v + 1);
                        continue;
                    }
                    if (GT_Values.debugCleanroom) {
                        GT_Log.out.println("Cleanroom: not allowed block " + tBlock3.getUnlocalizedName());
                    }
                    return false;
                }
            }
        }
        if (this.mMaintenanceHatches.size() != 1 || this.mEnergyHatches.size() != 1 || mDoorCount > 2 || mHullCount > 10) {
            return false;
        }
        if (mPlascreteCount < 20) {
            return false;
        }
        float ratio = (float)mPlascreteCount / 100.0f;
        for (Map.Entry e : otherBlocks.entrySet()) {
            ConfigEntry ce = config.get(e.getKey());
            if (!(ce.allowedCount > 0 ? (Integer)e.getValue() > ce.allowedCount : (float)((Integer)e.getValue()).intValue() > ratio * (float)ce.percentage)) continue;
            return false;
        }
        this.setCallbacks(x, y, z, aBaseMetaTileEntity);
        if (doorState) {
            this.mEfficiency = Math.max(0, this.mEfficiency - 200);
        }
        for (byte i2 = 0; i2 < 6; i2 = (byte)(i2 + 1)) {
            byte t = (byte)Math.max(1, (byte)(15.0f / (10000.0f / (float)this.mEfficiency)));
            aBaseMetaTileEntity.setInternalOutputRedstoneSignal(i2, t);
        }
        this.mHeight = -y;
        return true;
    }

    private void setCallbacks(int x, int y, int z, IGregTechTileEntity aBaseMetaTileEntity) {
        for (int dX = -x + 1; dX <= x - 1; ++dX) {
            for (int dZ = -z + 1; dZ <= z - 1; ++dZ) {
                for (int dY = -1; dY >= y + 1; --dY) {
                    TileEntity tTileEntity = aBaseMetaTileEntity.getTileEntityOffset(dX, dY, dZ);
                    if (tTileEntity instanceof IGregTechTileEntity) {
                        IMetaTileEntity iMetaTileEntity = ((IGregTechTileEntity)tTileEntity).getMetaTileEntity();
                        if (!(iMetaTileEntity instanceof IMachineCallback)) continue;
                        this.checkAndSetCallback((IMachineCallback)((Object)iMetaTileEntity));
                        continue;
                    }
                    if (!(tTileEntity instanceof IMachineCallback)) continue;
                    this.checkAndSetCallback((IMachineCallback)tTileEntity);
                }
            }
        }
    }

    private void checkAndSetCallback(IMachineCallback<?> iMachineCallback) {
        if (GT_Values.debugCleanroom) {
            GT_Log.out.println("Cleanroom: IMachineCallback detected, checking for cleanroom: " + (iMachineCallback.getType() == this.getClass()));
        }
        if (iMachineCallback.getType() == this.getClass()) {
            iMachineCallback.setCallbackBase(this);
        }
    }

    @Override
    public boolean allowGeneralRedstoneOutput() {
        return true;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == ForgeDirection.DOWN.ordinal() || aSide == ForgeDirection.UP.ordinal()) {
            return new ITexture[]{TextureFactory.of(Textures.BlockIcons.BLOCK_PLASCRETE), aActive ? TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_CLEANROOM_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_CLEANROOM_ACTIVE_GLOW).glow().build()) : TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_CLEANROOM), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_CLEANROOM_GLOW).glow().build())};
        }
        return new ITexture[]{TextureFactory.of(Textures.BlockIcons.BLOCK_PLASCRETE)};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "MultiblockDisplay.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private static void setDefaultConfigValues(Configuration cfg) {
        cfg.get("cleanroom_allowed_blocks.reinforced_glass", "Name", "blockAlloyGlass");
        cfg.get("cleanroom_allowed_blocks.reinforced_glass", "Percentage", 5);
        cfg.get("cleanroom_allowed_blocks.bw_reinforced_glass_0", "Name", "BW_GlasBlocks");
        cfg.get("cleanroom_allowed_blocks.bw_reinforced_glass_0", "Percentage", 50);
        cfg.get("cleanroom_allowed_blocks.bw_reinforced_glass_0", "Meta", 0);
        cfg.get("cleanroom_allowed_blocks.bw_reinforced_glass", "Name", "BW_GlasBlocks");
        cfg.get("cleanroom_allowed_blocks.bw_reinforced_glass", "Percentage", 100);
        cfg.get("cleanroom_allowed_blocks.elevator", "Name", "tile.openblocks.elevator");
        cfg.get("cleanroom_allowed_blocks.elevator", "Count", 1);
        cfg.get("cleanroom_allowed_blocks.travel_anchor", "Name", "tile.blockTravelAnchor");
        cfg.get("cleanroom_allowed_blocks.travel_anchor", "Count", 1);
        cfg.get("cleanroom_allowed_blocks.warded_glass", "Name", "tile.blockCosmeticOpaque");
        cfg.get("cleanroom_allowed_blocks.warded_glass", "Meta", 2);
        cfg.get("cleanroom_allowed_blocks.warded_glass", "Percentage", 50);
    }

    public static void loadConfig(Configuration cfg) {
        if (!cfg.hasCategory(category)) {
            GT_MetaTileEntity_Cleanroom.setDefaultConfigValues(cfg);
        }
        for (ConfigCategory cc : cfg.getCategory(category).getChildren()) {
            String name = cc.get("Name").getString();
            if (cc.containsKey("Count")) {
                if (cc.containsKey("Meta")) {
                    config.put(name + ":" + cc.get("Meta").getInt(), new ConfigEntry(0, cc.get("Count").getInt(), cc.get("Meta").getInt()));
                    continue;
                }
                config.put(name, new ConfigEntry(0, cc.get("Count").getInt(), Short.MAX_VALUE));
                continue;
            }
            if (!cc.containsKey("Percentage")) continue;
            if (cc.containsKey("Meta")) {
                config.put(name + ":" + cc.get("Meta").getInt(), new ConfigEntry(cc.get("Percentage").getInt(), 0, cc.get("Meta").getInt()));
                continue;
            }
            config.put(name, new ConfigEntry(cc.get("Percentage").getInt(), 0, Short.MAX_VALUE));
        }
    }

    private static class ConfigEntry {
        int percentage;
        int allowedCount;
        int meta;

        ConfigEntry(int percentage, int count, int meta) {
            this.percentage = percentage;
            this.allowedCount = count;
            this.meta = meta;
        }
    }
}

