/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Element;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_DataOrb;
import java.util.HashMap;
import java.util.NoSuchElementException;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_Replicator
extends GT_MetaTileEntity_BasicMachine {
    public static final HashMap<Materials, Long> MASS_OVERRIDES = new HashMap();
    public static final double EXPONENT = GregTech_API.sOPStuff.get((Object)"Replicator", "Nerf Exponent", 1.2);
    private static int sHeaviestElementMass = 0;

    public GT_MetaTileEntity_Replicator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "Producing Elemental Matter", 1, 1, "Replicator.png", "", TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_REPLICATOR_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_REPLICATOR_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_REPLICATOR), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_REPLICATOR_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_REPLICATOR_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_REPLICATOR_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_REPLICATOR), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_REPLICATOR_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_REPLICATOR_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_REPLICATOR_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_REPLICATOR), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_REPLICATOR_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_REPLICATOR_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_REPLICATOR_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_REPLICATOR), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_REPLICATOR_GLOW).glow().build()));
    }

    public GT_MetaTileEntity_Replicator(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, aGUIName, aNEIName);
    }

    public GT_MetaTileEntity_Replicator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, aGUIName, aNEIName);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Replicator(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName, this.mNEIName);
    }

    public static long cubicFluidMultiplier(long amount) {
        return (long)Math.pow(amount, EXPONENT);
    }

    @Override
    public int checkRecipe() {
        Materials tMaterial;
        long tMass;
        ItemStack tDataOrb;
        FluidStack tFluid = this.getFillableStack();
        if (tFluid != null && tFluid.isFluidEqual(Materials.UUMatter.getFluid(1L)) && ItemList.Tool_DataOrb.isStackEqual(tDataOrb = this.getSpecialSlot(), false, true) && Behaviour_DataOrb.getDataTitle(tDataOrb).equals("Elemental-Scan") && (long)tFluid.amount >= (tMass = GT_MetaTileEntity_Replicator.cubicFluidMultiplier(MASS_OVERRIDES.getOrDefault(tMaterial = Element.get((String)Behaviour_DataOrb.getDataName((ItemStack)tDataOrb)).mLinkedMaterials.get(0), tMaterial.getMass()))) && tMass > 0L) {
            this.mEUt = GT_Utility.safeInt(GT_Values.V[this.mTier], 1);
            this.mMaxProgresstime = GT_Utility.safeInt(tMass * 1024L / (1L << this.mTier), 1);
            if (this.mMaxProgresstime == 0x7FFFFFFE || this.mEUt == 0x7FFFFFFE) {
                return 1;
            }
            this.mOutputItems[0] = GT_OreDictUnificator.get(OrePrefixes.dust, tMaterial, 1L);
            if (this.mOutputItems[0] == null) {
                this.mOutputItems[0] = GT_OreDictUnificator.get(OrePrefixes.cell, tMaterial, 1L);
                if (this.mOutputItems[0] != null) {
                    this.mOutputFluid = GT_Utility.getFluidForFilledItem(this.mOutputItems[0], true);
                    if (this.mOutputFluid == null) {
                        if (ItemList.Cell_Empty.isStackEqual(this.getInputAt(0)) && this.canOutput(this.mOutputItems[0])) {
                            --this.getInputAt((int)0).stackSize;
                            tFluid.amount = (int)((long)tFluid.amount - tMass);
                            return 2;
                        }
                    } else {
                        this.mOutputItems[0] = null;
                        if (this.getDrainableStack() == null || this.getDrainableStack().isFluidEqual(this.mOutputFluid) && this.getDrainableStack().amount < 16000) {
                            tFluid.amount = (int)((long)tFluid.amount - tMass);
                            return 2;
                        }
                    }
                }
            } else if (this.canOutput(this.mOutputItems[0])) {
                tFluid.amount = (int)((long)tFluid.amount - tMass);
                return 2;
            }
        }
        return 0;
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeList() {
        return GT_Recipe.GT_Recipe_Map.sReplicatorFakeRecipes;
    }

    @Override
    protected boolean allowPutStackValidated(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return super.allowPutStackValidated(aBaseMetaTileEntity, aIndex, aSide, aStack) && ItemList.Cell_Empty.isStackEqual(aStack);
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return aFluid.isFluidEqual(Materials.UUMatter.getFluid(1L));
    }

    @Override
    public int getCapacity() {
        if (sHeaviestElementMass == 0 && GregTech_API.sPostloadFinished) {
            sHeaviestElementMass = Materials.getMaterialsMap().values().stream().mapToInt(material -> (int)GT_MetaTileEntity_Replicator.cubicFluidMultiplier((int)material.getMass())).max().orElseThrow(NoSuchElementException::new);
            sHeaviestElementMass = 1000 * (sHeaviestElementMass / 1000 + 1);
        }
        return sHeaviestElementMass;
    }
}

