/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.GT_Packet_New;
import gregtech.common.items.GT_VolumetricFlask;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public final class MessageSetFlaskCapacity
extends GT_Packet_New {
    private int capacity;
    private int dimID;
    private int playerID;

    public MessageSetFlaskCapacity() {
        super(true);
    }

    public MessageSetFlaskCapacity(int capacity, int dimID, int playerID) {
        super(false);
        this.capacity = capacity;
        this.dimID = dimID;
        this.playerID = playerID;
    }

    public MessageSetFlaskCapacity(int capacity, EntityPlayer p) {
        super(false);
        this.capacity = capacity;
        this.dimID = p.worldObj.provider.dimensionId;
        this.playerID = p.getEntityId();
    }

    @Override
    public byte getPacketID() {
        return 5;
    }

    @Override
    public void encode(ByteBuf aOut) {
        aOut.writeInt(this.capacity);
        aOut.writeInt(this.dimID);
        aOut.writeInt(this.playerID);
    }

    @Override
    public GT_Packet_New decode(ByteArrayDataInput aData) {
        return new MessageSetFlaskCapacity(aData.readInt(), aData.readInt(), aData.readInt());
    }

    @Override
    public void process(IBlockAccess aWorld) {
        Item item;
        ItemStack stack;
        WorldServer w = DimensionManager.getWorld((int)this.dimID);
        if (w != null && w.getEntityByID(this.playerID) instanceof EntityPlayer && (stack = ((EntityPlayer)w.getEntityByID(this.playerID)).getHeldItem()) != null && stack.stackSize > 0 && (item = stack.getItem()) instanceof GT_VolumetricFlask) {
            ((GT_VolumetricFlask)item).setCapacity(stack, this.capacity);
        }
    }
}

