/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import gregtech.common.items.PollenType;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemPollen
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon secondIcon;

    public ItemPollen() {
        this.setCreativeTab(Tabs.tabApiculture);
        this.setHasSubtypes(true);
        this.setUnlocalizedName("gt.pollen");
        GameRegistry.registerItem((Item)this, (String)"gt.pollen", (String)"gregtech");
    }

    public ItemStack getStackForType(PollenType type) {
        return new ItemStack((Item)this, 1, type.ordinal());
    }

    public ItemStack getStackForType(PollenType type, int count) {
        return new ItemStack((Item)this, count, type.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tabs, List list) {
        for (PollenType type : PollenType.values()) {
            if (!type.showInList) continue;
            list.add(this.getStackForType(type));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    public int getRenderPasses(int meta) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("forestry:pollen.0");
        this.secondIcon = par1IconRegister.registerIcon("forestry:pollen.1");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return pass == 0 ? this.itemIcon : this.secondIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int pass) {
        int meta = Math.max(0, Math.min(PollenType.values().length - 1, stack.getItemDamage()));
        int colour = PollenType.values()[meta].getColours()[0];
        if (pass >= 1) {
            colour = PollenType.values()[meta].getColours()[1];
        }
        return colour;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        return PollenType.values()[stack.getItemDamage()].getName();
    }
}

