/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_Values;
import gregtech.common.gui.GT_ContainerVolumetricFlask;
import gregtech.common.items.GT_VolumetricFlask;
import gregtech.common.net.MessageSetFlaskCapacity;
import java.text.DecimalFormat;
import java.text.ParseException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class GT_GUIContainerVolumetricFlask
extends GuiContainer {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("gregtech:textures/gui/VolumetricFlask.png");
    private GuiIntegerBox amount;
    private GuiButton apply;
    private GuiButton plus1;
    private GuiButton plus10;
    private GuiButton plus100;
    private GuiButton plus1000;
    private GuiButton minus1;
    private GuiButton minus10;
    private GuiButton minus100;
    private GuiButton minus1000;
    private GT_ContainerVolumetricFlask container;

    public GT_GUIContainerVolumetricFlask(GT_ContainerVolumetricFlask container) {
        super((Container)container);
        this.container = container;
    }

    public void initGui() {
        super.initGui();
        this.plus1 = new GuiButton(0, this.guiLeft + 20, this.guiTop + 26, 22, 20, "+1");
        this.buttonList.add(this.plus1);
        this.plus10 = new GuiButton(0, this.guiLeft + 48, this.guiTop + 26, 28, 20, "+10");
        this.buttonList.add(this.plus10);
        this.plus100 = new GuiButton(0, this.guiLeft + 82, this.guiTop + 26, 32, 20, "+100");
        this.buttonList.add(this.plus100);
        this.plus1000 = new GuiButton(0, this.guiLeft + 120, this.guiTop + 26, 38, 20, "+1000");
        this.buttonList.add(this.plus1000);
        this.minus1 = new GuiButton(0, this.guiLeft + 20, this.guiTop + 75, 22, 20, "-1");
        this.buttonList.add(this.minus1);
        this.minus10 = new GuiButton(0, this.guiLeft + 48, this.guiTop + 75, 28, 20, "-10");
        this.buttonList.add(this.minus10);
        this.minus100 = new GuiButton(0, this.guiLeft + 82, this.guiTop + 75, 32, 20, "-100");
        this.buttonList.add(this.minus100);
        this.minus1000 = new GuiButton(0, this.guiLeft + 120, this.guiTop + 75, 38, 20, "-1000");
        this.buttonList.add(this.minus1000);
        this.apply = new GuiButton(0, this.guiLeft + 128, this.guiTop + 51, 38, 20, "Accept");
        this.buttonList.add(this.apply);
        this.amount = new GuiIntegerBox(this.fontRendererObj, this.guiLeft + 62, this.guiTop + 57, 59, this.fontRendererObj.FONT_HEIGHT, ((GT_VolumetricFlask)this.container.flask.getItem()).getMaxCapacity());
        this.amount.setEnableBackgroundDrawing(false);
        this.amount.setMaxStringLength(16);
        this.amount.setTextColor(0xFFFFFF);
        this.amount.setVisible(true);
        this.amount.setFocused(true);
        this.amount.setText("1");
        System.out.println(((GT_VolumetricFlask)this.container.flask.getItem()).getCapacity(this.container.flask));
        this.amount.setText(String.valueOf(((GT_VolumetricFlask)this.container.flask.getItem()).getCapacity(this.container.flask)));
    }

    protected final void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(BACKGROUND);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        try {
            Long.parseLong(this.amount.getText());
            this.apply.enabled = this.amount.getText().length() > 0;
        }
        catch (NumberFormatException e) {
            this.apply.enabled = false;
        }
        this.amount.drawTextBox();
    }

    protected void keyTyped(char character, int key) {
        if (!this.checkHotbarKeys(key)) {
            if (key == 28) {
                this.actionPerformed(this.apply);
            }
            if ((key == 211 || key == 205 || key == 203 || key == 14 || character == '-' || Character.isDigit(character)) && this.amount.textboxKeyTyped(character, key)) {
                try {
                    long result;
                    String out = this.amount.getText();
                    boolean fixed = false;
                    while (out.startsWith("0") && out.length() > 1) {
                        out = out.substring(1);
                        fixed = true;
                    }
                    if (fixed) {
                        this.amount.setText(out);
                    }
                    if (out.isEmpty()) {
                        out = "0";
                    }
                    if ((result = Long.parseLong(out)) < 0L) {
                        this.amount.setText("1");
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                super.keyTyped(character, key);
            }
        }
    }

    protected void actionPerformed(GuiButton btn) {
        boolean isMinus;
        try {
            if (btn == this.apply) {
                GT_Values.NW.sendToServer(new MessageSetFlaskCapacity(Integer.parseInt(this.amount.getText()), (EntityPlayer)Minecraft.getMinecraft().thePlayer));
                this.mc.thePlayer.closeScreen();
            }
        }
        catch (NumberFormatException e) {
            this.amount.setText("1");
        }
        boolean isPlus = btn == this.plus1 || btn == this.plus10 || btn == this.plus100 || btn == this.plus1000;
        boolean bl = isMinus = btn == this.minus1 || btn == this.minus10 || btn == this.minus100 || btn == this.minus1000;
        if (isPlus || isMinus) {
            this.addQty(this.getQty(btn));
        }
    }

    private void addQty(int i) {
        try {
            long result;
            String out = this.amount.getText();
            boolean fixed = false;
            while (out.startsWith("0") && out.length() > 1) {
                out = out.substring(1);
                fixed = true;
            }
            if (fixed) {
                this.amount.setText(out);
            }
            if (out.isEmpty()) {
                out = "0";
            }
            if ((result = (long)Integer.parseInt(out)) == 1L && i > 1) {
                result = 0L;
            }
            if ((result += (long)i) < 1L) {
                result = 1L;
            }
            out = Long.toString(result);
            Integer.parseInt(out);
            this.amount.setText(out);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected int getQty(GuiButton btn) {
        try {
            DecimalFormat df = new DecimalFormat("+#;-#");
            return df.parse(btn.displayString).intValue();
        }
        catch (ParseException parseException) {
            return 0;
        }
    }

    public class GuiIntegerBox
    extends GuiTextField {
        private final int maxValue;

        public GuiIntegerBox(FontRenderer fontRenderer, int x, int y, int width, int height) {
            this(fontRenderer, x, y, width, height, Integer.MAX_VALUE);
        }

        public GuiIntegerBox(FontRenderer fontRenderer, int x, int y, int width, int height, int maxValue) {
            super(fontRenderer, x, y, width, height);
            this.maxValue = maxValue;
        }

        public void writeText(String selectedText) {
            String original = this.getText();
            super.writeText(selectedText);
            try {
                int i = Integer.parseInt(this.getText());
                if (i > this.maxValue) {
                    this.setText(String.valueOf(this.maxValue));
                } else if (i < 0) {
                    this.setText("0");
                }
            }
            catch (NumberFormatException e) {
                this.setText(original);
            }
        }

        public void setText(String s) {
            try {
                int i = Integer.parseInt(s);
                if (i > this.maxValue) {
                    s = String.valueOf(this.maxValue);
                } else if (i < 0) {
                    s = "0";
                }
            }
            catch (NumberFormatException e) {
                s = String.valueOf(this.maxValue);
            }
            super.setText(s);
        }
    }
}

