/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.entities;

import com.mojang.authlib.GameProfile;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class GT_Entity_Arrow
extends EntityArrow {
    private int mHitBlockX = -1;
    private int mHitBlockY = -1;
    private int mHitBlockZ = -1;
    private Block mHitBlock = Blocks.air;
    private int mHitBlockMeta = 0;
    private boolean inGround = false;
    private int mTicksAlive = 0;
    private int ticksInAir = 0;
    private int mKnockback = 0;
    private ItemStack mArrow = null;

    public GT_Entity_Arrow(World aWorld) {
        super(aWorld);
    }

    public GT_Entity_Arrow(World aWorld, double aX, double aY, double aZ) {
        super(aWorld, aX, aY, aZ);
    }

    public GT_Entity_Arrow(World aWorld, EntityLivingBase aEntity, float aSpeed) {
        super(aWorld, aEntity, aSpeed);
    }

    public GT_Entity_Arrow(EntityArrow aArrow, ItemStack aStack) {
        super(aArrow.worldObj);
        NBTTagCompound tNBT = new NBTTagCompound();
        aArrow.writeToNBT(tNBT);
        this.readFromNBT(tNBT);
        this.setArrowItem(aStack);
    }

    public void onUpdate() {
        Block tBlock;
        this.onEntityUpdate();
        if (this.mArrow == null && !this.worldObj.isRemote) {
            this.setDead();
            return;
        }
        Entity tShootingEntity = this.shootingEntity;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float f = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(this.motionY, f) * 180.0 / Math.PI);
        }
        if (this.mTicksAlive++ == 3000) {
            this.setDead();
        }
        if ((tBlock = this.worldObj.getBlock(this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ)).getMaterial() != Material.air) {
            tBlock.setBlockBoundsBasedOnState((IBlockAccess)this.worldObj, this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ);
            AxisAlignedBB axisalignedbb = tBlock.getCollisionBoundingBoxFromPool(this.worldObj, this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ);
            if (axisalignedbb != null && axisalignedbb.isVecInside(Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ))) {
                this.inGround = true;
            }
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround) {
            int j = this.worldObj.getBlockMetadata(this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ);
            if (tBlock != this.mHitBlock || j != this.mHitBlockMeta) {
                this.inGround = false;
                this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
                this.mTicksAlive = 0;
                this.ticksInAir = 0;
            }
        } else {
            ++this.ticksInAir;
            Vec3 vec31 = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
            Vec3 vec3 = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
            MovingObjectPosition tVector = this.worldObj.func_147447_a(vec31, vec3, false, true, false);
            vec31 = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
            vec3 = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
            if (tVector != null) {
                vec3 = Vec3.createVectorHelper((double)tVector.hitVec.xCoord, (double)tVector.hitVec.yCoord, (double)tVector.hitVec.zCoord);
            }
            Entity tHitEntity = null;
            List tAllPotentiallyHitEntities = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
            double tLargestDistance = Double.MAX_VALUE;
            for (int i2 = 0; i2 < tAllPotentiallyHitEntities.size(); ++i2) {
                double tDistance;
                AxisAlignedBB axisalignedbb1;
                MovingObjectPosition movingobjectposition1;
                Entity entity1 = (Entity)tAllPotentiallyHitEntities.get(i2);
                if (!entity1.canBeCollidedWith() || entity1 == tShootingEntity && this.ticksInAir < 5 || (movingobjectposition1 = (axisalignedbb1 = entity1.boundingBox.expand(0.3, 0.3, 0.3)).calculateIntercept(vec31, vec3)) == null || !((tDistance = vec31.distanceTo(movingobjectposition1.hitVec)) < tLargestDistance)) continue;
                tHitEntity = entity1;
                tLargestDistance = tDistance;
            }
            if (tHitEntity != null) {
                tVector = new MovingObjectPosition(tHitEntity);
            }
            if (tVector != null && tVector.entityHit instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)tVector.entityHit;
                if (entityplayer.capabilities.disableDamage || tShootingEntity instanceof EntityPlayer && !((EntityPlayer)tShootingEntity).canAttackPlayer(entityplayer)) {
                    tVector = null;
                }
            }
            if (tVector != null) {
                if (tVector.entityHit != null) {
                    int tHitTimer;
                    int tKnockback;
                    ItemData tData = GT_OreDictUnificator.getItemData(this.mArrow);
                    float tMagicDamage = tVector.entityHit instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a((ItemStack)this.mArrow, (EnumCreatureAttribute)((EntityLivingBase)tVector.entityHit).getCreatureAttribute()) : 0.0f;
                    float tDamage = MathHelper.ceiling_double_int((double)((double)MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ)) * (this.getDamage() + (double)(tData != null && tData.mMaterial != null && tData.mMaterial.mMaterial != null ? (float)tData.mMaterial.mMaterial.mToolQuality / 2.0f - 1.0f : 0.0f))));
                    if (this.getIsCritical()) {
                        tDamage += (float)this.rand.nextInt((int)((double)tDamage / 2.0 + 2.0));
                    }
                    int tFireDamage = (this.isBurning() ? 5 : 0) + 4 * EnchantmentHelper.getEnchantmentLevel((int)Enchantment.fireAspect.effectId, (ItemStack)this.mArrow);
                    int[] tDamages = this.onHitEntity(tVector.entityHit, (Entity)(tShootingEntity == null ? this : tShootingEntity), this.mArrow == null ? new ItemStack(Items.arrow, 1) : this.mArrow, (int)(tDamage * 2.0f), (int)(tMagicDamage * 2.0f), tKnockback = this.mKnockback + EnchantmentHelper.getEnchantmentLevel((int)Enchantment.knockback.effectId, (ItemStack)this.mArrow), tFireDamage, tHitTimer = -1);
                    if (tDamages != null) {
                        tDamage = (float)tDamages[0] / 2.0f;
                        tMagicDamage = (float)tDamages[1] / 2.0f;
                        tKnockback = tDamages[2];
                        tFireDamage = tDamages[3];
                        tHitTimer = tDamages[4];
                        if (tFireDamage > 0 && !(tVector.entityHit instanceof EntityEnderman)) {
                            tVector.entityHit.setFire(tFireDamage);
                        }
                        if (!(tHitEntity instanceof EntityPlayer) && EnchantmentHelper.getEnchantmentLevel((int)Enchantment.looting.effectId, (ItemStack)this.mArrow) > 0) {
                            FakePlayer tPlayer = null;
                            if (this.worldObj instanceof WorldServer) {
                                tPlayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.worldObj), (GameProfile)new GameProfile(new UUID(0L, 0L), tShootingEntity instanceof EntityLivingBase ? ((EntityLivingBase)tShootingEntity).getCommandSenderName() : "Arrow"));
                            }
                            if (tPlayer != null) {
                                tPlayer.inventory.currentItem = 0;
                                tPlayer.inventory.setInventorySlotContents(0, this.getArrowItem());
                                tShootingEntity = tPlayer;
                                tPlayer.setDead();
                            }
                        }
                        DamageSource tDamageSource = DamageSource.causeArrowDamage((EntityArrow)this, (Entity)(tShootingEntity == null ? this : tShootingEntity));
                        if (tDamage + tMagicDamage > 0.0f && tVector.entityHit.attackEntityFrom(tDamageSource, tDamage + tMagicDamage)) {
                            if (tVector.entityHit instanceof EntityLivingBase) {
                                float tKnockbackDivider;
                                if (tHitTimer >= 0) {
                                    tVector.entityHit.hurtResistantTime = tHitTimer;
                                }
                                if (tVector.entityHit instanceof EntityCreeper && EnchantmentHelper.getEnchantmentLevel((int)Enchantment.fireAspect.effectId, (ItemStack)this.mArrow) > 0) {
                                    ((EntityCreeper)tVector.entityHit).func_146079_cb();
                                }
                                EntityLivingBase tHitLivingEntity = (EntityLivingBase)tVector.entityHit;
                                if (!this.worldObj.isRemote) {
                                    tHitLivingEntity.setArrowCountInEntity(tHitLivingEntity.getArrowCountInEntity() + 1);
                                }
                                if (tKnockback > 0 && (tKnockbackDivider = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ))) > 0.0f) {
                                    tHitLivingEntity.addVelocity(this.motionX * (double)tKnockback * (double)0.6f / (double)tKnockbackDivider, 0.1, this.motionZ * (double)tKnockback * (double)0.6f / (double)tKnockbackDivider);
                                }
                                GT_Utility.GT_EnchantmentHelper.applyBullshitA(tHitLivingEntity, (Entity)(tShootingEntity == null ? this : tShootingEntity), this.mArrow);
                                GT_Utility.GT_EnchantmentHelper.applyBullshitB(tShootingEntity instanceof EntityLivingBase ? (EntityLivingBase)tShootingEntity : null, (Entity)tHitLivingEntity, this.mArrow);
                                if (tShootingEntity != null && tHitLivingEntity != tShootingEntity && tHitLivingEntity instanceof EntityPlayer && tShootingEntity instanceof EntityPlayerMP) {
                                    ((EntityPlayerMP)tShootingEntity).playerNetServerHandler.sendPacket((Packet)new S2BPacketChangeGameState(6, 0.0f));
                                }
                            }
                            if (tShootingEntity instanceof EntityPlayer && tMagicDamage > 0.0f) {
                                ((EntityPlayer)tShootingEntity).onEnchantmentCritical(tVector.entityHit);
                            }
                            if (!(tVector.entityHit instanceof EntityEnderman) || ((EntityEnderman)tVector.entityHit).getActivePotionEffect(Potion.weakness) != null) {
                                if (tFireDamage > 0) {
                                    tVector.entityHit.setFire(tFireDamage);
                                }
                                this.playSound("random.bowhit", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                                this.setDead();
                            }
                        } else {
                            this.motionX *= -0.1000000014901161;
                            this.motionY *= -0.1000000014901161;
                            this.motionZ *= -0.1000000014901161;
                            this.rotationYaw += 180.0f;
                            this.prevRotationYaw += 180.0f;
                            this.ticksInAir = 0;
                        }
                    }
                } else {
                    this.mHitBlockX = tVector.blockX;
                    this.mHitBlockY = tVector.blockY;
                    this.mHitBlockZ = tVector.blockZ;
                    this.mHitBlock = this.worldObj.getBlock(this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ);
                    this.mHitBlockMeta = this.worldObj.getBlockMetadata(this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ);
                    this.motionX = (float)(tVector.hitVec.xCoord - this.posX);
                    this.motionY = (float)(tVector.hitVec.yCoord - this.posY);
                    this.motionZ = (float)(tVector.hitVec.zCoord - this.posZ);
                    float f2 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
                    this.posX -= this.motionX / (double)f2 * 0.0500000007450581;
                    this.posY -= this.motionY / (double)f2 * 0.0500000007450581;
                    this.posZ -= this.motionZ / (double)f2 * 0.0500000007450581;
                    this.playSound("random.bowhit", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                    this.inGround = true;
                    this.arrowShake = 7;
                    this.setIsCritical(false);
                    if (this.mHitBlock.getMaterial() != Material.air) {
                        this.mHitBlock.onEntityCollidedWithBlock(this.worldObj, this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ, (Entity)this);
                    }
                    if (!this.worldObj.isRemote && EnchantmentHelper.getEnchantmentLevel((int)Enchantment.fireAspect.effectId, (ItemStack)this.mArrow) > 2) {
                        GT_Utility.setCoordsOnFire(this.worldObj, this.mHitBlockX, this.mHitBlockY, this.mHitBlockZ, true);
                    }
                    if (this.breaksOnImpact()) {
                        this.setDead();
                    }
                }
            }
            WorldSpawnedEventBuilder.ParticleEventBuilder events = new WorldSpawnedEventBuilder.ParticleEventBuilder().setWorld(this.worldObj);
            if (this.getIsCritical()) {
                events.setIdentifier("crit").setMotion(-this.motionX, -this.motionY + 0.2, -this.motionZ).times(4, (x, i) -> x.setPosition(this.posX + this.motionX * (double)i.intValue() / 4.0, this.posY + this.motionY * (double)i.intValue() / 4.0, this.posZ + this.motionZ * (double)i.intValue() / 4.0).run());
            }
            this.posX += this.motionX;
            this.posY += this.motionY;
            this.posZ += this.motionZ;
            this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
            this.rotationPitch = (float)(Math.atan2(this.motionY, MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ))) * 180.0 / Math.PI);
            while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
                this.prevRotationPitch -= 360.0f;
            }
            while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
                this.prevRotationPitch += 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
                this.prevRotationYaw -= 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
                this.prevRotationYaw += 360.0f;
            }
            this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
            this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
            float tFrictionMultiplier = 0.99f;
            if (this.isInWater()) {
                events.setMotion(-this.motionX, -this.motionY + 0.2, -this.motionZ).setIdentifier("bubble").setPosition(this.posX - this.motionX * 0.25, this.posY - this.motionY * 0.25, this.posZ - this.motionZ * 0.25).times(4, Runnable::run);
                tFrictionMultiplier = 0.8f;
            }
            if (this.isWet()) {
                this.extinguish();
            }
            this.motionX *= (double)tFrictionMultiplier;
            this.motionY *= (double)tFrictionMultiplier;
            this.motionZ *= (double)tFrictionMultiplier;
            this.motionY -= 0.0500000007450581;
            this.setPosition(this.posX, this.posY, this.posZ);
            this.func_145775_I();
        }
    }

    public void writeEntityToNBT(NBTTagCompound aNBT) {
        super.writeEntityToNBT(aNBT);
        aNBT.setShort("xTile", (short)this.mHitBlockX);
        aNBT.setShort("yTile", (short)this.mHitBlockY);
        aNBT.setShort("zTile", (short)this.mHitBlockZ);
        aNBT.setShort("life", (short)this.mTicksAlive);
        aNBT.setByte("inTile", (byte)Block.getIdFromBlock((Block)this.mHitBlock));
        aNBT.setByte("inData", (byte)this.mHitBlockMeta);
        aNBT.setByte("shake", (byte)this.arrowShake);
        aNBT.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        aNBT.setByte("pickup", (byte)this.canBePickedUp);
        aNBT.setDouble("damage", this.getDamage());
        aNBT.setTag("mArrow", this.mArrow == null ? null : this.mArrow.writeToNBT(new NBTTagCompound()));
    }

    public void readEntityFromNBT(NBTTagCompound aNBT) {
        super.readEntityFromNBT(aNBT);
        this.mHitBlockX = aNBT.getShort("xTile");
        this.mHitBlockY = aNBT.getShort("yTile");
        this.mHitBlockZ = aNBT.getShort("zTile");
        this.mTicksAlive = aNBT.getShort("life");
        this.mHitBlock = Block.getBlockById((int)(aNBT.getByte("inTile") & 0xFF));
        this.mHitBlockMeta = aNBT.getByte("inData") & 0xFF;
        this.arrowShake = aNBT.getByte("shake") & 0xFF;
        this.inGround = aNBT.getByte("inGround") == 1;
        this.setDamage(aNBT.getDouble("damage"));
        this.canBePickedUp = aNBT.getByte("pickup");
        this.mArrow = GT_Utility.loadItem(aNBT, "mArrow");
    }

    public void onCollideWithPlayer(EntityPlayer aPlayer) {
        if (!this.worldObj.isRemote && this.inGround && this.arrowShake <= 0 && this.canBePickedUp == 1 && aPlayer.inventory.addItemStackToInventory(this.getArrowItem())) {
            this.playSound("random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            aPlayer.onItemPickup((Entity)this, 1);
            this.setDead();
        }
    }

    public int[] onHitEntity(Entity aHitEntity, Entity aShootingEntity, ItemStack aArrow, int aRegularDamage, int aMagicDamage, int aKnockback, int aFireDamage, int aHitTimer) {
        return new int[]{aRegularDamage, aMagicDamage, aKnockback, aFireDamage, aHitTimer};
    }

    public ItemStack getArrowItem() {
        return GT_Utility.copyOrNull(this.mArrow);
    }

    public void setArrowItem(ItemStack aStack) {
        this.mArrow = GT_Utility.updateItemStack(GT_Utility.copyAmount(1L, aStack));
    }

    public boolean breaksOnImpact() {
        return false;
    }

    public void setKnockbackStrength(int aKnockback) {
        this.mKnockback = aKnockback;
    }
}

