/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiFakeItemButton;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconButton;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.net.GT_Packet_TileEntityCover;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;

public class GT_Cover_ItemFilter
extends GT_CoverBehavior {
    private final boolean mExport;

    public GT_Cover_ItemFilter(boolean isExport) {
        this.mExport = isExport;
    }

    @Override
    public boolean isRedstoneSensitive(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        TileEntity tTileEntity = aTileEntity.getTileEntityAtSide(aSide);
        ICoverable fromEntity = this.mExport ? aTileEntity : tTileEntity;
        ICoverable toEntity = !this.mExport ? aTileEntity : tTileEntity;
        byte fromSide = !this.mExport ? GT_Utility.getOppositeSide(aSide) : aSide;
        byte toSide = this.mExport ? GT_Utility.getOppositeSide(aSide) : aSide;
        int FilterId = aCoverVariable >>> 1;
        List<ItemStack> Filter = Collections.singletonList(GT_Utility.intToStack(FilterId));
        boolean isWhiteList = (aCoverVariable & 1) != 0;
        GT_Utility.moveMultipleItemStacks(fromEntity, toEntity, fromSide, toSide, Filter, isWhiteList, (byte)64, (byte)1, (byte)64, (byte)1, 64);
        return aCoverVariable;
    }

    @Override
    public boolean onCoverRightclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        ItemStack tStack = aPlayer.inventory.getCurrentItem();
        if (tStack != null) {
            aCoverVariable = (GT_Utility.stackToInt(tStack) << 1) + (aCoverVariable & 1);
            aTileEntity.setCoverDataAtSide(aSide, aCoverVariable);
            GT_Utility.sendChatToPlayer(aPlayer, this.trans("301", "Item Filter: ") + tStack.getDisplayName());
        } else {
            aTileEntity.setCoverDataAtSide(aSide, aCoverVariable &= 1);
            GT_Utility.sendChatToPlayer(aPlayer, this.trans("300", "Filter Cleared!"));
        }
        return true;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int mode = aCoverVariable & 1;
        mode = mode == 1 ? 0 : 1;
        if (mode == 1) {
            GT_Utility.sendChatToPlayer(aPlayer, this.trans("124", "Blacklist Mode"));
        } else {
            GT_Utility.sendChatToPlayer(aPlayer, this.trans("125", "Whitelist Mode"));
        }
        aCoverVariable = (aCoverVariable & 0xFFFFFFFE) + mode;
        return aCoverVariable;
    }

    @Override
    public boolean letsRedstoneGoIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean alwaysLookConnected(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public Object getClientGUI(byte aSide, int aCoverID, int coverData, ICoverable aTileEntity) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private int coverVariable;
        private final GT_GuiFakeItemButton itemFilterButtons;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public GUI(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            GT_GuiIconButton b = new GT_GuiIconButton(this, 0, 10, 25, GT_GuiIcon.WHITELIST).setTooltipText(GT_Cover_ItemFilter.this.trans("125", "Whitelist Mode"));
            b = new GT_GuiIconButton(this, 1, 28, 25, GT_GuiIcon.BLACKLIST).setTooltipText(GT_Cover_ItemFilter.this.trans("124", "Blacklist Mode"));
            this.itemFilterButtons = new GT_GuiFakeItemButton(this, 10, 61, GT_GuiIcon.SLOT_GRAY);
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.fontRendererObj.drawString(GT_Cover_ItemFilter.this.trans("303", "Filter: "), 10, 46, -11184811);
            this.fontRendererObj.drawString(GT_Cover_ItemFilter.this.trans("302", "Check Mode"), 46, 28, -11184811);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.updateButtons();
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            if (this.getClickable(btn.id)) {
                this.coverVariable = this.getNewCoverVariable(btn.id);
                GT_Values.NW.sendToServer(new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
            }
            this.updateButtons();
        }

        private void updateButtons() {
            for (Object o : this.buttonList) {
                GuiButton b = (GuiButton)o;
                b.enabled = this.getClickable(b.id);
            }
            ItemStack tItemStack = GT_Utility.intToStack(this.coverVariable >>> 1);
            if (tItemStack != null) {
                this.itemFilterButtons.setItem(tItemStack);
                return;
            }
            this.itemFilterButtons.setItem(null);
        }

        private int getNewCoverVariable(int id) {
            switch (id) {
                case 0: {
                    return this.coverVariable & 0xFFFFFFFE;
                }
                case 1: {
                    return this.coverVariable | 1;
                }
            }
            return this.coverVariable;
        }

        private boolean getClickable(int id) {
            switch (id) {
                case 0: {
                    return (1 & this.coverVariable) != 0;
                }
                case 1: {
                    return (1 & this.coverVariable) == 0;
                }
            }
            return false;
        }
    }
}

