/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconButton;
import gregtech.api.gui.widgets.GT_GuiIntegerTextBox;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.net.GT_Packet_TileEntityCover;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Cover_FluidRegulator
extends GT_CoverBehavior {
    private static final int SPEED_LENGTH = 20;
    private static final int TICK_RATE_LENGTH = 11;
    private static final int TICK_RATE_MIN = 1;
    private static final int TICK_RATE_MAX = 2048;
    private static final int TICK_RATE_BITMASK = 0x7FF00000;
    public final int mTransferRate;
    private boolean allowFluid = false;

    public GT_Cover_FluidRegulator(int aTransferRate) {
        if (aTransferRate > 1048575) {
            throw new IllegalArgumentException("aTransferRate too big: " + aTransferRate);
        }
        this.mTransferRate = aTransferRate;
    }

    private static int getSpeed(int aCoverVariable) {
        return aCoverVariable >= 0 ? aCoverVariable & 0x800FFFFF : aCoverVariable | 0x7FF00000;
    }

    private static int getTickRate(int aCoverVariable) {
        return ((Math.abs(aCoverVariable) & 0x7FF00000) >>> 20) + 1;
    }

    private static int generateNewCoverVariable(int aFlowRate, int aTickRate) {
        int tToStoreRaw = aTickRate - 1;
        int tToStore = aFlowRate >= 0 ? tToStoreRaw : ~tToStoreRaw;
        return aFlowRate & 0x800FFFFF | tToStore << 20;
    }

    @Override
    public boolean isRedstoneSensitive(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        int tSpeed = GT_Cover_FluidRegulator.getSpeed(aCoverVariable);
        if (tSpeed == 0) {
            return aCoverVariable;
        }
        if (aTileEntity instanceof IFluidHandler) {
            ForgeDirection directionTo;
            ForgeDirection directionFrom;
            IFluidHandler tTank1;
            IFluidHandler tTank2;
            if (tSpeed > 0) {
                tTank2 = aTileEntity.getITankContainerAtSide(aSide);
                tTank1 = (IFluidHandler)aTileEntity;
                directionFrom = ForgeDirection.getOrientation((int)aSide);
                directionTo = ForgeDirection.getOrientation((int)aSide).getOpposite();
            } else {
                tTank1 = aTileEntity.getITankContainerAtSide(aSide);
                tTank2 = (IFluidHandler)aTileEntity;
                directionFrom = ForgeDirection.getOrientation((int)aSide).getOpposite();
                directionTo = ForgeDirection.getOrientation((int)aSide);
            }
            if (tTank1 != null && tTank2 != null) {
                this.allowFluid = true;
                FluidStack tLiquid = tTank1.drain(directionFrom, Math.abs(tSpeed), false);
                if (tLiquid != null) {
                    tLiquid = tLiquid.copy();
                    tLiquid.amount = tTank2.fill(directionTo, tLiquid, false);
                    if (tLiquid.amount > 0) {
                        tTank2.fill(directionTo, tTank1.drain(directionFrom, tLiquid.amount, true), true);
                    }
                }
                this.allowFluid = false;
            }
        }
        return aCoverVariable;
    }

    private int adjustSpeed(EntityPlayer aPlayer, int aCoverVariable, int scale) {
        int tSpeed = GT_Cover_FluidRegulator.getSpeed(aCoverVariable);
        int tTickRate = GT_Cover_FluidRegulator.getTickRate(aCoverVariable);
        if (Math.abs(tSpeed += scale) > this.mTransferRate * tTickRate) {
            tSpeed = this.mTransferRate * tTickRate * (tSpeed > 0 ? 1 : -1);
            GT_Utility.sendChatToPlayer(aPlayer, this.trans("219", "Pump speed limit reached!"));
        }
        if (tTickRate == 1) {
            GT_Utility.sendChatToPlayer(aPlayer, this.trans("048", "Pump speed: ") + tSpeed + this.trans("049", "L/tick ") + tSpeed * 20 + this.trans("050", "L/sec"));
        } else {
            GT_Utility.sendChatToPlayer(aPlayer, String.format(this.trans("207", "Pump speed: %dL every %d ticks, %.2f L/sec on average"), tSpeed, tTickRate, (double)tSpeed * 20.0 / (double)tTickRate));
        }
        return GT_Cover_FluidRegulator.generateNewCoverVariable(tSpeed, tTickRate);
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (GT_Utility.getClickedFacingCoords(aSide, aX, aY, aZ)[0] >= 0.5f) {
            return this.adjustSpeed(aPlayer, aCoverVariable, aPlayer.isSneaking() ? 256 : 16);
        }
        return this.adjustSpeed(aPlayer, aCoverVariable, aPlayer.isSneaking() ? -256 : -16);
    }

    @Override
    public boolean onCoverRightclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aCoverVariable = GT_Utility.getClickedFacingCoords(aSide, aX, aY, aZ)[0] >= 0.5f ? this.adjustSpeed(aPlayer, aCoverVariable, 1) : this.adjustSpeed(aPlayer, aCoverVariable, -1);
        aTileEntity.setCoverDataAtSide(aSide, aCoverVariable);
        return true;
    }

    @Override
    public boolean letsRedstoneGoIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return this.allowFluid;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return this.allowFluid;
    }

    @Override
    public boolean alwaysLookConnected(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return GT_Cover_FluidRegulator.getTickRate(aCoverVariable);
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public Object getClientGUI(byte aSide, int aCoverID, int coverData, ICoverable aTileEntity) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private GT_GuiIntegerTextBox tBox;
        private GT_GuiIntegerTextBox lBox;
        private int coverVariable;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;
        private int speed;
        private boolean export;
        private int tickRate;
        private boolean warn;

        public GUI(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.warn = false;
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            int speed = GT_Cover_FluidRegulator.getSpeed(this.coverVariable);
            this.speed = Math.abs(speed);
            this.export = speed >= 0;
            this.tickRate = GT_Cover_FluidRegulator.getTickRate(this.coverVariable);
            new GT_GuiIconButton(this, 0, 10, 25, GT_GuiIcon.EXPORT).setTooltipText(GT_Cover_FluidRegulator.this.trans("006", "Export"));
            new GT_GuiIconButton(this, 1, 28, 25, GT_GuiIcon.IMPORT).setTooltipText(GT_Cover_FluidRegulator.this.trans("007", "Import"));
            this.tBox = new GT_GuiIntegerTextBox(this, 2, 10, 45, 69, 12);
            this.tBox.setText(String.valueOf(this.speed));
            this.tBox.setMaxStringLength(10);
            this.lBox = new GT_GuiIntegerTextBox(this, 3, 10, 63, 69, 12);
            this.lBox.setText(String.valueOf(this.tickRate));
            this.lBox.setMaxStringLength(4);
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.getFontRenderer().drawString(GT_Cover_FluidRegulator.this.trans("229", "Import/Export"), 82, 29, -11184811);
            this.getFontRenderer().drawString(GT_Cover_FluidRegulator.this.trans("200", " L"), 82, 47, -11184811);
            this.getFontRenderer().drawString(GT_Cover_FluidRegulator.this.trans("209", " ticks"), 82, 65, -11184811);
            if (this.warn) {
                this.getFontRenderer().drawString(String.format(GT_Cover_FluidRegulator.this.trans("210", "Average: %.2f L/sec"), (double)this.speed * 20.0 / (double)this.tickRate), 10, 83, -65536);
            } else {
                this.getFontRenderer().drawString(String.format(GT_Cover_FluidRegulator.this.trans("210", "Average: %.2f L/sec"), (double)this.speed * 20.0 / (double)this.tickRate), 10, 83, -11184811);
            }
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.updateButtons();
            this.tBox.setFocused(true);
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            if (this.getClickable(btn.id)) {
                this.coverVariable = this.getNewCoverVariable(btn.id);
                GT_Values.NW.sendToServer(new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
            }
            this.updateButtons();
        }

        @Override
        public void onMouseWheel(int x, int y, int delta) {
            for (GT_GuiIntegerTextBox box : this.textBoxes) {
                long i;
                if (!box.isFocused()) continue;
                int step = Math.max(1, Math.abs(delta / 120));
                step = (GUI.isShiftKeyDown() ? 50 : (GUI.isCtrlKeyDown() ? 5 : 1)) * (delta > 0 ? step : -step);
                try {
                    i = Long.parseLong(box.getText());
                }
                catch (NumberFormatException e) {
                    return;
                }
                if (i > 9223372036854774807L) break;
                if ((i += (long)step) <= 0L) {
                    i = 0L;
                }
                box.setText(String.valueOf(i));
                break;
            }
        }

        @Override
        public void applyTextBox(GT_GuiIntegerTextBox box) {
            long i;
            String s = box.getText().trim();
            try {
                i = Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                this.resetTextBox(box);
                return;
            }
            this.warn = false;
            if (box.id == 2) {
                if (i > (long)GT_Cover_FluidRegulator.this.mTransferRate * (long)this.tickRate) {
                    i = (long)GT_Cover_FluidRegulator.this.mTransferRate * (long)this.tickRate;
                    this.warn = true;
                } else if (i < 0L) {
                    i = 0L;
                }
                this.speed = (int)i;
            } else if (box.id == 3) {
                if (i > 2048L) {
                    i = this.tickRate;
                } else if ((long)this.speed > (long)GT_Cover_FluidRegulator.this.mTransferRate * i) {
                    i = Math.min(2048, (this.speed + GT_Cover_FluidRegulator.this.mTransferRate - 1) / GT_Cover_FluidRegulator.this.mTransferRate);
                    this.warn = true;
                } else if (i < 1L) {
                    i = 1L;
                }
                this.tickRate = (int)i;
            }
            box.setText(String.valueOf(i));
            this.coverVariable = this.getNewCoverVariable(2);
            GT_Values.NW.sendToServer(new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
        }

        @Override
        public void resetTextBox(GT_GuiIntegerTextBox box) {
            if (box.id == 2) {
                box.setText(String.valueOf(this.speed));
            } else if (box.id == 3) {
                box.setText(String.valueOf(this.tickRate));
            }
        }

        private void updateButtons() {
            for (Object o : this.buttonList) {
                GuiButton b = (GuiButton)o;
                b.enabled = this.getClickable(b.id);
            }
        }

        private int getNewCoverVariable(int id) {
            switch (id) {
                case 0: {
                    this.export = true;
                    return GT_Cover_FluidRegulator.generateNewCoverVariable(this.speed, this.tickRate);
                }
                case 1: {
                    this.export = false;
                    return GT_Cover_FluidRegulator.generateNewCoverVariable(-this.speed, this.tickRate);
                }
                case 2: {
                    return GT_Cover_FluidRegulator.generateNewCoverVariable(this.export ? this.speed : -this.speed, this.tickRate);
                }
            }
            return this.coverVariable;
        }

        private boolean getClickable(int id) {
            return id == 0 ^ this.export;
        }
    }
}

