/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import gregtech.GT_Mod;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_UO_Dimension;
import gregtech.api.objects.GT_UO_Fluid;
import gregtech.api.objects.XSTR;
import gregtech.common.GT_Proxy;
import java.util.HashMap;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_UndergroundOil {
    public static final short DIVIDER = 5000;

    public static FluidStack undergroundOilReadInformation(IGregTechTileEntity te) {
        return GT_UndergroundOil.undergroundOil(te.getWorld().getChunkFromBlockCoords(te.getXCoord(), te.getZCoord()), -1.0f);
    }

    public static FluidStack undergroundOilReadInformation(Chunk chunk) {
        return GT_UndergroundOil.undergroundOil(chunk, -1.0f);
    }

    public static FluidStack undergroundOil(IGregTechTileEntity te, float readOrDrainCoefficient) {
        return GT_UndergroundOil.undergroundOil(te.getWorld().getChunkFromBlockCoords(te.getXCoord(), te.getZCoord()), readOrDrainCoefficient);
    }

    public static FluidStack undergroundOil(Chunk chunk, float readOrDrainCoefficient) {
        FluidStack fluidInChunk;
        int[] tInts;
        World aWorld = chunk.worldObj;
        int dimensionId = aWorld.provider.dimensionId;
        GT_UO_Dimension dimension = GT_Mod.gregtechproxy.mUndergroundOil.GetDimension(dimensionId);
        if (dimension == null) {
            return null;
        }
        HashMap<Object, Object> chunkData = GT_Proxy.dimensionWiseChunkData.get(dimensionId);
        if (chunkData == null) {
            chunkData = new HashMap(1024);
            GT_Proxy.dimensionWiseChunkData.put(dimensionId, chunkData);
        }
        if ((tInts = chunkData.get(chunk.getChunkCoordIntPair())) == null) {
            tInts = GT_Proxy.getDefaultChunkDataOnCreation();
        } else if (tInts[3] == 0) {
            return readOrDrainCoefficient >= 0.0f ? null : new FluidStack(FluidRegistry.getFluid((int)tInts[2]), 0);
        }
        XSTR tRandom = new XSTR(aWorld.getSeed() + (long)(dimensionId * 2) + (long)(chunk.getChunkCoordIntPair().chunkXPos >> 3) + (long)(8267 * (chunk.getChunkCoordIntPair().chunkZPos >> 3)));
        GT_UO_Fluid uoFluid = dimension.getRandomFluid(tRandom);
        if (uoFluid == null || uoFluid.getFluid() == null) {
            tInts[2] = Integer.MAX_VALUE;
            tInts[3] = 0;
            chunkData.put(chunk.getChunkCoordIntPair(), tInts);
            return null;
        }
        if (tInts[2] == uoFluid.getFluid().getID()) {
            fluidInChunk = new FluidStack(uoFluid.getFluid(), tInts[3]);
        } else {
            fluidInChunk = new FluidStack(uoFluid.getFluid(), uoFluid.getRandomAmount(tRandom));
            fluidInChunk.amount = (int)((float)fluidInChunk.amount * (0.75f + XSTR.XSTR_INSTANCE.nextFloat() / 2.0f));
        }
        tInts[3] = fluidInChunk.amount;
        tInts[2] = fluidInChunk.getFluidID();
        if (readOrDrainCoefficient >= 0.0f) {
            int fluidExtracted = (int)Math.floor((double)fluidInChunk.amount * (double)readOrDrainCoefficient / 5000.0);
            double averageDecrease = (double)uoFluid.DecreasePerOperationAmount * (double)readOrDrainCoefficient;
            int decrease = (int)Math.ceil(averageDecrease);
            if (fluidExtracted <= 0 || fluidInChunk.amount <= decrease) {
                fluidInChunk = null;
                tInts[3] = 0;
            } else {
                fluidInChunk.amount = fluidExtracted;
                if ((double)XSTR.XSTR_INSTANCE.nextFloat() < (double)decrease - averageDecrease) {
                    --decrease;
                }
                tInts[3] = tInts[3] - decrease;
            }
        } else if (fluidInChunk.amount <= 5000) {
            fluidInChunk.amount = 0;
            tInts[3] = 0;
        } else {
            fluidInChunk.amount /= 5000;
        }
        chunkData.put(chunk.getChunkCoordIntPair(), tInts);
        return fluidInChunk;
    }
}

