/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class WorldSpawnedEventBuilder
implements Runnable {
    private static final String ILLEGAL_STATE_STR1 = "Position, identifier and world must be set";
    private World world;

    public World getWorld() {
        return this.world;
    }

    public WorldSpawnedEventBuilder setWorld(World world) {
        this.world = world;
        return this;
    }

    public <U extends WorldSpawnedEventBuilder> void times(int times, Consumer<U> action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < times; ++i) {
            action.accept(this);
        }
    }

    public <U extends WorldSpawnedEventBuilder> void times(int times, BiConsumer<U, Integer> action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < times; ++i) {
            action.accept((Integer)((Object)this), i);
        }
    }

    public static final class SoundToNearExceptEventBuilder
    extends WorldSpawnedEventBuilder
    implements ISoundWorldSpawnedEvent,
    IStringIdentifierWorldSpawnedEvent,
    IEntityPlayerWorldSpawnedEvent {
        private float pitch;
        private float volume;
        private String identifier;
        private EntityPlayer entityPlayer;

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public SoundToNearExceptEventBuilder setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public float getPitch() {
            return this.pitch;
        }

        @Override
        public float getVolume() {
            return this.volume;
        }

        @Override
        public SoundToNearExceptEventBuilder setPitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        @Override
        public SoundToNearExceptEventBuilder setVolume(float volume) {
            this.volume = volume;
            return this;
        }

        @Override
        public SoundToNearExceptEventBuilder setWorld(World world) {
            return (SoundToNearExceptEventBuilder)super.setWorld(world);
        }

        @Override
        public void run() {
            if (this.getWorld() == null || this.getIdentifier() == null || this.getEntityPlayer() == null) {
                throw new IllegalStateException("World, Identifier and EntityPlayer must be set!");
            }
            this.getWorld().playSoundAtEntity((Entity)this.getEntityPlayer(), this.getIdentifier(), this.volume, this.pitch);
        }

        @Override
        public EntityPlayer getEntityPlayer() {
            return this.entityPlayer;
        }

        @Override
        public SoundToNearExceptEventBuilder setEntityPlayer(EntityPlayer entity) {
            this.entityPlayer = entity;
            return this;
        }
    }

    public static final class SoundAtEntityEventBuilder
    extends EntityWorldSpawnedEventBuilder
    implements ISoundWorldSpawnedEvent,
    IStringIdentifierWorldSpawnedEvent {
        private float pitch;
        private float volume;
        private String identifier;

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public SoundAtEntityEventBuilder setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public float getPitch() {
            return this.pitch;
        }

        @Override
        public float getVolume() {
            return this.volume;
        }

        @Override
        public SoundAtEntityEventBuilder setPitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        @Override
        public SoundAtEntityEventBuilder setVolume(float volume) {
            this.volume = volume;
            return this;
        }

        @Override
        public SoundAtEntityEventBuilder setWorld(World world) {
            return (SoundAtEntityEventBuilder)super.setWorld(world);
        }

        @Override
        public SoundAtEntityEventBuilder setEntity(Entity entity) {
            return (SoundAtEntityEventBuilder)super.setEntity(entity);
        }

        @Override
        public void run() {
            if (this.getWorld() == null || this.getIdentifier() == null || this.getEntity() == null) {
                throw new IllegalStateException("World, Identifier and entity must be set!");
            }
            this.getWorld().playSoundAtEntity(this.getEntity(), this.getIdentifier(), this.volume, this.pitch);
        }
    }

    public static final class ExtinguishFireEffectEventBuilder
    extends PositionedWorldSpawnedEventBuilder
    implements IEntityPlayerWorldSpawnedEvent {
        private int side;
        private EntityPlayer entityPlayer;

        public int getSide() {
            return this.side;
        }

        public ExtinguishFireEffectEventBuilder setSide(int side) {
            this.side = side;
            return this;
        }

        @Override
        public EntityPlayer getEntityPlayer() {
            return this.entityPlayer;
        }

        @Override
        public ExtinguishFireEffectEventBuilder setEntityPlayer(EntityPlayer entity) {
            this.entityPlayer = entity;
            return this;
        }

        @Override
        public ExtinguishFireEffectEventBuilder setWorld(World world) {
            return (ExtinguishFireEffectEventBuilder)super.setWorld(world);
        }

        @Override
        public ExtinguishFireEffectEventBuilder setPosition(Vec3 position) {
            return (ExtinguishFireEffectEventBuilder)super.setPosition(position);
        }

        @Override
        public ExtinguishFireEffectEventBuilder setPosition(double x, double y, double z) {
            return (ExtinguishFireEffectEventBuilder)super.setPosition(x, y, z);
        }

        @Override
        public void run() {
            if (this.getEntityPlayer() == null || this.getPosition() == null || this.getWorld() == null) {
                throw new IllegalStateException("EntityPlayer, position and world must be set");
            }
            this.getWorld().extinguishFire(this.getEntityPlayer(), (int)this.getPosition().xCoord, (int)this.getPosition().yCoord, (int)this.getPosition().zCoord, this.side);
        }
    }

    public static final class ExplosionEffectEventBuilder
    extends PositionedEntityWorldSpawnedEventBuilder {
        private boolean isFlaming;
        private boolean isSmoking;
        private float strength;

        public float getStrength() {
            return this.strength;
        }

        public ExplosionEffectEventBuilder setStrength(float strength) {
            this.strength = strength;
            return this;
        }

        public boolean isFlaming() {
            return this.isFlaming;
        }

        public ExplosionEffectEventBuilder setFlaming(boolean flaming) {
            this.isFlaming = flaming;
            return this;
        }

        public boolean isSmoking() {
            return this.isSmoking;
        }

        public ExplosionEffectEventBuilder setSmoking(boolean smoking) {
            this.isSmoking = smoking;
            return this;
        }

        @Override
        public ExplosionEffectEventBuilder setWorld(World world) {
            return (ExplosionEffectEventBuilder)super.setWorld(world);
        }

        @Override
        public ExplosionEffectEventBuilder setEntity(Entity entity) {
            return (ExplosionEffectEventBuilder)super.setEntity(entity);
        }

        @Override
        public ExplosionEffectEventBuilder setPosition(double x, double y, double z) {
            return (ExplosionEffectEventBuilder)super.setPosition(x, y, z);
        }

        @Override
        public void run() {
            if (this.getPosition() == null || this.getWorld() == null) {
                throw new IllegalStateException("Position and world must be set");
            }
            this.getWorld().newExplosion(this.getEntity(), this.getPosition().xCoord, this.getPosition().yCoord, this.getPosition().zCoord, this.strength, this.isFlaming, this.isSmoking);
        }
    }

    public static final class RecordEffectEventBuilder
    extends StringIdentifierPositionedWorldSpawnedEventBuilder {
        @Override
        public RecordEffectEventBuilder setWorld(World world) {
            return (RecordEffectEventBuilder)super.setWorld(world);
        }

        @Override
        public RecordEffectEventBuilder setPosition(Vec3 position) {
            return (RecordEffectEventBuilder)super.setPosition(position);
        }

        @Override
        public RecordEffectEventBuilder setPosition(double x, double y, double z) {
            return (RecordEffectEventBuilder)super.setPosition(x, y, z);
        }

        @Override
        public RecordEffectEventBuilder setIdentifier(String identifier) {
            return (RecordEffectEventBuilder)super.setIdentifier(identifier);
        }

        @Override
        public void run() {
            if (this.getPosition() == null || this.getIdentifier() == null || this.getWorld() == null) {
                throw new IllegalStateException(WorldSpawnedEventBuilder.ILLEGAL_STATE_STR1);
            }
            this.getWorld().playRecord(this.getIdentifier(), (int)this.getPosition().xCoord, (int)this.getPosition().yCoord, (int)this.getPosition().zCoord);
        }
    }

    public static final class SoundEventBuilder
    extends SoundStringIdentifierPositionedWorldSpawnedEventBuilder {
        private boolean proximity;

        public boolean isProximity() {
            return this.proximity;
        }

        @Override
        public SoundEventBuilder setWorld(World world) {
            return (SoundEventBuilder)super.setWorld(world);
        }

        @Override
        public SoundEventBuilder setPosition(Vec3 position) {
            return (SoundEventBuilder)super.setPosition(position);
        }

        @Override
        public SoundEventBuilder setPosition(double x, double y, double z) {
            return (SoundEventBuilder)super.setPosition(x, y, z);
        }

        @Override
        public SoundEventBuilder setIdentifier(String identifier) {
            return (SoundEventBuilder)super.setIdentifier(identifier);
        }

        @Override
        public SoundEventBuilder setPitch(float pitch) {
            return (SoundEventBuilder)super.setPitch(pitch);
        }

        @Override
        public SoundEventBuilder setVolume(float volume) {
            return (SoundEventBuilder)super.setVolume(volume);
        }

        public SoundEventBuilder setProximity(boolean proximity) {
            this.proximity = proximity;
            return this;
        }

        @Override
        public void run() {
            if (this.getPosition() == null || this.getIdentifier() == null || this.getWorld() == null) {
                throw new IllegalStateException(WorldSpawnedEventBuilder.ILLEGAL_STATE_STR1);
            }
            this.getWorld().playSound(this.getPosition().xCoord, this.getPosition().yCoord, this.getPosition().zCoord, this.getIdentifier(), this.getPitch(), this.getVolume(), this.isProximity());
        }
    }

    public static final class SoundEffectEventBuilder
    extends SoundStringIdentifierPositionedWorldSpawnedEventBuilder {
        @Override
        public SoundEffectEventBuilder setWorld(World world) {
            return (SoundEffectEventBuilder)super.setWorld(world);
        }

        @Override
        public SoundEffectEventBuilder setPosition(Vec3 position) {
            return (SoundEffectEventBuilder)super.setPosition(position);
        }

        @Override
        public SoundEffectEventBuilder setPosition(double x, double y, double z) {
            return (SoundEffectEventBuilder)super.setPosition(x, y, z);
        }

        @Override
        public SoundEffectEventBuilder setIdentifier(String identifier) {
            return (SoundEffectEventBuilder)super.setIdentifier(identifier);
        }

        @Override
        public SoundEffectEventBuilder setPitch(float pitch) {
            return (SoundEffectEventBuilder)super.setPitch(pitch);
        }

        @Override
        public SoundEffectEventBuilder setVolume(float volume) {
            return (SoundEffectEventBuilder)super.setVolume(volume);
        }

        @Override
        public void run() {
            if (this.getPosition() == null || this.getIdentifier() == null || this.getWorld() == null) {
                throw new IllegalStateException(WorldSpawnedEventBuilder.ILLEGAL_STATE_STR1);
            }
            this.getWorld().playSoundEffect(this.getPosition().xCoord, this.getPosition().yCoord, this.getPosition().zCoord, this.getIdentifier(), this.getPitch(), this.getVolume());
        }
    }

    public static final class ParticleEventBuilder
    extends StringIdentifierPositionedWorldSpawnedEventBuilder {
        private Vec3 motion;

        public Vec3 getMotion() {
            return this.motion;
        }

        public ParticleEventBuilder setMotion(double x, double y, double z) {
            this.motion = Vec3.createVectorHelper((double)x, (double)y, (double)z);
            return this;
        }

        public ParticleEventBuilder setMotion(Vec3 motion) {
            this.motion = motion;
            return this;
        }

        @Override
        public ParticleEventBuilder setWorld(World world) {
            return (ParticleEventBuilder)super.setWorld(world);
        }

        @Override
        public ParticleEventBuilder setPosition(Vec3 position) {
            return (ParticleEventBuilder)super.setPosition(position);
        }

        @Override
        public ParticleEventBuilder setPosition(double x, double y, double z) {
            return (ParticleEventBuilder)super.setPosition(x, y, z);
        }

        @Override
        public ParticleEventBuilder setIdentifier(String identifier) {
            return (ParticleEventBuilder)super.setIdentifier(identifier);
        }

        @Override
        public void run() {
            if (this.getPosition() == null || this.getIdentifier() == null || this.getMotion() == null || this.getWorld() == null) {
                throw new IllegalStateException("Position, identifier, motion and world must be set");
            }
            this.getWorld().spawnParticle(this.getIdentifier(), this.getPosition().xCoord, this.getPosition().yCoord, this.getPosition().zCoord, this.getMotion().xCoord, this.getMotion().yCoord, this.getMotion().zCoord);
        }
    }

    private static abstract class SoundStringIdentifierPositionedWorldSpawnedEventBuilder
    extends StringIdentifierPositionedWorldSpawnedEventBuilder
    implements ISoundWorldSpawnedEvent {
        private float pitch;
        private float volume;

        private SoundStringIdentifierPositionedWorldSpawnedEventBuilder() {
        }

        @Override
        public float getPitch() {
            return this.pitch;
        }

        @Override
        public float getVolume() {
            return this.volume;
        }

        @Override
        public SoundStringIdentifierPositionedWorldSpawnedEventBuilder setPitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        @Override
        public SoundStringIdentifierPositionedWorldSpawnedEventBuilder setVolume(float volume) {
            this.volume = volume;
            return this;
        }
    }

    private static abstract class StringIdentifierPositionedWorldSpawnedEventBuilder
    extends PositionedWorldSpawnedEventBuilder
    implements IStringIdentifierWorldSpawnedEvent {
        private String identifier;

        private StringIdentifierPositionedWorldSpawnedEventBuilder() {
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public StringIdentifierPositionedWorldSpawnedEventBuilder setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }
    }

    private static abstract class PositionedWorldSpawnedEventBuilder
    extends WorldSpawnedEventBuilder
    implements IPositionedWorldSpawnedEvent {
        private Vec3 position;

        private PositionedWorldSpawnedEventBuilder() {
        }

        @Override
        public Vec3 getPosition() {
            return this.position;
        }

        @Override
        public PositionedWorldSpawnedEventBuilder setPosition(Vec3 position) {
            this.position = position;
            return this;
        }

        @Override
        public PositionedWorldSpawnedEventBuilder setPosition(double x, double y, double z) {
            this.position = Vec3.createVectorHelper((double)x, (double)y, (double)z);
            return this;
        }
    }

    private static abstract class PositionedEntityWorldSpawnedEventBuilder
    extends EntityWorldSpawnedEventBuilder
    implements IPositionedWorldSpawnedEvent {
        private Vec3 position;

        private PositionedEntityWorldSpawnedEventBuilder() {
        }

        @Override
        public Vec3 getPosition() {
            return this.position;
        }

        @Override
        public PositionedEntityWorldSpawnedEventBuilder setPosition(Vec3 position) {
            this.position = position;
            return this;
        }

        @Override
        public PositionedEntityWorldSpawnedEventBuilder setPosition(double x, double y, double z) {
            this.position = Vec3.createVectorHelper((double)x, (double)y, (double)z);
            return this;
        }
    }

    private static abstract class EntityWorldSpawnedEventBuilder
    extends WorldSpawnedEventBuilder
    implements IEntityWorldSpawnedEvent {
        private Entity entity;

        private EntityWorldSpawnedEventBuilder() {
        }

        @Override
        public Entity getEntity() {
            return this.entity;
        }

        @Override
        public EntityWorldSpawnedEventBuilder setEntity(Entity entity) {
            this.entity = entity;
            return this;
        }
    }

    private static interface ISoundWorldSpawnedEvent {
        public float getPitch();

        public float getVolume();

        public ISoundWorldSpawnedEvent setPitch(float var1);

        public ISoundWorldSpawnedEvent setVolume(float var1);
    }

    private static interface IStringIdentifierWorldSpawnedEvent {
        public String getIdentifier();

        public IStringIdentifierWorldSpawnedEvent setIdentifier(String var1);
    }

    private static interface IEntityPlayerWorldSpawnedEvent {
        public EntityPlayer getEntityPlayer();

        public IEntityPlayerWorldSpawnedEvent setEntityPlayer(EntityPlayer var1);
    }

    private static interface IEntityWorldSpawnedEvent {
        public Entity getEntity();

        public IEntityWorldSpawnedEvent setEntity(Entity var1);
    }

    private static interface IPositionedWorldSpawnedEvent {
        public Vec3 getPosition();

        public IPositionedWorldSpawnedEvent setPosition(Vec3 var1);

        public IPositionedWorldSpawnedEvent setPosition(double var1, double var3, double var5);
    }
}

