/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import gregtech.api.enums.Dyes;
import gregtech.api.interfaces.IColorModulationContainer;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.util.LightingHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

@Deprecated
public class GT_RenderedTexture
implements ITexture,
IColorModulationContainer {
    final IIconContainer mIconContainer;
    final boolean mAllowAlpha;
    public short[] mRGBa;

    public GT_RenderedTexture(IIconContainer aIcon, short[] aRGBa, boolean aAllowAlpha) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ GT_RenderedTexture");
        }
        this.mIconContainer = aIcon;
        this.mAllowAlpha = aAllowAlpha;
        this.mRGBa = aRGBa;
    }

    public GT_RenderedTexture(IIconContainer aIcon, short[] aRGBa) {
        this(aIcon, aRGBa, true);
    }

    public GT_RenderedTexture(IIconContainer aIcon) {
        this(aIcon, Dyes._NULL.mRGBa);
    }

    @Override
    public void renderXPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        aRenderer.field_152631_f = true;
        LightingHelper lighting = new LightingHelper(aRenderer);
        lighting.setupLightingXPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.EAST.ordinal(), this.mRGBa);
        aRenderer.renderFaceXPos(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.EAST.ordinal(), 0xFFFFFF);
            aRenderer.renderFaceXPos(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
        aRenderer.field_152631_f = false;
    }

    @Override
    public void renderXNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        LightingHelper lighting = new LightingHelper(aRenderer);
        lighting.setupLightingXNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.WEST.ordinal(), this.mRGBa);
        aRenderer.renderFaceXNeg(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.WEST.ordinal(), 0xFFFFFF);
            aRenderer.renderFaceXNeg(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
    }

    @Override
    public void renderYPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        LightingHelper lighting = new LightingHelper(aRenderer);
        lighting.setupLightingYPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.UP.ordinal(), this.mRGBa);
        aRenderer.renderFaceYPos(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.UP.ordinal(), 0xFFFFFF);
            aRenderer.renderFaceYPos(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
    }

    @Override
    public void renderYNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        Tessellator tessellator = Tessellator.instance;
        IIcon aIcon = this.mIconContainer.getIcon();
        float minU = aIcon.getInterpolatedU((1.0 - aRenderer.renderMaxX) * 16.0);
        float maxU = aIcon.getInterpolatedU((1.0 - aRenderer.renderMinX) * 16.0);
        float minV = aIcon.getInterpolatedV(aRenderer.renderMinZ * 16.0);
        float maxV = aIcon.getInterpolatedV(aRenderer.renderMaxZ * 16.0);
        if (aRenderer.renderMinX < 0.0 || aRenderer.renderMaxX > 1.0) {
            minU = 16.0f - aIcon.getMaxU();
            maxU = 16.0f - aIcon.getMinU();
        }
        if (aRenderer.renderMinZ < 0.0 || aRenderer.renderMaxZ > 1.0) {
            minV = aIcon.getMinV();
            maxV = aIcon.getMaxV();
        }
        double minX = (double)aX + aRenderer.renderMinX;
        double maxX = (double)aX + aRenderer.renderMaxX;
        double minY = (double)aY + aRenderer.renderMinY;
        double minZ = (double)aZ + aRenderer.renderMinZ;
        double maxZ = (double)aZ + aRenderer.renderMaxZ;
        LightingHelper lighting = new LightingHelper(aRenderer);
        lighting.setupLightingYNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.DOWN.ordinal(), this.mRGBa);
        if (aRenderer.enableAO) {
            tessellator.setColorOpaque_F(aRenderer.colorRedTopLeft, aRenderer.colorGreenTopLeft, aRenderer.colorBlueTopLeft);
            tessellator.setBrightness(aRenderer.brightnessTopLeft);
            tessellator.addVertexWithUV(minX, minY, maxZ, (double)maxU, (double)maxV);
            tessellator.setColorOpaque_F(aRenderer.colorRedBottomLeft, aRenderer.colorGreenBottomLeft, aRenderer.colorBlueBottomLeft);
            tessellator.setBrightness(aRenderer.brightnessBottomLeft);
            tessellator.addVertexWithUV(minX, minY, minZ, (double)maxU, (double)minV);
            tessellator.setColorOpaque_F(aRenderer.colorRedBottomRight, aRenderer.colorGreenBottomRight, aRenderer.colorBlueBottomRight);
            tessellator.setBrightness(aRenderer.brightnessBottomRight);
            tessellator.addVertexWithUV(maxX, minY, minZ, (double)minU, (double)minV);
            tessellator.setColorOpaque_F(aRenderer.colorRedTopRight, aRenderer.colorGreenTopRight, aRenderer.colorBlueTopRight);
            tessellator.setBrightness(aRenderer.brightnessTopRight);
        } else {
            tessellator.addVertexWithUV(minX, minY, maxZ, (double)maxU, (double)maxV);
            tessellator.addVertexWithUV(minX, minY, minZ, (double)maxU, (double)minV);
            tessellator.addVertexWithUV(maxX, minY, minZ, (double)minU, (double)minV);
        }
        tessellator.addVertexWithUV(maxX, minY, maxZ, (double)minU, (double)maxV);
        if (this.mIconContainer.getOverlayIcon() != null) {
            minU = aIcon.getInterpolatedU((1.0 - aRenderer.renderMaxX) * 16.0);
            maxU = aIcon.getInterpolatedU((1.0 - aRenderer.renderMinX) * 16.0);
            minV = aIcon.getInterpolatedV(aRenderer.renderMinZ * 16.0);
            maxV = aIcon.getInterpolatedV(aRenderer.renderMaxZ * 16.0);
            if (aRenderer.renderMinX < 0.0 || aRenderer.renderMaxX > 1.0) {
                minU = 16.0f - aIcon.getMaxU();
                maxU = 16.0f - aIcon.getMinU();
            }
            if (aRenderer.renderMinZ < 0.0 || aRenderer.renderMaxZ > 1.0) {
                minV = aIcon.getMinV();
                maxV = aIcon.getMaxV();
            }
            minX = (float)aX + (float)aRenderer.renderMinX;
            maxX = (float)aX + (float)aRenderer.renderMaxX;
            minY = (float)aY + (float)aRenderer.renderMinY;
            minZ = (float)aZ + (float)aRenderer.renderMinZ;
            maxZ = (float)aZ + (float)aRenderer.renderMaxZ;
            lighting.setupColor(ForgeDirection.DOWN.ordinal(), 0xFFFFFF);
            if (aRenderer.enableAO) {
                tessellator.setColorOpaque_F(aRenderer.colorRedTopLeft, aRenderer.colorGreenTopLeft, aRenderer.colorBlueTopLeft);
                tessellator.setBrightness(aRenderer.brightnessTopLeft);
                tessellator.addVertexWithUV(minX, minY, maxZ, (double)maxU, (double)maxV);
                tessellator.setColorOpaque_F(aRenderer.colorRedBottomLeft, aRenderer.colorGreenBottomLeft, aRenderer.colorBlueBottomLeft);
                tessellator.setBrightness(aRenderer.brightnessBottomLeft);
                tessellator.addVertexWithUV(minX, minY, minZ, (double)maxU, (double)minV);
                tessellator.setColorOpaque_F(aRenderer.colorRedBottomRight, aRenderer.colorGreenBottomRight, aRenderer.colorBlueBottomRight);
                tessellator.setBrightness(aRenderer.brightnessBottomRight);
                tessellator.addVertexWithUV(maxX, minY, minZ, (double)minU, (double)minV);
                tessellator.setColorOpaque_F(aRenderer.colorRedTopRight, aRenderer.colorGreenTopRight, aRenderer.colorBlueTopRight);
                tessellator.setBrightness(aRenderer.brightnessTopRight);
            } else {
                tessellator.addVertexWithUV(minX, minY, maxZ, (double)maxU, (double)maxV);
                tessellator.addVertexWithUV(minX, minY, minZ, (double)maxU, (double)minV);
                tessellator.addVertexWithUV(maxX, minY, minZ, (double)minU, (double)minV);
            }
            tessellator.addVertexWithUV(maxX, minY, maxZ, (double)minU, (double)maxV);
        }
    }

    @Override
    public void renderZPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        LightingHelper lighting = new LightingHelper(aRenderer);
        lighting.setupLightingZPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.SOUTH.ordinal(), this.mRGBa);
        aRenderer.renderFaceZPos(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.SOUTH.ordinal(), 0xFFFFFF);
            aRenderer.renderFaceZPos(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
    }

    @Override
    public void renderZNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        aRenderer.field_152631_f = true;
        LightingHelper lighting = new LightingHelper(aRenderer);
        lighting.setupLightingZNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.NORTH.ordinal(), this.mRGBa);
        aRenderer.renderFaceZNeg(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.NORTH.ordinal(), 0xFFFFFF);
            aRenderer.renderFaceZNeg(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
        aRenderer.field_152631_f = false;
    }

    @Override
    public short[] getRGBA() {
        return this.mRGBa;
    }

    @Override
    public boolean isValidTexture() {
        return this.mIconContainer != null;
    }
}

