/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.GT_MetaGenerated_Item;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import java.util.Arrays;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public abstract class GT_MetaGenerated_Item_X32
extends GT_MetaGenerated_Item {
    protected final OrePrefixes[] mGeneratedPrefixList;

    public GT_MetaGenerated_Item_X32(String aUnlocalized, OrePrefixes ... aGeneratedPrefixList) {
        super(aUnlocalized, (short)32000, (short)766);
        this.mGeneratedPrefixList = Arrays.copyOf(aGeneratedPrefixList, 32);
        for (int i = 0; i < 32000; ++i) {
            Materials tMaterial;
            OrePrefixes tPrefix = this.mGeneratedPrefixList[i / 1000];
            if (tPrefix == null || (tMaterial = GregTech_API.sGeneratedMaterials[i % 1000]) == null || !this.doesMaterialAllowGeneration(tPrefix, tMaterial)) continue;
            ItemStack tStack = new ItemStack((Item)this, 1, i);
            GT_LanguageManager.addStringLocalization(this.getUnlocalizedName(tStack) + ".name", GT_LanguageManager.i18nPlaceholder ? this.getDefaultLocalizationFormat(tPrefix, tMaterial, i) : this.getDefaultLocalization(tPrefix, tMaterial, i));
            GT_LanguageManager.addStringLocalization(this.getUnlocalizedName(tStack) + ".tooltip", tMaterial.getToolTip(tPrefix.mMaterialAmount / 3628800L));
            if (tPrefix.mIsUnificatable) {
                GT_OreDictUnificator.set(tPrefix, tMaterial, tStack);
            } else {
                GT_OreDictUnificator.registerOre(tPrefix.get(tMaterial), tStack);
            }
            if (tPrefix != OrePrefixes.stick && tPrefix != OrePrefixes.wireFine && tPrefix != OrePrefixes.ingot || tMaterial != Materials.Lead && tMaterial != Materials.Tin && tMaterial != Materials.SolderingAlloy) continue;
            GregTech_API.sSolderingMetalList.add(tStack);
        }
    }

    @Override
    public short[] getRGBa(ItemStack aStack) {
        Materials tMaterial = GregTech_API.sGeneratedMaterials[this.getDamage(aStack) % 1000];
        return tMaterial == null ? Materials._NULL.mRGBa : tMaterial.mRGBa;
    }

    public boolean doesMaterialAllowGeneration(OrePrefixes aPrefix, Materials aMaterial) {
        return aPrefix != null && aMaterial != null && aPrefix.doGenerateItem(aMaterial);
    }

    public String getDefaultLocalization(OrePrefixes aPrefix, Materials aMaterial, int aMetaData) {
        return aPrefix.getDefaultLocalNameForItem(aMaterial);
    }

    public String getDefaultLocalizationFormat(OrePrefixes aPrefix, Materials aMaterial, int aMetaData) {
        return aPrefix.getDefaultLocalNameFormatForItem(aMaterial);
    }

    public final IIconContainer getIconContainer(int aMetaData, Materials aMaterial) {
        return this.mGeneratedPrefixList[aMetaData / 1000] != null && this.mGeneratedPrefixList[aMetaData / 1000].mTextureIndex >= 0 ? aMaterial.mIconSet.mTextures[this.mGeneratedPrefixList[aMetaData / 1000].mTextureIndex] : null;
    }

    public boolean doesShowInCreative(OrePrefixes aPrefix, Materials aMaterial, boolean aDoShowAllItems) {
        return true;
    }

    public String getItemStackDisplayName(ItemStack aStack) {
        String aName = super.getItemStackDisplayName(aStack);
        int aDamage = aStack.getItemDamage();
        if (aDamage < 32000 && aDamage >= 0) {
            return Materials.getLocalizedNameForItem(aName, aDamage % 1000);
        }
        return aName;
    }

    @Override
    public ItemStack getContainerItem(ItemStack aStack) {
        OrePrefixes aPrefix;
        Materials aMaterial;
        int aDamage = aStack.getItemDamage();
        if (aDamage < 32000 && aDamage >= 0 && (aMaterial = GregTech_API.sGeneratedMaterials[aDamage % 1000]) != null && aMaterial != Materials.Empty && aMaterial != Materials._NULL && (aPrefix = this.mGeneratedPrefixList[aDamage / 1000]) != null) {
            return GT_Utility.copyAmount(1L, aPrefix.mContainerItem);
        }
        return null;
    }

    @Override
    public final IIconContainer getIconContainer(int aMetaData) {
        return GregTech_API.sGeneratedMaterials[aMetaData % 1000] == null ? null : this.getIconContainer(aMetaData, GregTech_API.sGeneratedMaterials[aMetaData % 1000]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void getSubItems(Item var1, CreativeTabs aCreativeTab, List aList) {
        for (int i = 0; i < 32000; ++i) {
            OrePrefixes aPrefix = this.mGeneratedPrefixList[i / 1000];
            Materials aMaterial = GregTech_API.sGeneratedMaterials[i % 1000];
            if (aPrefix == null || aMaterial == null || !this.doesMaterialAllowGeneration(aPrefix, aMaterial) || !this.doesShowInCreative(aPrefix, aMaterial, GregTech_API.sDoShowAllItemsInCreative)) continue;
            ItemStack tStack = new ItemStack((Item)this, 1, i);
            this.isItemStackUsable(tStack);
            aList.add(tStack);
        }
        super.getSubItems(var1, aCreativeTab, aList);
    }

    @Override
    public final IIcon getIconFromDamage(int aMetaData) {
        if (aMetaData < 0) {
            return null;
        }
        if (aMetaData < 32000) {
            Materials tMaterial = GregTech_API.sGeneratedMaterials[aMetaData % 1000];
            if (tMaterial == null) {
                return null;
            }
            IIconContainer tIcon = this.getIconContainer(aMetaData, tMaterial);
            if (tIcon != null) {
                return tIcon.getIcon();
            }
            return null;
        }
        return aMetaData - 32000 < this.mIconList.length ? this.mIconList[aMetaData - 32000][0] : null;
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        int tDamage = this.getDamage(aStack);
        if (tDamage < 32000 && this.mGeneratedPrefixList[tDamage / 1000] != null) {
            return Math.min(super.getItemStackLimit(aStack), this.mGeneratedPrefixList[tDamage / 1000].mDefaultStackSize);
        }
        return super.getItemStackLimit(aStack);
    }
}

