/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.graphs.paths;

import gregtech.api.graphs.paths.NodePath;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Cable;
import net.minecraft.server.MinecraftServer;

public class PowerNodePath
extends NodePath {
    int mMaxAmps;
    int mAmps = 0;
    int mLoss;
    int mVoltage = 0;
    int mMaxVoltage;
    int mTick = 0;
    boolean mCountUp = true;

    public PowerNodePath(MetaPipeEntity[] aCables) {
        super(aCables);
    }

    public int getLoss() {
        return this.mLoss;
    }

    public void applyVoltage(int aVoltage, boolean aCountUp) {
        int tNewTime = MinecraftServer.getServer().getTickCounter();
        if (this.mTick != tNewTime) {
            this.reset(tNewTime - this.mTick);
            this.mTick = tNewTime;
            this.mVoltage = aVoltage;
            this.mCountUp = aCountUp;
        } else if (this.mCountUp != aCountUp && aVoltage - this.mLoss > this.mVoltage || aVoltage > this.mVoltage) {
            this.mCountUp = aCountUp;
            this.mVoltage = aVoltage;
        }
        if (aVoltage > this.mMaxVoltage) {
            for (MetaPipeEntity tCable : this.mPipes) {
                BaseMetaPipeEntity tBaseCable;
                if (((GT_MetaPipeEntity_Cable)tCable).mVoltage >= (long)this.mVoltage || (tBaseCable = (BaseMetaPipeEntity)tCable.getBaseMetaTileEntity()) == null) continue;
                tBaseCable.setToFire();
            }
        }
    }

    public void addAmps(int aAmps) {
        this.mAmps += aAmps;
        if (this.mAmps > this.mMaxAmps * 40) {
            for (MetaPipeEntity tCable : this.mPipes) {
                BaseMetaPipeEntity tBaseCable;
                if (((GT_MetaPipeEntity_Cable)tCable).mAmperage * 40L >= (long)this.mAmps || (tBaseCable = (BaseMetaPipeEntity)tCable.getBaseMetaTileEntity()) == null) continue;
                tBaseCable.setToFire();
            }
        }
    }

    public int getAmps() {
        int tTime = MinecraftServer.getServer().getTickCounter() - 10;
        if (this.mTick < tTime) {
            this.reset(tTime - this.mTick);
            this.mTick = tTime;
        }
        return this.mAmps;
    }

    public int getVoltage(MetaPipeEntity aCable) {
        int tLoss = 0;
        if (this.mCountUp) {
            for (int i = 0; i < this.mPipes.length; ++i) {
                GT_MetaPipeEntity_Cable tCable = (GT_MetaPipeEntity_Cable)this.mPipes[i];
                tLoss = (int)((long)tLoss + tCable.mCableLossPerMeter);
                if (aCable != tCable) continue;
                return Math.max(this.mVoltage - tLoss, 0);
            }
        } else {
            for (int i = this.mPipes.length - 1; i >= 0; --i) {
                GT_MetaPipeEntity_Cable tCable = (GT_MetaPipeEntity_Cable)this.mPipes[i];
                tLoss = (int)((long)tLoss + tCable.mCableLossPerMeter);
                if (aCable != tCable) continue;
                return Math.max(this.mVoltage - tLoss, 0);
            }
        }
        return -1;
    }

    private void reset(int aTimePassed) {
        if (aTimePassed < 0 || aTimePassed > 100) {
            this.mAmps = 0;
        }
        this.mAmps = Math.max(0, this.mAmps - this.mMaxAmps * aTimePassed);
    }

    @Override
    protected void processPipes() {
        super.processPipes();
        this.mMaxAmps = Integer.MAX_VALUE;
        this.mMaxVoltage = Integer.MAX_VALUE;
        for (MetaPipeEntity tCable : this.mPipes) {
            if (!(tCable instanceof GT_MetaPipeEntity_Cable)) continue;
            this.mMaxAmps = Math.min((int)((GT_MetaPipeEntity_Cable)tCable).mAmperage, this.mMaxAmps);
            this.mLoss += (int)((GT_MetaPipeEntity_Cable)tCable).mCableLossPerMeter;
            this.mMaxVoltage = Math.min((int)((GT_MetaPipeEntity_Cable)tCable).mVoltage, this.mMaxVoltage);
        }
    }
}

