/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.enchants;

import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.Materials;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_LanguageManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDamage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class Enchantment_EnderDamage
extends EnchantmentDamage {
    public static Enchantment_EnderDamage INSTANCE;

    public Enchantment_EnderDamage() {
        super(GT_Config.addIDConfig((Object)ConfigCategories.IDs.enchantments, "Disjunction", 15), 2, -1);
        GT_LanguageManager.addStringLocalization(this.getName(), "Disjunction");
        Materials.Silver.setEnchantmentForTools((Enchantment)this, 2);
        Materials.Mercury.setEnchantmentForTools((Enchantment)this, 3);
        Materials.Electrum.setEnchantmentForTools((Enchantment)this, 3);
        Materials.SterlingSilver.setEnchantmentForTools((Enchantment)this, 4);
        Materials.AstralSilver.setEnchantmentForTools((Enchantment)this, 5);
        INSTANCE = this;
    }

    public int getMinEnchantability(int aLevel) {
        return 5 + (aLevel - 1) * 8;
    }

    public int getMaxEnchantability(int aLevel) {
        return this.getMinEnchantability(aLevel) + 20;
    }

    public int getMaxLevel() {
        return 5;
    }

    public void func_151367_b(EntityLivingBase aHurtEntity, Entity aDamagingEntity, int aLevel) {
        if (aHurtEntity instanceof EntityEnderman || aHurtEntity instanceof EntityDragon || aHurtEntity.getClass().getName().contains(".") && aHurtEntity.getClass().getName().substring(aHurtEntity.getClass().getName().lastIndexOf(".")).contains("Ender")) {
            aHurtEntity.addPotionEffect(new PotionEffect(Potion.weakness.id, aLevel * 200, Math.max(1, 5 * aLevel / 7)));
            aHurtEntity.addPotionEffect(new PotionEffect(Potion.poison.id, aLevel * 200, Math.max(1, 5 * aLevel / 7)));
        }
    }

    public String getName() {
        return "enchantment.damage.endermen";
    }
}

