/*
 * Decompiled with CFR 0.152.
 */
package gregtech;

import com.google.common.base.Stopwatch;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ProgressManager;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLModIdMappingEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enchants.Enchantment_EnderDamage;
import gregtech.api.enchants.Enchantment_Radioactivity;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Element;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.internal.IGT_Mod;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.objects.ReverseShapedRecipe;
import gregtech.api.objects.ReverseShapelessRecipe;
import gregtech.api.objects.XSTR;
import gregtech.api.threads.GT_Runnable_MachineBlockUpdate;
import gregtech.api.util.GT_Assemblyline_Server;
import gregtech.api.util.GT_CLS_Compat;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_Forestry_Compat;
import gregtech.api.util.GT_ItsNotMyFaultException;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeRegistrator;
import gregtech.api.util.GT_SpawnEventHandler;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_DummyWorld;
import gregtech.common.GT_Network;
import gregtech.common.GT_Proxy;
import gregtech.common.GT_RecipeAdder;
import gregtech.common.entities.GT_Entity_Arrow;
import gregtech.common.entities.GT_Entity_Arrow_Potion;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gregtech.common.items.behaviors.Behaviour_DataOrb;
import gregtech.common.misc.GT_Command;
import gregtech.common.tileentities.machines.basic.GT_MetaTileEntity_Massfabricator;
import gregtech.common.tileentities.machines.long_distance.GT_MetaTileEntity_LongDistancePipelineBase;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_Cleanroom;
import gregtech.common.tileentities.storage.GT_MetaTileEntity_DigitalChestBase;
import gregtech.loaders.ExtraIcons;
import gregtech.loaders.load.GT_CoverBehaviorLoader;
import gregtech.loaders.load.GT_FuelLoader;
import gregtech.loaders.load.GT_ItemIterator;
import gregtech.loaders.load.GT_SonictronLoader;
import gregtech.loaders.misc.GT_Achievements;
import gregtech.loaders.misc.GT_Bees;
import gregtech.loaders.misc.GT_CoverLoader;
import gregtech.loaders.postload.GT_BlockResistanceLoader;
import gregtech.loaders.postload.GT_BookAndLootLoader;
import gregtech.loaders.postload.GT_CraftingRecipeLoader;
import gregtech.loaders.postload.GT_CropLoader;
import gregtech.loaders.postload.GT_ExtremeDieselFuelLoader;
import gregtech.loaders.postload.GT_ItemMaxStacksizeLoader;
import gregtech.loaders.postload.GT_MachineRecipeLoader;
import gregtech.loaders.postload.GT_MinableRegistrator;
import gregtech.loaders.postload.GT_RecyclerBlacklistLoader;
import gregtech.loaders.postload.GT_ScrapboxDropLoader;
import gregtech.loaders.postload.GT_Worldgenloader;
import gregtech.loaders.preload.GT_Loader_CircuitBehaviors;
import gregtech.loaders.preload.GT_Loader_ItemData;
import gregtech.loaders.preload.GT_Loader_Item_Block_And_Fluid;
import gregtech.loaders.preload.GT_Loader_MetaTileEntities;
import gregtech.loaders.preload.GT_Loader_OreDictionary;
import gregtech.loaders.preload.GT_Loader_OreProcessing;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="gregtech", name="GregTech", version="MC1710", useMetadata=false, dependencies=" required-after:IC2; required-after:structurelib; after:dreamcraft; after:Forestry; after:PFAAGeologica; after:Thaumcraft; after:Railcraft; after:appliedenergistics2; after:ThermalExpansion; after:TwilightForest; after:harvestcraft; after:magicalcrops; after:BuildCraft|Transport; after:BuildCraft|Silicon; after:BuildCraft|Factory; after:BuildCraft|Energy; after:BuildCraft|Core; after:BuildCraft|Builders; after:GalacticraftCore; after:GalacticraftMars; after:GalacticraftPlanets; after:ThermalExpansion|Transport; after:ThermalExpansion|Energy; after:ThermalExpansion|Factory; after:RedPowerCore; after:RedPowerBase; after:RedPowerMachine; after:RedPowerCompat; after:RedPowerWiring; after:RedPowerLogic; after:RedPowerLighting; after:RedPowerWorld; after:RedPowerControl; after:UndergroundBiomes; after:TConstruct; after:Translocator;")
public class GT_Mod
implements IGT_Mod {
    public static final int VERSION = 509;
    public static final int SUBVERSION = 33;
    public static final int TOTAL_VERSION = GT_Mod.calculateTotalGTVersion(509, 33);
    public static final int REQUIRED_IC2 = 624;
    @Mod.Instance(value="gregtech")
    public static GT_Mod instance;
    @SidedProxy(modId="gregtech", clientSide="gregtech.common.GT_Client", serverSide="gregtech.common.GT_Server")
    public static GT_Proxy gregtechproxy;
    public static int MAX_IC2;
    public static GT_Achievements achievements;
    private final String aTextGeneral = "general";
    private final String aTextIC2 = "ic2_";
    public static final Logger GT_FML_LOGGER;

    public GT_Mod() {
        try {
            Class.forName("ic2.core.IC2").getField("enableOreDictCircuit").set(null, Boolean.FALSE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Class.forName("ic2.core.IC2").getField("enableCraftingBucket").set(null, Boolean.FALSE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Class.forName("ic2.core.IC2").getField("enableEnergyInStorageBlockItems").set(null, Boolean.FALSE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        GT_Values.GT = this;
        GT_Values.DW = new GT_DummyWorld();
        GT_Values.NW = new GT_Network();
        GregTech_API.sRecipeAdder = GT_Values.RA = new GT_RecipeAdder();
        Textures.BlockIcons.VOID.name();
        Textures.ItemIcons.VOID.name();
    }

    public static int calculateTotalGTVersion(int minorVersion) {
        return GT_Mod.calculateTotalGTVersion(509, minorVersion);
    }

    public static int calculateTotalGTVersion(int majorVersion, int minorVersion) {
        return majorVersion * 1000 + minorVersion;
    }

    @Mod.EventHandler
    public void onPreLoad(FMLPreInitializationEvent aEvent) {
        block87: {
            File globalDir;
            block86: {
                Locale.setDefault(Locale.ENGLISH);
                if (GregTech_API.sPreloadStarted) {
                    return;
                }
                for (Runnable tRunnable : GregTech_API.sBeforeGTPreload) {
                    try {
                        tRunnable.run();
                    }
                    catch (Throwable e) {
                        e.printStackTrace(GT_Log.err);
                    }
                }
                if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                    MinecraftForge.EVENT_BUS.register((Object)new ExtraIcons());
                }
                File tFile = new File(new File(aEvent.getModConfigurationDirectory(), "GregTech"), "GregTech.cfg");
                Configuration tMainConfig = new Configuration(tFile);
                tMainConfig.load();
                tFile = new File(new File(aEvent.getModConfigurationDirectory(), "GregTech"), "IDs.cfg");
                GT_Config.sConfigFileIDs = new Configuration(tFile);
                GT_Config.sConfigFileIDs.load();
                GT_Config.sConfigFileIDs.save();
                GregTech_API.sRecipeFile = new GT_Config(new Configuration(new File(new File(aEvent.getModConfigurationDirectory(), "GregTech"), "Recipes.cfg")));
                GregTech_API.sMachineFile = new GT_Config(new Configuration(new File(new File(aEvent.getModConfigurationDirectory(), "GregTech"), "MachineStats.cfg")));
                GregTech_API.sWorldgenFile = new GT_Config(new Configuration(new File(new File(aEvent.getModConfigurationDirectory(), "GregTech"), "WorldGeneration.cfg")));
                GregTech_API.sMaterialProperties = new GT_Config(new Configuration(new File(new File(aEvent.getModConfigurationDirectory(), "GregTech"), "MaterialProperties.cfg")));
                GregTech_API.sMaterialComponents = new GT_Config(new Configuration(new File(new File(aEvent.getModConfigurationDirectory(), "GregTech"), "MaterialComponents.cfg")));
                GregTech_API.sUnification = new GT_Config(new Configuration(new File(new File(aEvent.getModConfigurationDirectory(), "GregTech"), "Unification.cfg")));
                GregTech_API.sSpecialFile = new GT_Config(new Configuration(new File(new File(aEvent.getModConfigurationDirectory(), "GregTech"), "Other.cfg")));
                GregTech_API.sOPStuff = new GT_Config(new Configuration(new File(new File(aEvent.getModConfigurationDirectory(), "GregTech"), "OverpoweredStuff.cfg")));
                GregTech_API.sClientDataFile = new GT_Config(new Configuration(new File(aEvent.getModConfigurationDirectory().getParentFile(), "GregTech.cfg")));
                GregTech_API.mIC2Classic = Loader.isModLoaded((String)"IC2-Classic-Spmod");
                GregTech_API.mGTPlusPlus = Loader.isModLoaded((String)"miscutils");
                GregTech_API.mTranslocator = Loader.isModLoaded((String)"Translocator");
                GregTech_API.mTConstruct = Loader.isModLoaded((String)"TConstruct");
                GregTech_API.mGalacticraft = Loader.isModLoaded((String)"GalacticraftCore");
                GregTech_API.mAE2 = Loader.isModLoaded((String)"appliedenergistics2");
                GT_Log.out.println("GT_Mod: Are you there Translocator? " + GregTech_API.mTranslocator);
                GT_Log.out.println("GT_Mod: Are you there TConstruct? " + GregTech_API.mTConstruct);
                GT_Log.out.println("GT_Mod: Are you there GalacticraftCore? " + GregTech_API.mGalacticraft);
                GT_Log.mLogFile = new File(aEvent.getModConfigurationDirectory().getParentFile(), "logs/GregTech.log");
                if (!GT_Log.mLogFile.exists()) {
                    try {
                        GT_Log.mLogFile.createNewFile();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                try {
                    GT_Log.out = GT_Log.err = new PrintStream(GT_Log.mLogFile);
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
                GT_Log.mOreDictLogFile = new File(aEvent.getModConfigurationDirectory().getParentFile(), "logs/OreDict.log");
                if (!GT_Log.mOreDictLogFile.exists()) {
                    try {
                        GT_Log.mOreDictLogFile.createNewFile();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (tMainConfig.get("general", "LoggingExplosions", true).getBoolean(true)) {
                    GT_Log.mExplosionLog = new File(aEvent.getModConfigurationDirectory().getParentFile(), "logs/Explosion.log");
                    if (!GT_Log.mExplosionLog.exists()) {
                        try {
                            GT_Log.mExplosionLog.createNewFile();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    try {
                        GT_Log.exp = new PrintStream(GT_Log.mExplosionLog);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (tMainConfig.get("general", "LoggingPlayerActivity", true).getBoolean(true)) {
                    GT_Log.mPlayerActivityLogFile = new File(aEvent.getModConfigurationDirectory().getParentFile(), "logs/PlayerActivity.log");
                    if (!GT_Log.mPlayerActivityLogFile.exists()) {
                        try {
                            GT_Log.mPlayerActivityLogFile.createNewFile();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    try {
                        GT_Log.pal = new PrintStream(GT_Log.mPlayerActivityLogFile);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                try {
                    List<String> tList = ((GT_Log.LogBuffer)GT_Log.ore).mBufferedOreDictLog;
                    GT_Log.ore.println("******************************************************************************");
                    GT_Log.ore.println("* This is the complete log of the GT5-Unofficial OreDictionary Handler. It   *");
                    GT_Log.ore.println("* processes all OreDictionary entries and can sometimes cause errors. All    *");
                    GT_Log.ore.println("* entries and errors are being logged. If you see an error please raise an   *");
                    GT_Log.ore.println("* issue at https://github.com/Blood-Asp/GT5-Unofficial.                      *");
                    GT_Log.ore.println("******************************************************************************");
                    tList.forEach(GT_Log.ore::println);
                }
                catch (Throwable tList) {
                    // empty catch block
                }
                gregtechproxy.onPreLoad();
                GT_Log.out.println("GT_Mod: Setting Configs");
                GT_Values.D1 = tMainConfig.get("general", "Debug", false).getBoolean(false);
                GT_Values.D2 = tMainConfig.get("general", "Debug2", false).getBoolean(false);
                GT_Values.hideAssLineRecipes = tMainConfig.get("general", "hide assline recipes", false).getBoolean(false);
                GT_Values.updateFluidDisplayItems = tMainConfig.get("general", "update fluid display items", true).getBoolean(true);
                GT_Values.allow_broken_recipemap = tMainConfig.get("general", "debug allow broken recipemap", false).getBoolean(false);
                GT_Values.debugCleanroom = tMainConfig.get("general", "debugCleanroom", false).getBoolean(false);
                GT_Values.debugDriller = tMainConfig.get("general", "debugDriller", false).getBoolean(false);
                GT_Values.debugWorldGen = tMainConfig.get("general", "debugWorldGen", false).getBoolean(false);
                GT_Values.debugOrevein = tMainConfig.get("general", "debugOrevein", false).getBoolean(false);
                GT_Values.debugSmallOres = tMainConfig.get("general", "debugSmallOres", false).getBoolean(false);
                GT_Values.debugStones = tMainConfig.get("general", "debugStones", false).getBoolean(false);
                GT_Values.debugBlockMiner = tMainConfig.get("general", "debugBlockMiner", false).getBoolean(false);
                GT_Values.debugBlockPump = tMainConfig.get("general", "debugBlockPump", false).getBoolean(false);
                GT_Values.debugEntityCramming = tMainConfig.get("general", "debugEntityCramming", false).getBoolean(false);
                GT_Values.oreveinPercentage = tMainConfig.get("general", "oreveinPercentage_100", 100).getInt(100);
                GT_Values.oreveinAttempts = tMainConfig.get("general", "oreveinAttempts_64", 64).getInt(64);
                GT_Values.oreveinMaxPlacementAttempts = tMainConfig.get("general", "oreveinMaxPlacementAttempts_8", 8).getInt(8);
                GT_Values.oreveinPlacerOres = tMainConfig.get("general", "oreveinPlacerOres", true).getBoolean(true);
                GT_Values.oreveinPlacerOresMultiplier = tMainConfig.get("general", "oreveinPlacerOresMultiplier", 2).getInt(2);
                GT_Values.ticksBetweenSounds = tMainConfig.get("machines", "TicksBetweenSounds", 30).getInt(30);
                GT_Values.cleanroomGlass = (float)tMainConfig.get("machines", "ReinforcedGlassPercentageForCleanroom", 5.0).getDouble(5.0);
                GT_Values.enableChunkloaders = tMainConfig.get("machines", "enableChunkloaders", true).getBoolean(true);
                GT_Values.alwaysReloadChunkloaders = tMainConfig.get("machines", "alwaysReloadChunkloaders", false).getBoolean(false);
                GT_Values.debugChunkloaders = tMainConfig.get("machines", "debugChunkloaders", false).getBoolean(false);
                GT_Values.disableDigitalChestsExternalAccess = tMainConfig.get("machines", "disableDigitalChestsExternalAccess", false).getBoolean(false);
                GregTech_API.TICKS_FOR_LAG_AVERAGING = tMainConfig.get("general", "TicksForLagAveragingWithScanner", 25).getInt(25);
                GregTech_API.MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING = tMainConfig.get("general", "MillisecondsPassedInGTTileEntityUntilLagWarning", 100).getInt(100);
                if (tMainConfig.get("general", "disable_STDOUT", false).getBoolean(false)) {
                    GT_FML_LOGGER.info("Disableing Console Messages.");
                    GT_FML_LOGGER.exit();
                    System.out.close();
                    System.err.close();
                }
                GregTech_API.sMachineExplosions = tMainConfig.get("machines", "machines_explosion_damage", true).getBoolean(false);
                GregTech_API.sMachineFlammable = tMainConfig.get("machines", "machines_flammable", true).getBoolean(false);
                GregTech_API.sMachineNonWrenchExplosions = tMainConfig.get("machines", "explosions_on_nonwrenching", true).getBoolean(false);
                GregTech_API.sMachineWireFire = tMainConfig.get("machines", "wirefire_on_explosion", true).getBoolean(false);
                GregTech_API.sMachineFireExplosions = tMainConfig.get("machines", "fire_causes_explosions", true).getBoolean(false);
                GregTech_API.sMachineRainExplosions = tMainConfig.get("machines", "rain_causes_explosions", true).getBoolean(false);
                GregTech_API.sMachineThunderExplosions = tMainConfig.get("machines", "lightning_causes_explosions", true).getBoolean(false);
                GregTech_API.sConstantEnergy = tMainConfig.get("machines", "constant_need_of_energy", true).getBoolean(false);
                GregTech_API.sColoredGUI = tMainConfig.get("machines", "colored_guis_when_painted", true).getBoolean(false);
                GregTech_API.sMachineMetalGUI = tMainConfig.get("machines", "guis_in_consistent_machine_metal_color", false).getBoolean(false);
                GregTech_API.sUseMachineMetal = tMainConfig.get("machines", "use_machine_metal_tint", true).getBoolean(true);
                GregTech_API.sTimber = tMainConfig.get("general", "timber_axe", true).getBoolean(true);
                GregTech_API.sDrinksAlwaysDrinkable = tMainConfig.get("general", "drinks_always_drinkable", false).getBoolean(false);
                GregTech_API.sDoShowAllItemsInCreative = tMainConfig.get("general", "show_all_metaitems_in_creative_and_NEI", false).getBoolean(false);
                GregTech_API.sMultiThreadedSounds = tMainConfig.get("general", "sound_multi_threading", false).getBoolean(false);
                String SBdye0 = "ColorModulation.";
                Arrays.stream(Dyes.values()).filter(tDye -> tDye != Dyes._NULL && tDye.mIndex < 0).forEach(tDye -> {
                    String SBdye1 = SBdye0 + tDye;
                    tDye.mRGBa[0] = (short)Math.min(255, Math.max(0, GregTech_API.sClientDataFile.get((Object)SBdye1, "R", (int)tDye.mRGBa[0])));
                    tDye.mRGBa[1] = (short)Math.min(255, Math.max(0, GregTech_API.sClientDataFile.get((Object)SBdye1, "G", (int)tDye.mRGBa[1])));
                    tDye.mRGBa[2] = (short)Math.min(255, Math.max(0, GregTech_API.sClientDataFile.get((Object)SBdye1, "B", (int)tDye.mRGBa[2])));
                });
                GT_Mod.gregtechproxy.mRenderTileAmbientOcclusion = GregTech_API.sClientDataFile.get((Object)"render", "TileAmbientOcclusion", true);
                GT_Mod.gregtechproxy.mRenderGlowTextures = GregTech_API.sClientDataFile.get((Object)"render", "GlowTextures", true);
                GT_Mod.gregtechproxy.mRenderFlippedMachinesFlipped = GregTech_API.sClientDataFile.get((Object)"render", "RenderFlippedMachinesFlipped", true);
                GT_Mod.gregtechproxy.mRenderIndicatorsOnHatch = GregTech_API.sClientDataFile.get((Object)"render", "RenderIndicatorsOnHatch", true);
                GT_Mod.gregtechproxy.mMaxEqualEntitiesAtOneSpot = tMainConfig.get("general", "MaxEqualEntitiesAtOneSpot", 3).getInt(3);
                GT_Mod.gregtechproxy.mSkeletonsShootGTArrows = tMainConfig.get("general", "SkeletonsShootGTArrows", 16).getInt(16);
                GT_Mod.gregtechproxy.mFlintChance = tMainConfig.get("general", "FlintAndSteelChance", 30).getInt(30);
                GT_Mod.gregtechproxy.mItemDespawnTime = tMainConfig.get("general", "ItemDespawnTime", 6000).getInt(6000);
                GT_Mod.gregtechproxy.mAllowSmallBoilerAutomation = tMainConfig.get("general", "AllowSmallBoilerAutomation", false).getBoolean(false);
                GT_Mod.gregtechproxy.mHardMachineCasings = tMainConfig.get("general", "HardMachineCasings", true).getBoolean(true);
                GT_Mod.gregtechproxy.mDisableVanillaOres = tMainConfig.get("general", "DisableVanillaOres", true).getBoolean(true);
                GT_Mod.gregtechproxy.mNerfDustCrafting = tMainConfig.get("general", "NerfDustCrafting", true).getBoolean(true);
                GT_Mod.gregtechproxy.mIncreaseDungeonLoot = tMainConfig.get("general", "IncreaseDungeonLoot", true).getBoolean(true);
                GT_Mod.gregtechproxy.mAxeWhenAdventure = tMainConfig.get("general", "AdventureModeStartingAxe", true).getBoolean(true);
                GT_Mod.gregtechproxy.mHardcoreCables = tMainConfig.get("general", "HardCoreCableLoss", false).getBoolean(false);
                GT_Mod.gregtechproxy.mSurvivalIntoAdventure = tMainConfig.get("general", "forceAdventureMode", false).getBoolean(false);
                GT_Mod.gregtechproxy.mHungerEffect = tMainConfig.get("general", "AFK_Hunger", false).getBoolean(false);
                GT_Mod.gregtechproxy.mHardRock = tMainConfig.get("general", "harderstone", false).getBoolean(false);
                GT_Mod.gregtechproxy.mInventoryUnification = tMainConfig.get("general", "InventoryUnification", true).getBoolean(true);
                GT_Mod.gregtechproxy.mGTBees = tMainConfig.get("general", "GTBees", true).getBoolean(true);
                GT_Mod.gregtechproxy.mCraftingUnification = tMainConfig.get("general", "CraftingUnification", true).getBoolean(true);
                GT_Mod.gregtechproxy.mNerfedWoodPlank = tMainConfig.get("general", "WoodNeedsSawForCrafting", true).getBoolean(true);
                GT_Mod.gregtechproxy.mNerfedVanillaTools = tMainConfig.get("general", "smallerVanillaToolDurability", true).getBoolean(true);
                GT_Mod.gregtechproxy.mSortToTheEnd = tMainConfig.get("general", "EnsureToBeLoadedLast", true).getBoolean(true);
                GT_Mod.gregtechproxy.mDisableIC2Cables = tMainConfig.get("general", "DisableIC2Cables", true).getBoolean(true);
                GT_Mod.gregtechproxy.mAchievements = tMainConfig.get("general", "EnableAchievements", true).getBoolean(true);
                GT_Mod.gregtechproxy.mAE2Integration = GregTech_API.sSpecialFile.get((Object)ConfigCategories.general, "EnableAE2Integration", GregTech_API.mAE2);
                GT_Mod.gregtechproxy.mNerfedCombs = tMainConfig.get("general", "NerfCombs", true).getBoolean(true);
                GT_Mod.gregtechproxy.mNerfedCrops = tMainConfig.get("general", "NerfCrops", true).getBoolean(true);
                GT_Mod.gregtechproxy.mHideUnusedOres = tMainConfig.get("general", "HideUnusedOres", true).getBoolean(true);
                GT_Mod.gregtechproxy.mHideRecyclingRecipes = tMainConfig.get("general", "HideRecyclingRecipes", true).getBoolean(true);
                GT_Mod.gregtechproxy.mArcSmeltIntoAnnealed = tMainConfig.get("general", "ArcSmeltIntoAnnealedWrought", true).getBoolean(true);
                GT_Mod.gregtechproxy.mMagneticraftRecipes = tMainConfig.get("general", "EnableMagneticraftSupport", true).getBoolean(true);
                GT_Mod.gregtechproxy.mImmersiveEngineeringRecipes = tMainConfig.get("general", "EnableImmersiveEngineeringRSupport", true).getBoolean(true);
                GT_Mod.gregtechproxy.mMagneticraftBonusOutputPercent = tMainConfig.get("general", "MagneticraftBonusOutputPercent", 100.0).getDouble();
                GT_Mod.gregtechproxy.mTEMachineRecipes = tMainConfig.get("general", "TEMachineRecipes", false).getBoolean(false);
                GT_Mod.gregtechproxy.mEnableAllMaterials = tMainConfig.get("general", "EnableAllMaterials", false).getBoolean(false);
                GT_Mod.gregtechproxy.mEnableAllComponents = tMainConfig.get("general", "EnableAllComponents", false).getBoolean(false);
                GT_Mod.gregtechproxy.mPollution = tMainConfig.get("Pollution", "EnablePollution", true).getBoolean(true);
                GT_Mod.gregtechproxy.mPollutionSmogLimit = tMainConfig.get("Pollution", "SmogLimit", 500000).getInt(500000);
                GT_Mod.gregtechproxy.mPollutionPoisonLimit = tMainConfig.get("Pollution", "PoisonLimit", 750000).getInt(750000);
                GT_Mod.gregtechproxy.mPollutionVegetationLimit = tMainConfig.get("Pollution", "VegetationLimit", 1000000).getInt(1000000);
                GT_Mod.gregtechproxy.mPollutionSourRainLimit = tMainConfig.get("Pollution", "SourRainLimit", 2000000).getInt(2000000);
                GT_Mod.gregtechproxy.mExplosionItemDrop = tMainConfig.get("general", "ExplosionItemDrops", false).getBoolean(false);
                GT_Mod.gregtechproxy.mUndergroundOil.getConfig(tMainConfig, "undergroundfluid");
                GT_Mod.gregtechproxy.mEnableCleanroom = tMainConfig.get("general", "EnableCleanroom", true).getBoolean(true);
                if (GT_Mod.gregtechproxy.mEnableCleanroom) {
                    GT_MetaTileEntity_Cleanroom.loadConfig(tMainConfig);
                }
                GT_Mod.gregtechproxy.mLowGravProcessing = Loader.isModLoaded((String)"GalacticraftCore") && tMainConfig.get("general", "LowGravProcessing", true).getBoolean(true);
                GT_Mod.gregtechproxy.mUseGreatlyShrukenReplacementList = tMainConfig.get("general", "GTNH Optimised Material Loading", true).getBoolean(true);
                Calendar now = Calendar.getInstance();
                GT_Mod.gregtechproxy.mAprilFool = GregTech_API.sSpecialFile.get((Object)ConfigCategories.general, "AprilFool", now.get(2) == 3 && now.get(5) == 1);
                GT_Mod.gregtechproxy.mCropNeedBlock = tMainConfig.get("general", "CropNeedBlockBelow", true).getBoolean(true);
                GT_Mod.gregtechproxy.mDisableOldChemicalRecipes = tMainConfig.get("general", "DisableOldChemicalRecipes", false).getBoolean(false);
                GT_Mod.gregtechproxy.mAMHInteraction = tMainConfig.get("general", "AllowAutoMaintenanceHatchInteraction", false).getBoolean(false);
                GregTech_API.mOutputRF = GregTech_API.sOPStuff.get((Object)ConfigCategories.general, "OutputRF", true);
                GregTech_API.mInputRF = GregTech_API.sOPStuff.get((Object)ConfigCategories.general, "InputRF", false);
                GregTech_API.mEUtoRF = GregTech_API.sOPStuff.get((Object)ConfigCategories.general, "100EUtoRF", 360);
                GregTech_API.mRFtoEU = GregTech_API.sOPStuff.get((Object)ConfigCategories.general, "100RFtoEU", 20);
                GregTech_API.mRFExplosions = GregTech_API.sOPStuff.get((Object)ConfigCategories.general, "RFExplosions", false);
                GregTech_API.meIOLoaded = Loader.isModLoaded((String)"EnderIO");
                GT_Mod.gregtechproxy.mForceFreeFace = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "forceFreeFace", true);
                GT_Mod.gregtechproxy.mBrickedBlastFurnace = tMainConfig.get("general", "BrickedBlastFurnace", true).getBoolean(true);
                GT_Mod.gregtechproxy.mEasierIVPlusCables = tMainConfig.get("general", "EasierEVPlusCables", false).getBoolean(false);
                GT_Mod.gregtechproxy.mMixedOreOnlyYieldsTwoThirdsOfPureOre = tMainConfig.get("general", "MixedOreOnlyYieldsTwoThirdsOfPureOre", false).getBoolean(false);
                GT_Mod.gregtechproxy.enableBlackGraniteOres = GregTech_API.sWorldgenFile.get((Object)"general", "enableBlackGraniteOres", GT_Mod.gregtechproxy.enableBlackGraniteOres);
                GT_Mod.gregtechproxy.enableRedGraniteOres = GregTech_API.sWorldgenFile.get((Object)"general", "enableRedGraniteOres", GT_Mod.gregtechproxy.enableRedGraniteOres);
                GT_Mod.gregtechproxy.enableMarbleOres = GregTech_API.sWorldgenFile.get((Object)"general", "enableMarbleOres", GT_Mod.gregtechproxy.enableMarbleOres);
                GT_Mod.gregtechproxy.enableBasaltOres = GregTech_API.sWorldgenFile.get((Object)"general", "enableBasaltOres", GT_Mod.gregtechproxy.enableBasaltOres);
                GT_Mod.gregtechproxy.gt6Pipe = tMainConfig.get("general", "GT6StyledPipesConnection", true).getBoolean(true);
                GT_Mod.gregtechproxy.gt6Cable = tMainConfig.get("general", "GT6StyledWiresConnection", true).getBoolean(true);
                GT_Mod.gregtechproxy.ic2EnergySourceCompat = tMainConfig.get("general", "Ic2EnergySourceCompat", true).getBoolean(true);
                GT_Mod.gregtechproxy.costlyCableConnection = tMainConfig.get("general", "CableConnectionRequiresSolderingMaterial", false).getBoolean(false);
                GT_LanguageManager.i18nPlaceholder = tMainConfig.get("general", "EnablePlaceholderForMaterialNamesInLangFile", true).getBoolean(true);
                GT_MetaTileEntity_LongDistancePipelineBase.minimalDistancePoints = tMainConfig.get("general", "LongDistancePipelineMinimalDistancePoints", 64).getInt(64);
                GregTech_API.mUseOnlyGoodSolderingMaterials = GregTech_API.sRecipeFile.get((Object)ConfigCategories.Recipes.harderrecipes, "useonlygoodsolderingmaterials", GregTech_API.mUseOnlyGoodSolderingMaterials);
                GT_Mod.gregtechproxy.mChangeHarvestLevels = GregTech_API.sMaterialProperties.get((Object)"havestLevel", "activateHarvestLevelChange", false);
                if (GT_Mod.gregtechproxy.mChangeHarvestLevels) {
                    GT_Mod.gregtechproxy.mGraniteHavestLevel = GregTech_API.sMaterialProperties.get((Object)"havestLevel", "graniteHarvestLevel", 3);
                    GT_Mod.gregtechproxy.mMaxHarvestLevel = Math.min(15, GregTech_API.sMaterialProperties.get((Object)"havestLevel", "maxLevel", 7));
                    Materials.getMaterialsMap().values().parallelStream().filter(tMaterial -> tMaterial != null && tMaterial.mToolQuality > 0 && tMaterial.mMetaItemSubID < GT_Mod.gregtechproxy.mHarvestLevel.length && tMaterial.mMetaItemSubID >= 0).forEach(tMaterial -> {
                        GT_Mod.gregtechproxy.mHarvestLevel[tMaterial.mMetaItemSubID] = GregTech_API.sMaterialProperties.get((Object)"materialHavestLevel", tMaterial.mDefaultLocalName, (int)tMaterial.mToolQuality);
                    });
                }
                if (tMainConfig.get("general", "hardermobspawners", true).getBoolean(true)) {
                    Blocks.mob_spawner.setHardness(500.0f).setResistance(6000000.0f);
                }
                GT_Mod.gregtechproxy.mOnline = tMainConfig.get("general", "online", true).getBoolean(false);
                GT_Mod.gregtechproxy.mUpgradeCount = Math.min(64, Math.max(1, tMainConfig.get("features", "UpgradeStacksize", 4).getInt()));
                for (OrePrefixes orePrefixes : OrePrefixes.values()) {
                    if (orePrefixes.mIsUsedForOreProcessing) {
                        orePrefixes.mDefaultStackSize = (byte)Math.min(64, Math.max(1, tMainConfig.get("features", "MaxOreStackSize", 64).getInt()));
                        continue;
                    }
                    if (orePrefixes == OrePrefixes.plank) {
                        orePrefixes.mDefaultStackSize = (byte)Math.min(64, Math.max(16, tMainConfig.get("features", "MaxPlankStackSize", 64).getInt()));
                        continue;
                    }
                    if (orePrefixes == OrePrefixes.wood || orePrefixes == OrePrefixes.treeLeaves || orePrefixes == OrePrefixes.treeSapling || orePrefixes == OrePrefixes.log) {
                        orePrefixes.mDefaultStackSize = (byte)Math.min(64, Math.max(16, tMainConfig.get("features", "MaxLogStackSize", 64).getInt()));
                        continue;
                    }
                    if (!orePrefixes.mIsUsedForBlocks) continue;
                    orePrefixes.mDefaultStackSize = (byte)Math.min(64, Math.max(16, tMainConfig.get("features", "MaxOtherBlockStackSize", 64).getInt()));
                }
                new Enchantment_EnderDamage();
                new Enchantment_Radioactivity();
                Materials.init();
                GT_Log.out.println("GT_Mod: Saving Main Config");
                tMainConfig.save();
                GT_Log.out.println("GT_Mod: Generating Lang-File");
                GT_LanguageManager.sEnglishFile = new Configuration(new File(aEvent.getModConfigurationDirectory().getParentFile(), "GregTech.lang"));
                GT_LanguageManager.sEnglishFile.load();
                if (GT_LanguageManager.sEnglishFile.get("EnableLangFile", "UseThisFileAsLanguageFile", false).getBoolean(false)) {
                    GT_LanguageManager.sLanguage = GT_LanguageManager.sEnglishFile.get("EnableLangFile", "Language", "en_US").getString();
                }
                Materials.getMaterialsMap().values().parallelStream().filter(Objects::nonNull).forEach(aMaterial -> {
                    aMaterial.mLocalizedName = GT_LanguageManager.addStringLocalization("Material." + aMaterial.mName.toLowerCase(), aMaterial.mDefaultLocalName);
                });
                GT_Log.out.println("GT_Mod: Removing all original Scrapbox Drops.");
                try {
                    GT_Utility.getField("ic2.core.item.ItemScrapbox$Drop", "topChance", true, true).set(null, 0);
                    ((List)GT_Utility.getFieldContent(GT_Utility.getFieldContent("ic2.api.recipe.Recipes", "scrapboxDrops", true, true), "drops", true, true)).clear();
                }
                catch (Throwable e) {
                    if (!GT_Values.D1) break block86;
                    e.printStackTrace(GT_Log.err);
                }
            }
            GT_Log.out.println("GT_Mod: Adding Scrap with a Weight of 200.0F to the Scrapbox Drops.");
            GT_ModHandler.addScrapboxDrop(200.0f, GT_ModHandler.getIC2Item("scrap", 1L));
            EntityRegistry.registerModEntity(GT_Entity_Arrow.class, (String)"GT_Entity_Arrow", (int)1, (Object)GT_Values.GT, (int)160, (int)1, (boolean)true);
            EntityRegistry.registerModEntity(GT_Entity_Arrow_Potion.class, (String)"GT_Entity_Arrow_Potion", (int)2, (Object)GT_Values.GT, (int)160, (int)1, (boolean)true);
            GT_FML_LOGGER.info("preReader");
            ArrayList<String> oreTags = new ArrayList<String>();
            if (Loader.isModLoaded((String)"MineTweaker3") && (globalDir = new File("scripts")).exists()) {
                ArrayList<String> scripts = new ArrayList<String>();
                for (File file : globalDir.listFiles()) {
                    if (!file.getName().endsWith(".zs")) continue;
                    try (BufferedReader br = new BufferedReader(new FileReader(file));){
                        String line;
                        while ((line = br.readLine()) != null) {
                            scripts.add(line);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                String string = "<";
                String pattern2 = ">";
                Pattern p = Pattern.compile(Pattern.quote(string) + "(.*?)" + Pattern.quote(pattern2));
                for (String text : scripts) {
                    Matcher m = p.matcher(text);
                    while (m.find()) {
                        int mIt;
                        String hit = m.group(1);
                        if (hit.startsWith("ore:")) {
                            if (oreTags.contains(hit = hit.substring(4))) continue;
                            oreTags.add(hit);
                            continue;
                        }
                        if (!hit.startsWith("gregtech:gt.metaitem.0") || (mIt = Integer.parseInt((hit = hit.substring(22)).substring(0, 1))) <= 0) continue;
                        int meta = 0;
                        try {
                            hit = hit.substring(2);
                            meta = Integer.parseInt(hit);
                        }
                        catch (Exception e) {
                            GT_FML_LOGGER.info("parseError: " + hit);
                        }
                        if (meta <= 0 || meta >= 32000) continue;
                        int prefix = meta / 1000;
                        int material = meta % 1000;
                        String tag = "";
                        String[] tags = new String[]{};
                        if (mIt == 1) {
                            tags = new String[]{"dustTiny", "dustSmall", "dust", "dustImpure", "dustPure", "crushed", "crushedPurified", "crushedCentrifuged", "gem", "nugget", null, "ingot", "ingotHot", "ingotDouble", "ingotTriple", "ingotQuadruple", "ingotQuintuple", "plate", "plateDouble", "plateTriple", "plateQuadruple", "plateQuintuple", "plateDense", "stick", "lens", "round", "bolt", "screw", "ring", "foil", "cell", "cellPlasma", "cellMolten"};
                        }
                        if (mIt == 2) {
                            tags = new String[]{"toolHeadSword", "toolHeadPickaxe", "toolHeadShovel", "toolHeadAxe", "toolHeadHoe", "toolHeadHammer", "toolHeadFile", "toolHeadSaw", "toolHeadDrill", "toolHeadChainsaw", "toolHeadWrench", "toolHeadUniversalSpade", "toolHeadSense", "toolHeadPlow", "toolHeadArrow", "toolHeadBuzzSaw", "turbineBlade", null, null, "wireFine", "gearGtSmall", "rotor", "stickLong", "springSmall", "spring", "arrowGtWood", "arrowGtPlastic", "gemChipped", "gemFlawed", "gemFlawless", "gemExquisite", "gearGt"};
                        }
                        if (mIt == 3) {
                            tags = new String[]{"crateGtDust", "crateGtIngot", "crateGtGem", "crateGtPlate", "itemCasing"};
                        }
                        if (tags.length > prefix) {
                            tag = tags[prefix];
                        }
                        if (GregTech_API.sGeneratedMaterials[material] != null) {
                            if (oreTags.contains(tag = tag + GregTech_API.sGeneratedMaterials[material].mName)) continue;
                            oreTags.add(tag);
                            continue;
                        }
                        if (material <= 0) continue;
                        GT_FML_LOGGER.info("MaterialDisabled: " + material + " " + m.group(1));
                    }
                }
            }
            String[] preS = new String[]{"dustTiny", "dustSmall", "dust", "dustImpure", "dustPure", "crushed", "crushedPurified", "crushedCentrifuged", "gem", "nugget", "ingot", "ingotHot", "ingotDouble", "ingotTriple", "ingotQuadruple", "ingotQuintuple", "plate", "plateDouble", "plateTriple", "plateQuadruple", "plateQuintuple", "plateDense", "stick", "lens", "round", "bolt", "screw", "ring", "foil", "cell", "cellPlasma", "toolHeadSword", "toolHeadPickaxe", "toolHeadShovel", "toolHeadAxe", "toolHeadHoe", "toolHeadHammer", "toolHeadFile", "toolHeadSaw", "toolHeadDrill", "toolHeadChainsaw", "toolHeadWrench", "toolHeadUniversalSpade", "toolHeadSense", "toolHeadPlow", "toolHeadArrow", "toolHeadBuzzSaw", "turbineBlade", "wireFine", "gearGtSmall", "rotor", "stickLong", "springSmall", "spring", "arrowGtWood", "arrowGtPlastic", "gemChipped", "gemFlawed", "gemFlawless", "gemExquisite", "gearGt", "crateGtDust", "crateGtIngot", "crateGtGem", "crateGtPlate", "cellMolten"};
            ArrayList mMTTags = new ArrayList();
            oreTags.stream().filter(test -> StringUtils.startsWithAny((CharSequence)test, (CharSequence[])preS)).forEach(test -> {
                mMTTags.add(test);
                if (GT_Values.D1) {
                    GT_FML_LOGGER.info("oretag: " + test);
                }
            });
            GT_FML_LOGGER.info("reenableMetaItems");
            for (String reEnable : mMTTags) {
                OrePrefixes tPrefix = OrePrefixes.getOrePrefix(reEnable);
                if (tPrefix != null) {
                    Materials tName = Materials.get(reEnable.replaceFirst(tPrefix.toString(), ""));
                    if (tName != null) {
                        tPrefix.mDisabledItems.remove(tName);
                        tPrefix.mGeneratedItems.add(tName);
                        if (tPrefix == OrePrefixes.screw) {
                            OrePrefixes.bolt.mDisabledItems.remove(tName);
                            OrePrefixes.bolt.mGeneratedItems.add(tName);
                            OrePrefixes.stick.mDisabledItems.remove(tName);
                            OrePrefixes.stick.mGeneratedItems.add(tName);
                        }
                        if (tPrefix == OrePrefixes.round) {
                            OrePrefixes.nugget.mDisabledItems.remove(tName);
                            OrePrefixes.nugget.mGeneratedItems.add(tName);
                        }
                        if (tPrefix == OrePrefixes.spring) {
                            OrePrefixes.stickLong.mDisabledItems.remove(tName);
                            OrePrefixes.stickLong.mGeneratedItems.add(tName);
                            OrePrefixes.stick.mDisabledItems.remove(tName);
                            OrePrefixes.stick.mGeneratedItems.add(tName);
                        }
                        if (tPrefix == OrePrefixes.springSmall) {
                            OrePrefixes.stick.mDisabledItems.remove(tName);
                            OrePrefixes.stick.mGeneratedItems.add(tName);
                        }
                        if (tPrefix == OrePrefixes.stickLong) {
                            OrePrefixes.stick.mDisabledItems.remove(tName);
                            OrePrefixes.stick.mGeneratedItems.add(tName);
                        }
                        if (tPrefix != OrePrefixes.rotor) continue;
                        OrePrefixes.ring.mDisabledItems.remove(tName);
                        OrePrefixes.ring.mGeneratedItems.add(tName);
                        continue;
                    }
                    GT_FML_LOGGER.info("noMaterial " + reEnable);
                    continue;
                }
                GT_FML_LOGGER.info("noPrefix " + reEnable);
            }
            new GT_Loader_OreProcessing().run();
            new GT_Loader_OreDictionary().run();
            new GT_Loader_ItemData().run();
            new GT_Loader_Item_Block_And_Fluid().run();
            new GT_Loader_MetaTileEntities().run();
            new GT_Loader_CircuitBehaviors().run();
            new GT_CoverBehaviorLoader().run();
            new GT_SonictronLoader().run();
            new GT_SpawnEventHandler();
            GT_Values.RA.addCentrifugeRecipe(Materials.Stone.getDust(1), GT_Values.NI, GT_Values.NF, GT_Values.NF, Materials.Quartzite.getDustSmall(1), Materials.PotassiumFeldspar.getDustSmall(1), Materials.Marble.getDustTiny(2), Materials.Biotite.getDustTiny(1), Materials.MetalMixture.getDustTiny(1), Materials.Sodalite.getDustTiny(1), new int[]{10000, 10000, 10000, 10000, 7500, 5000}, 480, 120);
            GT_Values.RA.addCentrifugeRecipe(Materials.MetalMixture.getDust(1), GT_Values.NI, GT_Values.NF, GT_Values.NF, Materials.BandedIron.getDustSmall(1), Materials.Bauxite.getDustSmall(1), Materials.Pyrolusite.getDustTiny(2), Materials.Barite.getDustTiny(1), Materials.Chromite.getDustTiny(1), Materials.Ilmenite.getDustTiny(1), new int[]{10000, 10000, 10000, 10000, 7500, 5000}, 1000, 900);
            double d = Math.min(GregTech_API.sOPStuff.get((Object)ConfigCategories.Recipes.gregtechrecipes, "StoneDustOutputMultiplier", 0.6), 1.0);
            if (GregTech_API.sOPStuff.get((Object)ConfigCategories.Recipes.gregtechrecipes, "StoneDustCentrifugation", false)) {
                int fullChance = (int)(10000.0 * d);
                int[] chances = new int[]{fullChance, fullChance, fullChance, fullChance, fullChance, (int)(5500.0 * d)};
                GT_Values.RA.addCentrifugeRecipe(Materials.Stone.getDust(1), GT_Values.NI, GT_Values.NF, GT_Values.NF, Materials.Quartzite.getDustSmall(1), Materials.PotassiumFeldspar.getDustSmall(1), Materials.Marble.getDustTiny(2), Materials.Biotite.getDustTiny(1), Materials.MetalMixture.getDustTiny(1), Materials.Sodalite.getDustTiny(1), chances, 600, 120);
                GT_Values.RA.addCentrifugeRecipe(Materials.MetalMixture.getDust(1), GT_Values.NI, GT_Values.NF, GT_Values.NF, Materials.BandedIron.getDustSmall(1), Materials.Bauxite.getDustSmall(1), Materials.Pyrolusite.getDustTiny(2), Materials.Barite.getDustTiny(1), Materials.Chromite.getDustTiny(1), Materials.Ilmenite.getDustTiny(1), new int[]{10000, 10000, 10000, 10000, 10000, 6000}, 600, 1920);
            }
            double ashOutputMultiplier = Math.min(GregTech_API.sOPStuff.get((Object)ConfigCategories.Recipes.gregtechrecipes, "AshOutputMultiplier", 1.0), 1.0);
            if (GregTech_API.sOPStuff.get((Object)ConfigCategories.Recipes.gregtechrecipes, "AshYieldsAlkaliMetalOxides", true)) {
                int[] outputChances = new int[]{(int)(9900.0 * ashOutputMultiplier), (int)(6400.0 * ashOutputMultiplier), (int)(6000.0 * ashOutputMultiplier), (int)(500.0 * ashOutputMultiplier), (int)(5000.0 * ashOutputMultiplier), (int)(2500.0 * ashOutputMultiplier)};
                GT_Values.RA.addCentrifugeRecipe(Materials.Ash.getDust(1), GT_Values.NI, GT_Values.NF, GT_Values.NF, Materials.Quicklime.getDustSmall(2), Materials.Potash.getDustSmall(1), Materials.Magnesia.getDustSmall(1), Materials.PhosphorousPentoxide.getDustTiny(1), Materials.SodaAsh.getDustTiny(1), Materials.BandedIron.getDustTiny(1), outputChances, 240, 30);
            } else {
                GT_Values.RA.addCentrifugeRecipe(Materials.Ash.getDust(1), GT_Values.NI, GT_Values.NF, GT_Values.NF, Materials.Carbon.getDust(1), GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, new int[]{(int)(10000.0 * ashOutputMultiplier), 0, 0, 0, 0, 0}, 40, 16);
            }
            if (GT_Mod.gregtechproxy.mSortToTheEnd) {
                try {
                    GT_Log.out.println("GT_Mod: Sorting GregTech to the end of the Mod List for further processing.");
                    LoadController tLoadController = (LoadController)GT_Utility.getFieldContent(Loader.instance(), "modController", true, true);
                    List tModList = tLoadController.getActiveModList();
                    ArrayList<ModContainer> tNewModsList = new ArrayList<ModContainer>();
                    ModContainer tGregTech = null;
                    short tModList_sS = (short)tModList.size();
                    for (short i = 0; i < tModList_sS; i = (short)(i + 1)) {
                        ModContainer tMod = (ModContainer)tModList.get(i);
                        if (tMod.getModId().equalsIgnoreCase("gregtech")) {
                            tGregTech = tMod;
                            continue;
                        }
                        tNewModsList.add(tMod);
                    }
                    if (tGregTech != null) {
                        tNewModsList.add(tGregTech);
                    }
                    GT_Utility.getField(tLoadController, "activeModList", true, true).set(tLoadController, tNewModsList);
                }
                catch (Throwable e) {
                    if (!GT_Values.D1) break block87;
                    e.printStackTrace(GT_Log.err);
                }
            }
        }
        GregTech_API.sPreloadFinished = true;
        GT_Log.out.println("GT_Mod: Preload-Phase finished!");
        GT_Log.ore.println("GT_Mod: Preload-Phase finished!");
        for (Runnable tRunnable : GregTech_API.sAfterGTPreload) {
            try {
                tRunnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace(GT_Log.err);
            }
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            GT_Assemblyline_Server.fillMap(aEvent);
        }
    }

    @Mod.EventHandler
    public void onLoad(FMLInitializationEvent aEvent) {
        if (GregTech_API.sLoadStarted) {
            return;
        }
        for (Runnable tRunnable : GregTech_API.sBeforeGTLoad) {
            try {
                tRunnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace(GT_Log.err);
            }
        }
        if (Loader.isModLoaded((String)"Forestry")) {
            new GT_Bees();
        }
        if (!GT_Mod.gregtechproxy.mEnableCleanroom) {
            GT_Mod.gregtechproxy.mLowGravProcessing = false;
        }
        gregtechproxy.onLoad();
        if (GT_Mod.gregtechproxy.mSortToTheEnd) {
            new GT_ItemIterator().run();
            gregtechproxy.registerUnificationEntries();
            new GT_FuelLoader().run();
        }
        GregTech_API.sLoadFinished = true;
        GT_Log.out.println("GT_Mod: Load-Phase finished!");
        GT_Log.ore.println("GT_Mod: Load-Phase finished!");
        for (Runnable tRunnable : GregTech_API.sAfterGTLoad) {
            try {
                tRunnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace(GT_Log.err);
            }
        }
    }

    @Mod.EventHandler
    public void onPostLoad(FMLPostInitializationEvent aEvent) {
        if (GregTech_API.sPostloadStarted) {
            return;
        }
        for (Runnable tRunnable : GregTech_API.sBeforeGTPostload) {
            try {
                tRunnable.run();
            }
            catch (Throwable e2) {
                e2.printStackTrace(GT_Log.err);
            }
        }
        gregtechproxy.onPostLoad();
        for (int i = 1; i < GregTech_API.METATILEENTITIES.length && i < GregTech_API.METATILEENTITIES.length; ++i) {
            if (GregTech_API.METATILEENTITIES[i] == null) continue;
            GT_Log.out.println("META " + i + " " + GregTech_API.METATILEENTITIES[i].getMetaName());
        }
        if (GT_Mod.gregtechproxy.mSortToTheEnd) {
            gregtechproxy.registerUnificationEntries();
        } else {
            new GT_ItemIterator().run();
            gregtechproxy.registerUnificationEntries();
            new GT_FuelLoader().run();
        }
        new GT_BookAndLootLoader().run();
        new GT_ItemMaxStacksizeLoader().run();
        new GT_BlockResistanceLoader().run();
        new GT_RecyclerBlacklistLoader().run();
        new GT_MinableRegistrator().run();
        new GT_MachineRecipeLoader().run();
        new GT_ScrapboxDropLoader().run();
        new GT_CropLoader().run();
        new GT_Worldgenloader().run();
        new GT_CoverLoader().run();
        GT_RecipeRegistrator.registerUsagesForMaterials(null, false, new ItemStack(Blocks.planks, 1), new ItemStack(Blocks.cobblestone, 1), new ItemStack(Blocks.stone, 1), new ItemStack(Items.leather, 1));
        GT_OreDictUnificator.addItemData(GT_ModHandler.getRecipeOutput(null, GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Tin, 1L), null, GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Tin, 1L), null, GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Tin, 1L), null, null, null), new ItemData(Materials.Tin, 10886400L, new MaterialStack[0]));
        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Recipes.storageblockcrafting, "tile.glowstone", false)) {
            GT_ModHandler.removeRecipe(new ItemStack(Items.glowstone_dust, 1), new ItemStack(Items.glowstone_dust, 1), null, new ItemStack(Items.glowstone_dust, 1), new ItemStack(Items.glowstone_dust, 1));
        }
        GT_ModHandler.removeRecipeDelayed(new ItemStack((Block)Blocks.wooden_slab, 1, 0), new ItemStack((Block)Blocks.wooden_slab, 1, 1), new ItemStack((Block)Blocks.wooden_slab, 1, 2));
        GT_ModHandler.addCraftingRecipe(new ItemStack((Block)Blocks.wooden_slab, 6, 0), GT_ModHandler.RecipeBits.NOT_REMOVABLE | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"WWW", Character.valueOf('W'), new ItemStack(Blocks.planks, 1, 0)});
        Map<IRecipeInput, RecipeOutput> aMaceratorRecipeList = GT_ModHandler.getMaceratorRecipeList();
        Map<IRecipeInput, RecipeOutput> aCompressorRecipeList = GT_ModHandler.getCompressorRecipeList();
        Map<IRecipeInput, RecipeOutput> aExtractorRecipeList = GT_ModHandler.getExtractorRecipeList();
        Map<IRecipeInput, RecipeOutput> aOreWashingRecipeList = GT_ModHandler.getOreWashingRecipeList();
        Map<IRecipeInput, RecipeOutput> aThermalCentrifugeRecipeList = GT_ModHandler.getThermalCentrifugeRecipeList();
        GT_Log.out.println("GT_Mod: Activating OreDictionary Handler, this can take some time, as it scans the whole OreDictionary");
        GT_FML_LOGGER.info("If your Log stops here, you were too impatient. Wait a bit more next time, before killing Minecraft with the Task Manager.");
        Stopwatch stopwatch = Stopwatch.createStarted();
        gregtechproxy.activateOreDictHandler();
        GT_FML_LOGGER.info("Congratulations, you have been waiting long enough (" + stopwatch.stop() + "). Have a Cake.");
        GT_Log.out.println("GT_Mod: List of Lists of Tool Recipes: " + GT_ModHandler.sSingleNonBlockDamagableRecipeList_list.toString());
        GT_Log.out.println("GT_Mod: Vanilla Recipe List -> Outputs null or stackSize <=0: " + GT_ModHandler.sVanillaRecipeList_warntOutput.toString());
        GT_Log.out.println("GT_Mod: Single Non Block Damagable Recipe List -> Outputs null or stackSize <=0: " + GT_ModHandler.sSingleNonBlockDamagableRecipeList_warntOutput.toString());
        HashSet<Materials> replaceVanillaItemsSet = GT_Mod.gregtechproxy.mUseGreatlyShrukenReplacementList ? Arrays.stream(Materials.values()).filter(GT_RecipeRegistrator::hasVanillaRecipes).collect(Collectors.toSet()) : new HashSet<Materials>(Arrays.asList(Materials.values()));
        stopwatch.reset();
        stopwatch.start();
        GT_FML_LOGGER.info("Replacing Vanilla Materials in recipes, please wait.");
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Register materials", (int)replaceVanillaItemsSet.size());
        if (GT_Values.cls_enabled) {
            try {
                GT_CLS_Compat.doActualRegistrationCLS(progressBar, replaceVanillaItemsSet);
                GT_CLS_Compat.pushToDisplayProgress();
            }
            catch (IllegalAccessException | InvocationTargetException e3) {
                GT_FML_LOGGER.catching((Throwable)e3);
            }
        } else {
            replaceVanillaItemsSet.forEach(m -> {
                progressBar.step(m.mDefaultLocalName);
                GT_Mod.doActualRegistration(m);
            });
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        GT_FML_LOGGER.info("Replaced Vanilla Materials (" + stopwatch.stop() + "). Have a Cake.");
        stopwatch.reset();
        stopwatch.start();
        ItemStack iridiumOre = GT_ModHandler.getIC2Item("iridiumOre", 1L);
        aCompressorRecipeList.entrySet().parallelStream().filter(e -> ((IRecipeInput)e.getKey()).getInputs().size() == 1 && ((ItemStack)((IRecipeInput)e.getKey()).getInputs().get(0)).isItemEqual(iridiumOre)).findAny().ifPresent(e -> {
            RecipeOutput cfr_ignored_0 = (RecipeOutput)aCompressorRecipeList.remove(e.getKey());
        });
        GT_ModHandler.addIC2RecipesToGT(aMaceratorRecipeList, GT_Recipe.GT_Recipe_Map.sMaceratorRecipes, true, true, true);
        GT_ModHandler.addIC2RecipesToGT(aCompressorRecipeList, GT_Recipe.GT_Recipe_Map.sCompressorRecipes, true, true, true);
        GT_ModHandler.addIC2RecipesToGT(aExtractorRecipeList, GT_Recipe.GT_Recipe_Map.sExtractorRecipes, true, true, true);
        GT_ModHandler.addIC2RecipesToGT(aOreWashingRecipeList, GT_Recipe.GT_Recipe_Map.sOreWasherRecipes, false, true, true);
        GT_ModHandler.addIC2RecipesToGT(aThermalCentrifugeRecipeList, GT_Recipe.GT_Recipe_Map.sThermalCentrifugeRecipes, true, true, true);
        GT_FML_LOGGER.info("IC2 Removal (" + stopwatch.stop() + "). Have a Cake.");
        if (GT_Values.D1) {
            GT_ModHandler.sSingleNonBlockDamagableRecipeList.forEach(iRecipe -> GT_Log.out.println("=> " + iRecipe.getRecipeOutput().getDisplayName()));
        }
        new GT_CraftingRecipeLoader().run();
        if (GregTech_API.sRecipeFile.get((Object)ConfigCategories.Recipes.disabledrecipes, "ic2forgehammer", true)) {
            GT_ModHandler.removeRecipeByOutput(ItemList.IC2_ForgeHammer.getWildcard(1L, new Object[0]));
        }
        GT_ModHandler.removeRecipeByOutput(GT_ModHandler.getIC2Item("machine", 1L));
        GT_ModHandler.addCraftingRecipe(GT_ModHandler.getIC2Item("machine", 1L), GT_ModHandler.RecipeBits.BUFFERED | GT_ModHandler.RecipeBits.NOT_REMOVABLE | GT_ModHandler.RecipeBits.REVERSIBLE, new Object[]{"RRR", "RwR", "RRR", Character.valueOf('R'), OrePrefixes.plate.get(Materials.Iron)});
        ItemStack ISdata0 = new ItemStack((Item)Items.potionitem, 1, 0);
        ItemStack ILdata0 = ItemList.Bottle_Empty.get(1L, new Object[0]);
        for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (tData.filledContainer.getItem() == Items.potionitem && tData.filledContainer.getItemDamage() == 0) {
                GT_Recipe.GT_Recipe_Map.sFluidCannerRecipes.addRecipe(true, new ItemStack[]{ILdata0}, new ItemStack[]{ISdata0}, null, new FluidStack[]{Materials.Water.getFluid(250L)}, null, 4, 1, 0);
                GT_Recipe.GT_Recipe_Map.sFluidCannerRecipes.addRecipe(true, new ItemStack[]{ISdata0}, new ItemStack[]{ILdata0}, null, null, null, 4, 1, 0);
                continue;
            }
            GT_Recipe.GT_Recipe_Map.sFluidCannerRecipes.addRecipe(true, new ItemStack[]{tData.emptyContainer}, new ItemStack[]{tData.filledContainer}, null, new FluidStack[]{tData.fluid}, null, tData.fluid.amount / 62, 1, 0);
            GT_Recipe.GT_Recipe_Map.sFluidCannerRecipes.addRecipe(true, new ItemStack[]{tData.filledContainer}, new ItemStack[]{GT_Utility.getContainerItem(tData.filledContainer, true)}, null, null, new FluidStack[]{tData.fluid}, tData.fluid.amount / 62, 1, 0);
        }
        if (Loader.isModLoaded((String)"Forestry")) {
            GT_Forestry_Compat.transferCentrifugeRecipes();
            GT_Forestry_Compat.transferSqueezerRecipes();
        }
        if (GregTech_API.mAE2) {
            GT_MetaTileEntity_DigitalChestBase.registerAEIntegration();
        }
        Arrays.stream(new String[]{"blastfurnace", "blockcutter", "inductionFurnace", "generator", "windMill", "waterMill", "solarPanel", "centrifuge", "electrolyzer", "compressor", "electroFurnace", "extractor", "macerator", "recycler", "metalformer", "orewashingplant", "massFabricator", "replicator"}).filter(tName -> GregTech_API.sRecipeFile.get((Object)ConfigCategories.Recipes.disabledrecipes, "ic2_" + tName, true)).map(tName -> GT_ModHandler.getIC2Item(tName, 1L)).forEach(GT_ModHandler::removeRecipeByOutputDelayed);
        if (GT_Mod.gregtechproxy.mNerfedVanillaTools) {
            GT_Log.out.println("GT_Mod: Nerfing Vanilla Tool Durability");
            Items.wooden_sword.setMaxDamage(12);
            Items.wooden_pickaxe.setMaxDamage(12);
            Items.wooden_shovel.setMaxDamage(12);
            Items.wooden_axe.setMaxDamage(12);
            Items.wooden_hoe.setMaxDamage(12);
            Items.stone_sword.setMaxDamage(48);
            Items.stone_pickaxe.setMaxDamage(48);
            Items.stone_shovel.setMaxDamage(48);
            Items.stone_axe.setMaxDamage(48);
            Items.stone_hoe.setMaxDamage(48);
            Items.iron_sword.setMaxDamage(256);
            Items.iron_pickaxe.setMaxDamage(256);
            Items.iron_shovel.setMaxDamage(256);
            Items.iron_axe.setMaxDamage(256);
            Items.iron_hoe.setMaxDamage(256);
            Items.golden_sword.setMaxDamage(24);
            Items.golden_pickaxe.setMaxDamage(24);
            Items.golden_shovel.setMaxDamage(24);
            Items.golden_axe.setMaxDamage(24);
            Items.golden_hoe.setMaxDamage(24);
            Items.diamond_sword.setMaxDamage(768);
            Items.diamond_pickaxe.setMaxDamage(768);
            Items.diamond_shovel.setMaxDamage(768);
            Items.diamond_axe.setMaxDamage(768);
            Items.diamond_hoe.setMaxDamage(768);
        }
        new GT_ExtremeDieselFuelLoader().run();
        stopwatch.reset();
        stopwatch.start();
        GT_Log.out.println("GT_Mod: Adding buffered Recipes.");
        GT_ModHandler.stopBufferingCraftingRecipes();
        GT_FML_LOGGER.info("Executed delayed Crafting Recipes (" + stopwatch.stop() + "). Have a Cake.");
        GT_Log.out.println("GT_Mod: Saving Lang File.");
        GT_LanguageManager.sEnglishFile.save();
        GregTech_API.sPostloadFinished = true;
        GT_Log.out.println("GT_Mod: PostLoad-Phase finished!");
        GT_Log.ore.println("GT_Mod: PostLoad-Phase finished!");
        for (Runnable tRunnable : GregTech_API.sAfterGTPostload) {
            try {
                tRunnable.run();
            }
            catch (Throwable e4) {
                e4.printStackTrace(GT_Log.err);
            }
        }
        GT_Log.out.println("GT_Mod: Adding Fake Recipes for NEI");
        if (Loader.isModLoaded((String)"Forestry")) {
            GT_Forestry_Compat.populateFakeNeiRecipes();
        }
        if (ItemList.IC2_Crop_Seeds.get(1L, new Object[0]) != null) {
            GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{ItemList.IC2_Crop_Seeds.getWildcard(1L, new Object[0])}, new ItemStack[]{ItemList.IC2_Crop_Seeds.getWithName(1L, "Scanned Seeds", new Object[0])}, null, null, null, 160, 8, 0);
        }
        GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{new ItemStack(Items.written_book, 1, Short.MAX_VALUE)}, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Scanned Book Data", new Object[0])}, ItemList.Tool_DataStick.getWithName(1L, "Stick to save it to", new Object[0]), null, null, 128, 30, 0);
        GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{new ItemStack((Item)Items.filled_map, 1, Short.MAX_VALUE)}, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Scanned Map Data", new Object[0])}, ItemList.Tool_DataStick.getWithName(1L, "Stick to save it to", new Object[0]), null, null, 128, 30, 0);
        GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{ItemList.Tool_DataOrb.getWithName(1L, "Orb to overwrite", new Object[0])}, new ItemStack[]{ItemList.Tool_DataOrb.getWithName(1L, "Copy of the Orb", new Object[0])}, ItemList.Tool_DataOrb.getWithName(0L, "Orb to copy", new Object[0]), null, null, 512, 30, 0);
        GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Stick to overwrite", new Object[0])}, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Copy of the Stick", new Object[0])}, ItemList.Tool_DataStick.getWithName(0L, "Stick to copy", new Object[0]), null, null, 128, 30, 0);
        GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Raw Prospection Data", new Object[0])}, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Analyzed Prospection Data", new Object[0])}, null, null, null, 1000, 30, 0);
        if (Loader.isModLoaded((String)"GalacticraftCore")) {
            GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{GT_ModHandler.getModItem("GalacticraftCore", "item.schematic", 1L, Short.MAX_VALUE).setStackDisplayName("Any Schematic")}, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Scanned Schematic", new Object[0])}, ItemList.Tool_DataStick.getWithName(1L, "Stick to save it to", new Object[0]), null, null, 36000, 480, 0);
            if (Loader.isModLoaded((String)"GalacticraftMars")) {
                GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{GT_ModHandler.getModItem("GalacticraftMars", "item.schematic", 1L, Short.MAX_VALUE).setStackDisplayName("Any Schematic")}, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Scanned Schematic", new Object[0])}, ItemList.Tool_DataStick.getWithName(1L, "Stick to save it to", new Object[0]), null, null, 36000, 480, 0);
            }
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                for (int i = 4; i < 9; ++i) {
                    GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{GT_ModHandler.getModItem("GalaxySpace", "item.SchematicTier" + i, 1L).setStackDisplayName("Any Schematic")}, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Scanned Schematic", new Object[0])}, ItemList.Tool_DataStick.getWithName(1L, "Stick to save it to", new Object[0]), null, null, 36000, 480, 0);
                }
            }
        }
        Materials.getMaterialsMap().values().stream().forEach(tMaterial -> {
            if (tMaterial.mElement != null && !tMaterial.mElement.mIsIsotope && tMaterial != Materials.Magic && tMaterial.getMass() > 0L) {
                ItemStack tOutput = ItemList.Tool_DataOrb.get(1L, new Object[0]);
                Behaviour_DataOrb.setDataTitle(tOutput, "Elemental-Scan");
                Behaviour_DataOrb.setDataName(tOutput, tMaterial.mElement.name());
                ItemStack tInput = GT_OreDictUnificator.get(OrePrefixes.dust, tMaterial, 1L);
                ItemStack[] ISmat0 = new ItemStack[]{tInput};
                ItemStack[] ISmat1 = new ItemStack[]{tOutput};
                if (tInput != null) {
                    GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, ISmat0, ISmat1, ItemList.Tool_DataOrb.get(1L, new Object[0]), null, null, (int)(tMaterial.getMass() * 8192L), 30, 0);
                    GT_Recipe.GT_Recipe_Map.sReplicatorFakeRecipes.addFakeRecipe(false, null, ISmat0, ISmat1, new FluidStack[]{Materials.UUMatter.getFluid(tMaterial.getMass())}, null, (int)(tMaterial.getMass() * 512L), 30, 0);
                }
                tInput = GT_OreDictUnificator.get(OrePrefixes.cell, tMaterial, 1L);
                ISmat0 = new ItemStack[]{tInput};
                if (tInput != null) {
                    GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, ISmat0, ISmat1, ItemList.Tool_DataOrb.get(1L, new Object[0]), null, null, (int)(tMaterial.getMass() * 8192L), 30, 0);
                    GT_Recipe.GT_Recipe_Map.sReplicatorFakeRecipes.addFakeRecipe(false, null, ISmat0, ISmat1, new FluidStack[]{Materials.UUMatter.getFluid(tMaterial.getMass())}, null, (int)(tMaterial.getMass() * 512L), 30, 0);
                }
            }
        });
        if (!GT_MetaTileEntity_Massfabricator.sRequiresUUA) {
            GT_Recipe.GT_Recipe_Map.sMassFabFakeRecipes.addFakeRecipe(false, null, null, null, null, new FluidStack[]{Materials.UUMatter.getFluid(1L)}, GT_MetaTileEntity_Massfabricator.sDurationMultiplier, 256, 0);
        }
        GT_Recipe.GT_Recipe_Map.sMassFabFakeRecipes.addFakeRecipe(false, null, null, null, new FluidStack[]{Materials.UUAmplifier.getFluid(GT_MetaTileEntity_Massfabricator.sUUAperUUM)}, new FluidStack[]{Materials.UUMatter.getFluid(1L)}, GT_MetaTileEntity_Massfabricator.sDurationMultiplier / GT_MetaTileEntity_Massfabricator.sUUASpeedBonus, 256, 0);
        GT_Recipe.GT_Recipe_Map.sRockBreakerFakeRecipes.addFakeRecipe(false, new ItemStack[]{ItemList.Display_ITS_FREE.getWithName(0L, "Place Lava on Side", new Object[0])}, new ItemStack[]{new ItemStack(Blocks.cobblestone, 1)}, null, null, null, 16, 30, 0);
        GT_Recipe.GT_Recipe_Map.sRockBreakerFakeRecipes.addFakeRecipe(false, new ItemStack[]{ItemList.Display_ITS_FREE.getWithName(0L, "Place Lava on Top", new Object[0])}, new ItemStack[]{new ItemStack(Blocks.stone, 1)}, null, null, null, 16, 30, 0);
        GT_Recipe.GT_Recipe_Map.sRockBreakerFakeRecipes.addFakeRecipe(false, new ItemStack[]{GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Redstone, 1L)}, new ItemStack[]{new ItemStack(Blocks.obsidian, 1)}, null, null, null, 128, 30, 0);
        if (GregTech_API.mOutputRF || GregTech_API.mInputRF) {
            GT_Utility.checkAvailabilities();
            if (!GT_Utility.RF_CHECK) {
                GregTech_API.mOutputRF = false;
                GregTech_API.mInputRF = false;
            }
        }
        this.addSolidFakeLargeBoilerFuels();
        this.identifyAnySteam();
        achievements = new GT_Achievements();
        ReverseShapedRecipe.runReverseRecipes();
        ReverseShapelessRecipe.runReverseRecipes();
        GT_Recipe.GTppRecipeHelper = true;
        GT_Log.out.println("GT_Mod: Loading finished, deallocating temporary Init Variables.");
        GregTech_API.sBeforeGTPreload = null;
        GregTech_API.sAfterGTPreload = null;
        GregTech_API.sBeforeGTLoad = null;
        GregTech_API.sAfterGTLoad = null;
        GregTech_API.sBeforeGTPostload = null;
        GregTech_API.sAfterGTPostload = null;
        CreativeTabs mainTab = new CreativeTabs("GTtools"){

            @SideOnly(value=Side.CLIENT)
            public ItemStack getIconItemStack() {
                return ItemList.Tool_Cheat.get(1L, new ItemStack(Blocks.iron_block, 1));
            }

            @SideOnly(value=Side.CLIENT)
            public Item getTabIconItem() {
                return ItemList.Circuit_Integrated.getItem();
            }

            public void displayAllReleventItems(List aList) {
                for (int i = 0; i < 32766; i += 2) {
                    if (GT_MetaGenerated_Tool_01.INSTANCE.getToolStats(new ItemStack((Item)GT_MetaGenerated_Tool_01.INSTANCE, 1, i)) == null) continue;
                    ItemStack tStack = new ItemStack((Item)GT_MetaGenerated_Tool_01.INSTANCE, 1, i);
                    GT_MetaGenerated_Tool_01.INSTANCE.isItemStackUsable(tStack);
                    aList.add(GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(i, 1, Materials.Lead, Materials.Lead, null));
                    aList.add(GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(i, 1, Materials.Nickel, Materials.Nickel, null));
                    aList.add(GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(i, 1, Materials.Cobalt, Materials.Cobalt, null));
                    aList.add(GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(i, 1, Materials.Osmium, Materials.Osmium, null));
                    aList.add(GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(i, 1, Materials.Adamantium, Materials.Adamantium, null));
                    aList.add(GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(i, 1, Materials.Neutronium, Materials.Neutronium, null));
                }
                super.displayAllReleventItems(aList);
            }
        };
    }

    public static void doActualRegistration(Materials m) {
        boolean noSmash;
        String platename = OrePrefixes.plate.get(m).toString();
        boolean bl = noSmash = !m.contains(SubTag.NO_SMASHING);
        if ((m.mTypes & 2) != 0) {
            GT_RecipeRegistrator.registerUsagesForMaterials(platename, noSmash, m.getIngots(1));
        }
        if ((m.mTypes & 4) != 0) {
            GT_RecipeRegistrator.registerUsagesForMaterials(platename, noSmash, m.getGems(1));
        }
        if (m.getBlocks(1) != null) {
            GT_RecipeRegistrator.registerUsagesForMaterials(null, noSmash, m.getBlocks(1));
        }
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent aEvent) {
        gregtechproxy.onServerStarted();
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent aEvent) {
        gregtechproxy.onServerAboutToStart();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent aEvent) {
        for (Runnable tRunnable : GregTech_API.sBeforeGTServerstart) {
            try {
                tRunnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace(GT_Log.err);
            }
        }
        gregtechproxy.onServerStarting();
        GT_ModHandler.addIC2RecipesToGT(GT_ModHandler.getMaceratorRecipeList(), GT_Recipe.GT_Recipe_Map.sMaceratorRecipes, true, true, true);
        GT_ModHandler.addIC2RecipesToGT(GT_ModHandler.getCompressorRecipeList(), GT_Recipe.GT_Recipe_Map.sCompressorRecipes, true, true, true);
        GT_ModHandler.addIC2RecipesToGT(GT_ModHandler.getExtractorRecipeList(), GT_Recipe.GT_Recipe_Map.sExtractorRecipes, true, true, true);
        GT_ModHandler.addIC2RecipesToGT(GT_ModHandler.getOreWashingRecipeList(), GT_Recipe.GT_Recipe_Map.sOreWasherRecipes, false, true, true);
        GT_ModHandler.addIC2RecipesToGT(GT_ModHandler.getThermalCentrifugeRecipeList(), GT_Recipe.GT_Recipe_Map.sThermalCentrifugeRecipes, true, true, true);
        GT_Log.out.println("GT_Mod: Unificating outputs of all known Recipe Types.");
        ArrayList<ItemStack> tStacks = new ArrayList<ItemStack>(10000);
        GT_Log.out.println("GT_Mod: IC2 Machines");
        Recipes.cannerBottle.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        Recipes.centrifuge.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        Recipes.compressor.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        Recipes.extractor.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        Recipes.macerator.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        Recipes.metalformerCutting.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        Recipes.metalformerExtruding.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        Recipes.metalformerRolling.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        Recipes.matterAmplifier.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        Recipes.oreWashing.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        GT_Log.out.println("GT_Mod: Dungeon Loot");
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"dungeonChest").getItems((Random)new XSTR())) {
            tStacks.add(tContent.theItemId);
        }
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"bonusChest").getItems((Random)new XSTR())) {
            tStacks.add(tContent.theItemId);
        }
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"villageBlacksmith").getItems((Random)new XSTR())) {
            tStacks.add(tContent.theItemId);
        }
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"strongholdCrossing").getItems((Random)new XSTR())) {
            tStacks.add(tContent.theItemId);
        }
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"strongholdLibrary").getItems((Random)new XSTR())) {
            tStacks.add(tContent.theItemId);
        }
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"strongholdCorridor").getItems((Random)new XSTR())) {
            tStacks.add(tContent.theItemId);
        }
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"pyramidJungleDispenser").getItems((Random)new XSTR())) {
            tStacks.add(tContent.theItemId);
        }
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"pyramidJungleChest").getItems((Random)new XSTR())) {
            tStacks.add(tContent.theItemId);
        }
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"pyramidDesertyChest").getItems((Random)new XSTR())) {
            tStacks.add(tContent.theItemId);
        }
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"mineshaftCorridor").getItems((Random)new XSTR())) {
            tStacks.add(tContent.theItemId);
        }
        GT_Log.out.println("GT_Mod: Smelting");
        FurnaceRecipes.smelting().getSmeltingList().values().forEach(k -> tStacks.add((ItemStack)k));
        if (GT_Mod.gregtechproxy.mCraftingUnification) {
            GT_Log.out.println("GT_Mod: Crafting Recipes");
            for (Object tRecipe : CraftingManager.getInstance().getRecipeList()) {
                if (!(tRecipe instanceof IRecipe)) continue;
                tStacks.add(((IRecipe)tRecipe).getRecipeOutput());
            }
        }
        for (ItemStack tOutput : tStacks) {
            if (GT_Mod.gregtechproxy.mRegisteredOres.contains(tOutput)) {
                GT_FML_LOGGER.error("GT-ERR-01: @ " + tOutput.getUnlocalizedName() + "   " + tOutput.getDisplayName());
                GT_FML_LOGGER.error("A Recipe used an OreDict Item as Output directly, without copying it before!!! This is a typical CallByReference/CallByValue Error");
                GT_FML_LOGGER.error("Said Item will be renamed to make the invalid Recipe visible, so that you can report it properly.");
                GT_FML_LOGGER.error("Please check all Recipes outputting this Item, and report the Recipes to their Owner.");
                GT_FML_LOGGER.error("The Owner of the ==>RECIPE<==, NOT the Owner of the Item, which has been mentioned above!!!");
                GT_FML_LOGGER.error("And ONLY Recipes which are ==>OUTPUTTING<== the Item, sorry but I don't want failed Bug Reports.");
                GT_FML_LOGGER.error("GregTech just reports this Error to you, so you can report it to the Mod causing the Problem.");
                GT_FML_LOGGER.error("Even though I make that Bug visible, I can not and will not fix that for you, that's for the causing Mod to fix.");
                GT_FML_LOGGER.error("And speaking of failed Reports:");
                GT_FML_LOGGER.error("Both IC2 and GregTech CANNOT be the CAUSE of this Problem, so don't report it to either of them.");
                GT_FML_LOGGER.error("I REPEAT, BOTH, IC2 and GregTech CANNOT be the source of THIS BUG. NO MATTER WHAT.");
                GT_FML_LOGGER.error("Asking in the IC2 Forums, which Mod is causing that, won't help anyone, since it is not possible to determine, which Mod it is.");
                GT_FML_LOGGER.error("If it would be possible, then I would have had added the Mod which is causing it to the Message already. But it is not possible.");
                GT_FML_LOGGER.error("Sorry, but this Error is serious enough to justify this Wall-O-Text and the partially allcapsed Language.");
                GT_FML_LOGGER.error("Also it is a Ban Reason on the IC2-Forums to post this seriously.");
                tOutput.setStackDisplayName("ERROR! PLEASE CHECK YOUR LOG FOR 'GT-ERR-01'!");
                continue;
            }
            GT_OreDictUnificator.setStack(tOutput);
        }
        GregTech_API.mServerStarted = true;
        GT_Log.out.println("GT_Mod: ServerStarting-Phase finished!");
        GT_Log.ore.println("GT_Mod: ServerStarting-Phase finished!");
        for (Runnable tRunnable : GregTech_API.sAfterGTServerstart) {
            try {
                tRunnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace(GT_Log.err);
            }
        }
        aEvent.registerServerCommand((ICommand)new GT_Command());
        GT_Runnable_MachineBlockUpdate.initExecutorService();
    }

    @Override
    public boolean isServerSide() {
        return gregtechproxy.isServerSide();
    }

    @Override
    public boolean isClientSide() {
        return gregtechproxy.isClientSide();
    }

    @Override
    public boolean isBukkitSide() {
        return gregtechproxy.isBukkitSide();
    }

    @Override
    public EntityPlayer getThePlayer() {
        return gregtechproxy.getThePlayer();
    }

    @Override
    public int addArmor(String aArmorPrefix) {
        return gregtechproxy.addArmor(aArmorPrefix);
    }

    @Override
    public void doSonictronSound(ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
        gregtechproxy.doSonictronSound(aStack, aWorld, aX, aY, aZ);
    }

    @Mod.EventHandler
    public void onIDChangingEvent(FMLModIdMappingEvent aEvent) {
        GT_Utility.reInit();
        GT_Recipe.reInit();
        try {
            for (Map<GT_ItemStack, ?> gt_itemStackMap : GregTech_API.sItemStackMappings) {
                GT_Utility.reMap(gt_itemStackMap);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent aEvent) {
        block16: {
            for (Runnable runnable : GregTech_API.sBeforeGTServerstop) {
                try {
                    runnable.run();
                }
                catch (Throwable e) {
                    e.printStackTrace(GT_Log.err);
                }
            }
            gregtechproxy.onServerStopping();
            try {
                if (GT_Values.D1 || GT_Log.out != System.out) {
                    void var3_10;
                    void var3_8;
                    GT_Log.out.println("*");
                    GT_Log.out.println("Printing List of all registered Objects inside the OreDictionary, now with free extra Sorting:");
                    GT_Log.out.println("*");
                    GT_Log.out.println("*");
                    GT_Log.out.println("*");
                    Object[] tList = OreDictionary.getOreNames();
                    Arrays.sort(tList);
                    for (Object tOreName : tList) {
                        int tAmount = OreDictionary.getOres((String)tOreName).size();
                        if (tAmount <= 0) continue;
                        GT_Log.out.println((tAmount < 10 ? " " : "") + tAmount + "x " + (String)tOreName);
                    }
                    GT_Log.out.println("*");
                    GT_Log.out.println("Printing List of all registered Objects inside the Fluid Registry, now with free extra Sorting:");
                    GT_Log.out.println("*");
                    GT_Log.out.println("*");
                    GT_Log.out.println("*");
                    tList = FluidRegistry.getRegisteredFluids().keySet().toArray(new String[0]);
                    Arrays.sort(tList);
                    for (Object tFluidName : tList) {
                        GT_Log.out.println((String)tFluidName);
                    }
                    GT_Log.out.println("*");
                    GT_Log.out.println("*");
                    GT_Log.out.println("*");
                    GT_Log.out.println("Outputting all the Names inside the Biomeslist");
                    GT_Log.out.println("*");
                    GT_Log.out.println("*");
                    GT_Log.out.println("*");
                    boolean bl = false;
                    while (var3_8 < BiomeGenBase.getBiomeGenArray().length) {
                        if (BiomeGenBase.getBiomeGenArray()[var3_8] != null) {
                            GT_Log.out.println(BiomeGenBase.getBiomeGenArray()[var3_8].biomeID + " = " + BiomeGenBase.getBiomeGenArray()[var3_8].biomeName);
                        }
                        ++var3_8;
                    }
                    GT_Log.out.println("*");
                    GT_Log.out.println("*");
                    GT_Log.out.println("*");
                    GT_Log.out.println("Printing List of generatable Materials");
                    GT_Log.out.println("*");
                    GT_Log.out.println("*");
                    GT_Log.out.println("*");
                    boolean bl2 = false;
                    while (var3_10 < GregTech_API.sGeneratedMaterials.length) {
                        if (GregTech_API.sGeneratedMaterials[var3_10] == null) {
                            GT_Log.out.println("Index " + (int)var3_10 + ":" + null);
                        } else {
                            GT_Log.out.println("Index " + (int)var3_10 + ":" + GregTech_API.sGeneratedMaterials[var3_10]);
                        }
                        ++var3_10;
                    }
                    GT_Log.out.println("*");
                    GT_Log.out.println("*");
                    GT_Log.out.println("*");
                    GT_Log.out.println("END GregTech-Debug");
                    GT_Log.out.println("*");
                    GT_Log.out.println("*");
                    GT_Log.out.println("*");
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block16;
                e.printStackTrace(GT_Log.err);
            }
        }
        for (Runnable runnable : GregTech_API.sAfterGTServerstop) {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace(GT_Log.err);
            }
        }
        GT_Runnable_MachineBlockUpdate.shutdownExecutorService();
    }

    private void addSolidFakeLargeBoilerFuels() {
        GT_Recipe.GT_Recipe_Map.sLargeBoilerFakeFuels.addSolidRecipes(GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Charcoal, 1L), GT_OreDictUnificator.get(OrePrefixes.gem, Materials.Charcoal, 1L), GT_OreDictUnificator.get(OrePrefixes.block, Materials.Charcoal, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Coal, 1L), GT_OreDictUnificator.get(OrePrefixes.gem, Materials.Coal, 1L), GT_OreDictUnificator.get(OrePrefixes.block, Materials.Coal, 1L), GT_OreDictUnificator.get(OrePrefixes.crushed, Materials.Coal, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Lignite, 1L), GT_OreDictUnificator.get(OrePrefixes.gem, Materials.Lignite, 1L), GT_OreDictUnificator.get(OrePrefixes.block, Materials.Lignite, 1L), GT_OreDictUnificator.get(OrePrefixes.crushed, Materials.Lignite, 1L), GT_OreDictUnificator.get(OrePrefixes.log, Materials.Wood, 1L), GT_OreDictUnificator.get(OrePrefixes.plank, Materials.Wood, 1L), GT_OreDictUnificator.get(OrePrefixes.stick, Materials.Wood, 1L), GT_OreDictUnificator.get(OrePrefixes.slab, Materials.Wood, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Wood, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Sodium, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Lithium, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Caesium, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Sulfur, 1L), GT_OreDictUnificator.get(ItemList.Block_SSFUEL.get(1L, new Object[0])), GT_OreDictUnificator.get(ItemList.Block_MSSFUEL.get(1L, new Object[0])), GT_OreDictUnificator.get(OrePrefixes.rod, Materials.Blaze, 1L));
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            GT_Recipe.GT_Recipe_Map.sLargeBoilerFakeFuels.addSolidRecipe(GT_ModHandler.getModItem("Thaumcraft", "ItemResource", 1L));
        }
    }

    private void identifyAnySteam() {
        String[] steamCandidates = new String[]{"steam", "ic2steam"};
        String[] superHeatedSteamCandidates = new String[]{"ic2superheatedsteam"};
        GT_ModHandler.sAnySteamFluidIDs = Arrays.stream(steamCandidates).map(FluidRegistry::getFluid).filter(Objects::nonNull).map(FluidRegistry::getFluidID).collect(Collectors.toList());
        GT_ModHandler.sSuperHeatedSteamFluidIDs = Arrays.stream(superHeatedSteamCandidates).map(FluidRegistry::getFluid).filter(Objects::nonNull).map(FluidRegistry::getFluidID).collect(Collectors.toList());
    }

    static {
        MAX_IC2 = Integer.MAX_VALUE;
        GT_FML_LOGGER = LogManager.getLogger((String)"GregTech GTNH");
        if (509 != GregTech_API.VERSION || 509 != GT_ModHandler.VERSION || 509 != GT_OreDictUnificator.VERSION || 509 != GT_Recipe.VERSION || 509 != GT_Utility.VERSION || 509 != GT_RecipeRegistrator.VERSION || 509 != Element.VERSION || 509 != Materials.VERSION || 509 != OrePrefixes.VERSION) {
            throw new GT_ItsNotMyFaultException("One of your Mods included GregTech-API Files inside it's download, mention this to the Mod Author, who does this bad thing, and tell him/her to use reflection. I have added a Version check, to prevent Authors from breaking my Mod that way.");
        }
    }
}

