/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_LargeTurbine;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_LargeTurbine_Gas
extends GT_MetaTileEntity_LargeTurbine {
    public GT_MetaTileEntity_LargeTurbine_Gas(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeTurbine_Gas(String aName) {
        super(aName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.BlockIcons.MACHINE_CASINGS[1][aColorIndex + 1];
        iTextureArray[1] = aFacing == aSide ? (aActive ? TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_SS_ACTIVE5).extFacing().build() : TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_SS5).extFacing().build()) : Textures.BlockIcons.casingTexturePages[0][58];
        return iTextureArray;
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Gas Turbine").addInfo("Controller block for the Large Gas Turbine").addInfo("Needs a Turbine, place inside controller").addPollutionAmount(20 * this.getPollutionPerTick(null)).addSeparator().beginStructureBlock(3, 3, 4, true).addController("Front center").addCasingInfo("Stainless Steel Turbine Casing", 24).addDynamoHatch("Back center", 1).addMaintenanceHatch("Side centered", 2).addMufflerHatch("Side centered", 2).addInputHatch("Gas Fuel, Side centered", 2).toolTipFinisher("Gregtech");
        return tt;
    }

    public int getFuelValue(FluidStack aLiquid) {
        if (aLiquid == null) {
            return 0;
        }
        GT_Recipe tFuel = GT_Recipe.GT_Recipe_Map.sTurbineFuels.findFuel(aLiquid);
        if (tFuel != null) {
            return tFuel.mSpecialValue;
        }
        return 0;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_LargeTurbine_Gas(this.mName);
    }

    @Override
    public Block getCasingBlock() {
        return GregTech_API.sBlockCasings4;
    }

    @Override
    public byte getCasingMeta() {
        return 10;
    }

    @Override
    public byte getCasingTextureIndex() {
        return 58;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 15;
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, int aOptFlow, int aBaseEff) {
        if (aFluids.size() >= 1) {
            int tEU = 0;
            int actualOptimalFlow = 0;
            FluidStack firstFuelType = new FluidStack(aFluids.get(0), 0);
            int fuelValue = this.getFuelValue(firstFuelType);
            if (aOptFlow < fuelValue) {
                this.realOptFlow = 1.0;
                this.depleteInput(new FluidStack(firstFuelType, 1));
                ++this.storedFluid;
                return GT_Utility.safeInt((long)aOptFlow * (long)aBaseEff / 10000L);
            }
            actualOptimalFlow = GT_Utility.safeInt((long)aOptFlow / (long)fuelValue);
            this.realOptFlow = actualOptimalFlow;
            int remainingFlow = GT_Utility.safeInt((long)((float)actualOptimalFlow * 1.25f));
            int flow = 0;
            int totalFlow = 0;
            this.storedFluid = 0;
            for (FluidStack aFluid : aFluids) {
                if (!aFluid.isFluidEqual(firstFuelType)) continue;
                flow = Math.min(aFluid.amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluid, flow));
                this.storedFluid += aFluid.amount;
                remainingFlow -= flow;
                totalFlow += flow;
            }
            if (totalFlow <= 0) {
                return 0;
            }
            tEU = GT_Utility.safeInt((long)totalFlow * (long)fuelValue);
            if (totalFlow == actualOptimalFlow) {
                tEU = GT_Utility.safeInt((long)tEU * (long)aBaseEff / 10000L);
            } else {
                float efficiency = 1.0f - Math.abs((float)(totalFlow - actualOptimalFlow) / (float)actualOptimalFlow);
                tEU = (int)((float)tEU * efficiency);
                tEU = GT_Utility.safeInt((long)tEU * (long)aBaseEff / 10000L);
            }
            return tEU;
        }
        return 0;
    }
}

