/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_DataAccess;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_AssemblyLine
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_MetaTileEntity_AssemblyLine> {
    public ArrayList<GT_MetaTileEntity_Hatch_DataAccess> mDataAccessHatches = new ArrayList();
    private static final String STRUCTURE_PIECE_FIRST = "first";
    private static final String STRUCTURE_PIECE_SECOND = "second";
    private static final String STRUCTURE_PIECE_LATER = "later";
    private static final IStructureDefinition<GT_MetaTileEntity_AssemblyLine> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("first", StructureUtility.transpose((String[][])new String[][]{{" ", "e", " "}, {"~", "l", "G"}, {"g", "m", "g"}, {"b", "i", "b"}})).addShape("second", StructureUtility.transpose((String[][])new String[][]{{" ", "e", " "}, {"d", "l", "G"}, {"g", "m", "g"}, {"b", "I", "b"}})).addShape("later", StructureUtility.transpose((String[][])new String[][]{{" ", "e", " "}, {"G", "l", "G"}, {"g", "m", "g"}, {"b", "I", "b"}})).addElement(Character.valueOf('G'), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings3, (int)10)).addElement(Character.valueOf('l'), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)9)).addElement(Character.valueOf('m'), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)5)).addElement(Character.valueOf('g'), StructureUtility.ofBlockAnyMeta((Block)GameRegistry.findBlock((String)"IC2", (String)"blockAlloyGlass"))).addElement(Character.valueOf('e'), GT_StructureUtility.ofHatchAdderOptional(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, 16, 1, GregTech_API.sBlockCasings2, 0)).addElement(Character.valueOf('d'), GT_StructureUtility.ofHatchAdderOptional(GT_MetaTileEntity_AssemblyLine::addDataAccessToMachineList, 42, 2, GregTech_API.sBlockCasings3, 10)).addElement(Character.valueOf('b'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, 16, 3), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_AssemblyLine::addInputHatchToMachineList, 16, 3), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)0)})).addElement(Character.valueOf('I'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, 16, 4), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, 16, 4)})).addElement(Character.valueOf('i'), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, 16, 5)).build();

    public GT_MetaTileEntity_AssemblyLine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_AssemblyLine(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_AssemblyLine(this.mName);
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Assembling Line").addInfo("Controller block for the Assembling Line").addInfo("Used to make complex machine parts (LuV+)").addInfo("Does not make Assembler items").addSeparator().beginVariableStructureBlock(5, 15, 4, 4, 3, 3, false).addStructureInfo("From Bottom to Top, Left to Right").addStructureInfo("Layer 1 - Solid Steel Machine Casing, Input Bus (last is Output Bus), Solid Steel Machine Casing").addStructureInfo("Layer 2 - Reinforced Glass, Assembling Line Casing, Reinforced Glass").addStructureInfo("Layer 3 - Grate Machine Casing, Assembler Machine Casing, Grate Machine Casing").addStructureInfo("Layer 4 - Empty, Solid Steel Machine Casing, Empty").addStructureInfo("Up to 16 repeating slices, each one allows for 1 more item in recipes, aside from the last").addController("Either Grate on layer 3 of the first slice").addEnergyHatch("Any layer 4 casing", 1).addMaintenanceHatch("Any layer 1 casing", 3).addInputBus("As specified on layer 1", 4, 5).addInputHatch("Any layer 1 casing", 3).addOutputBus("Replaces Input Bus on final slice", 4).addOtherStructurePart("Data Access Hatch", "Optional, next to controller", 2).toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "AssemblyLine.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        int i;
        ArrayList<ItemStack> tDataStickList;
        if (GT_Values.D1) {
            GT_Mod.GT_FML_LOGGER.info("Start ALine recipe check");
        }
        if ((tDataStickList = this.getDataItems(2)).isEmpty()) {
            return false;
        }
        if (GT_Values.D1) {
            GT_Mod.GT_FML_LOGGER.info("Stick accepted, " + tDataStickList.size() + " Data Sticks found");
        }
        ItemStack[] tStack = new ItemStack[15];
        FluidStack[] tFluids = new FluidStack[4];
        boolean findRecipe = false;
        block0: for (ItemStack tDataStick : tDataStickList) {
            int tMaxProgressTime;
            int i2;
            NBTTagCompound tTag = tDataStick.func_77978_p();
            if (tTag == null) continue;
            for (i2 = 0; i2 < 15; ++i2) {
                int count = tTag.func_74762_e("a" + i2);
                if (!tTag.func_74764_b("" + i2) && count <= 0) continue;
                if (this.mInputBusses.get(i2) == null) continue block0;
                ItemStack stackInSlot = ((GT_MetaTileEntity_Hatch_InputBus)this.mInputBusses.get(i2)).getBaseMetaTileEntity().func_70301_a(0);
                boolean flag = true;
                if (count > 0) {
                    for (int j = 0; j < count; ++j) {
                        tStack[i2] = GT_Utility.loadItem(tTag, "a" + i2 + ":" + j);
                        if (tStack[i2] == null) continue;
                        if (GT_Values.D1) {
                            GT_Mod.GT_FML_LOGGER.info("Item " + i2 + " : " + tStack[i2].func_77977_a());
                        }
                        if (!GT_Utility.areStacksEqual(tStack[i2], stackInSlot, true) || tStack[i2].field_77994_a > stackInSlot.field_77994_a) continue;
                        flag = false;
                        break;
                    }
                }
                if (flag) {
                    tStack[i2] = GT_Utility.loadItem(tTag, "" + i2);
                    if (tStack[i2] == null) {
                        flag = false;
                        continue;
                    }
                    if (GT_Values.D1) {
                        GT_Mod.GT_FML_LOGGER.info("Item " + i2 + " : " + tStack[i2].func_77977_a());
                    }
                    if (GT_Utility.areStacksEqual(tStack[i2], stackInSlot, true) && tStack[i2].field_77994_a <= stackInSlot.field_77994_a) {
                        flag = false;
                    }
                }
                if (GT_Values.D1) {
                    GT_Mod.GT_FML_LOGGER.info(i2 + (flag ? " not accepted" : " accepted"));
                }
                if (flag) continue block0;
            }
            if (GT_Values.D1) {
                GT_Mod.GT_FML_LOGGER.info("All Items done, start fluid check");
            }
            for (i2 = 0; i2 < 4; ++i2) {
                if (!tTag.func_74764_b("f" + i2)) continue;
                tFluids[i2] = GT_Utility.loadFluid(tTag, "f" + i2);
                if (tFluids[i2] == null) continue;
                if (GT_Values.D1) {
                    GT_Mod.GT_FML_LOGGER.info("Fluid " + i2 + " " + tFluids[i2].getUnlocalizedName());
                }
                if (this.mInputHatches.get(i2) == null) continue block0;
                FluidStack fluidInHatch = ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)i2)).mFluid;
                if (!GT_Utility.areFluidsEqual(fluidInHatch, tFluids[i2], true) || fluidInHatch.amount < tFluids[i2].amount) {
                    if (!GT_Values.D1) continue block0;
                    GT_Mod.GT_FML_LOGGER.info(i2 + " not accepted");
                    continue block0;
                }
                if (!GT_Values.D1) continue;
                GT_Mod.GT_FML_LOGGER.info(i2 + " accepted");
            }
            if (GT_Values.D1) {
                GT_Mod.GT_FML_LOGGER.info("Input accepted, check other values");
            }
            if (!tTag.func_74764_b("output")) continue;
            this.mOutputItems = new ItemStack[]{GT_Utility.loadItem(tTag, "output")};
            if (this.mOutputItems[0] == null || !GT_Utility.isStackValid(this.mOutputItems[0]) || !tTag.func_74764_b("time") || (tMaxProgressTime = tTag.func_74762_e("time")) <= 0 || !tTag.func_74764_b("eu")) continue;
            if (GT_Values.D1) {
                GT_Mod.GT_FML_LOGGER.info("Check overclock");
            }
            this.calculateOverclockedNessMulti(tTag.func_74762_e("eu"), tMaxProgressTime, 1, this.getMaxInputVoltage());
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                if (!GT_Values.D1) continue;
                GT_Mod.GT_FML_LOGGER.info("Recipe too OP");
                continue;
            }
            if (GT_Values.D1) {
                GT_Mod.GT_FML_LOGGER.info("Find avaiable recipe");
            }
            findRecipe = true;
            break;
        }
        if (!findRecipe) {
            return false;
        }
        if (GT_Values.D1) {
            GT_Mod.GT_FML_LOGGER.info("All checked start consuming inputs");
        }
        for (i = 0; i < 15; ++i) {
            if (tStack[i] == null) continue;
            ItemStack stackInSlot = ((GT_MetaTileEntity_Hatch_InputBus)this.mInputBusses.get(i)).getBaseMetaTileEntity().func_70301_a(0);
            stackInSlot.field_77994_a -= tStack[i].field_77994_a;
        }
        for (i = 0; i < 4; ++i) {
            if (tFluids[i] == null) continue;
            ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)i)).mFluid.amount -= tFluids[i].amount;
            if (((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)i)).mFluid.amount > 0) continue;
            ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)i)).mFluid = null;
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.updateSlots();
        if (GT_Values.D1) {
            GT_Mod.GT_FML_LOGGER.info("Recipe sucessfull");
        }
        return true;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        for (GT_MetaTileEntity_Hatch_DataAccess hatch_dataAccess : this.mDataAccessHatches) {
            hatch_dataAccess.setActive(true);
        }
        return super.onRunningTick(aStack);
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 20) {
            GT_Utility.doSoundAtClient(GregTech_API.sSoundList.get(212), 10, 1.0f, aX, aY, aZ);
        }
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_AssemblyLine> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mDataAccessHatches.clear();
        if (!this.checkPiece(STRUCTURE_PIECE_FIRST, 0, 1, 0)) {
            return false;
        }
        return this.checkMachine(true) || this.checkMachine(false);
    }

    private boolean checkMachine(boolean leftToRight) {
        for (int i = 1; i < 16; ++i) {
            if (!this.checkPiece(i == 1 ? STRUCTURE_PIECE_SECOND : STRUCTURE_PIECE_LATER, leftToRight ? -i : i, 1, 0)) {
                return false;
            }
            if (this.mOutputBusses.isEmpty()) continue;
            return !this.mEnergyHatches.isEmpty() && this.mMaintenanceHatches.size() == 1;
        }
        return false;
    }

    private boolean isCorrectDataItem(ItemStack aStack, int state) {
        if ((state & 1) != 0 && ItemList.Circuit_Integrated.isStackEqual(aStack, true, true)) {
            return true;
        }
        if ((state & 2) != 0 && ItemList.Tool_DataStick.isStackEqual(aStack, false, true)) {
            return true;
        }
        return (state & 4) != 0 && ItemList.Tool_DataOrb.isStackEqual(aStack, false, true);
    }

    public ArrayList<ItemStack> getDataItems(int state) {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (GT_Utility.isStackValid(this.mInventory[1]) && this.isCorrectDataItem(this.mInventory[1], state)) {
            rList.add(this.mInventory[1]);
        }
        for (GT_MetaTileEntity_Hatch_DataAccess tHatch : this.mDataAccessHatches) {
            if (!GT_MetaTileEntity_AssemblyLine.isValidMetaTileEntity(tHatch)) continue;
            for (int i = 0; i < tHatch.getBaseMetaTileEntity().func_70302_i_(); ++i) {
                if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null || !this.isCorrectDataItem(tHatch.getBaseMetaTileEntity().func_70301_a(i), state)) continue;
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    public boolean addDataAccessToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DataAccess) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mDataAccessHatches.add((GT_MetaTileEntity_Hatch_DataAccess)aMetaTileEntity);
        }
        return false;
    }

    private boolean addInputHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_FIRST, stackSize, hintsOnly, 0, 1, 0);
        int tLength = Math.min(stackSize.field_77994_a + 1, 16);
        for (int i = 1; i < tLength; ++i) {
            this.buildPiece(i == 1 ? STRUCTURE_PIECE_SECOND : STRUCTURE_PIECE_LATER, stackSize, hintsOnly, -i, 1, 0);
        }
    }
}

