/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconCheckButton;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.net.GT_Packet_TileEntityCover;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fluids.Fluid;

public class GT_Cover_PlayerDetector
extends GT_CoverBehavior {
    private String placer = "";
    private int range = 8;

    @Override
    public boolean isRedstoneSensitive(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        boolean playerDetected = false;
        if (aTileEntity instanceof IGregTechTileEntity) {
            if (aTileEntity.isUniversalEnergyStored(20L)) {
                aTileEntity.decreaseStoredEnergyUnits(20L, true);
                this.range = 32;
            } else {
                this.range = 8;
            }
            this.placer = ((IGregTechTileEntity)aTileEntity).getOwnerName();
        }
        for (Object tObject : aTileEntity.getWorld().field_73010_i) {
            EntityPlayerMP tEntity;
            int dist;
            if (!(tObject instanceof EntityPlayerMP) || (dist = Math.max(1, (int)(tEntity = (EntityPlayerMP)tObject).func_70011_f((double)aTileEntity.getXCoord() + 0.5, (double)aTileEntity.getYCoord() + 0.5, (double)aTileEntity.getZCoord() + 0.5))) >= this.range) continue;
            if (aCoverVariable == 0) {
                playerDetected = true;
                break;
            }
            if (tEntity.getDisplayName().equalsIgnoreCase(this.placer)) {
                if (aCoverVariable != 1) continue;
                playerDetected = true;
                break;
            }
            if (aCoverVariable != 2) continue;
            playerDetected = true;
            break;
        }
        aTileEntity.setOutputRedstoneSignal(aSide, (byte)(playerDetected ? 15 : 0));
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((aCoverVariable = (aCoverVariable + (aPlayer.func_70093_af() ? -1 : 1)) % 3) < 0) {
            aCoverVariable = 2;
        }
        switch (aCoverVariable) {
            case 0: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("068", "Emit if any Player is close"));
                break;
            }
            case 1: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("069", "Emit if other Player is close"));
                break;
            }
            case 2: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("070", "Emit if you are close"));
            }
        }
        return aCoverVariable;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 20;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public Object getClientGUI(byte aSide, int aCoverID, int coverData, ICoverable aTileEntity) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private int coverVariable;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public GUI(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            new GT_GuiIconCheckButton(this, 0, 10, 25, GT_GuiIcon.CHECKMARK, null).setTooltipText(GT_Cover_PlayerDetector.this.trans("068", "Emit if any Player is close"));
            new GT_GuiIconCheckButton(this, 1, 10, 43, GT_GuiIcon.CHECKMARK, null).setTooltipText(GT_Cover_PlayerDetector.this.trans("069", "Emit if other Player is close"));
            new GT_GuiIconCheckButton(this, 2, 10, 61, GT_GuiIcon.CHECKMARK, null).setTooltipText(GT_Cover_PlayerDetector.this.trans("070", "Emit if you are close"));
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.field_146289_q.func_78276_b("Any player", 28, 29, -11184811);
            this.field_146289_q.func_78276_b("Other players", 28, 47, -11184811);
            this.field_146289_q.func_78276_b("Only owner", 28, 65, -11184811);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.updateButtons();
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            if (!this.isEnabled(btn.field_146127_k)) {
                this.coverVariable = this.getNewCoverVariable(btn.field_146127_k, ((GT_GuiIconCheckButton)btn).isChecked());
                GT_Values.NW.sendToServer(new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
            }
            this.updateButtons();
        }

        private void updateButtons() {
            for (Object o : this.field_146292_n) {
                ((GT_GuiIconCheckButton)o).setChecked(this.isEnabled(((GT_GuiIconCheckButton)o).field_146127_k));
            }
        }

        private int getNewCoverVariable(int id, boolean checked) {
            return id;
        }

        private boolean isEnabled(int id) {
            return this.coverVariable == id;
        }
    }
}

