/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;

@SideOnly(value=Side.CLIENT)
public class LightingHelper {
    public static final int NORMAL_BRIGHTNESS = 0xFF00FF;
    public static final int MAX_BRIGHTNESS = 0xF000F0;
    public static final float NO_Z_FIGHT_OFFSET = 9.765625E-4f;
    protected static final float[] LIGHTNESS = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    private final RenderBlocks renderBlocks;
    private int brightness;
    private float aoTopLeft;
    private float aoBottomLeft;
    private float aoBottomRight;
    private float aoTopRight;
    private boolean hasLightnessOverride;
    private float lightnessOverride;
    private boolean hasBrightnessOverride;
    private int brightnessOverride;
    private boolean hasColorOverride;
    private int colorOverride = 0xFFFFFF;

    public LightingHelper(RenderBlocks renderBlocks) {
        this.renderBlocks = renderBlocks;
        if (renderBlocks.field_147844_c) {
            this.setLightnessOverride(1.0f);
        }
    }

    public static int getAverageBrightness(int brightnessA, int brightnessB) {
        int sectionA1 = brightnessA >> 16 & 0xFF;
        int sectionA2 = brightnessA & 0xFF;
        int sectionB1 = brightnessB >> 16 & 0xFF;
        int sectionB2 = brightnessB & 0xFF;
        int difference1 = (int)((float)(sectionA1 + sectionB1) / 2.0f);
        int difference2 = (int)((float)(sectionA2 + sectionB2) / 2.0f);
        return difference1 << 16 | difference2;
    }

    public static float[] getRGB(short[] color) {
        float red = (float)color[0] / 255.0f;
        float green = (float)color[1] / 255.0f;
        float blue = (float)color[2] / 255.0f;
        return new float[]{red, green, blue};
    }

    public void clearBrightnessOverride() {
        this.hasBrightnessOverride = false;
    }

    public void clearColorOverride() {
        this.hasColorOverride = false;
    }

    public void clearLightnessOverride() {
        this.hasLightnessOverride = false;
    }

    public float getAoBottomLeft() {
        return this.aoBottomLeft;
    }

    public float getAoBottomRight() {
        return this.aoBottomRight;
    }

    public float getAoTopLeft() {
        return this.aoTopLeft;
    }

    public float getAoTopRight() {
        return this.aoTopRight;
    }

    public LightingHelper setBrightnessOverride(int brightness) {
        this.hasBrightnessOverride = true;
        this.brightnessOverride = brightness;
        return this;
    }

    public LightingHelper setColorOverride(short[] color) {
        return this.setColorOverride(LightingHelper.getColor(color));
    }

    public LightingHelper setColorOverride(int color) {
        this.hasColorOverride = true;
        this.colorOverride = color;
        return this;
    }

    public static int getColor(short[] rgba) {
        return rgba[2] & 0xFF | (rgba[1] & 0xFF) << 8 | (rgba[0] & 0xFF) << 16;
    }

    public LightingHelper setLightnessOverride(float lightness) {
        this.hasLightnessOverride = true;
        this.lightnessOverride = lightness;
        return this;
    }

    public void setupColor(int side, short[] rgba) {
        this.setupColor(side, LightingHelper.getColor(rgba));
    }

    public void setupColor(int side, int hexColor) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float lightness = this.hasLightnessOverride ? this.lightnessOverride : LIGHTNESS[side];
        float[] rgb = LightingHelper.getRGB(hexColor);
        if (this.hasColorOverride && !this.renderBlocks.func_147744_b()) {
            rgb = LightingHelper.getRGB(this.colorOverride);
        }
        this.applyAnaglyph(rgb);
        if (this.renderBlocks.field_147863_w) {
            tessellator.func_78380_c(this.hasBrightnessOverride ? this.brightnessOverride : this.brightness);
            if (this.renderBlocks.func_147744_b()) {
                this.renderBlocks.field_147850_ar = this.renderBlocks.field_147848_as = rgb[0];
                this.renderBlocks.field_147852_aq = this.renderBlocks.field_147848_as;
                this.renderBlocks.field_147872_ap = this.renderBlocks.field_147848_as;
                this.renderBlocks.field_147858_av = this.renderBlocks.field_147856_aw = rgb[1];
                this.renderBlocks.field_147860_au = this.renderBlocks.field_147856_aw;
                this.renderBlocks.field_147846_at = this.renderBlocks.field_147856_aw;
                this.renderBlocks.field_147839_az = this.renderBlocks.field_147833_aA = rgb[2];
                this.renderBlocks.field_147841_ay = this.renderBlocks.field_147833_aA;
                this.renderBlocks.field_147854_ax = this.renderBlocks.field_147833_aA;
            } else {
                this.renderBlocks.field_147850_ar = this.renderBlocks.field_147848_as = rgb[0] * lightness;
                this.renderBlocks.field_147852_aq = this.renderBlocks.field_147848_as;
                this.renderBlocks.field_147872_ap = this.renderBlocks.field_147848_as;
                this.renderBlocks.field_147858_av = this.renderBlocks.field_147856_aw = rgb[1] * lightness;
                this.renderBlocks.field_147860_au = this.renderBlocks.field_147856_aw;
                this.renderBlocks.field_147846_at = this.renderBlocks.field_147856_aw;
                this.renderBlocks.field_147839_az = this.renderBlocks.field_147833_aA = rgb[2] * lightness;
                this.renderBlocks.field_147841_ay = this.renderBlocks.field_147833_aA;
                this.renderBlocks.field_147854_ax = this.renderBlocks.field_147833_aA;
                this.renderBlocks.field_147872_ap *= this.aoTopLeft;
                this.renderBlocks.field_147846_at *= this.aoTopLeft;
                this.renderBlocks.field_147854_ax *= this.aoTopLeft;
                this.renderBlocks.field_147852_aq *= this.aoBottomLeft;
                this.renderBlocks.field_147860_au *= this.aoBottomLeft;
                this.renderBlocks.field_147841_ay *= this.aoBottomLeft;
                this.renderBlocks.field_147850_ar *= this.aoBottomRight;
                this.renderBlocks.field_147858_av *= this.aoBottomRight;
                this.renderBlocks.field_147839_az *= this.aoBottomRight;
                this.renderBlocks.field_147848_as *= this.aoTopRight;
                this.renderBlocks.field_147856_aw *= this.aoTopRight;
                this.renderBlocks.field_147833_aA *= this.aoTopRight;
            }
        } else {
            if (this.hasBrightnessOverride) {
                tessellator.func_78380_c(this.brightnessOverride);
            }
            tessellator.func_78386_a(rgb[0] * lightness, rgb[1] * lightness, rgb[2] * lightness);
        }
    }

    public static float[] getRGB(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        return new float[]{red, green, blue};
    }

    public void applyAnaglyph(float[] rgb) {
        if (EntityRenderer.field_78517_a) {
            rgb[0] = (rgb[0] * 30.0f + rgb[1] * 59.0f + rgb[2] * 11.0f) / 100.0f;
            rgb[1] = (rgb[0] * 30.0f + rgb[1] * 70.0f) / 100.0f;
            rgb[2] = (rgb[0] * 30.0f + rgb[2] * 70.0f) / 100.0f;
        }
    }

    public static float getMixedAo(float ao1, float ao2, double ratio) {
        float diff = (float)((double)Math.abs(ao1 - ao2) * (1.0 - ratio));
        return ao1 > ao2 ? ao1 - diff : ao1 + diff;
    }

    public LightingHelper setupLightingXNeg(Block block, int x, int y, int z) {
        if (this.renderBlocks.field_147863_w) {
            int mixedBrightness;
            int xOffset = this.renderBlocks.field_147859_h > 9.765625E-4 ? x : x - 1;
            this.brightness = mixedBrightness = block.func_149677_c(this.renderBlocks.field_147845_a, xOffset, y, z);
            float ratio = (float)(1.0 - this.renderBlocks.field_147859_h);
            float aoLightValue = this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I();
            this.renderBlocks.field_147831_S = block.func_149677_c(this.renderBlocks.field_147845_a, xOffset, y - 1, z);
            this.renderBlocks.field_147883_ah = block.func_149677_c(this.renderBlocks.field_147845_a, xOffset, y, z - 1);
            this.renderBlocks.field_147868_aj = block.func_149677_c(this.renderBlocks.field_147845_a, xOffset, y, z + 1);
            this.renderBlocks.field_147880_aa = block.func_149677_c(this.renderBlocks.field_147845_a, xOffset, y + 1, z);
            this.renderBlocks.field_147832_R = block.func_149677_c(this.renderBlocks.field_147845_a, xOffset, y - 1, z - 1);
            this.renderBlocks.field_147826_T = block.func_149677_c(this.renderBlocks.field_147845_a, xOffset, y - 1, z + 1);
            this.renderBlocks.field_147836_Z = block.func_149677_c(this.renderBlocks.field_147845_a, xOffset, y + 1, z - 1);
            this.renderBlocks.field_147881_ab = block.func_149677_c(this.renderBlocks.field_147845_a, xOffset, y + 1, z + 1);
            this.renderBlocks.field_147886_y = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I(), ratio);
            this.renderBlocks.field_147819_N = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I(), ratio);
            this.renderBlocks.field_147830_P = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I(), ratio);
            this.renderBlocks.field_147813_G = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I(), ratio);
            this.renderBlocks.field_147888_x = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z - 1).func_149685_I(), ratio);
            this.renderBlocks.field_147884_z = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z + 1).func_149685_I(), ratio);
            this.renderBlocks.field_147812_F = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z - 1).func_149685_I(), ratio);
            this.renderBlocks.field_147821_H = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z + 1).func_149685_I(), ratio);
            int brightnessMixedXYZNPN = this.renderBlocks.func_147778_a(this.renderBlocks.field_147883_ah, this.renderBlocks.field_147836_Z, this.renderBlocks.field_147880_aa, mixedBrightness);
            int brightnessMixedXYZNNN = this.renderBlocks.func_147778_a(this.renderBlocks.field_147832_R, this.renderBlocks.field_147831_S, this.renderBlocks.field_147883_ah, mixedBrightness);
            int brightnessMixedXYZNNP = this.renderBlocks.func_147778_a(this.renderBlocks.field_147831_S, this.renderBlocks.field_147826_T, this.renderBlocks.field_147868_aj, mixedBrightness);
            int brightnessMixedXYZNPP = this.renderBlocks.func_147778_a(this.renderBlocks.field_147868_aj, this.renderBlocks.field_147880_aa, this.renderBlocks.field_147881_ab, mixedBrightness);
            float aoMixedXYZNPN = (this.renderBlocks.field_147819_N + aoLightValue + this.renderBlocks.field_147812_F + this.renderBlocks.field_147813_G) / 4.0f;
            float aoMixedXYZNNN = (this.renderBlocks.field_147888_x + this.renderBlocks.field_147886_y + this.renderBlocks.field_147819_N + aoLightValue) / 4.0f;
            float aoMixedXYZNNP = (this.renderBlocks.field_147886_y + this.renderBlocks.field_147884_z + aoLightValue + this.renderBlocks.field_147830_P) / 4.0f;
            float aoMixedXYZNPP = (aoLightValue + this.renderBlocks.field_147830_P + this.renderBlocks.field_147813_G + this.renderBlocks.field_147821_H) / 4.0f;
            this.aoTopLeft = (float)((double)aoMixedXYZNPP * this.renderBlocks.field_147857_k * this.renderBlocks.field_147853_m + (double)aoMixedXYZNPN * this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147853_m) + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147853_m) + (double)aoMixedXYZNNP * (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147853_m);
            this.aoBottomLeft = (float)((double)aoMixedXYZNPP * this.renderBlocks.field_147857_k * this.renderBlocks.field_147851_l + (double)aoMixedXYZNPN * this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147851_l) + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147851_l) + (double)aoMixedXYZNNP * (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147851_l);
            this.aoBottomRight = (float)((double)aoMixedXYZNPP * this.renderBlocks.field_147855_j * this.renderBlocks.field_147851_l + (double)aoMixedXYZNPN * this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147851_l) + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147851_l) + (double)aoMixedXYZNNP * (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147851_l);
            this.aoTopRight = (float)((double)aoMixedXYZNPP * this.renderBlocks.field_147855_j * this.renderBlocks.field_147853_m + (double)aoMixedXYZNPN * this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147853_m) + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147853_m) + (double)aoMixedXYZNNP * (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147853_m);
            this.renderBlocks.field_147864_al = this.renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZNPN, brightnessMixedXYZNNN, brightnessMixedXYZNNP, this.renderBlocks.field_147857_k * this.renderBlocks.field_147853_m, this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147853_m), (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147853_m), (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147853_m);
            this.renderBlocks.field_147874_am = this.renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZNPN, brightnessMixedXYZNNN, brightnessMixedXYZNNP, this.renderBlocks.field_147857_k * this.renderBlocks.field_147851_l, this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147851_l), (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147851_l), (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147851_l);
            this.renderBlocks.field_147876_an = this.renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZNPN, brightnessMixedXYZNNN, brightnessMixedXYZNNP, this.renderBlocks.field_147855_j * this.renderBlocks.field_147851_l, this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147851_l), (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147851_l), (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147851_l);
            this.renderBlocks.field_147870_ao = this.renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZNPN, brightnessMixedXYZNNN, brightnessMixedXYZNNP, this.renderBlocks.field_147855_j * this.renderBlocks.field_147853_m, this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147853_m), (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147853_m), (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147853_m);
        }
        return this;
    }

    public LightingHelper setupLightingXPos(Block block, int x, int y, int z) {
        if (this.renderBlocks.field_147863_w) {
            int mixedBrightness;
            int xOffset = this.renderBlocks.field_147861_i < 0.9990234375 ? x : x + 1;
            this.brightness = mixedBrightness = block.func_149677_c(this.renderBlocks.field_147845_a, xOffset, y, z);
            float aoLightValue = this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I();
            this.renderBlocks.field_147835_X = block.func_149677_c(this.renderBlocks.field_147845_a, xOffset, y - 1, z);
            this.renderBlocks.field_147866_ai = block.func_149677_c(this.renderBlocks.field_147845_a, xOffset, y, z - 1);
            this.renderBlocks.field_147862_ak = block.func_149677_c(this.renderBlocks.field_147845_a, xOffset, y, z + 1);
            this.renderBlocks.field_147885_ae = block.func_149677_c(this.renderBlocks.field_147845_a, xOffset, y + 1, z);
            this.renderBlocks.field_147827_W = block.func_149677_c(this.renderBlocks.field_147845_a, xOffset, y - 1, z - 1);
            this.renderBlocks.field_147834_Y = block.func_149677_c(this.renderBlocks.field_147845_a, xOffset, y - 1, z + 1);
            this.renderBlocks.field_147879_ad = block.func_149677_c(this.renderBlocks.field_147845_a, xOffset, y + 1, z - 1);
            this.renderBlocks.field_147882_ag = block.func_149677_c(this.renderBlocks.field_147845_a, xOffset, y + 1, z + 1);
            this.renderBlocks.field_147810_D = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I(), this.renderBlocks.field_147861_i);
            this.renderBlocks.field_147820_O = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I(), this.renderBlocks.field_147861_i);
            this.renderBlocks.field_147829_Q = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I(), this.renderBlocks.field_147861_i);
            this.renderBlocks.field_147824_K = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I(), this.renderBlocks.field_147861_i);
            this.renderBlocks.field_147816_C = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z - 1).func_149685_I(), this.renderBlocks.field_147861_i);
            this.renderBlocks.field_147811_E = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z + 1).func_149685_I(), this.renderBlocks.field_147861_i);
            this.renderBlocks.field_147823_J = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z - 1).func_149685_I(), this.renderBlocks.field_147861_i);
            this.renderBlocks.field_147818_M = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z + 1).func_149685_I(), this.renderBlocks.field_147861_i);
            int brightnessMixedXYZPPP = this.renderBlocks.func_147778_a(this.renderBlocks.field_147862_ak, this.renderBlocks.field_147885_ae, this.renderBlocks.field_147882_ag, mixedBrightness);
            int brightnessMixedXYZPNP = this.renderBlocks.func_147778_a(this.renderBlocks.field_147835_X, this.renderBlocks.field_147834_Y, this.renderBlocks.field_147862_ak, mixedBrightness);
            int brightnessMixedXYZPNN = this.renderBlocks.func_147778_a(this.renderBlocks.field_147827_W, this.renderBlocks.field_147835_X, this.renderBlocks.field_147866_ai, mixedBrightness);
            int brightnessMixedXYZPPN = this.renderBlocks.func_147778_a(this.renderBlocks.field_147866_ai, this.renderBlocks.field_147879_ad, this.renderBlocks.field_147885_ae, mixedBrightness);
            float aoMixedXYZPPP = (aoLightValue + this.renderBlocks.field_147829_Q + this.renderBlocks.field_147824_K + this.renderBlocks.field_147818_M) / 4.0f;
            float aoMixedXYZPNP = (this.renderBlocks.field_147810_D + this.renderBlocks.field_147811_E + aoLightValue + this.renderBlocks.field_147829_Q) / 4.0f;
            float aoMixedXYZPNN = (this.renderBlocks.field_147816_C + this.renderBlocks.field_147810_D + this.renderBlocks.field_147820_O + aoLightValue) / 4.0f;
            float aoMixedXYZPPN = (this.renderBlocks.field_147820_O + aoLightValue + this.renderBlocks.field_147823_J + this.renderBlocks.field_147824_K) / 4.0f;
            this.aoTopLeft = (float)((double)aoMixedXYZPNP * (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147853_m + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147853_m) + (double)aoMixedXYZPPN * this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147853_m) + (double)aoMixedXYZPPP * this.renderBlocks.field_147855_j * this.renderBlocks.field_147853_m);
            this.aoBottomLeft = (float)((double)aoMixedXYZPNP * (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147851_l + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147851_l) + (double)aoMixedXYZPPN * this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147851_l) + (double)aoMixedXYZPPP * this.renderBlocks.field_147855_j * this.renderBlocks.field_147851_l);
            this.aoBottomRight = (float)((double)aoMixedXYZPNP * (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147851_l + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147851_l) + (double)aoMixedXYZPPN * this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147851_l) + (double)aoMixedXYZPPP * this.renderBlocks.field_147857_k * this.renderBlocks.field_147851_l);
            this.aoTopRight = (float)((double)aoMixedXYZPNP * (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147853_m + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147853_m) + (double)aoMixedXYZPPN * this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147853_m) + (double)aoMixedXYZPPP * this.renderBlocks.field_147857_k * this.renderBlocks.field_147853_m);
            this.renderBlocks.field_147864_al = this.renderBlocks.func_147727_a(brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZPPN, brightnessMixedXYZPPP, (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147853_m, (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147853_m), this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147853_m), this.renderBlocks.field_147855_j * this.renderBlocks.field_147853_m);
            this.renderBlocks.field_147874_am = this.renderBlocks.func_147727_a(brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZPPN, brightnessMixedXYZPPP, (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147851_l, (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147851_l), this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147851_l), this.renderBlocks.field_147855_j * this.renderBlocks.field_147851_l);
            this.renderBlocks.field_147876_an = this.renderBlocks.func_147727_a(brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZPPN, brightnessMixedXYZPPP, (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147851_l, (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147851_l), this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147851_l), this.renderBlocks.field_147857_k * this.renderBlocks.field_147851_l);
            this.renderBlocks.field_147870_ao = this.renderBlocks.func_147727_a(brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZPPN, brightnessMixedXYZPPP, (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147853_m, (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147853_m), this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147853_m), this.renderBlocks.field_147857_k * this.renderBlocks.field_147853_m);
        }
        return this;
    }

    public LightingHelper setupLightingYNeg(Block block, int x, int y, int z) {
        if (this.renderBlocks.field_147863_w) {
            int mixedBrightness;
            int yOffset = this.renderBlocks.field_147855_j > 9.765625E-4 ? y : y - 1;
            this.brightness = mixedBrightness = block.func_149677_c(this.renderBlocks.field_147845_a, x, yOffset, z);
            float ratio = (float)(1.0 - this.renderBlocks.field_147855_j);
            float aoLightValue = this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I();
            this.renderBlocks.field_147831_S = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, yOffset, z);
            this.renderBlocks.field_147825_U = block.func_149677_c(this.renderBlocks.field_147845_a, x, yOffset, z - 1);
            this.renderBlocks.field_147828_V = block.func_149677_c(this.renderBlocks.field_147845_a, x, yOffset, z + 1);
            this.renderBlocks.field_147835_X = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, yOffset, z);
            this.renderBlocks.field_147832_R = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, yOffset, z - 1);
            this.renderBlocks.field_147826_T = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, yOffset, z + 1);
            this.renderBlocks.field_147827_W = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, yOffset, z - 1);
            this.renderBlocks.field_147834_Y = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, yOffset, z + 1);
            this.renderBlocks.field_147886_y = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I(), ratio);
            this.renderBlocks.field_147814_A = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I(), ratio);
            this.renderBlocks.field_147815_B = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I(), ratio);
            this.renderBlocks.field_147810_D = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I(), ratio);
            this.renderBlocks.field_147888_x = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z - 1).func_149685_I(), ratio);
            this.renderBlocks.field_147884_z = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z + 1).func_149685_I(), ratio);
            this.renderBlocks.field_147816_C = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z - 1).func_149685_I(), ratio);
            this.renderBlocks.field_147811_E = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z + 1).func_149685_I(), ratio);
            int brightnessMixedXYZPNP = this.renderBlocks.func_147778_a(this.renderBlocks.field_147828_V, this.renderBlocks.field_147834_Y, this.renderBlocks.field_147835_X, mixedBrightness);
            int brightnessMixedXYZPNN = this.renderBlocks.func_147778_a(this.renderBlocks.field_147825_U, this.renderBlocks.field_147835_X, this.renderBlocks.field_147827_W, mixedBrightness);
            int brightnessMixedXYZNNN = this.renderBlocks.func_147778_a(this.renderBlocks.field_147831_S, this.renderBlocks.field_147832_R, this.renderBlocks.field_147825_U, mixedBrightness);
            int brightnessMixedXYZNNP = this.renderBlocks.func_147778_a(this.renderBlocks.field_147826_T, this.renderBlocks.field_147831_S, this.renderBlocks.field_147828_V, mixedBrightness);
            float aoMixedXYZPNP = (this.renderBlocks.field_147815_B + aoLightValue + this.renderBlocks.field_147811_E + this.renderBlocks.field_147810_D) / 4.0f;
            float aoMixedXYZPNN = (aoLightValue + this.renderBlocks.field_147814_A + this.renderBlocks.field_147810_D + this.renderBlocks.field_147816_C) / 4.0f;
            float aoMixedXYZNNN = (this.renderBlocks.field_147886_y + this.renderBlocks.field_147888_x + aoLightValue + this.renderBlocks.field_147814_A) / 4.0f;
            float aoMixedXYZNNP = (this.renderBlocks.field_147884_z + this.renderBlocks.field_147886_y + this.renderBlocks.field_147815_B + aoLightValue) / 4.0f;
            this.aoTopLeft = (float)((double)aoMixedXYZNNP * this.renderBlocks.field_147853_m * (1.0 - this.renderBlocks.field_147859_h) + (double)aoMixedXYZPNP * this.renderBlocks.field_147853_m * this.renderBlocks.field_147859_h + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.field_147853_m) * this.renderBlocks.field_147859_h + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.field_147853_m) * (1.0 - this.renderBlocks.field_147859_h));
            this.aoBottomLeft = (float)((double)aoMixedXYZNNP * this.renderBlocks.field_147851_l * (1.0 - this.renderBlocks.field_147859_h) + (double)aoMixedXYZPNP * this.renderBlocks.field_147851_l * this.renderBlocks.field_147859_h + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.field_147851_l) * this.renderBlocks.field_147859_h + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.field_147851_l) * (1.0 - this.renderBlocks.field_147859_h));
            this.aoBottomRight = (float)((double)aoMixedXYZNNP * this.renderBlocks.field_147851_l * (1.0 - this.renderBlocks.field_147861_i) + (double)aoMixedXYZPNP * this.renderBlocks.field_147851_l * this.renderBlocks.field_147861_i + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.field_147851_l) * this.renderBlocks.field_147861_i + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.field_147851_l) * (1.0 - this.renderBlocks.field_147861_i));
            this.aoTopRight = (float)((double)aoMixedXYZNNP * this.renderBlocks.field_147853_m * (1.0 - this.renderBlocks.field_147861_i) + (double)aoMixedXYZPNP * this.renderBlocks.field_147853_m * this.renderBlocks.field_147861_i + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.field_147853_m) * this.renderBlocks.field_147861_i + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.field_147853_m) * (1.0 - this.renderBlocks.field_147861_i));
            this.renderBlocks.field_147864_al = this.renderBlocks.func_147727_a(brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZNNN, this.renderBlocks.field_147853_m * (1.0 - this.renderBlocks.field_147859_h), this.renderBlocks.field_147853_m * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147853_m) * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147853_m) * (1.0 - this.renderBlocks.field_147859_h));
            this.renderBlocks.field_147874_am = this.renderBlocks.func_147727_a(brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZNNN, this.renderBlocks.field_147851_l * (1.0 - this.renderBlocks.field_147859_h), this.renderBlocks.field_147851_l * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147851_l) * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147851_l) * (1.0 - this.renderBlocks.field_147859_h));
            this.renderBlocks.field_147876_an = this.renderBlocks.func_147727_a(brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZNNN, this.renderBlocks.field_147851_l * (1.0 - this.renderBlocks.field_147861_i), this.renderBlocks.field_147851_l * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147851_l) * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147851_l) * (1.0 - this.renderBlocks.field_147861_i));
            this.renderBlocks.field_147870_ao = this.renderBlocks.func_147727_a(brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZNNN, this.renderBlocks.field_147853_m * (1.0 - this.renderBlocks.field_147861_i), this.renderBlocks.field_147853_m * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147853_m) * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147853_m) * (1.0 - this.renderBlocks.field_147861_i));
        }
        return this;
    }

    public LightingHelper setupLightingYPos(Block block, int x, int y, int z) {
        if (this.renderBlocks.field_147863_w) {
            int mixedBrightness;
            int yOffset = this.renderBlocks.field_147857_k < 0.9990234375 ? y : y + 1;
            this.brightness = mixedBrightness = block.func_149677_c(this.renderBlocks.field_147845_a, x, yOffset, z);
            float aoLightValue = this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I();
            this.renderBlocks.field_147880_aa = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, yOffset, z);
            this.renderBlocks.field_147885_ae = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, yOffset, z);
            this.renderBlocks.field_147878_ac = block.func_149677_c(this.renderBlocks.field_147845_a, x, yOffset, z - 1);
            this.renderBlocks.field_147887_af = block.func_149677_c(this.renderBlocks.field_147845_a, x, yOffset, z + 1);
            this.renderBlocks.field_147836_Z = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, yOffset, z - 1);
            this.renderBlocks.field_147879_ad = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, yOffset, z - 1);
            this.renderBlocks.field_147881_ab = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, yOffset, z + 1);
            this.renderBlocks.field_147882_ag = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, yOffset, z + 1);
            this.renderBlocks.field_147813_G = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I(), this.renderBlocks.field_147857_k);
            this.renderBlocks.field_147824_K = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I(), this.renderBlocks.field_147857_k);
            this.renderBlocks.field_147822_I = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I(), this.renderBlocks.field_147857_k);
            this.renderBlocks.field_147817_L = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I(), this.renderBlocks.field_147857_k);
            this.renderBlocks.field_147812_F = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z - 1).func_149685_I(), this.renderBlocks.field_147857_k);
            this.renderBlocks.field_147823_J = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z - 1).func_149685_I(), this.renderBlocks.field_147857_k);
            this.renderBlocks.field_147821_H = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z + 1).func_149685_I(), this.renderBlocks.field_147857_k);
            this.renderBlocks.field_147818_M = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z + 1).func_149685_I(), this.renderBlocks.field_147857_k);
            int brightnessMixedXYZPPP = this.renderBlocks.func_147778_a(this.renderBlocks.field_147887_af, this.renderBlocks.field_147882_ag, this.renderBlocks.field_147885_ae, mixedBrightness);
            int brightnessMixedXYZPPN = this.renderBlocks.func_147778_a(this.renderBlocks.field_147878_ac, this.renderBlocks.field_147885_ae, this.renderBlocks.field_147879_ad, mixedBrightness);
            int brightnessMixedXYZNPN = this.renderBlocks.func_147778_a(this.renderBlocks.field_147880_aa, this.renderBlocks.field_147836_Z, this.renderBlocks.field_147878_ac, mixedBrightness);
            int brightnessMixedXYZNPP = this.renderBlocks.func_147778_a(this.renderBlocks.field_147881_ab, this.renderBlocks.field_147880_aa, this.renderBlocks.field_147887_af, mixedBrightness);
            float aoMixedXYZPPP = (this.renderBlocks.field_147817_L + aoLightValue + this.renderBlocks.field_147818_M + this.renderBlocks.field_147824_K) / 4.0f;
            float aoMixedXYZPPN = (aoLightValue + this.renderBlocks.field_147822_I + this.renderBlocks.field_147824_K + this.renderBlocks.field_147823_J) / 4.0f;
            float aoMixedXYZNPN = (this.renderBlocks.field_147813_G + this.renderBlocks.field_147812_F + aoLightValue + this.renderBlocks.field_147822_I) / 4.0f;
            float aoMixedXYZNPP = (this.renderBlocks.field_147821_H + this.renderBlocks.field_147813_G + this.renderBlocks.field_147817_L + aoLightValue) / 4.0f;
            this.aoTopLeft = (float)((double)aoMixedXYZNPP * this.renderBlocks.field_147853_m * (1.0 - this.renderBlocks.field_147861_i) + (double)aoMixedXYZPPP * this.renderBlocks.field_147853_m * this.renderBlocks.field_147861_i + (double)aoMixedXYZPPN * (1.0 - this.renderBlocks.field_147853_m) * this.renderBlocks.field_147861_i + (double)aoMixedXYZNPN * (1.0 - this.renderBlocks.field_147853_m) * (1.0 - this.renderBlocks.field_147861_i));
            this.aoBottomLeft = (float)((double)aoMixedXYZNPP * this.renderBlocks.field_147851_l * (1.0 - this.renderBlocks.field_147861_i) + (double)aoMixedXYZPPP * this.renderBlocks.field_147851_l * this.renderBlocks.field_147861_i + (double)aoMixedXYZPPN * (1.0 - this.renderBlocks.field_147851_l) * this.renderBlocks.field_147861_i + (double)aoMixedXYZNPN * (1.0 - this.renderBlocks.field_147851_l) * (1.0 - this.renderBlocks.field_147861_i));
            this.aoBottomRight = (float)((double)aoMixedXYZNPP * this.renderBlocks.field_147851_l * (1.0 - this.renderBlocks.field_147859_h) + (double)aoMixedXYZPPP * this.renderBlocks.field_147851_l * this.renderBlocks.field_147859_h + (double)aoMixedXYZPPN * (1.0 - this.renderBlocks.field_147851_l) * this.renderBlocks.field_147859_h + (double)aoMixedXYZNPN * (1.0 - this.renderBlocks.field_147851_l) * (1.0 - this.renderBlocks.field_147859_h));
            this.aoTopRight = (float)((double)aoMixedXYZNPP * this.renderBlocks.field_147853_m * (1.0 - this.renderBlocks.field_147859_h) + (double)aoMixedXYZPPP * this.renderBlocks.field_147853_m * this.renderBlocks.field_147859_h + (double)aoMixedXYZPPN * (1.0 - this.renderBlocks.field_147853_m) * this.renderBlocks.field_147859_h + (double)aoMixedXYZNPN * (1.0 - this.renderBlocks.field_147853_m) * (1.0 - this.renderBlocks.field_147859_h));
            this.renderBlocks.field_147864_al = this.renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZPPP, brightnessMixedXYZPPN, brightnessMixedXYZNPN, this.renderBlocks.field_147853_m * (1.0 - this.renderBlocks.field_147861_i), this.renderBlocks.field_147853_m * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147853_m) * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147853_m) * (1.0 - this.renderBlocks.field_147861_i));
            this.renderBlocks.field_147874_am = this.renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZPPP, brightnessMixedXYZPPN, brightnessMixedXYZNPN, this.renderBlocks.field_147851_l * (1.0 - this.renderBlocks.field_147861_i), this.renderBlocks.field_147851_l * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147851_l) * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147851_l) * (1.0 - this.renderBlocks.field_147861_i));
            this.renderBlocks.field_147876_an = this.renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZPPP, brightnessMixedXYZPPN, brightnessMixedXYZNPN, this.renderBlocks.field_147851_l * (1.0 - this.renderBlocks.field_147859_h), this.renderBlocks.field_147851_l * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147851_l) * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147851_l) * (1.0 - this.renderBlocks.field_147859_h));
            this.renderBlocks.field_147870_ao = this.renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZPPP, brightnessMixedXYZPPN, brightnessMixedXYZNPN, this.renderBlocks.field_147853_m * (1.0 - this.renderBlocks.field_147859_h), this.renderBlocks.field_147853_m * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147853_m) * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147853_m) * (1.0 - this.renderBlocks.field_147859_h));
        }
        return this;
    }

    public LightingHelper setupLightingZNeg(Block block, int x, int y, int z) {
        if (this.renderBlocks.field_147863_w) {
            int mixedBrightness;
            int zOffset = this.renderBlocks.field_147851_l > 9.765625E-4 ? z : z - 1;
            this.brightness = mixedBrightness = block.func_149677_c(this.renderBlocks.field_147845_a, x, y, zOffset);
            float ratio = (float)(1.0 - this.renderBlocks.field_147851_l);
            float aoLightValue = this.renderBlocks.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I();
            this.renderBlocks.field_147883_ah = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, y, zOffset);
            this.renderBlocks.field_147825_U = block.func_149677_c(this.renderBlocks.field_147845_a, x, y - 1, zOffset);
            this.renderBlocks.field_147878_ac = block.func_149677_c(this.renderBlocks.field_147845_a, x, y + 1, zOffset);
            this.renderBlocks.field_147866_ai = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, y, zOffset);
            this.renderBlocks.field_147832_R = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, y - 1, zOffset);
            this.renderBlocks.field_147836_Z = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, y + 1, zOffset);
            this.renderBlocks.field_147827_W = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, y - 1, zOffset);
            this.renderBlocks.field_147879_ad = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, y + 1, zOffset);
            this.renderBlocks.field_147819_N = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I(), ratio);
            this.renderBlocks.field_147814_A = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I(), ratio);
            this.renderBlocks.field_147822_I = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I(), ratio);
            this.renderBlocks.field_147820_O = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I(), ratio);
            this.renderBlocks.field_147888_x = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z).func_149685_I(), ratio);
            this.renderBlocks.field_147812_F = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z).func_149685_I(), ratio);
            this.renderBlocks.field_147816_C = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z).func_149685_I(), ratio);
            this.renderBlocks.field_147823_J = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z).func_149685_I(), ratio);
            int brightnessMixedXYZPPN = this.renderBlocks.func_147778_a(this.renderBlocks.field_147878_ac, this.renderBlocks.field_147866_ai, this.renderBlocks.field_147879_ad, mixedBrightness);
            int brightnessMixedXYZPNN = this.renderBlocks.func_147778_a(this.renderBlocks.field_147825_U, this.renderBlocks.field_147827_W, this.renderBlocks.field_147866_ai, mixedBrightness);
            int brightnessMixedXYZNNN = this.renderBlocks.func_147778_a(this.renderBlocks.field_147832_R, this.renderBlocks.field_147883_ah, this.renderBlocks.field_147825_U, mixedBrightness);
            int brightnessMixedXYZNPN = this.renderBlocks.func_147778_a(this.renderBlocks.field_147883_ah, this.renderBlocks.field_147836_Z, this.renderBlocks.field_147878_ac, mixedBrightness);
            float aoMixedXYZPPN = (aoLightValue + this.renderBlocks.field_147822_I + this.renderBlocks.field_147820_O + this.renderBlocks.field_147823_J) / 4.0f;
            float aoMixedXYZPNN = (this.renderBlocks.field_147814_A + aoLightValue + this.renderBlocks.field_147816_C + this.renderBlocks.field_147820_O) / 4.0f;
            float aoMixedXYZNNN = (this.renderBlocks.field_147888_x + this.renderBlocks.field_147819_N + this.renderBlocks.field_147814_A + aoLightValue) / 4.0f;
            float aoMixedXYZNPN = (this.renderBlocks.field_147819_N + this.renderBlocks.field_147812_F + aoLightValue + this.renderBlocks.field_147822_I) / 4.0f;
            this.aoTopLeft = (float)((double)aoMixedXYZNPN * this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147859_h) + (double)aoMixedXYZPPN * this.renderBlocks.field_147857_k * this.renderBlocks.field_147859_h + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147859_h + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147859_h));
            this.aoBottomLeft = (float)((double)aoMixedXYZNPN * this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147861_i) + (double)aoMixedXYZPPN * this.renderBlocks.field_147857_k * this.renderBlocks.field_147861_i + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147861_i + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147861_i));
            this.aoBottomRight = (float)((double)aoMixedXYZNPN * this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147861_i) + (double)aoMixedXYZPPN * this.renderBlocks.field_147855_j * this.renderBlocks.field_147861_i + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147861_i + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147861_i));
            this.aoTopRight = (float)((double)aoMixedXYZNPN * this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147859_h) + (double)aoMixedXYZPPN * this.renderBlocks.field_147855_j * this.renderBlocks.field_147859_h + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147859_h + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147859_h));
            this.renderBlocks.field_147864_al = this.renderBlocks.func_147727_a(brightnessMixedXYZNPN, brightnessMixedXYZPPN, brightnessMixedXYZPNN, brightnessMixedXYZNNN, this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147859_h), this.renderBlocks.field_147857_k * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147859_h));
            this.renderBlocks.field_147874_am = this.renderBlocks.func_147727_a(brightnessMixedXYZNPN, brightnessMixedXYZPPN, brightnessMixedXYZPNN, brightnessMixedXYZNNN, this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147861_i), this.renderBlocks.field_147857_k * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147861_i));
            this.renderBlocks.field_147876_an = this.renderBlocks.func_147727_a(brightnessMixedXYZNPN, brightnessMixedXYZPPN, brightnessMixedXYZPNN, brightnessMixedXYZNNN, this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147861_i), this.renderBlocks.field_147855_j * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147861_i));
            this.renderBlocks.field_147870_ao = this.renderBlocks.func_147727_a(brightnessMixedXYZNPN, brightnessMixedXYZPPN, brightnessMixedXYZPNN, brightnessMixedXYZNNN, this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147859_h), this.renderBlocks.field_147855_j * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147859_h));
        }
        return this;
    }

    public LightingHelper setupLightingZPos(Block block, int x, int y, int z) {
        if (this.renderBlocks.field_147863_w) {
            int mixedBrightness;
            int zOffset = this.renderBlocks.field_147853_m < 0.9990234375 ? z : z + 1;
            this.brightness = mixedBrightness = block.func_149677_c(this.renderBlocks.field_147845_a, x, y, zOffset);
            float aoLightValue = this.renderBlocks.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I();
            this.renderBlocks.field_147868_aj = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, y, zOffset);
            this.renderBlocks.field_147862_ak = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, y, zOffset);
            this.renderBlocks.field_147828_V = block.func_149677_c(this.renderBlocks.field_147845_a, x, y - 1, zOffset);
            this.renderBlocks.field_147887_af = block.func_149677_c(this.renderBlocks.field_147845_a, x, y + 1, zOffset);
            this.renderBlocks.field_147826_T = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, y - 1, zOffset);
            this.renderBlocks.field_147881_ab = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, y + 1, zOffset);
            this.renderBlocks.field_147834_Y = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, y - 1, zOffset);
            this.renderBlocks.field_147882_ag = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, y + 1, zOffset);
            this.renderBlocks.field_147830_P = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I(), this.renderBlocks.field_147853_m);
            this.renderBlocks.field_147829_Q = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I(), this.renderBlocks.field_147853_m);
            this.renderBlocks.field_147815_B = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I(), this.renderBlocks.field_147853_m);
            this.renderBlocks.field_147817_L = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I(), this.renderBlocks.field_147853_m);
            this.renderBlocks.field_147884_z = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z).func_149685_I(), this.renderBlocks.field_147853_m);
            this.renderBlocks.field_147821_H = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z).func_149685_I(), this.renderBlocks.field_147853_m);
            this.renderBlocks.field_147811_E = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z).func_149685_I(), this.renderBlocks.field_147853_m);
            this.renderBlocks.field_147818_M = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z).func_149685_I(), this.renderBlocks.field_147853_m);
            int brightnessMixedXYZNPP = this.renderBlocks.func_147778_a(this.renderBlocks.field_147868_aj, this.renderBlocks.field_147881_ab, this.renderBlocks.field_147887_af, mixedBrightness);
            int brightnessMixedXYZNNP = this.renderBlocks.func_147778_a(this.renderBlocks.field_147826_T, this.renderBlocks.field_147868_aj, this.renderBlocks.field_147828_V, mixedBrightness);
            int brightnessMixedXYZPNP = this.renderBlocks.func_147778_a(this.renderBlocks.field_147828_V, this.renderBlocks.field_147834_Y, this.renderBlocks.field_147862_ak, mixedBrightness);
            int brightnessMixedXYZPPP = this.renderBlocks.func_147778_a(this.renderBlocks.field_147887_af, this.renderBlocks.field_147862_ak, this.renderBlocks.field_147882_ag, mixedBrightness);
            float aoMixedXYZNPP = (this.renderBlocks.field_147830_P + this.renderBlocks.field_147821_H + aoLightValue + this.renderBlocks.field_147817_L) / 4.0f;
            float aoMixedXYZNNP = (this.renderBlocks.field_147884_z + this.renderBlocks.field_147830_P + this.renderBlocks.field_147815_B + aoLightValue) / 4.0f;
            float aoMixedXYZPNP = (this.renderBlocks.field_147815_B + aoLightValue + this.renderBlocks.field_147811_E + this.renderBlocks.field_147829_Q) / 4.0f;
            float aoMixedXYZPPP = (aoLightValue + this.renderBlocks.field_147817_L + this.renderBlocks.field_147829_Q + this.renderBlocks.field_147818_M) / 4.0f;
            this.aoTopLeft = (float)((double)aoMixedXYZNPP * this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147859_h) + (double)aoMixedXYZPPP * this.renderBlocks.field_147857_k * this.renderBlocks.field_147859_h + (double)aoMixedXYZPNP * (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147859_h + (double)aoMixedXYZNNP * (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147859_h));
            this.aoBottomLeft = (float)((double)aoMixedXYZNPP * this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147859_h) + (double)aoMixedXYZPPP * this.renderBlocks.field_147855_j * this.renderBlocks.field_147859_h + (double)aoMixedXYZPNP * (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147859_h + (double)aoMixedXYZNNP * (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147859_h));
            this.aoBottomRight = (float)((double)aoMixedXYZNPP * this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147861_i) + (double)aoMixedXYZPPP * this.renderBlocks.field_147855_j * this.renderBlocks.field_147861_i + (double)aoMixedXYZPNP * (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147861_i + (double)aoMixedXYZNNP * (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147861_i));
            this.aoTopRight = (float)((double)aoMixedXYZNPP * this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147861_i) + (double)aoMixedXYZPPP * this.renderBlocks.field_147857_k * this.renderBlocks.field_147861_i + (double)aoMixedXYZPNP * (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147861_i + (double)aoMixedXYZNNP * (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147861_i));
            this.renderBlocks.field_147864_al = this.renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPPP, this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147859_h), (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147859_h), (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147859_h, this.renderBlocks.field_147857_k * this.renderBlocks.field_147859_h);
            this.renderBlocks.field_147874_am = this.renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPPP, this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147859_h), (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147859_h), (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147859_h, this.renderBlocks.field_147855_j * this.renderBlocks.field_147859_h);
            this.renderBlocks.field_147876_an = this.renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPPP, this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147861_i), (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147861_i), (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147861_i, this.renderBlocks.field_147855_j * this.renderBlocks.field_147861_i);
            this.renderBlocks.field_147870_ao = this.renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPPP, this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147861_i), (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147861_i), (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147861_i, this.renderBlocks.field_147857_k * this.renderBlocks.field_147861_i);
        }
        return this;
    }
}

