/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.alignment.enumerable.Flip;
import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import cpw.mods.fml.common.network.NetworkRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

public abstract class GT_MetaTileEntity_EnhancedMultiBlockBase<T extends GT_MetaTileEntity_EnhancedMultiBlockBase<T>>
extends GT_MetaTileEntity_MultiBlockBase
implements IAlignment,
IConstructable {
    private static final AtomicReferenceArray<GT_Multiblock_Tooltip_Builder> tooltips = new AtomicReferenceArray(GregTech_API.METATILEENTITIES.length);
    private ExtendedFacing mExtendedFacing = ExtendedFacing.DEFAULT;
    private IAlignmentLimits mLimits = this.getInitialAlignmentLimits();

    protected GT_MetaTileEntity_EnhancedMultiBlockBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    protected GT_MetaTileEntity_EnhancedMultiBlockBase(String aName) {
        super(aName);
    }

    public ExtendedFacing getExtendedFacing() {
        return this.mExtendedFacing;
    }

    public void setExtendedFacing(ExtendedFacing newExtendedFacing) {
        if (this.mExtendedFacing != newExtendedFacing) {
            if (this.mMachine) {
                this.stopMachine();
            }
            this.mExtendedFacing = newExtendedFacing;
            IGregTechTileEntity base = this.getBaseMetaTileEntity();
            this.mMachine = false;
            this.mUpdate = 100;
            if (this.getBaseMetaTileEntity().isServerSide()) {
                StructureLibAPI.sendAlignment((IAlignmentProvider)((IAlignmentProvider)base), (NetworkRegistry.TargetPoint)new NetworkRegistry.TargetPoint(base.getWorld().field_73011_w.field_76574_g, (double)base.getXCoord(), (double)base.getYCoord(), (double)base.getZCoord(), 512.0));
            } else {
                base.issueTextureUpdate();
            }
        }
    }

    @Override
    public final boolean isFacingValid(byte aFacing) {
        return this.canSetToDirectionAny(ForgeDirection.getOrientation((int)aFacing));
    }

    @Override
    public boolean onWrenchRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aWrenchingSide != this.getBaseMetaTileEntity().getFrontFacing()) {
            return super.onWrenchRightClick(aSide, aWrenchingSide, aPlayer, aX, aY, aZ);
        }
        if (aPlayer.func_70093_af()) {
            this.toolSetFlip(this.getFlip().isHorizontallyFlipped() ? Flip.NONE : Flip.HORIZONTAL);
        } else {
            this.toolSetRotation(null);
        }
        return true;
    }

    @Override
    public void onFacingChange() {
        this.toolSetDirection(ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getFrontFacing()));
    }

    public IAlignmentLimits getAlignmentLimits() {
        return this.mLimits;
    }

    protected void setAlignmentLimits(IAlignmentLimits mLimits) {
        this.mLimits = mLimits;
    }

    public abstract IStructureDefinition<T> getStructureDefinition();

    protected abstract GT_Multiblock_Tooltip_Builder createTooltip();

    @Override
    public String[] getDescription() {
        if (Keyboard.isKeyDown((int)42)) {
            return this.getTooltip().getStructureInformation();
        }
        return this.getTooltip().getInformation();
    }

    protected GT_Multiblock_Tooltip_Builder getTooltip() {
        int tId = this.getBaseMetaTileEntity().getMetaTileID();
        GT_Multiblock_Tooltip_Builder tooltip = tooltips.get(tId);
        if (tooltip == null) {
            tooltip = this.createTooltip();
            tooltips.set(tId, tooltip);
        }
        return tooltip;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return this.getTooltip().getStructureHint();
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> !f.isVerticallyFliped();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("eRotation", (byte)this.mExtendedFacing.getRotation().getIndex());
        aNBT.func_74774_a("eFlip", (byte)this.mExtendedFacing.getFlip().getIndex());
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mExtendedFacing = ExtendedFacing.of((ForgeDirection)ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getFrontFacing()), (Rotation)Rotation.byIndex((int)aNBT.func_74771_c("eRotation")), (Flip)Flip.byIndex((int)aNBT.func_74771_c("eFlip")));
    }

    private IStructureDefinition<GT_MetaTileEntity_EnhancedMultiBlockBase<T>> getCastedStructureDefinition() {
        return this.getStructureDefinition();
    }

    protected final boolean checkPiece(String piece, int horizontalOffset, int verticalOffset, int depthOffset) {
        IGregTechTileEntity tTile = this.getBaseMetaTileEntity();
        return this.getCastedStructureDefinition().check((Object)this, piece, tTile.getWorld(), this.getExtendedFacing(), tTile.getXCoord(), (int)tTile.getYCoord(), tTile.getZCoord(), horizontalOffset, verticalOffset, depthOffset, !this.mMachine);
    }

    protected final boolean buildPiece(String piece, ItemStack trigger, boolean hintOnly, int horizontalOffset, int verticalOffset, int depthOffset) {
        IGregTechTileEntity tTile = this.getBaseMetaTileEntity();
        return this.getCastedStructureDefinition().buildOrHints((Object)this, trigger, piece, tTile.getWorld(), this.getExtendedFacing(), tTile.getXCoord(), (int)tTile.getYCoord(), tTile.getZCoord(), horizontalOffset, verticalOffset, depthOffset, hintOnly);
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (aBaseMetaTileEntity.isClientSide()) {
            StructureLibAPI.queryAlignment((IAlignmentProvider)((IAlignmentProvider)aBaseMetaTileEntity));
        }
    }
}

