/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class GT_MetaTileEntity_Buffer
extends GT_MetaTileEntity_TieredMachineBlock {
    private static final int OUTPUT_INDEX = 0;
    private static final int ARROW_RIGHT_INDEX = 1;
    private static final int ARROW_DOWN_INDEX = 2;
    private static final int ARROW_LEFT_INDEX = 3;
    private static final int ARROW_UP_INDEX = 4;
    private static final int FRONT_INDEX = 5;
    public int mMaxStackSize = 64;
    public static int MAX = 8;
    public boolean bOutput = false;
    public boolean bRedstoneIfFull = false;
    public boolean bInvert = false;
    public boolean bStockingMode = false;
    public boolean bSortStacks = false;
    public int mSuccess = 0;
    public int mTargetStackSize = 0;

    public GT_MetaTileEntity_Buffer(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String aDescription) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, new ITexture[0]);
    }

    public GT_MetaTileEntity_Buffer(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String[] aDescription) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, new ITexture[0]);
    }

    public GT_MetaTileEntity_Buffer(String aName, int aTier, int aInvSlotCount, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Buffer(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[ForgeDirection.VALID_DIRECTIONS.length][17][];
        ITexture tIcon = this.getOverlayIcon();
        ITexture tOut = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT);
        ITexture tUp = TextureFactory.of(TextureFactory.of(Textures.BlockIcons.ARROW_UP), TextureFactory.builder().addIcon(Textures.BlockIcons.ARROW_UP_GLOW).glow().build());
        ITexture tDown = TextureFactory.of(TextureFactory.of(Textures.BlockIcons.ARROW_DOWN), TextureFactory.builder().addIcon(Textures.BlockIcons.ARROW_DOWN_GLOW).glow().build());
        ITexture tLeft = TextureFactory.of(TextureFactory.of(Textures.BlockIcons.ARROW_LEFT), TextureFactory.builder().addIcon(Textures.BlockIcons.ARROW_LEFT_GLOW).glow().build());
        ITexture tRight = TextureFactory.of(TextureFactory.of(Textures.BlockIcons.ARROW_RIGHT), TextureFactory.builder().addIcon(Textures.BlockIcons.ARROW_RIGHT_GLOW).glow().build());
        for (int i = 0; i < rTextures[0].length; ++i) {
            rTextures[0][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], tOut};
            rTextures[1][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], tRight, tIcon};
            rTextures[2][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], tDown, tIcon};
            rTextures[3][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], tLeft, tIcon};
            rTextures[4][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], tUp, tIcon};
            rTextures[5][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], tIcon};
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        int colorIndex = aColorIndex + 1;
        ForgeDirection side = ForgeDirection.VALID_DIRECTIONS[aSide];
        ForgeDirection facing = ForgeDirection.VALID_DIRECTIONS[aFacing];
        if (side == facing) {
            return this.mTextures[5][colorIndex];
        }
        if (ForgeDirection.OPPOSITES[aSide] == aFacing) {
            return this.mTextures[0][colorIndex];
        }
        switch (facing) {
            case DOWN: {
                return this.mTextures[4][colorIndex];
            }
            case UP: {
                return this.mTextures[2][colorIndex];
            }
            case NORTH: {
                switch (side) {
                    case DOWN: 
                    case UP: {
                        return this.mTextures[2][colorIndex];
                    }
                    case WEST: {
                        return this.mTextures[1][colorIndex];
                    }
                    case EAST: {
                        return this.mTextures[3][colorIndex];
                    }
                }
                break;
            }
            case SOUTH: {
                switch (side) {
                    case DOWN: 
                    case UP: {
                        return this.mTextures[4][colorIndex];
                    }
                    case WEST: {
                        return this.mTextures[3][colorIndex];
                    }
                    case EAST: {
                        return this.mTextures[1][colorIndex];
                    }
                }
                break;
            }
            case WEST: {
                switch (side) {
                    case UP: 
                    case SOUTH: {
                        return this.mTextures[1][colorIndex];
                    }
                    case DOWN: 
                    case NORTH: {
                        return this.mTextures[3][colorIndex];
                    }
                }
                break;
            }
            case EAST: {
                switch (side) {
                    case UP: 
                    case SOUTH: {
                        return this.mTextures[3][colorIndex];
                    }
                    case DOWN: 
                    case NORTH: {
                        return this.mTextures[1][colorIndex];
                    }
                }
                break;
            }
        }
        return this.mTextures[5][colorIndex];
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex < this.mInventory.length - 1;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    @Override
    public boolean isInputFacing(byte aSide) {
        return !this.isOutputFacing(aSide);
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return this.getBaseMetaTileEntity().getBackFacing() == aSide;
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return 512L;
    }

    @Override
    public long maxEUStore() {
        return 512L + GT_Values.V[this.mTier] * 50L;
    }

    @Override
    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    @Override
    public long maxEUOutput() {
        return this.bOutput ? GT_Values.V[this.mTier] : 0L;
    }

    @Override
    public long maxAmperesIn() {
        return 2L;
    }

    @Override
    public long maxAmperesOut() {
        return 2L;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public abstract ITexture getOverlayIcon();

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("bInvert", this.bInvert);
        aNBT.func_74757_a("bOutput", this.bOutput);
        aNBT.func_74757_a("bRedstoneIfFull", this.bRedstoneIfFull);
        aNBT.func_74757_a("bStockingMode", this.bStockingMode);
        aNBT.func_74768_a("mTargetStackSize", this.mTargetStackSize);
        aNBT.func_74757_a("bSortStacks", this.bSortStacks);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.bInvert = aNBT.func_74767_n("bInvert");
        this.bOutput = aNBT.func_74767_n("bOutput");
        this.bRedstoneIfFull = aNBT.func_74767_n("bRedstoneIfFull");
        this.bSortStacks = aNBT.func_74767_n("bSortStacks");
        if (aNBT.func_74764_b("bStockingMode")) {
            this.bStockingMode = aNBT.func_74767_n("bStockingMode");
        }
        if (aNBT.func_74764_b("bSortStacks")) {
            this.bSortStacks = aNBT.func_74767_n("bSortStacks");
        }
        this.mTargetStackSize = aNBT.func_74762_e("mTargetStackSize");
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        super.setItemNBT(aNBT);
        if (this.mTargetStackSize > 0) {
            aNBT.func_74768_a("mTargetStackSize", this.mTargetStackSize);
        }
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aSide == this.getBaseMetaTileEntity().getBackFacing()) {
            this.mTargetStackSize = (byte)((this.mTargetStackSize + (aPlayer.func_70093_af() ? -1 : 1)) % 65);
            if (this.mTargetStackSize < 0) {
                this.mTargetStackSize = this.mMaxStackSize;
            }
            if (this.mTargetStackSize == 0) {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("098", "Do not regulate Item Stack Size"));
            } else {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("099", "Regulate Item Stack Size to: ") + this.mTargetStackSize);
            }
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (aBaseMetaTileEntity.isAllowedToWork() && aBaseMetaTileEntity.isServerSide() && (aBaseMetaTileEntity.hasWorkJustBeenEnabled() || aBaseMetaTileEntity.hasInventoryBeenModified() || aTimer % 200L == 0L || this.mSuccess > 0)) {
            byte b;
            --this.mSuccess;
            this.updateSlots();
            this.moveItems(aBaseMetaTileEntity, aTimer);
            for (b = 0; b < 6; b = (byte)(b + 1)) {
                aBaseMetaTileEntity.setInternalOutputRedstoneSignal(b, this.bInvert ? (byte)15 : 0);
            }
            if (this.bRedstoneIfFull) {
                for (b = 0; b < 6; b = (byte)(b + 1)) {
                    aBaseMetaTileEntity.setInternalOutputRedstoneSignal(b, this.bInvert ? (byte)0 : 15);
                }
                for (int i = 0; i < this.mInventory.length; ++i) {
                    if (!this.isValidSlot(i) || this.mInventory[i] != null) continue;
                    for (byte b2 = 0; b2 < 6; b2 = (byte)(b2 + 1)) {
                        aBaseMetaTileEntity.setInternalOutputRedstoneSignal(b2, this.bInvert ? (byte)15 : 0);
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        for (byte b = 0; b < 6; b = (byte)(b + 1)) {
            aBaseMetaTileEntity.setInternalOutputRedstoneSignal(b, (byte)0);
        }
    }

    protected void moveItems(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        this.moveItems(aBaseMetaTileEntity, aTimer, 1);
    }

    protected void moveItems(IGregTechTileEntity aBaseMetaTileEntity, long aTimer, int stacks) {
        int tCost = this.bStockingMode ? GT_Utility.moveMultipleItemStacks(aBaseMetaTileEntity, aBaseMetaTileEntity.getTileEntityAtSide(aBaseMetaTileEntity.getBackFacing()), aBaseMetaTileEntity.getBackFacing(), aBaseMetaTileEntity.getFrontFacing(), null, false, (byte)(this.mTargetStackSize == 0 ? 64 : (byte)this.mTargetStackSize), this.mTargetStackSize == 0 ? (byte)1 : (byte)this.mTargetStackSize, (byte)64, (byte)1, stacks) : GT_Utility.moveMultipleItemStacks(aBaseMetaTileEntity, aBaseMetaTileEntity.getTileEntityAtSide(aBaseMetaTileEntity.getBackFacing()), aBaseMetaTileEntity.getBackFacing(), aBaseMetaTileEntity.getFrontFacing(), null, false, (byte)64, (byte)1, (byte)(this.mTargetStackSize == 0 ? 64 : (byte)this.mTargetStackSize), this.mTargetStackSize == 0 ? (byte)1 : (byte)this.mTargetStackSize, stacks);
        if (tCost > 0 || aBaseMetaTileEntity.hasInventoryBeenModified()) {
            this.mSuccess = 50;
        }
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return true;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide != aBaseMetaTileEntity.getBackFacing();
    }

    @Override
    public boolean allowGeneralRedstoneOutput() {
        return true;
    }

    public void updateSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
            this.mInventory[i] = null;
        }
        if (this.bSortStacks) {
            this.fillStacksIntoFirstSlots();
        }
    }

    protected void fillStacksIntoFirstSlots() {
        for (int i = 0; i < this.mInventory.length - 1; ++i) {
            if (!this.isValidSlot(i)) continue;
            for (int j = i + 1; j < this.mInventory.length; ++j) {
                if (!this.isValidSlot(j) || this.mInventory[j] == null || this.mInventory[i] != null && !GT_Utility.areStacksEqual(this.mInventory[i], this.mInventory[j])) continue;
                GT_Utility.moveStackFromSlotAToSlotB((IInventory)this.getBaseMetaTileEntity(), (IInventory)this.getBaseMetaTileEntity(), j, i, (byte)64, (byte)1, (byte)64, (byte)1);
            }
        }
    }

    @Override
    public boolean onSolderingToolRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            this.bSortStacks = !this.bSortStacks;
            GT_Utility.sendChatToPlayer(aPlayer, this.trans("200", "Sort mode: " + (this.bSortStacks ? "Enabled" : "Disabled")));
            return true;
        }
        return super.onSolderingToolRightClick(aSide, aWrenchingSide, aPlayer, aX, aY, aZ);
    }
}

