/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.metatileentity.IConnectable;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IColoredTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.GT_Client;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public abstract class MetaPipeEntity
implements IMetaTileEntity,
IConnectable {
    public final ItemStack[] mInventory;
    public byte mConnections = 0;
    protected boolean mCheckConnections = false;
    public String mName;
    public boolean doTickProfilingInThisTick = true;
    private IGregTechTileEntity mBaseMetaTileEntity;

    public MetaPipeEntity(int aID, String aBasicName, String aRegionalName, int aInvSlotCount) {
        this(aID, aBasicName, aRegionalName, aInvSlotCount, true);
    }

    public MetaPipeEntity(int aID, String aBasicName, String aRegionalName, int aInvSlotCount, boolean aAddInfo) {
        if (GregTech_API.sPostloadStarted || !GregTech_API.sPreloadStarted) {
            throw new IllegalAccessError("This Constructor has to be called in the load Phase");
        }
        if (GregTech_API.METATILEENTITIES[aID] != null) {
            throw new IllegalArgumentException("MetaMachine-Slot Nr. " + aID + " is already occupied!");
        }
        GregTech_API.METATILEENTITIES[aID] = this;
        this.mName = aBasicName.replaceAll(" ", "_").toLowerCase(Locale.ENGLISH);
        this.setBaseMetaTileEntity(new BaseMetaPipeEntity());
        this.getBaseMetaTileEntity().setMetaTileID((short)aID);
        GT_LanguageManager.addStringLocalization("gt.blockmachines." + this.mName + ".name", aRegionalName);
        this.mInventory = new ItemStack[aInvSlotCount];
        if (aAddInfo && GT_Values.GT.isClientSide()) {
            this.addInfo(aID);
        }
    }

    protected final void addInfo(int aID) {
        if (!GT_Values.GT.isClientSide()) {
            return;
        }
        ItemStack tStack = new ItemStack(GregTech_API.sBlockMachines, 1, aID);
        tStack.func_77973_b().func_77624_a(tStack, null, new ArrayList(), true);
    }

    public MetaPipeEntity(String aName, int aInvSlotCount) {
        this.mInventory = new ItemStack[aInvSlotCount];
        this.mName = aName;
    }

    public abstract float getThickNess();

    public abstract boolean renderInside(byte var1);

    public boolean isDisplaySecondaryDescription() {
        return false;
    }

    @Override
    public IGregTechTileEntity getBaseMetaTileEntity() {
        return this.mBaseMetaTileEntity;
    }

    @Override
    public void setBaseMetaTileEntity(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.mBaseMetaTileEntity != null && aBaseMetaTileEntity == null) {
            this.mBaseMetaTileEntity.getMetaTileEntity().inValidate();
            this.mBaseMetaTileEntity.setMetaTileEntity(null);
        }
        this.mBaseMetaTileEntity = aBaseMetaTileEntity;
        if (this.mBaseMetaTileEntity != null) {
            this.mBaseMetaTileEntity.setMetaTileEntity(this);
        }
    }

    @Override
    public ItemStack getStackForm(long aAmount) {
        return new ItemStack(GregTech_API.sBlockMachines, (int)aAmount, this.getBaseMetaTileEntity().getMetaTileID());
    }

    public boolean isCoverOnSide(BaseMetaPipeEntity aPipe, EntityLivingBase aEntity) {
        boolean tCovered;
        byte aSide = 6;
        double difference = aEntity.field_70163_u - (double)aPipe.field_145848_d;
        if (difference > 0.6 && difference < 0.99) {
            aSide = 1;
        }
        if (difference < -1.5 && difference > -1.99) {
            aSide = 0;
        }
        if ((difference = aEntity.field_70161_v - (double)aPipe.field_145849_e) < -0.05 && difference > -0.4) {
            aSide = 2;
        }
        if (difference > 1.05 && difference < 1.4) {
            aSide = 3;
        }
        if ((difference = aEntity.field_70165_t - (double)aPipe.field_145851_c) < -0.05 && difference > -0.4) {
            aSide = 4;
        }
        if (difference > 1.05 && difference < 1.4) {
            aSide = 5;
        }
        boolean bl = tCovered = aSide < 6 && this.mBaseMetaTileEntity.getCoverIDAtSide(aSide) > 0;
        if (this.isConnectedAtSide(aSide)) {
            tCovered = true;
        }
        return tCovered;
    }

    @Override
    public void onServerStart() {
    }

    @Override
    public void onWorldSave(File aSaveDirectory) {
    }

    @Override
    public void onWorldLoad(File aSaveDirectory) {
    }

    @Override
    public void onConfigLoad(GT_Config aConfig) {
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
    }

    @Override
    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aCoverID) {
        return true;
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
    }

    @Override
    public boolean onWrenchRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return false;
    }

    @Override
    public boolean onWireCutterRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return false;
    }

    @Override
    public boolean onSolderingToolRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return false;
    }

    @Override
    public void onExplosion() {
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isClientSide() && GT_Client.changeDetected == 4) {
            aBaseMetaTileEntity.issueTextureUpdate();
        }
    }

    @Override
    public void inValidate() {
    }

    @Override
    public void onRemoval() {
    }

    @Override
    public void initDefaultModes(NBTTagCompound aNBT) {
    }

    public void onOpenGUI() {
    }

    public void onCloseGUI() {
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        return false;
    }

    @Override
    public void onLeftclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
    }

    @Override
    public void onValueUpdate(byte aValue) {
    }

    @Override
    public byte getUpdateData() {
        return 0;
    }

    @Override
    public void doSound(byte aIndex, double aX, double aY, double aZ) {
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
    }

    @Override
    public void stopSoundLoop(byte aValue, double aX, double aY, double aZ) {
    }

    @Override
    public final void sendSound(byte aIndex) {
        if (!this.getBaseMetaTileEntity().hasMufflerUpgrade()) {
            this.getBaseMetaTileEntity().sendBlockEvent((byte)4, aIndex);
        }
    }

    @Override
    public final void sendLoopStart(byte aIndex) {
        if (!this.getBaseMetaTileEntity().hasMufflerUpgrade()) {
            this.getBaseMetaTileEntity().sendBlockEvent((byte)5, aIndex);
        }
    }

    @Override
    public final void sendLoopEnd(byte aIndex) {
        if (!this.getBaseMetaTileEntity().hasMufflerUpgrade()) {
            this.getBaseMetaTileEntity().sendBlockEvent((byte)6, aIndex);
        }
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return false;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public boolean setStackToZeroInsteadOfNull(int aIndex) {
        return false;
    }

    @Override
    public ArrayList<String> getSpecialDebugInfo(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, int aLogLevel, ArrayList<String> aList) {
        return aList;
    }

    @Override
    public boolean isLiquidInput(byte aSide) {
        return false;
    }

    @Override
    public boolean isLiquidOutput(byte aSide) {
        return false;
    }

    public FluidStack getFluid() {
        return null;
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public int getTankPressure() {
        return 0;
    }

    public int getCapacity() {
        return 0;
    }

    public int getProgresstime() {
        return 0;
    }

    public int maxProgresstime() {
        return 0;
    }

    public int increaseProgress(int aProgress) {
        return 0;
    }

    @Override
    public void onMachineBlockUpdate() {
    }

    @Override
    public void receiveClientEvent(byte aEventID, byte aValue) {
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public byte getComparatorValue(byte aSide) {
        return 0;
    }

    @Override
    public boolean acceptsRotationalEnergy(byte aSide) {
        return false;
    }

    @Override
    public boolean injectRotationalEnergy(byte aSide, long aSpeed, long aEnergy) {
        return false;
    }

    @Override
    public String getSpecialVoltageToolTip() {
        return null;
    }

    @Override
    public boolean isGivingInformation() {
        return false;
    }

    @Override
    public String[] getInfoData() {
        return new String[0];
    }

    public boolean isDigitalChest() {
        return false;
    }

    public ItemStack[] getStoredItemData() {
        return null;
    }

    public void setItemCount(int aCount) {
    }

    public int getMaxItemCount() {
        return 0;
    }

    public int func_70302_i_() {
        return this.mInventory.length;
    }

    public ItemStack func_70301_a(int aIndex) {
        if (aIndex >= 0 && aIndex < this.mInventory.length) {
            return this.mInventory[aIndex];
        }
        return null;
    }

    public void func_70299_a(int aIndex, ItemStack aStack) {
        if (aIndex >= 0 && aIndex < this.mInventory.length) {
            this.mInventory[aIndex] = aStack;
        }
    }

    public String func_145825_b() {
        if (GregTech_API.METATILEENTITIES[this.getBaseMetaTileEntity().getMetaTileID()] != null) {
            return GregTech_API.METATILEENTITIES[this.getBaseMetaTileEntity().getMetaTileID()].getMetaName();
        }
        return "";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        return this.getBaseMetaTileEntity().isValidSlot(aIndex);
    }

    public ItemStack func_70298_a(int aIndex, int aAmount) {
        ItemStack tStack = this.func_70301_a(aIndex);
        ItemStack rStack = GT_Utility.copyOrNull(tStack);
        if (tStack != null) {
            if (tStack.field_77994_a <= aAmount) {
                if (this.setStackToZeroInsteadOfNull(aIndex)) {
                    tStack.field_77994_a = 0;
                } else {
                    this.func_70299_a(aIndex, null);
                }
            } else {
                rStack = tStack.func_77979_a(aAmount);
                if (tStack.field_77994_a == 0 && !this.setStackToZeroInsteadOfNull(aIndex)) {
                    this.func_70299_a(aIndex, null);
                }
            }
        }
        return rStack;
    }

    public int[] func_94128_d(int aSide) {
        ArrayList<Integer> tList = new ArrayList<Integer>();
        IGregTechTileEntity tTileEntity = this.getBaseMetaTileEntity();
        boolean tSkip = tTileEntity.getCoverBehaviorAtSide((byte)aSide).letsItemsIn((byte)aSide, tTileEntity.getCoverIDAtSide((byte)aSide), tTileEntity.getCoverDataAtSide((byte)aSide), -2, tTileEntity) || tTileEntity.getCoverBehaviorAtSide((byte)aSide).letsItemsOut((byte)aSide, tTileEntity.getCoverIDAtSide((byte)aSide), tTileEntity.getCoverDataAtSide((byte)aSide), -2, tTileEntity);
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.isValidSlot(i) || !tSkip && !tTileEntity.getCoverBehaviorAtSide((byte)aSide).letsItemsOut((byte)aSide, tTileEntity.getCoverIDAtSide((byte)aSide), tTileEntity.getCoverDataAtSide((byte)aSide), i, tTileEntity) && !tTileEntity.getCoverBehaviorAtSide((byte)aSide).letsItemsIn((byte)aSide, tTileEntity.getCoverIDAtSide((byte)aSide), tTileEntity.getCoverDataAtSide((byte)aSide), i, tTileEntity)) continue;
            tList.add(i);
        }
        int[] rArray = new int[tList.size()];
        for (int i = 0; i < rArray.length; ++i) {
            rArray[i] = (Integer)tList.get(i);
        }
        return rArray;
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int aSide) {
        return this.isValidSlot(aIndex) && aStack != null && aIndex < this.mInventory.length && (this.mInventory[aIndex] == null || GT_Utility.areStacksEqual(aStack, this.mInventory[aIndex])) && this.allowPutStack(this.getBaseMetaTileEntity(), aIndex, (byte)aSide, aStack);
    }

    public boolean func_102008_b(int aIndex, ItemStack aStack, int aSide) {
        return this.isValidSlot(aIndex) && aStack != null && aIndex < this.mInventory.length && this.allowPullStack(this.getBaseMetaTileEntity(), aIndex, (byte)aSide, aStack);
    }

    public boolean canFill(ForgeDirection aSide, Fluid aFluid) {
        return this.fill(aSide, new FluidStack(aFluid, 1), false) == 1;
    }

    public boolean canDrain(ForgeDirection aSide, Fluid aFluid) {
        return this.drain(aSide, new FluidStack(aFluid, 1), false) != null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection aSide) {
        if (this.getCapacity() <= 0 && !this.getBaseMetaTileEntity().hasSteamEngineUpgrade()) {
            return new FluidTankInfo[0];
        }
        return new FluidTankInfo[]{this.getInfo()};
    }

    public int fill_default(ForgeDirection aSide, FluidStack aFluid, boolean doFill) {
        return this.fill(aFluid, doFill);
    }

    public int fill(ForgeDirection aSide, FluidStack aFluid, boolean doFill) {
        return this.fill_default(aSide, aFluid, doFill);
    }

    public FluidStack drain(ForgeDirection aSide, FluidStack aFluid, boolean doDrain) {
        if (this.getFluid() != null && aFluid != null && this.getFluid().isFluidEqual(aFluid)) {
            return this.drain(aFluid.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection aSide, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public int getFluidAmount() {
        return 0;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    @Override
    public String getMetaName() {
        return this.mName;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    @Override
    public boolean doTickProfilingMessageDuringThisTick() {
        return this.doTickProfilingInThisTick;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    @Override
    public boolean connectsToItemPipe(byte aSide) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return null;
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return null;
    }

    @Override
    public float getExplosionResistance(byte aSide) {
        return 10.0f;
    }

    @Override
    public ItemStack[] getRealInventory() {
        return this.mInventory;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70296_d() {
    }

    @Override
    public void onColorChangeServer(byte aColor) {
        this.setCheckConnections();
    }

    @Override
    public void onColorChangeClient(byte aColor) {
    }

    public void setCheckConnections() {
        this.mCheckConnections = true;
    }

    public long injectEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        return 0L;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderInInventory(Block aBlock, int aMeta, RenderBlocks aRenderer) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderInWorld(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, RenderBlocks aRenderer) {
        return false;
    }

    @Override
    public void doExplosion(long aExplosionPower) {
        float tStrength = aExplosionPower < GT_Values.V[0] ? 1.0f : (aExplosionPower < GT_Values.V[1] ? 2.0f : (aExplosionPower < GT_Values.V[2] ? 3.0f : (aExplosionPower < GT_Values.V[3] ? 4.0f : (aExplosionPower < GT_Values.V[4] ? 5.0f : (aExplosionPower < GT_Values.V[4] * 2L ? 6.0f : (aExplosionPower < GT_Values.V[5] ? 7.0f : (aExplosionPower < GT_Values.V[6] ? 8.0f : (aExplosionPower < GT_Values.V[7] ? 9.0f : (aExplosionPower < GT_Values.V[8] ? 10.0f : (aExplosionPower < GT_Values.V[8] * 2L ? 11.0f : (aExplosionPower < GT_Values.V[9] ? 12.0f : (aExplosionPower < GT_Values.V[10] ? 13.0f : (aExplosionPower < GT_Values.V[11] ? 14.0f : (aExplosionPower < GT_Values.V[12] ? 15.0f : (aExplosionPower < GT_Values.V[12] * 2L ? 16.0f : (aExplosionPower < GT_Values.V[13] ? 17.0f : (aExplosionPower < GT_Values.V[14] ? 18.0f : (aExplosionPower < GT_Values.V[15] ? 19.0f : 20.0f))))))))))))))))));
        int tX = this.getBaseMetaTileEntity().getXCoord();
        short tY = this.getBaseMetaTileEntity().getYCoord();
        int tZ = this.getBaseMetaTileEntity().getZCoord();
        World tWorld = this.getBaseMetaTileEntity().getWorld();
        tWorld.func_147449_b(tX, (int)tY, tZ, Blocks.field_150350_a);
        if (GregTech_API.sMachineExplosions) {
            new WorldSpawnedEventBuilder.ExplosionEffectEventBuilder().setStrength(tStrength).setSmoking(true).setPosition((double)tX + 0.5, (double)tY + 0.5, (double)tZ + 0.5).setWorld(tWorld).run();
        }
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public void addCollisionBoxesToList(World aWorld, int aX, int aY, int aZ, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        AxisAlignedBB axisalignedbb1 = this.getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
        if (axisalignedbb1 != null && inputAABB.func_72326_a(axisalignedbb1)) {
            outputAABB.add(axisalignedbb1);
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        return AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1));
    }

    @Override
    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity collider) {
    }

    @Override
    public void onCreated(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
    }

    @Override
    public boolean allowGeneralRedstoneOutput() {
        return false;
    }

    @Override
    public boolean hasAlternativeModeText() {
        return false;
    }

    @Override
    public String getAlternativeModeText() {
        return "";
    }

    public String trans(String aKey, String aEnglish) {
        return GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_" + aKey, aEnglish, false);
    }

    private boolean connectableColor(TileEntity tTileEntity) {
        if (tTileEntity instanceof IColoredTileEntity && this.getBaseMetaTileEntity().getColorization() >= 0) {
            byte tColor = ((IColoredTileEntity)tTileEntity).getColorization();
            return tColor < 0 || tColor == this.getBaseMetaTileEntity().getColorization();
        }
        return true;
    }

    @Override
    public int connect(byte aSide) {
        if (aSide >= 6) {
            return 0;
        }
        byte tSide = GT_Utility.getOppositeSide(aSide);
        IGregTechTileEntity baseMetaTile = this.getBaseMetaTileEntity();
        if (baseMetaTile == null || !baseMetaTile.isServerSide()) {
            return 0;
        }
        GT_CoverBehavior coverBehavior = baseMetaTile.getCoverBehaviorAtSide(aSide);
        int coverId = baseMetaTile.getCoverIDAtSide(aSide);
        int coverData = baseMetaTile.getCoverDataAtSide(aSide);
        boolean alwaysLookConnected = coverBehavior.alwaysLookConnected(aSide, coverId, coverData, baseMetaTile);
        boolean letsIn = this.letsIn(coverBehavior, aSide, coverId, coverData, baseMetaTile);
        boolean letsOut = this.letsOut(coverBehavior, aSide, coverId, coverData, baseMetaTile);
        TileEntity tTileEntity = baseMetaTile.getTileEntityAtSide(aSide);
        if (!this.connectableColor(tTileEntity)) {
            return 0;
        }
        if (alwaysLookConnected || letsIn || letsOut) {
            IMetaTileEntity tPipe;
            IMetaTileEntity iMetaTileEntity = tPipe = tTileEntity instanceof IGregTechTileEntity ? ((IGregTechTileEntity)tTileEntity).getMetaTileEntity() : null;
            if (this.getClass().isInstance(tPipe) || tPipe != null && tPipe.getClass().isInstance(this)) {
                this.connectAtSide(aSide);
                if (!((MetaPipeEntity)tPipe).isConnectedAtSide(tSide)) {
                    ((MetaPipeEntity)tPipe).connect(tSide);
                }
                return 1;
            }
            if (this.getGT6StyleConnection() && baseMetaTile.getAirAtSide(aSide) || this.canConnect(aSide, tTileEntity)) {
                this.connectAtSide(aSide);
                return 1;
            }
            if (!baseMetaTile.getWorld().func_72863_F().func_73149_a(baseMetaTile.getOffsetX(aSide, 1) >> 4, baseMetaTile.getOffsetZ(aSide, 1) >> 4)) {
                return -1;
            }
        }
        return 0;
    }

    protected void checkConnections() {
        for (byte aSide = 0; aSide < 6; aSide = (byte)(aSide + 1)) {
            if (this.getGT6StyleConnection() && !this.isConnectedAtSide(aSide) || this.connect(aSide) != 0) continue;
            this.disconnect(aSide);
        }
        this.mCheckConnections = false;
    }

    private void connectAtSide(byte aSide) {
        this.mConnections = (byte)(this.mConnections | 1 << aSide);
    }

    @Override
    public void disconnect(byte aSide) {
        IMetaTileEntity tPipe;
        if (aSide >= 6) {
            return;
        }
        this.mConnections = (byte)(this.mConnections & ~(1 << aSide));
        byte tSide = GT_Utility.getOppositeSide(aSide);
        IGregTechTileEntity tTileEntity = this.getBaseMetaTileEntity().getIGregTechTileEntityAtSide(aSide);
        IMetaTileEntity iMetaTileEntity = tPipe = tTileEntity == null ? null : tTileEntity.getMetaTileEntity();
        if ((this.getClass().isInstance(tPipe) || tPipe != null && tPipe.getClass().isInstance(this)) && ((MetaPipeEntity)tPipe).isConnectedAtSide(tSide)) {
            ((MetaPipeEntity)tPipe).disconnect(tSide);
        }
    }

    @Override
    public boolean isConnectedAtSide(int aSide) {
        return (this.mConnections & 1 << aSide) != 0;
    }

    public boolean letsIn(GT_CoverBehavior coverBehavior, byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    public boolean letsOut(GT_CoverBehavior coverBehavior, byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    public boolean canConnect(byte aSide, TileEntity tTileEntity) {
        return false;
    }

    public boolean getGT6StyleConnection() {
        return false;
    }

    @Override
    public boolean shouldJoinIc2Enet() {
        return false;
    }

    @Override
    public boolean isMachineBlockUpdateRecursive() {
        return false;
    }
}

