/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.interfaces.tileentity;

import cofh.api.energy.IEnergyReceiver;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.tileentity.IColoredTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.GT_Pollution;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public interface IEnergyConnected
extends IColoredTileEntity,
IHasWorldObjectAndCoords {
    public long injectEnergyUnits(byte var1, long var2, long var4);

    public boolean inputEnergyFrom(byte var1);

    default public boolean inputEnergyFrom(byte aSide, boolean waitForActive) {
        return this.inputEnergyFrom(aSide);
    }

    public boolean outputsEnergyTo(byte var1);

    default public boolean outputsEnergyTo(byte aSide, boolean waitForActive) {
        return this.outputsEnergyTo(aSide);
    }

    public static class Util {
        public static final long emitEnergyToNetwork(long aVoltage, long aAmperage, IEnergyConnected aEmitter) {
            long rUsedAmperes = 0L;
            byte j = 0;
            for (byte i = 0; i < 6 && aAmperage > rUsedAmperes; i = (byte)(i + 1)) {
                int rfOut;
                if (!aEmitter.outputsEnergyTo(i)) continue;
                j = GT_Utility.getOppositeSide(i);
                TileEntity tTileEntity = aEmitter.getTileEntityAtSide(i);
                if (tTileEntity instanceof IEnergyConnected) {
                    byte tColor;
                    if (aEmitter.getColorization() >= 0 && (tColor = ((IEnergyConnected)tTileEntity).getColorization()) >= 0 && tColor != aEmitter.getColorization()) continue;
                    rUsedAmperes += ((IEnergyConnected)tTileEntity).injectEnergyUnits(j, aVoltage, aAmperage - rUsedAmperes);
                    continue;
                }
                if (tTileEntity instanceof IEnergySink) {
                    if (!((IEnergySink)tTileEntity).acceptsEnergyFrom((TileEntity)aEmitter, ForgeDirection.getOrientation((int)j))) continue;
                    while (aAmperage > rUsedAmperes && ((IEnergySink)tTileEntity).getDemandedEnergy() > 0.0 && ((IEnergySink)tTileEntity).injectEnergy(ForgeDirection.getOrientation((int)j), (double)aVoltage, (double)aVoltage) < (double)aVoltage) {
                        ++rUsedAmperes;
                    }
                    continue;
                }
                if (!GregTech_API.mOutputRF || !(tTileEntity instanceof IEnergyReceiver)) continue;
                ForgeDirection tDirection = ForgeDirection.getOrientation((int)i).getOpposite();
                if (((IEnergyReceiver)tTileEntity).receiveEnergy(tDirection, rfOut = GT_Utility.safeInt(aVoltage * (long)GregTech_API.mEUtoRF / 100L), true) == rfOut) {
                    ((IEnergyReceiver)tTileEntity).receiveEnergy(tDirection, rfOut, false);
                    ++rUsedAmperes;
                }
                if (!GregTech_API.mRFExplosions || !GregTech_API.sMachineExplosions || (long)((IEnergyReceiver)tTileEntity).getMaxEnergyStored(tDirection) >= (long)rfOut * 600L || (long)rfOut <= 32L * (long)GregTech_API.mEUtoRF / 100L) continue;
                int aExplosionPower = rfOut;
                float tStrength = (long)aExplosionPower < GT_Values.V[0] ? 1.0f : ((long)aExplosionPower < GT_Values.V[1] ? 2.0f : ((long)aExplosionPower < GT_Values.V[2] ? 3.0f : ((long)aExplosionPower < GT_Values.V[3] ? 4.0f : ((long)aExplosionPower < GT_Values.V[4] ? 5.0f : ((long)aExplosionPower < GT_Values.V[4] * 2L ? 6.0f : ((long)aExplosionPower < GT_Values.V[5] ? 7.0f : ((long)aExplosionPower < GT_Values.V[6] ? 8.0f : ((long)aExplosionPower < GT_Values.V[7] ? 9.0f : ((long)aExplosionPower < GT_Values.V[8] ? 10.0f : ((long)aExplosionPower < GT_Values.V[8] * 2L ? 11.0f : ((long)aExplosionPower < GT_Values.V[9] ? 12.0f : ((long)aExplosionPower < GT_Values.V[10] ? 13.0f : ((long)aExplosionPower < GT_Values.V[11] ? 14.0f : ((long)aExplosionPower < GT_Values.V[12] ? 15.0f : ((long)aExplosionPower < GT_Values.V[12] * 2L ? 16.0f : ((long)aExplosionPower < GT_Values.V[13] ? 17.0f : ((long)aExplosionPower < GT_Values.V[14] ? 18.0f : ((long)aExplosionPower < GT_Values.V[15] ? 19.0f : 20.0f))))))))))))))))));
                int tX = tTileEntity.field_145851_c;
                int tY = tTileEntity.field_145848_d;
                int tZ = tTileEntity.field_145849_e;
                World tWorld = tTileEntity.func_145831_w();
                GT_Utility.sendSoundToPlayers(tWorld, GregTech_API.sSoundList.get(209), 1.0f, -1.0f, tX, tY, tZ);
                tWorld.func_147449_b(tX, tY, tZ, Blocks.field_150350_a);
                if (GregTech_API.sMachineExplosions && GT_Mod.gregtechproxy.mPollution) {
                    GT_Pollution.addPollution(tWorld.func_72938_d(tX, tZ), 100000);
                }
                new WorldSpawnedEventBuilder.ExplosionEffectEventBuilder().setStrength(tStrength).setSmoking(true).setPosition((double)tX + 0.5, (double)tY + 0.5, (double)tZ + 0.5).setWorld(tWorld).run();
            }
            return rUsedAmperes;
        }
    }
}

