/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.gui.GT_ContainerMetaTile_Machine;
import gregtech.api.gui.GT_Slot_Output;
import gregtech.api.gui.GT_Slot_Render;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class GT_Container_BasicTank
extends GT_ContainerMetaTile_Machine {
    public int mContent = 0;

    public GT_Container_BasicTank(InventoryPlayer aInventoryPlayer, IGregTechTileEntity aTileEntity) {
        super(aInventoryPlayer, aTileEntity);
    }

    @Override
    public void addSlots(InventoryPlayer aInventoryPlayer) {
        this.func_75146_a(new Slot((IInventory)this.mTileEntity, 0, 80, 17));
        this.func_75146_a(new GT_Slot_Output((IInventory)this.mTileEntity, 1, 80, 53));
        this.func_75146_a(new GT_Slot_Render((IInventory)this.mTileEntity, 2, 59, 42));
    }

    @Override
    public ItemStack func_75144_a(int aSlotIndex, int aMouseclick, int aShifthold, EntityPlayer aPlayer) {
        if (aSlotIndex == 2 && aMouseclick < 2) {
            GT_MetaTileEntity_BasicTank tTank;
            if (this.mTileEntity.isClientSide()) {
                tTank = (GT_MetaTileEntity_BasicTank)this.mTileEntity.getMetaTileEntity();
                tTank.setDrainableStack(GT_Utility.getFluidFromDisplayStack(tTank.func_70301_a(2)));
            }
            tTank = (GT_MetaTileEntity_BasicTank)this.mTileEntity.getMetaTileEntity();
            IFluidAccess tDrainableAccess = IFluidAccess.from(tTank, false);
            return GT_Container_BasicTank.handleFluidSlotClick(tDrainableAccess, aPlayer, aMouseclick == 0, true, !tTank.isDrainableStackSeparate());
        }
        return super.func_75144_a(aSlotIndex, aMouseclick, aShifthold, aPlayer);
    }

    protected static ItemStack handleFluidSlotClick(IFluidAccess aFluidAccess, EntityPlayer aPlayer, boolean aProcessFullStack, boolean aCanDrain, boolean aCanFill) {
        ItemStack tStackHeld = aPlayer.field_71071_by.func_70445_o();
        ItemStack tStackSizedOne = GT_Utility.copyAmount(1L, tStackHeld);
        if (tStackSizedOne == null || tStackHeld.field_77994_a == 0) {
            return null;
        }
        FluidStack tInputFluid = aFluidAccess.get();
        FluidStack tFluidHeld = GT_Utility.getFluidForFilledItem(tStackSizedOne, true);
        if (tFluidHeld != null && tFluidHeld.amount <= 0) {
            tFluidHeld = null;
        }
        if (tInputFluid == null) {
            if (!aCanFill) {
                return null;
            }
            if (tFluidHeld == null) {
                return null;
            }
            return GT_Container_BasicTank.fillFluid(aFluidAccess, aPlayer, tFluidHeld, aProcessFullStack);
        }
        if (tFluidHeld != null && tInputFluid.amount < aFluidAccess.getCapacity()) {
            if (aCanFill) {
                return GT_Container_BasicTank.fillFluid(aFluidAccess, aPlayer, tFluidHeld, aProcessFullStack);
            }
            if (!aCanDrain) {
                return null;
            }
            return GT_Container_BasicTank.drainFluid(aFluidAccess, aPlayer, aProcessFullStack);
        }
        if (!aCanDrain) {
            return null;
        }
        return GT_Container_BasicTank.drainFluid(aFluidAccess, aPlayer, aProcessFullStack);
    }

    protected static ItemStack drainFluid(IFluidAccess aFluidAccess, EntityPlayer aPlayer, boolean aProcessFullStack) {
        IFluidContainerItem tContainerItem;
        int tFilledAmount;
        FluidStack tTankStack = aFluidAccess.get();
        if (tTankStack == null) {
            return null;
        }
        ItemStack tStackHeld = aPlayer.field_71071_by.func_70445_o();
        ItemStack tStackSizedOne = GT_Utility.copyAmount(1L, tStackHeld);
        if (tStackSizedOne == null || tStackHeld.field_77994_a == 0) {
            return null;
        }
        int tOriginalFluidAmount = tTankStack.amount;
        ItemStack tFilledContainer = GT_Utility.fillFluidContainer(tTankStack, tStackSizedOne, true, false);
        if (tFilledContainer == null && tStackSizedOne.func_77973_b() instanceof IFluidContainerItem && (tFilledAmount = (tContainerItem = (IFluidContainerItem)tStackSizedOne.func_77973_b()).fill(tStackSizedOne, tTankStack, true)) > 0) {
            tFilledContainer = tStackSizedOne;
            tTankStack.amount -= tFilledAmount;
        }
        if (tFilledContainer != null) {
            if (aProcessFullStack) {
                int tFilledAmount2 = tOriginalFluidAmount - tTankStack.amount;
                int tAdditionalParallel = Math.min(tStackHeld.field_77994_a - 1, tTankStack.amount / tFilledAmount2);
                tTankStack.amount -= tFilledAmount2 * tAdditionalParallel;
                tFilledContainer.field_77994_a += tAdditionalParallel;
            }
            GT_Container_BasicTank.replaceCursorItemStack(aPlayer, tFilledContainer);
        }
        if (tTankStack.amount <= 0) {
            aFluidAccess.set(null);
        }
        return tFilledContainer;
    }

    protected static ItemStack fillFluid(IFluidAccess aFluidAccess, EntityPlayer aPlayer, FluidStack aFluidHeld, boolean aProcessFullStack) {
        int tParallel;
        IFluidContainerItem container;
        FluidStack tDrained;
        if (aFluidAccess.get() != null && !aFluidAccess.get().isFluidEqual(aFluidHeld)) {
            return null;
        }
        ItemStack tStackHeld = aPlayer.field_71071_by.func_70445_o();
        ItemStack tStackSizedOne = GT_Utility.copyAmount(1L, tStackHeld);
        if (tStackSizedOne == null) {
            return null;
        }
        int tFreeSpace = aFluidAccess.getCapacity() - (aFluidAccess.get() != null ? aFluidAccess.get().amount : 0);
        if (tFreeSpace <= 0) {
            return null;
        }
        ItemStack tStackEmptied = null;
        int tAmountTaken = 0;
        if (tFreeSpace >= aFluidHeld.amount) {
            tStackEmptied = GT_Utility.getContainerForFilledItem(tStackSizedOne, false);
            tAmountTaken = aFluidHeld.amount;
        }
        if (tStackEmptied == null && tStackSizedOne.func_77973_b() instanceof IFluidContainerItem && (tDrained = (container = (IFluidContainerItem)tStackSizedOne.func_77973_b()).drain(tStackSizedOne, tFreeSpace, true)) != null && tDrained.amount > 0) {
            tStackEmptied = tStackSizedOne;
            tAmountTaken = tDrained.amount;
        }
        if (tStackEmptied == null) {
            return null;
        }
        int n = tParallel = aProcessFullStack ? Math.min(tFreeSpace / tAmountTaken, tStackHeld.field_77994_a) : 1;
        if (aFluidAccess.get() == null) {
            FluidStack tNewFillableStack = aFluidHeld.copy();
            tNewFillableStack.amount = tAmountTaken * tParallel;
            aFluidAccess.set(tNewFillableStack);
        } else {
            aFluidAccess.get().amount += tAmountTaken * tParallel;
        }
        tStackEmptied.field_77994_a = tParallel;
        GT_Container_BasicTank.replaceCursorItemStack(aPlayer, tStackEmptied);
        return tStackEmptied;
    }

    private static void replaceCursorItemStack(EntityPlayer aPlayer, ItemStack tStackResult) {
        int tStackResultMaxStackSize = tStackResult.func_77976_d();
        while (tStackResult.field_77994_a > tStackResultMaxStackSize) {
            aPlayer.field_71071_by.func_70445_o().field_77994_a -= tStackResultMaxStackSize;
            GT_Utility.addItemToPlayerInventory(aPlayer, tStackResult.func_77979_a(tStackResultMaxStackSize));
        }
        if (aPlayer.field_71071_by.func_70445_o().field_77994_a == tStackResult.field_77994_a) {
            aPlayer.field_71071_by.func_70437_b(tStackResult);
        } else {
            ItemStack tStackHeld = aPlayer.field_71071_by.func_70445_o();
            tStackHeld.field_77994_a -= tStackResult.field_77994_a;
            GT_Utility.addItemToPlayerInventory(aPlayer, tStackResult);
        }
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (this.mTileEntity.isClientSide() || this.mTileEntity.getMetaTileEntity() == null) {
            return;
        }
        this.mContent = ((GT_MetaTileEntity_BasicTank)this.mTileEntity.getMetaTileEntity()).mFluid != null ? ((GT_MetaTileEntity_BasicTank)this.mTileEntity.getMetaTileEntity()).mFluid.amount : 0;
        for (Object crafter : this.field_75149_d) {
            ICrafting var1 = (ICrafting)crafter;
            var1.func_71112_a((Container)this, 100, this.mContent & 0xFFFF);
            var1.func_71112_a((Container)this, 101, this.mContent >>> 16);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int par1, int par2) {
        super.func_75137_b(par1, par2);
        switch (par1) {
            case 100: {
                this.mContent = this.mContent & 0xFFFF0000 | par2;
                break;
            }
            case 101: {
                this.mContent = this.mContent & 0xFFFF | par2 << 16;
            }
        }
    }

    @Override
    public int getSlotCount() {
        return 2;
    }

    @Override
    public int getShiftClickSlotCount() {
        return 1;
    }

    static class BasicTankFluidAccess
    implements IFluidAccess {
        private final GT_MetaTileEntity_BasicTank mTank;
        private final boolean mIsFillableStack;

        public BasicTankFluidAccess(GT_MetaTileEntity_BasicTank aTank, boolean aIsFillableStack) {
            this.mTank = aTank;
            this.mIsFillableStack = aIsFillableStack;
        }

        @Override
        public void set(FluidStack stack) {
            if (this.mIsFillableStack) {
                this.mTank.setFillableStack(stack);
            } else {
                this.mTank.setDrainableStack(stack);
            }
        }

        @Override
        public FluidStack get() {
            return this.mIsFillableStack ? this.mTank.getFillableStack() : this.mTank.getDrainableStack();
        }

        @Override
        public int getCapacity() {
            return this.mTank.getCapacity();
        }
    }

    protected static interface IFluidAccess {
        public void set(FluidStack var1);

        public FluidStack get();

        public int getCapacity();

        public static IFluidAccess from(GT_MetaTileEntity_BasicTank aTank, boolean aIsFillableStack) {
            return new BasicTankFluidAccess(aTank, aIsFillableStack);
        }
    }
}

