/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.graphs;

import gregtech.api.graphs.Node;
import gregtech.api.graphs.consumers.ConsumerNode;
import gregtech.api.graphs.paths.NodePath;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.tileentity.TileEntity;

public abstract class GenerateNodeMap {
    public static void clearNodeMap(Node aNode, int aReturnNodeValue) {
        if (aNode.mTileEntity instanceof BaseMetaPipeEntity) {
            BaseMetaPipeEntity tPipe = (BaseMetaPipeEntity)aNode.mTileEntity;
            tPipe.setNode(null);
            tPipe.setNodePath(null);
            if (aNode.mSelfPath != null) {
                aNode.mSelfPath.clearPath();
                aNode.mSelfPath = null;
            }
        }
        for (int i = 0; i < 6; ++i) {
            Node tNextNode;
            NodePath tPath = aNode.mNodePaths[i];
            if (tPath != null) {
                tPath.clearPath();
                aNode.mNodePaths[i] = null;
            }
            if ((tNextNode = aNode.mNeighbourNodes[i]) == null) continue;
            if (tNextNode.mNodeValue != aReturnNodeValue) {
                GenerateNodeMap.clearNodeMap(tNextNode, aNode.mNodeValue);
            }
            aNode.mNeighbourNodes[i] = null;
        }
    }

    protected void generateNextNode(BaseMetaPipeEntity aPipe, Node aPipeNode, byte aInvalidSide, int aNextNodeValue, ArrayList<ConsumerNode> tConsumers, HashSet<Node> tNodeMap) {
        MetaPipeEntity tMetaPipe = (MetaPipeEntity)aPipe.getMetaTileEntity();
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            Node tNextNode;
            ArrayList<MetaPipeEntity> tNewPipes;
            Pair nextTileEntity;
            TileEntity tNextTileEntity;
            if (i == aInvalidSide || (tNextTileEntity = aPipe.getTileEntityAtSide(i)) == null || tMetaPipe != null && !tMetaPipe.isConnectedAtSide(i) || (nextTileEntity = this.getNextValidTileEntity(tNextTileEntity, tNewPipes = new ArrayList<MetaPipeEntity>(), i, tNodeMap)) == null || (tNextNode = this.generateNode(nextTileEntity.mTileEntity, aPipeNode, aNextNodeValue + 1, tNewPipes, nextTileEntity.mSide, tConsumers, tNodeMap)) == null) continue;
            aNextNodeValue = tNextNode.mHighestNodeValue;
            aPipeNode.mHighestNodeValue = tNextNode.mHighestNodeValue;
            aPipeNode.mNeighbourNodes[i] = tNextNode;
            aPipeNode.mNodePaths[i] = aPipeNode.mReturnPath;
        }
    }

    protected Node generateNode(TileEntity aTileEntity, Node aPreviousNode, int aNextNodeValue, ArrayList<MetaPipeEntity> aPipes, int aSide, ArrayList<ConsumerNode> aConsumers, HashSet<Node> aNodeMap) {
        if (aTileEntity.func_145837_r()) {
            return null;
        }
        byte tSideOp = GT_Utility.getOppositeSide(aSide);
        byte tInvalidSide = aPreviousNode == null ? (byte)-1 : (byte)tSideOp;
        Node tThisNode = null;
        if (this.isPipe(aTileEntity)) {
            Node tPipeNode;
            BaseMetaPipeEntity tPipe = (BaseMetaPipeEntity)aTileEntity;
            MetaPipeEntity tMetaPipe = (MetaPipeEntity)tPipe.getMetaTileEntity();
            int tConnections = GenerateNodeMap.getNumberOfConnections(tMetaPipe);
            if (tConnections == 1) {
                tPipeNode = this.getEmptyNode(aNextNodeValue, tSideOp, aTileEntity, aConsumers);
                if (tPipeNode == null) {
                    return null;
                }
            } else {
                tPipeNode = this.getPipeNode(aNextNodeValue, tSideOp, aTileEntity, aConsumers);
            }
            tPipe.setNode(tPipeNode);
            aNodeMap.add(tPipeNode);
            tPipeNode.mSelfPath = this.getNewPath(new MetaPipeEntity[]{tMetaPipe});
            tThisNode = tPipeNode;
            if (tInvalidSide > -1) {
                tPipeNode.mNeighbourNodes[tInvalidSide] = aPreviousNode;
                tPipeNode.mNodePaths[tInvalidSide] = this.getNewPath(aPipes.toArray(new MetaPipeEntity[0]));
                aPreviousNode.mReturnPath = tPipeNode.mNodePaths[tInvalidSide];
            }
            if (tConnections > 1) {
                this.generateNextNode(tPipe, tPipeNode, tInvalidSide, aNextNodeValue, aConsumers, aNodeMap);
            }
        } else if (this.addConsumer(aTileEntity, tSideOp, aNextNodeValue, aConsumers)) {
            ConsumerNode tConsumeNode = aConsumers.get(aConsumers.size() - 1);
            tConsumeNode.mNeighbourNodes[tSideOp] = aPreviousNode;
            tConsumeNode.mNodePaths[tSideOp] = this.getNewPath(aPipes.toArray(new MetaPipeEntity[0]));
            aPreviousNode.mReturnPath = tConsumeNode.mNodePaths[tSideOp];
            tThisNode = tConsumeNode;
        }
        return tThisNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Pair getNextValidTileEntity(TileEntity aTileEntity, ArrayList<MetaPipeEntity> aPipes, byte aSide, HashSet<Node> aNodeMap) {
        if (!this.isPipe(aTileEntity)) return new Pair(aTileEntity, aSide);
        BaseMetaPipeEntity tPipe = (BaseMetaPipeEntity)aTileEntity;
        MetaPipeEntity tMetaPipe = (MetaPipeEntity)tPipe.getMetaTileEntity();
        Node tNode = tPipe.getNode();
        if (tNode != null && aNodeMap.contains(tNode)) {
            return null;
        }
        int tConnections = GenerateNodeMap.getNumberOfConnections(tMetaPipe);
        if (tConnections != 2) return new Pair(aTileEntity, aSide);
        byte tSideOp = GT_Utility.getOppositeSide(aSide);
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            TileEntity tNewTileEntity;
            if (i == tSideOp || !tMetaPipe.isConnectedAtSide(i) || (tNewTileEntity = tPipe.getTileEntityAtSide(i)) == null) continue;
            if (!this.isPipe(tNewTileEntity)) return new Pair(aTileEntity, i);
            aPipes.add(tMetaPipe);
            return this.getNextValidTileEntity(tNewTileEntity, aPipes, i, aNodeMap);
        }
        return null;
    }

    protected boolean isPipe(TileEntity aTileEntity) {
        return aTileEntity instanceof BaseMetaPipeEntity;
    }

    protected abstract boolean addConsumer(TileEntity var1, byte var2, int var3, ArrayList<ConsumerNode> var4);

    protected abstract NodePath getNewPath(MetaPipeEntity[] var1);

    protected Node getEmptyNode(int aNodeValue, byte aSide, TileEntity aTileEntity, ArrayList<ConsumerNode> aConsumers) {
        return null;
    }

    protected Node getPipeNode(int aNodeValue, byte aSide, TileEntity aTileEntity, ArrayList<ConsumerNode> aConsumers) {
        return new Node(aNodeValue, aTileEntity, aConsumers);
    }

    private static int getNumberOfConnections(MetaPipeEntity aPipe) {
        int tCons = 0;
        for (int i = 0; i < 6; ++i) {
            if (!aPipe.isConnectedAtSide(i)) continue;
            ++tCons;
        }
        return tCons;
    }

    private static class Pair {
        public byte mSide;
        public TileEntity mTileEntity;

        public Pair(TileEntity aTileEntity, byte aSide) {
            this.mTileEntity = aTileEntity;
            this.mSide = aSide;
        }
    }
}

