/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.util;

import com.google.common.io.Files;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.exchange.EnergyValueStackMapping;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.knowledge.TransmutationKnowledge;
import com.pahimar.ee3.reference.Reference;
import com.pahimar.ee3.util.CompressionHelper;
import com.pahimar.ee3.util.INBTTaggable;
import com.pahimar.ee3.util.LogHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.codec.digest.DigestUtils;

public class SerializationHelper {
    private static File dataDirectory;
    private static File playerDataDirectory;

    public static File getDataDirectory() {
        return dataDirectory;
    }

    public static File getPlayerDataDirectory() {
        return playerDataDirectory;
    }

    public static void initModDataDirectories() {
        dataDirectory = new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_72860_G().func_75765_b(), "data" + File.separator + Reference.LOWERCASE_MOD_ID);
        dataDirectory.mkdirs();
        playerDataDirectory = new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_72860_G().func_75765_b(), "playerdata" + File.separator + Reference.LOWERCASE_MOD_ID);
        playerDataDirectory.mkdirs();
    }

    public static String getModListMD5() {
        ArrayList<String> modList = new ArrayList<String>();
        for (ModContainer modContainer : Loader.instance().getModList()) {
            modList.add("[" + modContainer.getModId() + "-" + modContainer.getName() + "-" + modContainer.getVersion() + "]");
        }
        Collections.sort(modList);
        StringBuilder modListString = new StringBuilder();
        for (String modEntry : modList) {
            modListString.append(modEntry);
        }
        return DigestUtils.md5Hex((String)modListString.toString());
    }

    public static NBTTagCompound readNBTFromFile(File nbtEncodedFile) {
        if (nbtEncodedFile.exists() && nbtEncodedFile.isFile()) {
            try {
                return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(nbtEncodedFile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void writeNBTToFile(File directory, String fileName, INBTTaggable nbtTaggable) {
        SerializationHelper.writeNBTToFile(directory, fileName, nbtTaggable, false);
    }

    public static void writeNBTToFile(File directory, String fileName, INBTTaggable nbtTaggable, boolean verboseLogging) {
        if (directory != null && fileName != null && nbtTaggable != null) {
            if (!directory.exists()) {
                directory.mkdirs();
            }
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTaggable.writeToNBT(nbtTagCompound);
            try {
                File file1 = new File(directory, fileName + ".tmp");
                File file2 = new File(directory, fileName);
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbtTagCompound, (OutputStream)new FileOutputStream(file1));
                if (file2.exists()) {
                    file2.delete();
                }
                file1.renameTo(file2);
                if (verboseLogging) {
                    LogHelper.info(String.format("Successfully saved %s to file: %s", nbtTaggable.getTagLabel(), file2.getAbsolutePath()));
                }
            }
            catch (Exception exception) {
                LogHelper.warn(String.format("Failed to save %s to file: %s%s%s", nbtTaggable.getTagLabel(), directory.getAbsolutePath(), File.separator, fileName));
                exception.printStackTrace();
            }
        }
    }

    public static TransmutationKnowledge readTransmutationKnowledgeFromFile(File directory, String fileName) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return TransmutationKnowledge.readFromFile(new File(directory, fileName));
    }

    public static void writeTransmutationKnowledgeToFile(File directory, String fileName, TransmutationKnowledge transmutationKnowledge) {
        SerializationHelper.writeTransmutationKnowledgeToFile(directory, fileName, transmutationKnowledge, false);
    }

    public static void writeTransmutationKnowledgeToFile(File directory, String fileName, TransmutationKnowledge transmutationKnowledge, boolean verboseLogging) {
        if (directory != null && fileName != null) {
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if (transmutationKnowledge == null) {
                transmutationKnowledge = new TransmutationKnowledge();
            }
            try {
                File file1 = new File(directory, fileName + ".tmp");
                File file2 = new File(directory, fileName);
                TransmutationKnowledge.writeToFile(file1, transmutationKnowledge);
                if (file2.exists()) {
                    file2.delete();
                }
                file1.renameTo(file2);
                if (verboseLogging) {
                    LogHelper.info(String.format("Successfully saved TransmutationKnowledge to file: %s", file2.getAbsolutePath()));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                LogHelper.error(String.format("Failed to save TransmutationKnowledge to file: %s%s", directory.getAbsolutePath(), fileName));
            }
        }
    }

    public static Map<WrappedStack, EnergyValue> readEnergyValueStackMapFromJsonFile(String fileName) {
        File energyValuesDataDirectory = new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_72860_G().func_75765_b(), "data" + File.separator + Reference.LOWERCASE_MOD_ID + File.separator + "energyvalues");
        return SerializationHelper.readEnergyValueStackMapFromJsonFile(new File(energyValuesDataDirectory, fileName));
    }

    public static Map<WrappedStack, EnergyValue> readEnergyValueStackMapFromJsonFile(File jsonFile) {
        TreeMap<WrappedStack, EnergyValue> energyValueStackMap = new TreeMap<WrappedStack, EnergyValue>();
        try {
            JsonReader jsonReader = new JsonReader((Reader)new FileReader(jsonFile));
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                EnergyValueStackMapping energyValueStackMapping = (EnergyValueStackMapping)EnergyValueStackMapping.jsonSerializer.fromJson(jsonReader, EnergyValueStackMapping.class);
                if (energyValueStackMapping == null) continue;
                energyValueStackMap.put(energyValueStackMapping.wrappedStack, energyValueStackMapping.energyValue);
            }
            jsonReader.endArray();
            jsonReader.close();
        }
        catch (FileNotFoundException ignored) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return energyValueStackMap;
    }

    public static void writeEnergyValueStackMapToJsonFile(String fileName, Map<WrappedStack, EnergyValue> energyValueMap) {
        File energyValuesDataDirectory = new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_72860_G().func_75765_b(), "data" + File.separator + Reference.LOWERCASE_MOD_ID + File.separator + "energyvalues");
        SerializationHelper.writeEnergyValueStackMapToJsonFile(new File(energyValuesDataDirectory, fileName), energyValueMap);
    }

    public static void writeEnergyValueStackMapToJsonFile(File jsonFile, Map<WrappedStack, EnergyValue> energyValueMap) {
        try {
            JsonWriter jsonWriter = new JsonWriter((Writer)new FileWriter(jsonFile));
            jsonWriter.setIndent("    ");
            jsonWriter.beginArray();
            for (WrappedStack wrappedStack : energyValueMap.keySet()) {
                if (wrappedStack == null || wrappedStack.getWrappedObject() == null) continue;
                EnergyValueStackMapping.jsonSerializer.toJson((Object)new EnergyValueStackMapping(wrappedStack, energyValueMap.get(wrappedStack)), EnergyValueStackMapping.class, jsonWriter);
            }
            jsonWriter.endArray();
            jsonWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void compressEnergyValueStackMapToFile(String fileName, Map<WrappedStack, EnergyValue> energyValueMap) {
        File energyValuesDataDirectory = new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_72860_G().func_75765_b(), "data" + File.separator + Reference.LOWERCASE_MOD_ID + File.separator + "energyvalues");
        SerializationHelper.compressEnergyValueStackMapToFile(new File(energyValuesDataDirectory, fileName), energyValueMap);
    }

    public static void compressEnergyValueStackMapToFile(File file, Map<WrappedStack, EnergyValue> energyValueMap) {
        try {
            byte[] energyValueRegistryArray = CompressionHelper.compressStringToByteArray(EnergyValueRegistry.getInstance().toJson());
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(energyValueRegistryArray);
            fos.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<WrappedStack, EnergyValue> decompressEnergyValueStackMapFromFile(String fileName) {
        File energyValuesDataDirectory = new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_72860_G().func_75765_b(), "data" + File.separator + Reference.LOWERCASE_MOD_ID + File.separator + "energyvalues");
        return SerializationHelper.decompressEnergyValueStackMapFromFile(new File(energyValuesDataDirectory, fileName));
    }

    public static Map<WrappedStack, EnergyValue> decompressEnergyValueStackMapFromFile(File file) {
        TreeMap<WrappedStack, EnergyValue> energyValueStackMap = new TreeMap<WrappedStack, EnergyValue>();
        try {
            String jsonEnergyValueStackMap = CompressionHelper.decompressStringFromByteArray(Files.toByteArray((File)file));
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(jsonEnergyValueStackMap));
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                EnergyValueStackMapping energyValueStackMapping = (EnergyValueStackMapping)EnergyValueStackMapping.jsonSerializer.fromJson(jsonReader, EnergyValueStackMapping.class);
                if (energyValueStackMapping == null) continue;
                energyValueStackMap.put(energyValueStackMapping.wrappedStack, energyValueStackMapping.energyValue);
            }
            jsonReader.endArray();
            jsonReader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return energyValueStackMap;
    }
}

