/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.util;

import com.pahimar.ee3.reference.Comparators;
import com.pahimar.ee3.util.NBTHelper;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemHelper {
    public static ItemStack cloneItemStack(ItemStack itemStack, int stackSize) {
        ItemStack clonedItemStack = itemStack.func_77946_l();
        clonedItemStack.field_77994_a = stackSize;
        return clonedItemStack;
    }

    public static boolean equals(ItemStack first, ItemStack second) {
        return Comparators.idComparator.compare(first, second) == 0;
    }

    public static boolean equalsIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2) {
        return itemStack1 != null && itemStack2 != null && Item.func_150891_b((Item)itemStack1.func_77973_b()) - Item.func_150891_b((Item)itemStack2.func_77973_b()) == 0 && itemStack1.func_77973_b() == itemStack2.func_77973_b() && itemStack1.func_77960_j() == itemStack2.func_77960_j() && (itemStack1.func_77942_o() && itemStack2.func_77942_o() ? ItemStack.func_77970_a((ItemStack)itemStack1, (ItemStack)itemStack2) : !itemStack1.func_77942_o() && !itemStack2.func_77942_o());
    }

    public static int compare(ItemStack itemStack1, ItemStack itemStack2) {
        return Comparators.idComparator.compare(itemStack1, itemStack2);
    }

    public static String toString(ItemStack itemStack) {
        if (itemStack != null) {
            if (itemStack.func_77942_o()) {
                return String.format("%sxitemStack[%s@%s:%s]", itemStack.field_77994_a, itemStack.func_77977_a(), itemStack.func_77960_j(), itemStack.func_77978_p());
            }
            return String.format("%sxitemStack[%s@%s]", itemStack.field_77994_a, itemStack.func_77977_a(), itemStack.func_77960_j());
        }
        return "null";
    }

    public static boolean hasOwner(ItemStack itemStack) {
        return NBTHelper.hasTag(itemStack, "ownerUUIDMostSig") && NBTHelper.hasTag(itemStack, "ownerUUIDLeastSig") || NBTHelper.hasTag(itemStack, "owner");
    }

    public static boolean hasOwnerUUID(ItemStack itemStack) {
        return NBTHelper.hasTag(itemStack, "ownerUUIDMostSig") && NBTHelper.hasTag(itemStack, "ownerUUIDLeastSig");
    }

    public static boolean hasOwnerName(ItemStack itemStack) {
        return NBTHelper.hasTag(itemStack, "owner");
    }

    public static String getOwnerName(ItemStack itemStack) {
        if (NBTHelper.hasTag(itemStack, "owner")) {
            return NBTHelper.getString(itemStack, "owner");
        }
        return null;
    }

    public static UUID getOwnerUUID(ItemStack itemStack) {
        if (NBTHelper.hasTag(itemStack, "ownerUUIDMostSig") && NBTHelper.hasTag(itemStack, "ownerUUIDLeastSig")) {
            return new UUID(NBTHelper.getLong(itemStack, "ownerUUIDMostSig"), NBTHelper.getLong(itemStack, "ownerUUIDLeastSig"));
        }
        return null;
    }

    public static void setOwner(ItemStack itemStack, EntityPlayer entityPlayer) {
        ItemHelper.setOwnerName(itemStack, entityPlayer);
        ItemHelper.setOwnerUUID(itemStack, entityPlayer);
    }

    public static void setOwnerUUID(ItemStack itemStack, EntityPlayer entityPlayer) {
        NBTHelper.setLong(itemStack, "ownerUUIDMostSig", entityPlayer.func_110124_au().getMostSignificantBits());
        NBTHelper.setLong(itemStack, "ownerUUIDLeastSig", entityPlayer.func_110124_au().getLeastSignificantBits());
    }

    public static void setOwnerName(ItemStack itemStack, EntityPlayer entityPlayer) {
        NBTHelper.setString(itemStack, "owner", entityPlayer.getDisplayName());
    }
}

