/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.util;

import java.util.Comparator;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidHelper {
    public static Comparator<FluidStack> comparator = new Comparator<FluidStack>(){

        @Override
        public int compare(FluidStack fluidStack1, FluidStack fluidStack2) {
            if (fluidStack1 != null) {
                if (fluidStack2 != null) {
                    if (FluidRegistry.getFluidID((Fluid)fluidStack1.getFluid()) == FluidRegistry.getFluidID((Fluid)fluidStack2.getFluid())) {
                        if (fluidStack1.amount == fluidStack2.amount) {
                            if (fluidStack1.tag != null) {
                                if (fluidStack2.tag != null) {
                                    return fluidStack1.tag.hashCode() - fluidStack2.tag.hashCode();
                                }
                                return -1;
                            }
                            if (fluidStack2.tag != null) {
                                return 1;
                            }
                            return 0;
                        }
                        return fluidStack1.amount - fluidStack2.amount;
                    }
                    return FluidRegistry.getFluidID((Fluid)fluidStack1.getFluid()) - FluidRegistry.getFluidID((Fluid)fluidStack2.getFluid());
                }
                return -1;
            }
            if (fluidStack2 != null) {
                return 1;
            }
            return 0;
        }
    };

    public static void registerFluids() {
        Fluid milk;
        if (!FluidRegistry.isFluidRegistered((String)"milk") && FluidRegistry.registerFluid((Fluid)(milk = new Fluid("milk").setUnlocalizedName("ee3.milk")))) {
            FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(milk, 1000), (ItemStack)new ItemStack(Items.field_151117_aB), (ItemStack)new ItemStack(Items.field_151133_ar));
        }
    }

    public static int compare(FluidStack fluidStack1, FluidStack fluidStack2) {
        return comparator.compare(fluidStack1, fluidStack2);
    }

    public static String toString(FluidStack fluidStack) {
        if (fluidStack != null) {
            return String.format("%sxfluidStack.%s", fluidStack.amount, fluidStack.getFluid().getName());
        }
        return "fluidStack[null]";
    }
}

