/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.tileentity;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import com.pahimar.ee3.block.BlockAshInfusedStoneSlab;
import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.item.ItemAlchemicalTome;
import com.pahimar.ee3.item.ItemMiniumStone;
import com.pahimar.ee3.item.ItemPhilosophersStone;
import com.pahimar.ee3.knowledge.AbilityRegistry;
import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessageTileEntityTransmutationTablet;
import com.pahimar.ee3.tileentity.TileEntityEE;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTransmutationTablet
extends TileEntityEE
implements ISidedInventory {
    public static final int INVENTORY_SIZE = 10;
    public static final int ITEM_INPUT_1 = 0;
    public static final int ITEM_INPUT_2 = 1;
    public static final int ITEM_INPUT_3 = 2;
    public static final int ITEM_INPUT_4 = 3;
    public static final int ITEM_INPUT_5 = 4;
    public static final int ITEM_INPUT_6 = 5;
    public static final int ITEM_INPUT_7 = 6;
    public static final int ITEM_INPUT_8 = 7;
    public static final int STONE_INDEX = 8;
    public static final int ALCHEMICAL_TOME_INDEX = 9;
    private EnergyValue storedEnergyValue;
    private EnergyValue availableEnergyValue;
    private ForgeDirection rotation = ForgeDirection.UNKNOWN;
    private ItemStack[] inventory;

    public TileEntityTransmutationTablet() {
        this.availableEnergyValue = new EnergyValue(0.0f);
        this.storedEnergyValue = new EnergyValue(0.0f);
        this.inventory = new ItemStack[10];
    }

    public EnergyValue getAvailableEnergyValue() {
        return this.availableEnergyValue;
    }

    public EnergyValue getStoredEnergyValue() {
        return this.storedEnergyValue;
    }

    public void consumeInventoryForEnergyValue(ItemStack outputItemStack) {
        EnergyValue outputEnergyValue = EnergyValueRegistryProxy.getEnergyValue(outputItemStack);
        if (this.storedEnergyValue.compareTo(outputEnergyValue) >= 0) {
            this.storedEnergyValue = new EnergyValue(this.storedEnergyValue.getValue() - outputEnergyValue.getValue());
        } else {
            while (this.storedEnergyValue.compareTo(outputEnergyValue) < 0 && this.availableEnergyValue.compareTo(outputEnergyValue) >= 0) {
                for (int i = 0; i < 8; ++i) {
                    ItemStack stackInSlot = this.func_70301_a(i);
                    if (stackInSlot == null || !EnergyValueRegistryProxy.hasEnergyValue(stackInSlot)) continue;
                    this.storedEnergyValue = new EnergyValue(this.storedEnergyValue.getValue() + EnergyValueRegistryProxy.getEnergyValue(stackInSlot).getValue());
                    this.func_70298_a(i, 1);
                }
            }
            if (this.storedEnergyValue.getValue() >= outputEnergyValue.getValue()) {
                this.storedEnergyValue = new EnergyValue(this.storedEnergyValue.getValue() - outputEnergyValue.getValue());
            }
        }
        this.updateEnergyValueFromInventory();
    }

    public void updateEnergyValueFromInventory() {
        float newEnergyValue = this.storedEnergyValue.getValue();
        for (int i = 0; i <= 8; ++i) {
            if (this.inventory[i] == null || !EnergyValueRegistryProxy.hasEnergyValue(this.inventory[i])) continue;
            newEnergyValue += EnergyValueRegistryProxy.getEnergyValueForStack(this.inventory[i]).getValue();
        }
        this.availableEnergyValue = new EnergyValue(newEnergyValue);
    }

    public ForgeDirection getRotation() {
        return this.rotation;
    }

    public void setRotation(ForgeDirection rotation) {
        this.rotation = rotation;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 1.5), (double)(this.field_145848_d - 1), (double)((double)this.field_145849_e - 1.5), (double)((double)this.field_145851_c + 1.5), (double)(this.field_145848_d + 1), (double)((double)this.field_145849_e + 1.5));
    }

    public boolean isStructureValid() {
        return this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 1) instanceof BlockAshInfusedStoneSlab && this.field_145850_b.func_72805_g(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 1) == 1 && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof BlockAshInfusedStoneSlab && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) == 2 && this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 1) instanceof BlockAshInfusedStoneSlab && this.field_145850_b.func_72805_g(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 1) == 3 && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof BlockAshInfusedStoneSlab && this.field_145850_b.func_72805_g(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) == 4 && this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof BlockAshInfusedStoneSlab && this.field_145850_b.func_72805_g(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) == 5 && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 1) instanceof BlockAshInfusedStoneSlab && this.field_145850_b.func_72805_g(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 1) == 6 && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof BlockAshInfusedStoneSlab && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) == 7 && this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 1) instanceof BlockAshInfusedStoneSlab && this.field_145850_b.func_72805_g(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 1) == 8;
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.updateEnergyValueFromInventory();
    }

    @Override
    public Packet func_145844_m() {
        return PacketHandler.INSTANCE.getPacketFrom((IMessage)new MessageTileEntityTransmutationTablet(this));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.rotation = ForgeDirection.getOrientation((int)nbtTagCompound.func_74762_e("rotation"));
        NBTTagList tagList = nbtTagCompound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slotIndex = tagCompound.func_74771_c("Slot");
            if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
            this.inventory[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        NBTTagCompound energyValueTagCompound = nbtTagCompound.func_74775_l("storedEnergyValue");
        this.storedEnergyValue = !energyValueTagCompound.func_82582_d() ? EnergyValue.loadEnergyValueFromNBT(energyValueTagCompound) : new EnergyValue(0.0f);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("rotation", this.rotation.ordinal());
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)tagList);
        NBTTagCompound energyValueTagCompound = new NBTTagCompound();
        if (this.storedEnergyValue != null) {
            this.storedEnergyValue.writeToNBT(energyValueTagCompound);
        }
        nbtTagCompound.func_74782_a("storedEnergyValue", (NBTBase)energyValueTagCompound);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return this.inventory[slotIndex];
    }

    public ItemStack func_70298_a(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= decrementAmount) {
                this.func_70299_a(slotIndex, null);
            } else {
                itemStack = itemStack.func_77979_a(decrementAmount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slotIndex) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (itemStack != null) {
            this.func_70299_a(slotIndex, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        if (slotIndex < this.func_70302_i_()) {
            this.inventory[slotIndex] = itemStack;
            if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
                itemStack.field_77994_a = this.func_70297_j_();
            }
            this.updateEnergyValueFromInventory();
        }
    }

    public String func_145825_b() {
        return this.hasCustomName() ? this.getCustomName() : "container.ee3:transmutationTablet";
    }

    public boolean func_145818_k_() {
        return this.hasCustomName();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        if (slotIndex < 8 && EnergyValueRegistry.getInstance().hasEnergyValue(itemStack) && AbilityRegistry.getInstance().isRecoverable(itemStack)) {
            return true;
        }
        if (slotIndex == 8 && (itemStack.func_77973_b() instanceof ItemMiniumStone || itemStack.func_77973_b() instanceof ItemPhilosophersStone)) {
            return true;
        }
        return slotIndex == 9 && itemStack.func_77973_b() instanceof ItemAlchemicalTome;
    }

    public int[] func_94128_d(int slotIndex) {
        return new int[0];
    }

    public boolean func_102007_a(int slotIndex, ItemStack itemStack, int side) {
        return false;
    }

    public boolean func_102008_b(int slotIndex, ItemStack itemStack, int side) {
        return false;
    }
}

