/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.FurnaceRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import com.pahimar.ee3.client.gui.inventory.GuiCalcinator;
import com.pahimar.ee3.item.ItemAlchemicalDust;
import com.pahimar.ee3.reference.Textures;
import com.pahimar.ee3.util.CalcinationHelper;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class CalcinationHandler
extends TemplateRecipeHandler {
    private static final DecimalFormat energyValueDecimalFormat = new DecimalFormat("###,###,###,###,###.###");

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCalcinator.class;
    }

    public String getGuiTexture() {
        return Textures.Gui.CALCINATOR.toString();
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"gui.nei.ee3:calcination");
    }

    public String getRecipeID() {
        return "EE3:calcinator";
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (ItemStack stack : ItemAlchemicalDust.getAlchemicalDusts()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)result)) continue;
            this.arecipes.add(new CachedCalcinationRecipe(stack));
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeID())) {
            for (ItemStack stack : ItemAlchemicalDust.getAlchemicalDusts()) {
                this.arecipes.add(new CachedCalcinationRecipe(stack));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(39, 20, 18, 18), "fuel", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(69, 19, 24, 16), this.getRecipeID(), new Object[0]));
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (ItemStack stack : ItemAlchemicalDust.getAlchemicalDusts()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)CalcinationHelper.getCalcinationResult(ingredient))) continue;
            this.arecipes.add(new CachedCalcinationRecipe(ingredient, stack));
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)14, (int)-3, (int)19, (int)7, (int)143, (int)68);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(41, 23, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(70, 20, 176, 14, 24, 16, 48, 0);
        CachedCalcinationRecipe cRecipe = (CachedCalcinationRecipe)((Object)this.arecipes.get(recipe));
        GuiDraw.drawStringC((String)StatCollector.func_74838_a((String)"gui.nei.ee3:calcination.tooltip.1"), (int)83, (int)75, (int)0x404040, (boolean)false);
        GuiDraw.drawStringC((String)(cRecipe.getResult().item.func_82833_r() + ":"), (int)83, (int)85, (int)0x404040, (boolean)false);
        if (cRecipe != null && cRecipe.minEnergyValue != null && cRecipe.maxEnergyValue != null && EnergyValueRegistryProxy.getEnergyValue(ItemAlchemicalDust.getAlchemicalDusts().get(ItemAlchemicalDust.getAlchemicalDusts().size() - 1)) != null) {
            GuiDraw.drawStringC((String)StatCollector.func_74837_a((String)"gui.nei.ee3:calcination.tooltip.2", (Object[])new Object[]{cRecipe.minEnergyValue.getValue() > 1.0f ? energyValueDecimalFormat.format(cRecipe.minEnergyValue.getValue()) : "0", cRecipe.maxEnergyValue.getValue() <= EnergyValueRegistryProxy.getEnergyValue(ItemAlchemicalDust.getAlchemicalDusts().get(ItemAlchemicalDust.getAlchemicalDusts().size() - 1)).getValue() ? energyValueDecimalFormat.format(cRecipe.maxEnergyValue.getValue()) : "\u221e"}), (int)83, (int)95, (int)0x404040, (boolean)false);
        }
    }

    public class CachedCalcinationRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public List<PositionedStack> inputs;
        public PositionedStack output;
        public EnergyValue minEnergyValue;
        public EnergyValue maxEnergyValue;

        public CachedCalcinationRecipe(ItemStack outputDust) {
            super((TemplateRecipeHandler)CalcinationHandler.this);
            this.output = new PositionedStack((Object)outputDust, 101, 19);
            this.inputs = new ArrayList<PositionedStack>();
            this.minEnergyValue = EnergyValueRegistryProxy.getEnergyValue(outputDust);
            this.maxEnergyValue = outputDust.func_77960_j() < ItemAlchemicalDust.getAlchemicalDusts().size() - 1 ? EnergyValueRegistryProxy.getEnergyValue(ItemAlchemicalDust.getAlchemicalDusts().get(outputDust.func_77960_j() + 1)) : new EnergyValue(Float.MAX_VALUE);
            for (Object obj : EnergyValueRegistryProxy.getStacksInRange(this.minEnergyValue, this.maxEnergyValue)) {
                if (!(obj instanceof ItemStack)) continue;
                this.inputs.add(new PositionedStack((Object)((ItemStack)obj), 40, 0));
            }
        }

        public CachedCalcinationRecipe(ItemStack inputStack, ItemStack outputDust) {
            super((TemplateRecipeHandler)CalcinationHandler.this);
            inputStack.field_77994_a = 1;
            this.inputs = Arrays.asList(new PositionedStack((Object)inputStack, 40, 0));
            this.output = new PositionedStack((Object)outputDust, 101, 19);
            this.minEnergyValue = EnergyValueRegistryProxy.getEnergyValue(outputDust);
            this.maxEnergyValue = outputDust.func_77960_j() < ItemAlchemicalDust.getAlchemicalDusts().size() - 1 ? EnergyValueRegistryProxy.getEnergyValue(ItemAlchemicalDust.getAlchemicalDusts().get(outputDust.func_77960_j() + 1)) : new EnergyValue(Float.MAX_VALUE);
        }

        public PositionedStack getIngredient() {
            return this.inputs.get(CalcinationHandler.this.cycleticks / 48 % this.inputs.size());
        }

        public PositionedStack getOtherStack() {
            return new PositionedStack((Object)((FurnaceRecipeHandler.FuelPair)FurnaceRecipeHandler.afuels.get((int)(CalcinationHandler.this.cycleticks / 48 % FurnaceRecipeHandler.afuels.size()))).stack.item, 40, 45);
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

