/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.item;

import com.pahimar.ee3.creativetab.CreativeTab;
import com.pahimar.ee3.reference.Key;
import com.pahimar.ee3.reference.Material;
import com.pahimar.ee3.reference.Textures;
import com.pahimar.ee3.reference.ToolMode;
import com.pahimar.ee3.util.CommonSoundHelper;
import com.pahimar.ee3.util.IChargeable;
import com.pahimar.ee3.util.IKeyBound;
import com.pahimar.ee3.util.IModalTool;
import com.pahimar.ee3.util.NBTHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;

public class ItemDarkMatterHoe
extends ItemHoe
implements IKeyBound,
IChargeable,
IModalTool {
    public ItemDarkMatterHoe() {
        super(Material.Tools.DARK_MATTER);
        this.func_77637_a(CreativeTab.EE3_TAB);
        this.setNoRepair();
        this.field_77777_bU = 1;
        this.func_77655_b("hoeDarkMatter");
    }

    public String func_77658_a() {
        return String.format("item.%s%s", Textures.RESOURCE_PREFIX, this.getUnwrappedUnlocalizedName(super.func_77658_a()));
    }

    public String func_77667_c(ItemStack itemStack) {
        return String.format("item.%s%s", Textures.RESOURCE_PREFIX, this.getUnwrappedUnlocalizedName(super.func_77658_a()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_77658_a().substring(this.func_77658_a().indexOf(".") + 1));
    }

    protected String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    public boolean func_77651_p() {
        return true;
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof IChargeable) {
            return ((IChargeable)itemStack.func_77973_b()).getChargeLevel(itemStack) > 0;
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof IChargeable) {
            return (double)(((IChargeable)itemStack.func_77973_b()).getMaxChargeLevel() - ((IChargeable)itemStack.func_77973_b()).getChargeLevel(itemStack)) / (double)((IChargeable)itemStack.func_77973_b()).getMaxChargeLevel();
        }
        return 1.0;
    }

    @Override
    public short getMaxChargeLevel() {
        return 3;
    }

    @Override
    public short getChargeLevel(ItemStack itemStack) {
        return NBTHelper.getShort(itemStack, "chargeLevel");
    }

    @Override
    public void setChargeLevel(ItemStack itemStack, short chargeLevel) {
        if (chargeLevel <= this.getMaxChargeLevel()) {
            NBTHelper.setShort(itemStack, "chargeLevel", chargeLevel);
        }
    }

    @Override
    public void increaseChargeLevel(ItemStack itemStack) {
        if (NBTHelper.getShort(itemStack, "chargeLevel") < this.getMaxChargeLevel()) {
            NBTHelper.setShort(itemStack, "chargeLevel", (short)(NBTHelper.getShort(itemStack, "chargeLevel") + 1));
        }
    }

    @Override
    public void decreaseChargeLevel(ItemStack itemStack) {
        if (NBTHelper.getShort(itemStack, "chargeLevel") > 0) {
            NBTHelper.setShort(itemStack, "chargeLevel", (short)(NBTHelper.getShort(itemStack, "chargeLevel") - 1));
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer entityPlayer, ItemStack itemStack, Key key) {
        if (key == Key.CHARGE) {
            if (!entityPlayer.func_70093_af()) {
                if (this.getChargeLevel(itemStack) == this.getMaxChargeLevel()) {
                    CommonSoundHelper.playSoundAtPlayer(entityPlayer, "fail", 1.5f, 1.5f);
                } else {
                    this.increaseChargeLevel(itemStack);
                    CommonSoundHelper.playSoundAtPlayer(entityPlayer, "chargeUp", 0.5f, 0.5f + 0.5f * ((float)this.getChargeLevel(itemStack) * 1.0f / (float)this.getMaxChargeLevel()));
                }
            } else if (this.getChargeLevel(itemStack) == 0) {
                CommonSoundHelper.playSoundAtPlayer(entityPlayer, "fail", 1.5f, 1.5f);
            } else {
                this.decreaseChargeLevel(itemStack);
                CommonSoundHelper.playSoundAtPlayer(entityPlayer, "chargeDown", 0.5f, 1.0f - (0.5f - 0.5f * ((float)this.getChargeLevel(itemStack) * 1.0f / (float)this.getMaxChargeLevel())));
            }
        } else if (key == Key.EXTRA) {
            CommonSoundHelper.playSoundAtPlayer(entityPlayer, "tock", 0.5f, 1.5f);
            this.changeToolMode(itemStack);
        }
    }

    @Override
    public List<ToolMode> getAvailableToolModes() {
        return Arrays.asList(ToolMode.STANDARD);
    }

    @Override
    public ToolMode getCurrentToolMode(ItemStack itemStack) {
        if (NBTHelper.getShort(itemStack, "mode") < ToolMode.TYPES.length) {
            return ToolMode.TYPES[NBTHelper.getShort(itemStack, "mode")];
        }
        return null;
    }

    @Override
    public void setToolMode(ItemStack itemStack, ToolMode toolMode) {
        NBTHelper.setShort(itemStack, "mode", (short)toolMode.ordinal());
    }

    @Override
    public void changeToolMode(ItemStack itemStack) {
        ToolMode currentToolMode = this.getCurrentToolMode(itemStack);
        if (this.getAvailableToolModes().contains((Object)currentToolMode)) {
            if (this.getAvailableToolModes().indexOf((Object)currentToolMode) == this.getAvailableToolModes().size() - 1) {
                this.setToolMode(itemStack, this.getAvailableToolModes().get(0));
            } else {
                this.setToolMode(itemStack, this.getAvailableToolModes().get(this.getAvailableToolModes().indexOf((Object)currentToolMode) + 1));
            }
        }
    }
}

