/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.item;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.item.ItemEE;
import com.pahimar.ee3.reference.GUIs;
import com.pahimar.ee3.reference.Textures;
import com.pahimar.ee3.util.ColorHelper;
import com.pahimar.ee3.util.IOwnable;
import com.pahimar.ee3.util.ItemHelper;
import com.pahimar.ee3.util.NBTHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemAlchemicalBag
extends ItemEE
implements IOwnable {
    private static final String[] ALCHEMICAL_BAG_ICONS = new String[]{"open", "closed", "symbolTier1", "symbolTier2", "symbolTier3"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemAlchemicalBag() {
        this.func_77627_a(true);
        this.func_77655_b("alchemicalBag");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[ALCHEMICAL_BAG_ICONS.length];
        for (int i = 0; i < ALCHEMICAL_BAG_ICONS.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a(Textures.RESOURCE_PREFIX + "alchemicalBag" + "." + ALCHEMICAL_BAG_ICONS[i]);
        }
    }

    public IIcon getIcon(ItemStack itemStack, int renderPass) {
        if (renderPass == 0) {
            if (NBTHelper.hasTag(itemStack, "alchemicalBagGuiOpen")) {
                return this.icons[0];
            }
            return this.icons[1];
        }
        return this.icons[2 + MathHelper.func_76125_a((int)itemStack.func_77960_j(), (int)0, (int)3)];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        for (int meta = 0; meta < 3; ++meta) {
            list.add(new ItemStack((Item)this, 1, meta));
        }
    }

    public boolean func_77651_p() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (!world.field_72995_K) {
            if (!ItemHelper.hasOwnerUUID(itemStack)) {
                ItemHelper.setOwner(itemStack, entityPlayer);
                entityPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("misc.ee3:owner-set-to-self", new Object[]{itemStack.func_151000_E()}));
            }
            NBTHelper.setUUID(itemStack);
            NBTHelper.setBoolean(itemStack, "alchemicalBagGuiOpen", true);
            entityPlayer.openGui((Object)EquivalentExchange3.instance, GUIs.ALCHEMICAL_BAG.ordinal(), entityPlayer.field_70170_p, (int)entityPlayer.field_70165_t, (int)entityPlayer.field_70163_u, (int)entityPlayer.field_70161_v);
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int renderPass) {
        int bagColor = this.getColor(itemStack);
        if (bagColor < 0) {
            bagColor = Integer.parseInt("ffffff", 16);
        }
        return bagColor;
    }

    public boolean hasColor(ItemStack itemStack) {
        return ColorHelper.hasColor(itemStack);
    }

    public int getColor(ItemStack itemStack) {
        return ColorHelper.getColor(itemStack);
    }

    public void setColor(ItemStack itemStack, int color) {
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemAlchemicalBag) {
            ColorHelper.setColor(itemStack, color);
        }
    }

    public void removeColor(ItemStack itemStack) {
        NBTTagCompound displayTagCompound;
        NBTTagCompound nbtTagCompound;
        if (itemStack != null && (nbtTagCompound = itemStack.func_77978_p()) != null && (displayTagCompound = nbtTagCompound.func_74775_l("display")).func_74764_b("color")) {
            displayTagCompound.func_82580_o("color");
        }
    }
}

