/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.api.exchange;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.api.exchange.EnergyValue;
import cpw.mods.fml.common.Mod;
import java.util.List;

public final class EnergyValueRegistryProxy {
    @Mod.Instance(value="EE3")
    private static Object ee3Mod;

    public static void addPreAssignedEnergyValue(Object object, float energyValue) {
        EnergyValueRegistryProxy.addPreAssignedEnergyValue(object, new EnergyValue(energyValue));
    }

    public static void addPreAssignedEnergyValue(Object object, EnergyValue energyValue) {
        EnergyValueRegistryProxy.init();
        if (ee3Mod != null) {
            EE3Wrapper.ee3mod.getEnergyValueRegistry().addPreAssignedEnergyValue(object, energyValue);
        }
    }

    public static void addPostAssignedEnergyValue(Object object, float energyValue) {
        EnergyValueRegistryProxy.addPostAssignedEnergyValue(object, new EnergyValue(energyValue));
    }

    public static void addPostAssignedEnergyValue(Object object, EnergyValue energyValue) {
        EnergyValueRegistryProxy.init();
        if (ee3Mod != null) {
            EE3Wrapper.ee3mod.getEnergyValueRegistry().addPostAssignedExactEnergyValue(object, energyValue);
        }
    }

    public static boolean hasEnergyValue(Object object) {
        return EnergyValueRegistryProxy.hasEnergyValue(object, false);
    }

    public static boolean hasEnergyValue(Object object, boolean strict) {
        EnergyValueRegistryProxy.init();
        if (ee3Mod != null) {
            return EE3Wrapper.ee3mod.getEnergyValueRegistry().hasEnergyValue(object, strict);
        }
        return false;
    }

    public static EnergyValue getEnergyValue(Object object) {
        return EnergyValueRegistryProxy.getEnergyValue(object, false);
    }

    public static EnergyValue getEnergyValue(Object object, boolean strict) {
        EnergyValueRegistryProxy.init();
        if (ee3Mod != null) {
            return EE3Wrapper.ee3mod.getEnergyValueRegistry().getEnergyValue(object, strict);
        }
        return null;
    }

    public static EnergyValue getEnergyValueForStack(Object object) {
        return EnergyValueRegistryProxy.getEnergyValueForStack(object, false);
    }

    public static EnergyValue getEnergyValueForStack(Object object, boolean strict) {
        EnergyValueRegistryProxy.init();
        if (ee3Mod != null) {
            return EE3Wrapper.ee3mod.getEnergyValueRegistry().getEnergyValueForStack(object, strict);
        }
        return null;
    }

    public static List getStacksInRange(float start, float finish) {
        return EnergyValueRegistryProxy.getStacksInRange(new EnergyValue(start), new EnergyValue(finish));
    }

    public static List getStacksInRange(EnergyValue start, EnergyValue finish) {
        EnergyValueRegistryProxy.init();
        if (ee3Mod != null) {
            return EE3Wrapper.ee3mod.getEnergyValueRegistry().getStacksInRange(start, finish);
        }
        return null;
    }

    public static void dumpEnergyValueRegistryToLog() {
        EnergyValueRegistryProxy.dumpEnergyValueRegistryToLog(Phase.ALL);
    }

    public static void dumpEnergyValueRegistryToLog(Phase phase) {
        EnergyValueRegistryProxy.init();
        if (ee3Mod != null) {
            EE3Wrapper.ee3mod.getEnergyValueRegistry().dumpEnergyValueRegistryToLog(phase);
        }
    }

    private static void init() {
        if (ee3Mod != null) {
            EE3Wrapper.ee3mod = (EquivalentExchange3)EnergyValueRegistryProxy.ee3Mod;
        }
    }

    public static enum Phase {
        PRE_ASSIGNMENT,
        POST_ASSIGNMENT,
        ALL;

    }

    private static class EE3Wrapper {
        private static EquivalentExchange3 ee3mod;

        private EE3Wrapper() {
        }
    }
}

