/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.repackage.cofh.lib.render;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public final class RenderHelper {
    public static final double RENDER_OFFSET = 9.765625E-4;
    public static final ResourceLocation MC_BLOCK_SHEET = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation MC_ITEM_SHEET = new ResourceLocation("textures/atlas/items.png");
    public static final ResourceLocation MC_FONT_DEFAULT = new ResourceLocation("textures/font/ascii.png");
    public static final ResourceLocation MC_FONT_ALTERNATE = new ResourceLocation("textures/font/ascii_sga.png");
    public static final ResourceLocation MC_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    private RenderHelper() {
    }

    public static final TextureManager engine() {
        return Minecraft.getMinecraft().renderEngine;
    }

    public static final Tessellator tessellator() {
        return Tessellator.instance;
    }

    public static void setColor3ub(int color) {
        GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
    }

    public static void setColor4ub(int color) {
        GL11.glColor4ub((byte)((byte)(color >> 24 & 0xFF)), (byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
    }

    public static void resetColor() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderItemAsBlock(RenderBlocks renderer, ItemStack item, double translateX, double translateY, double translateZ) {
        RenderHelper.renderTextureAsBlock(renderer, item.getIconIndex(), translateX, translateY, translateZ);
    }

    public static void renderTextureAsBlock(RenderBlocks renderer, IIcon texture, double translateX, double translateY, double translateZ) {
        Tessellator tessellator = Tessellator.instance;
        Block block = Blocks.stone;
        if (texture == null) {
            return;
        }
        renderer.setRenderBoundsFromBlock(block);
        GL11.glTranslated((double)translateX, (double)translateY, (double)translateZ);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderer.renderFaceYNeg(block, 0.0, 0.0, 0.0, texture);
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderer.renderFaceYPos(block, 0.0, 0.0, 0.0, texture);
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderer.renderFaceZNeg(block, 0.0, 0.0, 0.0, texture);
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderer.renderFaceZPos(block, 0.0, 0.0, 0.0, texture);
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderer.renderFaceXNeg(block, 0.0, 0.0, 0.0, texture);
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderer.renderFaceXPos(block, 0.0, 0.0, 0.0, texture);
        tessellator.draw();
    }

    public static void renderItemIn2D(IIcon icon) {
        ItemRenderer.renderItemIn2D((Tessellator)Tessellator.instance, (float)icon.getMaxU(), (float)icon.getMinV(), (float)icon.getMinU(), (float)icon.getMaxV(), (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.0625f);
    }

    public static void renderIcon(IIcon icon, double z) {
        Tessellator.instance.startDrawingQuads();
        Tessellator.instance.addVertexWithUV(0.0, 16.0, z, (double)icon.getMinU(), (double)icon.getMaxV());
        Tessellator.instance.addVertexWithUV(16.0, 16.0, z, (double)icon.getMaxU(), (double)icon.getMaxV());
        Tessellator.instance.addVertexWithUV(16.0, 0.0, z, (double)icon.getMaxU(), (double)icon.getMinV());
        Tessellator.instance.addVertexWithUV(0.0, 0.0, z, (double)icon.getMinU(), (double)icon.getMinV());
        Tessellator.instance.draw();
    }

    public static void renderIcon(double x, double y, double z, IIcon icon, int width, int height) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x, y + (double)height, z, (double)icon.getMinU(), (double)icon.getMaxV());
        tessellator.addVertexWithUV(x + (double)width, y + (double)height, z, (double)icon.getMaxU(), (double)icon.getMaxV());
        tessellator.addVertexWithUV(x + (double)width, y, z, (double)icon.getMaxU(), (double)icon.getMinV());
        tessellator.addVertexWithUV(x, y, z, (double)icon.getMinU(), (double)icon.getMinV());
        tessellator.draw();
    }

    public static final IIcon getFluidTexture(Fluid fluid) {
        if (fluid == null) {
            return FluidRegistry.LAVA.getIcon();
        }
        return fluid.getIcon();
    }

    public static final IIcon getFluidTexture(FluidStack fluid) {
        if (fluid == null || fluid.getFluid() == null || fluid.getFluid().getIcon(fluid) == null) {
            return FluidRegistry.LAVA.getIcon();
        }
        return fluid.getFluid().getIcon(fluid);
    }

    public static final void bindItemTexture(ItemStack stack) {
        RenderHelper.engine().bindTexture(stack.getItemSpriteNumber() == 0 ? MC_BLOCK_SHEET : MC_ITEM_SHEET);
    }

    public static final void bindTexture(ResourceLocation texture) {
        RenderHelper.engine().bindTexture(texture);
    }

    public static final void setBlockTextureSheet() {
        RenderHelper.bindTexture(MC_BLOCK_SHEET);
    }

    public static final void setItemTextureSheet() {
        RenderHelper.bindTexture(MC_ITEM_SHEET);
    }

    public static final void setDefaultFontTextureSheet() {
        RenderHelper.bindTexture(MC_FONT_DEFAULT);
    }

    public static final void setSGAFontTextureSheet() {
        RenderHelper.bindTexture(MC_FONT_ALTERNATE);
    }

    public static final void enableGUIStandardItemLighting() {
        net.minecraft.client.renderer.RenderHelper.enableGUIStandardItemLighting();
    }
}

