/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.repackage.cofh.lib.gui.element;

import com.pahimar.repackage.cofh.lib.gui.GuiBase;
import com.pahimar.repackage.cofh.lib.gui.GuiProps;
import com.pahimar.repackage.cofh.lib.gui.element.ElementBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class ElementButtonManaged
extends ElementBase {
    public static final ResourceLocation HOVER = new ResourceLocation(GuiProps.PATH_ELEMENTS + "Button_Hover.png");
    public static final ResourceLocation ENABLED = new ResourceLocation(GuiProps.PATH_ELEMENTS + "Button_Enabled.png");
    public static final ResourceLocation DISABLED = new ResourceLocation(GuiProps.PATH_ELEMENTS + "Button_Disabled.png");
    private String _text;

    public ElementButtonManaged(GuiBase containerScreen, int posX, int posY, int sizeX, int sizeY, String text) {
        super(containerScreen, posX, posY, sizeX, sizeY);
        this._text = text;
    }

    public void setText(String text) {
        this._text = text;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        if (!this.isEnabled()) {
            this.gui.bindTexture(DISABLED);
        } else if (this.intersectsWith(mouseX, mouseY)) {
            this.gui.bindTexture(HOVER);
        } else {
            this.gui.bindTexture(ENABLED);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(this.posX, this.posY, 0, 0, this.sizeX / 2, this.sizeY / 2);
        this.drawTexturedModalRect(this.posX, this.posY + this.sizeY / 2, 0, 256 - this.sizeY / 2, this.sizeX / 2, this.sizeY / 2);
        this.drawTexturedModalRect(this.posX + this.sizeX / 2, this.posY, 256 - this.sizeX / 2, 0, this.sizeX / 2, this.sizeY / 2);
        this.drawTexturedModalRect(this.posX + this.sizeX / 2, this.posY + this.sizeY / 2, 256 - this.sizeX / 2, 256 - this.sizeY / 2, this.sizeX / 2, this.sizeY / 2);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        String text = this.getFontRenderer().trimStringToWidth(this._text, this.sizeX - 4);
        this.drawCenteredString(this.getFontRenderer(), text, this.posX + this.sizeX / 2, this.posY + (this.sizeY - 8) / 2, this.getTextColor(mouseX, mouseY));
    }

    protected int getTextColor(int mouseX, int mouseY) {
        if (!this.isEnabled()) {
            return -6250336;
        }
        if (this.intersectsWith(mouseX, mouseY)) {
            return 0xFFFFA0;
        }
        return 0xE0E0E0;
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        GuiBase.playSound("random.click", 1.0f, 1.0f);
        if (mouseButton == 0) {
            this.onClick();
        } else if (mouseButton == 1) {
            this.onRightClick();
        } else if (mouseButton == 2) {
            this.onMiddleClick();
        }
        return true;
    }

    public abstract void onClick();

    public void onRightClick() {
    }

    public void onMiddleClick() {
    }
}

