/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.util;

import com.pahimar.ee3.exchange.OreStack;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.util.ItemHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeHelper {
    public static List<WrappedStack> getRecipeInputs(IRecipe recipe) {
        ArrayList<WrappedStack> recipeInputs;
        block12: {
            ShapelessOreRecipe shapelessOreRecipe;
            block14: {
                block13: {
                    block11: {
                        recipeInputs = new ArrayList<WrappedStack>();
                        if (!(recipe instanceof ShapedRecipes)) break block11;
                        ShapedRecipes shapedRecipe = (ShapedRecipes)recipe;
                        for (int i = 0; i < shapedRecipe.recipeItems.length; ++i) {
                            if (!(shapedRecipe.recipeItems[i] instanceof ItemStack)) continue;
                            ItemStack itemStack = shapedRecipe.recipeItems[i].copy();
                            if (itemStack.stackSize > 1) {
                                itemStack.stackSize = 1;
                            }
                            recipeInputs.add(WrappedStack.wrap(itemStack));
                        }
                        break block12;
                    }
                    if (!(recipe instanceof ShapelessRecipes)) break block13;
                    ShapelessRecipes shapelessRecipe = (ShapelessRecipes)recipe;
                    for (Object object : shapelessRecipe.recipeItems) {
                        if (!(object instanceof ItemStack)) continue;
                        ItemStack itemStack = ((ItemStack)object).copy();
                        if (itemStack.stackSize > 1) {
                            itemStack.stackSize = 1;
                        }
                        recipeInputs.add(WrappedStack.wrap(itemStack));
                    }
                    break block12;
                }
                if (!(recipe instanceof ShapedOreRecipe)) break block14;
                ShapedOreRecipe shapedOreRecipe = (ShapedOreRecipe)recipe;
                if (!RecipeHelper.validateOreDictionaryRecipe(Arrays.asList(shapedOreRecipe.getInput()))) break block12;
                for (int i = 0; i < shapedOreRecipe.getInput().length; ++i) {
                    if (shapedOreRecipe.getInput()[i] instanceof ArrayList) {
                        WrappedStack oreStack = WrappedStack.wrap(shapedOreRecipe.getInput()[i]);
                        if (oreStack == null || !(oreStack.getWrappedObject() instanceof OreStack)) continue;
                        recipeInputs.add(oreStack);
                        continue;
                    }
                    if (!(shapedOreRecipe.getInput()[i] instanceof ItemStack)) continue;
                    ItemStack itemStack = ((ItemStack)shapedOreRecipe.getInput()[i]).copy();
                    if (itemStack.stackSize > 1) {
                        itemStack.stackSize = 1;
                    }
                    recipeInputs.add(WrappedStack.wrap(itemStack));
                }
                break block12;
            }
            if (recipe instanceof ShapelessOreRecipe && RecipeHelper.validateOreDictionaryRecipe((shapelessOreRecipe = (ShapelessOreRecipe)recipe).getInput())) {
                for (Object object : shapelessOreRecipe.getInput()) {
                    if (object instanceof ArrayList) {
                        recipeInputs.add(WrappedStack.wrap(object));
                        continue;
                    }
                    if (!(object instanceof ItemStack)) continue;
                    ItemStack itemStack = ((ItemStack)object).copy();
                    if (itemStack.stackSize > 1) {
                        itemStack.stackSize = 1;
                    }
                    recipeInputs.add(WrappedStack.wrap(itemStack));
                }
            }
        }
        return RecipeHelper.collateInputStacks(recipeInputs);
    }

    public static List<WrappedStack> collateInputStacks(List<?> uncollatedStacks) {
        ArrayList<WrappedStack> collatedStacks = new ArrayList<WrappedStack>();
        for (Object object : uncollatedStacks) {
            boolean found = false;
            if (!WrappedStack.canBeWrapped(object)) continue;
            WrappedStack stack = WrappedStack.wrap(object);
            if (collatedStacks.isEmpty()) {
                collatedStacks.add(stack);
                continue;
            }
            for (WrappedStack collatedStack : collatedStacks) {
                if (collatedStack.getWrappedObject() == null) continue;
                if (stack.getWrappedObject() instanceof ItemStack && collatedStack.getWrappedObject() instanceof ItemStack) {
                    if (!ItemHelper.equals((ItemStack)stack.getWrappedObject(), (ItemStack)collatedStack.getWrappedObject())) continue;
                    collatedStack.setStackSize(collatedStack.getStackSize() + stack.getStackSize());
                    found = true;
                    continue;
                }
                if (!(stack.getWrappedObject() instanceof OreStack) || !(collatedStack.getWrappedObject() instanceof OreStack) || !OreStack.compareOreNames((OreStack)stack.getWrappedObject(), (OreStack)collatedStack.getWrappedObject())) continue;
                collatedStack.setStackSize(collatedStack.getStackSize() + stack.getStackSize());
                found = true;
            }
            if (found) continue;
            collatedStacks.add(stack);
        }
        Collections.sort(collatedStacks);
        return collatedStacks;
    }

    private static boolean validateOreDictionaryRecipe(List objects) {
        for (Object object : objects) {
            if (object == null || WrappedStack.canBeWrapped(object)) continue;
            return false;
        }
        return true;
    }
}

