/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.util;

import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTHelper {
    public static void clearStatefulNBTTags(ItemStack itemStack) {
        if (NBTHelper.hasTag(itemStack, "craftingGuiOpen")) {
            NBTHelper.removeTag(itemStack, "craftingGuiOpen");
        } else if (NBTHelper.hasTag(itemStack, "transmutationGuiOpen")) {
            NBTHelper.removeTag(itemStack, "transmutationGuiOpen");
        } else if (NBTHelper.hasTag(itemStack, "alchemicalBagGuiOpen")) {
            NBTHelper.removeTag(itemStack, "alchemicalBagGuiOpen");
        }
    }

    public static boolean hasTag(ItemStack itemStack, String keyName) {
        return itemStack != null && itemStack.stackTagCompound != null && itemStack.stackTagCompound.hasKey(keyName);
    }

    public static void removeTag(ItemStack itemStack, String keyName) {
        if (itemStack.stackTagCompound != null) {
            itemStack.stackTagCompound.removeTag(keyName);
        }
    }

    public static boolean hasUUID(ItemStack itemStack) {
        return NBTHelper.hasTag(itemStack, "UUIDMostSig") && NBTHelper.hasTag(itemStack, "UUIDLeastSig");
    }

    public static void setUUID(ItemStack itemStack) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!NBTHelper.hasTag(itemStack, "UUIDMostSig") && !NBTHelper.hasTag(itemStack, "UUIDLeastSig")) {
            UUID itemUUID = UUID.randomUUID();
            NBTHelper.setLong(itemStack, "UUIDMostSig", itemUUID.getMostSignificantBits());
            NBTHelper.setLong(itemStack, "UUIDLeastSig", itemUUID.getLeastSignificantBits());
        }
    }

    private static void initNBTTagCompound(ItemStack itemStack) {
        if (itemStack.stackTagCompound == null) {
            itemStack.setTagCompound(new NBTTagCompound());
        }
    }

    public static void setLong(ItemStack itemStack, String keyName, long keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.stackTagCompound.setLong(keyName, keyValue);
    }

    public static String getString(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.stackTagCompound.hasKey(keyName)) {
            NBTHelper.setString(itemStack, keyName, "");
        }
        return itemStack.stackTagCompound.getString(keyName);
    }

    public static void setString(ItemStack itemStack, String keyName, String keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.stackTagCompound.setString(keyName, keyValue);
    }

    public static boolean getBoolean(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.stackTagCompound.hasKey(keyName)) {
            NBTHelper.setBoolean(itemStack, keyName, false);
        }
        return itemStack.stackTagCompound.getBoolean(keyName);
    }

    public static void setBoolean(ItemStack itemStack, String keyName, boolean keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.stackTagCompound.setBoolean(keyName, keyValue);
    }

    public static byte getByte(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.stackTagCompound.hasKey(keyName)) {
            NBTHelper.setByte(itemStack, keyName, (byte)0);
        }
        return itemStack.stackTagCompound.getByte(keyName);
    }

    public static void setByte(ItemStack itemStack, String keyName, byte keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.stackTagCompound.setByte(keyName, keyValue);
    }

    public static short getShort(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.stackTagCompound.hasKey(keyName)) {
            NBTHelper.setShort(itemStack, keyName, (short)0);
        }
        return itemStack.stackTagCompound.getShort(keyName);
    }

    public static void setShort(ItemStack itemStack, String keyName, short keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.stackTagCompound.setShort(keyName, keyValue);
    }

    public static int getInt(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.stackTagCompound.hasKey(keyName)) {
            NBTHelper.setInteger(itemStack, keyName, 0);
        }
        return itemStack.stackTagCompound.getInteger(keyName);
    }

    public static void setInteger(ItemStack itemStack, String keyName, int keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.stackTagCompound.setInteger(keyName, keyValue);
    }

    public static long getLong(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.stackTagCompound.hasKey(keyName)) {
            NBTHelper.setLong(itemStack, keyName, 0L);
        }
        return itemStack.stackTagCompound.getLong(keyName);
    }

    public static float getFloat(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.stackTagCompound.hasKey(keyName)) {
            NBTHelper.setFloat(itemStack, keyName, 0.0f);
        }
        return itemStack.stackTagCompound.getFloat(keyName);
    }

    public static void setFloat(ItemStack itemStack, String keyName, float keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.stackTagCompound.setFloat(keyName, keyValue);
    }

    public static double getDouble(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.stackTagCompound.hasKey(keyName)) {
            NBTHelper.setDouble(itemStack, keyName, 0.0);
        }
        return itemStack.stackTagCompound.getDouble(keyName);
    }

    public static void setDouble(ItemStack itemStack, String keyName, double keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.stackTagCompound.setDouble(keyName, keyValue);
    }

    public static NBTTagList getTagList(ItemStack itemStack, String keyName, int nbtBaseType) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.stackTagCompound.hasKey(keyName)) {
            NBTHelper.setTagList(itemStack, keyName, new NBTTagList());
        }
        return itemStack.stackTagCompound.getTagList(keyName, nbtBaseType);
    }

    public static void setTagList(ItemStack itemStack, String keyName, NBTTagList nbtTagList) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.stackTagCompound.setTag(keyName, (NBTBase)nbtTagList);
    }

    public static NBTTagCompound getTagCompound(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.stackTagCompound.hasKey(keyName)) {
            NBTHelper.setTagCompound(itemStack, keyName, new NBTTagCompound());
        }
        return itemStack.stackTagCompound.getCompoundTag(keyName);
    }

    public static void setTagCompound(ItemStack itemStack, String keyName, NBTTagCompound nbtTagCompound) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.stackTagCompound.setTag(keyName, (NBTBase)nbtTagCompound);
    }
}

