/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.util;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ColorHelper {
    public static boolean hasColor(ItemStack itemStack) {
        return itemStack.hasTagCompound() && itemStack.getTagCompound().hasKey("display") && itemStack.getTagCompound().getCompoundTag("display").hasKey("color");
    }

    public static int getColor(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = itemStack.getTagCompound();
        if (nbtTagCompound == null) {
            return Integer.parseInt("ffffff", 16);
        }
        NBTTagCompound displayTagCompound = nbtTagCompound.getCompoundTag("display");
        return displayTagCompound == null ? Integer.parseInt("ffffff", 16) : (displayTagCompound.hasKey("color") ? displayTagCompound.getInteger("color") : Integer.parseInt("ffffff", 16));
    }

    public static void setColor(ItemStack itemStack, int color) {
        if (itemStack != null) {
            NBTTagCompound nbtTagCompound = itemStack.getTagCompound();
            if (nbtTagCompound == null) {
                nbtTagCompound = new NBTTagCompound();
                itemStack.setTagCompound(nbtTagCompound);
            }
            NBTTagCompound colourTagCompound = nbtTagCompound.getCompoundTag("display");
            if (!nbtTagCompound.hasKey("display")) {
                nbtTagCompound.setTag("display", (NBTBase)colourTagCompound);
            }
            colourTagCompound.setInteger("color", color);
        }
    }
}

