/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.tileentity;

import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessageTileEntityGlassBell;
import com.pahimar.ee3.tileentity.TileEntityEE;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;

public class TileEntityGlassBell
extends TileEntityEE
implements IInventory {
    public static final int INVENTORY_SIZE = 1;
    public static final int DISPLAY_SLOT_INVENTORY_INDEX = 0;
    public ItemStack outputItemStack;
    private ItemStack[] inventory = new ItemStack[1];

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        NBTTagList tagList = nbtTagCompound.getTagList("Items", 10);
        this.inventory = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound tagCompound = tagList.getCompoundTagAt(i);
            byte slotIndex = tagCompound.getByte("Slot");
            if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
            this.inventory[slotIndex] = ItemStack.loadItemStackFromNBT((NBTTagCompound)tagCompound);
        }
    }

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slotIndex) {
        return this.inventory[slotIndex];
    }

    public ItemStack decrStackSize(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.getStackInSlot(slotIndex);
        if (itemStack != null) {
            if (itemStack.stackSize <= decrementAmount) {
                this.setInventorySlotContents(slotIndex, null);
            } else {
                itemStack = itemStack.splitStack(decrementAmount);
                if (itemStack.stackSize == 0) {
                    this.setInventorySlotContents(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack getStackInSlotOnClosing(int slotIndex) {
        ItemStack itemStack = this.getStackInSlot(slotIndex);
        if (itemStack != null) {
            this.setInventorySlotContents(slotIndex, null);
        }
        return itemStack;
    }

    public void setInventorySlotContents(int slotIndex, ItemStack itemStack) {
        this.inventory[slotIndex] = itemStack;
        if (itemStack != null && itemStack.stackSize > this.getInventoryStackLimit()) {
            itemStack.stackSize = this.getInventoryStackLimit();
        }
        if (!this.worldObj.isRemote) {
            ItemStack displayStack = this.inventory[0];
            this.state = displayStack != null ? (byte)Block.getBlockFromItem((Item)displayStack.getItem()).getLightValue() : (byte)0;
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageTileEntityGlassBell(this, displayStack), new NetworkRegistry.TargetPoint(this.worldObj.provider.dimensionId, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, 128.0));
        }
        this.markDirty();
    }

    public String getInventoryName() {
        return this.hasCustomName() ? this.getCustomName() : "container.ee3:glassBell";
    }

    public boolean hasCustomInventoryName() {
        return this.hasCustomName();
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer entityPlayer) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        super.writeToNBT(nbtTagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.setByte("Slot", (byte)currentIndex);
            this.inventory[currentIndex].writeToNBT(tagCompound);
            tagList.appendTag((NBTBase)tagCompound);
        }
        nbtTagCompound.setTag("Items", (NBTBase)tagList);
    }

    @Override
    public Packet getDescriptionPacket() {
        return PacketHandler.INSTANCE.getPacketFrom((IMessage)new MessageTileEntityGlassBell(this, this.getStackInSlot(0)));
    }
}

