/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.tileentity;

import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessageTileEntityEE;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityEE
extends TileEntity {
    protected ForgeDirection orientation = ForgeDirection.SOUTH;
    protected byte state = 0;
    protected String customName = "";
    protected UUID ownerUUID = null;

    public ForgeDirection getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ForgeDirection orientation) {
        this.orientation = orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = ForgeDirection.getOrientation((int)orientation);
    }

    public short getState() {
        return this.state;
    }

    public void setState(byte state) {
        this.state = state;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public String getOwnerName() {
        if (this.ownerUUID != null) {
            return UsernameCache.getLastKnownUsername((UUID)this.ownerUUID);
        }
        return "Unknown";
    }

    public void setOwner(EntityPlayer entityPlayer) {
        this.ownerUUID = entityPlayer.getPersistentID();
    }

    public void setOwnerUUID(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        if (nbtTagCompound.hasKey("teDirection")) {
            this.orientation = ForgeDirection.getOrientation((int)nbtTagCompound.getByte("teDirection"));
        }
        if (nbtTagCompound.hasKey("teState")) {
            this.state = nbtTagCompound.getByte("teState");
        }
        if (nbtTagCompound.hasKey("CustomName")) {
            this.customName = nbtTagCompound.getString("CustomName");
        }
        if (nbtTagCompound.hasKey("ownerUUIDMostSig") && nbtTagCompound.hasKey("ownerUUIDLeastSig")) {
            this.ownerUUID = new UUID(nbtTagCompound.getLong("ownerUUIDMostSig"), nbtTagCompound.getLong("ownerUUIDLeastSig"));
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        super.writeToNBT(nbtTagCompound);
        nbtTagCompound.setByte("teDirection", (byte)this.orientation.ordinal());
        nbtTagCompound.setByte("teState", this.state);
        if (this.hasCustomName()) {
            nbtTagCompound.setString("CustomName", this.customName);
        }
        if (this.hasOwner()) {
            nbtTagCompound.setLong("ownerUUIDMostSig", this.ownerUUID.getMostSignificantBits());
            nbtTagCompound.setLong("ownerUUIDLeastSig", this.ownerUUID.getLeastSignificantBits());
        }
    }

    public boolean hasCustomName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public boolean hasOwner() {
        return this.ownerUUID != null;
    }

    public Packet getDescriptionPacket() {
        return PacketHandler.INSTANCE.getPacketFrom((IMessage)new MessageTileEntityEE(this));
    }
}

